package ejb;

import util.*;
import java.util.*;
import javax.ejb.*;
import com.caucho.ejb.*;
import javax.servlet.http.*;

public class TellFriendCtrlBean extends AbstractSessionBean {

  public void ejbCreate() { }

  public void sendMessage(HttpServletRequest request) throws ControlException {

    String senderName = TextProcessor.normStr(request.getParameter("senderName"));
    String senderEmail = TextProcessor.normStr(request.getParameter("senderEmail"));
    String friendName = TextProcessor.normStr(request.getParameter("friendName"));
    String friendEmail = TextProcessor.normStr(request.getParameter("friendEmail"));
    String text = TextProcessor.normStr(request.getParameter("text"));

    if ("".equals(senderName) || "".equals(senderEmail) || "".equals(friendName) || "".equals(friendEmail) || "".equals(text))
      throw new ControlException("all field are required");
    if ((senderEmail.indexOf('@') < 0) || (senderEmail.indexOf('.') < 0))
      throw new ControlException("invalid email format");

    text = "Hi " + friendName + "!\r\n\r\n" +
           "You've received the message as your friend " + senderName + " (sender's IP address: " + request.getRemoteAddr() + ") thinks you need to know about AI Agent Application.\r\n" +
           "==============================================\r\n" +
           text +
           "\r\n==============================================\r\n" +
           "AI Agent is an application that lets you build easy-to-use knowledge bases (Brains).\r\n\r\n" +
           "The animated characters are ready-to-learn (Agents) and live on your PC desktop.  They happily interact with you, making your life easier and more organized by storing your information at your command. These fascinating agents are able to learn, search and retrieve, access online resources, read text and clone themselves as you direct them.\r\n\r\n" +
           "AI Agent application allows you to create as many agents as you wish. Each of them will have their own characters and backend database, with a smart query engine using Artificial Intelligence search methods.\r\n\r\n" +
           "Visit http://www.aiagentz.com to get to know more.\r\n\r\n" +
           "If you do not wish to receive any future information about AI Agent, simply disregard this message and let your friend know.\r\n\r\n";
    try  {
      MailSender ms = EJBGetter.getMailSenderHome().create();
      try {
        ms.setFrom(System.getProperty("mail.tellafriend"));
        ms.addTo(friendEmail);
        if (System.getProperty("mail.tellafriend.bcc") != null)
          ms.addBcc(System.getProperty("mail.tellafriend.bcc"));
        ms.setSubject(senderName + " has sent you a suggestion!");
        ms.setBodyText(text);
        ms.send();
//      } catch (MailSenderException mex) {
//        throw new ControlException(mex.getMessage());
      } finally {
        ms.remove();
      }
    } catch (CreateException ex) {
      throw new ControlException(ex.getMessage(), ex);
    } catch (RemoveException ex) {
      throw new ControlException(ex.getMessage(), ex);
    }
  }

}
