package ejb;

/*
 * $Log: SubscriberBean.java,v $
 * Revision 1.2  2002/11/18 22:51:54  paul
 * + Log keyword added
 *
 */

import java.util.*;
import com.caucho.ejb.*;
import javax.ejb.*;

public abstract class SubscriberBean  extends AbstractEntityBean {

  public abstract int getId();

  public abstract String getEmail();
  public abstract void setEmail(String email);

  public abstract Date getSubscribed();
  public abstract void setSubscribed(Date subscribed);

  public abstract Date getNoticed();
  public abstract void setNoticed(Date noticed);

  public abstract int getFormat();
  public abstract void setFormat(int format);

  public abstract boolean getActive();
  public abstract void setActive(boolean confirmed);

  public int ejbCreate(String email, int format) throws CreateException {
    Date now = new Date();
    if ((email == null) || ("".equals(email)))
      throw new CreateException("email required");
    setEmail(email);
    setSubscribed(now);
    setNoticed(now);
    setFormat(format);
    setActive(false);
    return 0;
  }

  public void ejbPostCreate(String email, int format) throws CreateException { }

  public void ejbRemove() throws RemoveException { }

  public boolean equals(Object obj) {
    if ((obj instanceof Subscriber) && (obj != null))
      return getId() == ((Subscriber)obj).getId();
    else
      return false;
  }

  public String toString() {
    return "[Id:" + getId() + " EMail:" + getEmail() + " Active:" + getActive() + "]";
  }

}