package ejb;

import util.*;
import util.template.*;
import java.io.*;
import java.net.*;
import java.lang.reflect.*;
import java.util.*;
import javax.ejb.*;
import javax.naming.*;
import com.caucho.ejb.*;
import com.caucho.xml.*;
import org.w3c.dom.*;
import javax.servlet.http.*;

public class SubscribeCtrlBean extends AbstractSessionBean {

  public void ejbCreate() { }

  public Subscriber subscribe(String email, int format) throws ControlException {
    try {
      Subscriber subscriber = null;
      try {
        subscriber = EJBGetter.getSubscriberHome().findByEmail(email);
        subscriber.setFormat(format);
      } catch (FinderException fex) {}
      try {
        if (subscriber == null)
          subscriber = EJBGetter.getSubscriberHome().create(email, format);
      } catch (CreateException ex) {
        throw new SubscribeCtrlException(ex.getMessage());
      }

      MailSender mail = EJBGetter.getMailSenderHome().create();
      try {
        Template t = new Template();
        t.addMatcher(new SubscribeMatcher(subscriber.getEmail()));
        String text = t.parse(new File(System.getProperty("app.path") + "templates/confirm.template"));
        mail.sendText(System.getProperty("mail.news"),
                      subscriber.getEmail(),
                      "Please Confirm Your Subscription to AI Agent News", text);
      } catch (MailSenderException ex) {
        throw new SubscribeCtrlException(ex.getMessage());
      } catch (TemplateException ex) {
        throw new InternalControlException(ex);
      } finally {
        try {
          mail.remove();
        } catch (Exception ex) {}
      }
      return subscriber;
    } catch (CreateException ex) {
      throw new InternalControlException(ex);
    } catch (IOException ex) {
      throw new InternalControlException(ex);
    }
  }

  public void unsubscribe(int subscriberId) throws SubscribeCtrlException {
    try {
      Subscriber subscriber = EJBGetter.getSubscriberHome().findByPrimaryKey(subscriberId);
      subscriber.remove();
    } catch (FinderException fex) {
      throw new SubscribeCtrlException("subscriber with ID " + subscriberId + " does not exsist");
    } catch (RemoveException rex) {
      throw new SubscribeCtrlException(rex.getMessage());
    }
  }

  public void unsubscribe(String email) throws SubscribeCtrlException {
    try {
      Subscriber subscriber = EJBGetter.getSubscriberHome().findByEmail(email);
      subscriber.setActive(false);
      subscriber.remove();
    } catch (FinderException fex) {
      throw new SubscribeCtrlException("there is no such email (" + email + ") address in the recepient list");
    } catch (RemoveException rex) {
      throw new SubscribeCtrlException(rex.getMessage());
    }
  }

  public Subscriber confirm(HttpServletRequest request) throws SubscribeCtrlException {
    String email = TextProcessor.normStr(request.getParameter("email"));
    if ("".equals(email))
      throw new SubscribeCtrlException("there is no such email address in the recepient list");
    try {
      Subscriber subscriber = EJBGetter.getSubscriberHome().findByEmail(email); 
      if (! subscriber.getActive()) {
        subscriber.setNoticed(new Date());
      }
      subscriber.setActive(true);
      return subscriber;
    } catch (FinderException fex) {
      throw new SubscribeCtrlException("there is no such email (" + email + ") address in the recepient list");
    }
  }

  public Document xmlSubscribersList() throws SubscribeCtrlException {
    Document doc = Xml.createDocument();
    try {
      Node root = doc.createElement("subscribers-list");
      doc.appendChild(root);
      Iterator iter = EJBGetter.getSubscriberHome().findAll().iterator();
      while (iter.hasNext()) {
        Subscriber sub = (Subscriber)iter.next();
        Element el = doc.createElement("subscriber");
        root.appendChild(el);
        el.setAttribute("id", sub.getId() + "");
        el.setAttribute("email", sub.getEmail());
        el.setAttribute("subscribed", util.Format.dateTime(sub.getSubscribed()));
        el.setAttribute("noticed", util.Format.dateTime(sub.getNoticed()));
        el.setAttribute("format", sub.getFormat() + "");
        el.setAttribute("active", sub.getActive() + "");
      }
    } catch (FinderException fex) {
    }
    return doc;
  }

  public String massSubscribe(String emails) throws SubscribeCtrlException {
    StringBuffer badEmails = new StringBuffer();
    try {
      BufferedReader br = new BufferedReader(new java.io.StringReader(emails));
      String str_out;
      SubscribeCtrl ctrl = EJBGetter.getSubscribeCtrlHome().create();
      SubscriberHome home = EJBGetter.getSubscriberHome();
      for (str_out = br.readLine(); str_out != null; str_out = br.readLine()) {
        try {
          if (str_out.startsWith("- ")) {
            str_out = str_out.substring(2).trim();
            ctrl.unsubscribe(str_out);
          } else {
            Subscriber subs = null;
            try {
              subs = home.findByEmail(str_out);
            } catch (FinderException fex) { }
            if (subs == null) 
              ctrl.subscribe(str_out, Subscriber.FORMAT_HTML);
          }
        } catch (SubscribeCtrlException ex) {
          badEmails.append("- ").append(str_out).append("\r\n");
        }
      }
      ctrl.remove();
    } catch (Exception ex) {
    }
    return badEmails.toString();
  }

}

class SubscribeMatcher implements Matcher {

  private static String PREFIX = "confirm.";

  public String email;

  public SubscribeMatcher(String email) {
    this.email = email;
  }

  public boolean check(String value) {
    return value.startsWith(PREFIX);
  }

  public String match(String value) {
    String name = value.substring(PREFIX.length());
    try {
      Field f = this.getClass().getField(name);
      return f.get(this).toString();
    } catch (Exception ex) {
      System.out.println(ex.toString());
      return "[UNKNOWN]";
    }
  }

}