package ejb;

import javax.ejb.*;
import javax.naming.*;
import java.util.*;
import com.caucho.ejb.*;

public abstract class SpecialtyBean extends AbstractEntityBean {

  public abstract int getId();

  public abstract String getName();
  public abstract void setName(String value);

  public int ejbCreate(String name) throws CreateException {
    if (isEmptyStr(name))
      throw new CreateException("Specialty name required");
    setName(name);
    return 0;
  }

  public void ejbPostCreate(String name) { }

  public void ejbRemove() throws RemoveException { }

  public boolean equals(Object obj) {
    if ((obj instanceof Specialty) && (obj != null))
      return getId() == ((Specialty)obj).getId();
    else
      return false;
  }

  public String toString() {
    return "[Id:" + getId() + " Name:" + getName() + "]";
  }

  private boolean isEmptyStr(String str) {
    return ((str == null) || (str.trim().length() == 0));
  }

}
