package ejb;

import util.*;
import util.template.*;
import java.lang.reflect.*;
import java.io.*;
import java.util.*;
import javax.ejb.*;
import com.caucho.ejb.*;
import javax.servlet.http.*;

public class PasswordReminderCtrlBean extends AbstractSessionBean implements Matcher {

  public String login;
  public String password;
  public String name;
  public String email;

  public void ejbCreate() { }

  public void sendPassword(HttpServletRequest request) throws ControlException {

    login = TextProcessor.normStr(request.getParameter("login"));
    if ("".equals(login))
      throw new ControlException("Login name is required");

    User user = null;
    try {
      user = EJBGetter.getUserHome().findByLogin(login);
    } catch (FinderException ex) { }

    if (user == null) 
      throw new ControlException("User with the specified login does not exist");

    email = user.getEmail();
    if ((email == null) || (email.length() == 0))
      throw new ControlException("Profile with this login name does not contain email address");

    password = user.getPassword();
    name = user.getFullName();

    try {
      Template t = new Template();
      t.addMatcher(this);
      String text = t.parse(new File(System.getProperty("app.path") + "templates/reminder.template"));
      MailSender mail = EJBGetter.getMailSenderHome().create();
      try {
        mail.sendText(System.getProperty("mail.support"), email, "Password reminder", text);
      } finally {
        mail.remove();
      }
    } catch (Exception ex) {
      System.out.println("sendDownloadEmail exception:" + ex.getMessage());
    }


/*
    try  {
      MailSender ms = EJBGetter.getMailSenderHome().create();
      try {
        ms.addFrom(System.getProperty("mail.tellafriend"));
        ms.addTo(friendEmail);
        if (System.getProperty("mail.tellafriend.bcc") != null)
          ms.addBcc(System.getProperty("mail.tellafriend.bcc"));
        ms.setSubject(senderName + " has sent you a suggestion!");
        ms.setBodyText(text);
        ms.send();
      } finally {
        ms.remove();
      } 
    } catch (CreateException ex) {
      throw new ControlException(ex.getMessage(), ex);
    } catch (RemoveException ex) {
      throw new ControlException(ex.getMessage(), ex);
    }
*/
  }


  public boolean check(String value) {
    return value.startsWith("reminder.");
  }

  public String match(String value) {
    String name = value.substring(9);
    try {
      Field f = this.getClass().getField(name);
      return f.get(this).toString();
    } catch (Exception ex) {
      System.out.println(ex.toString());
      return "[UNKNOWN]";
    }
  }

}
