package ejb;

import java.util.*;
import javax.ejb.*;
import javax.naming.*;
import com.caucho.ejb.*;
import com.caucho.xml.*;
import org.w3c.dom.*;

public class NewsCtrlBean extends AbstractSessionBean {

  private final static String INTERNAL_ERROR = "internal error occurred";

  public void ejbCreate() { }

  public Document xmlList() throws NewsCtrlException {
    Document doc = Xml.createDocument();
    try {
      Node root = doc.createElement("news-list");
      doc.appendChild(root);
      Iterator iter = EJBGetter.getNewsHome().findAll().iterator();
      while (iter.hasNext()) {
        News news = (News)iter.next();
        Element el = doc.createElement("news");
        root.appendChild(el);
        el.setAttribute("id", news.getId() + "");
        el.setAttribute("posted", util.Format.date(news.getPosted()));
        el.setAttribute("subject", news.getSubject());
        el.appendChild(doc.createCDATASection(news.getText()));
      }
    } catch (FinderException fex) {
    }
    return doc;
  }

  public Document xmlNews(int id) throws NewsCtrlException {
    Document doc = Xml.createDocument();
    try {
      News news = EJBGetter.getNewsHome().findByPrimaryKey(id);
      Element root = doc.createElement("news");
      doc.appendChild(root);
      root.setAttribute("id", news.getId() + "");
      root.setAttribute("posted", util.Format.date(news.getPosted()));
      root.setAttribute("subject", news.getSubject());
      root.appendChild(doc.createCDATASection(news.getText()));
    } catch (FinderException fex) {
      throw new NewsCtrlException("news " + id + "does not exsist");
    }
    return doc;
  }

  public News post(String subject, String text) throws NewsCtrlException {
    if ((subject == null) || "".equals(subject.trim()))
      throw new NewsCtrlException("subject required");
    subject = subject.trim();
    if ((text == null) || "".equals(text.trim()))
      throw new NewsCtrlException("text required");
    try {
      News news = EJBGetter.getNewsHome().create(subject, text);
      return news;
    } catch (CreateException ex) {
      throw new NewsCtrlException(INTERNAL_ERROR, ex);
    }
  }

  public News update(int id, String subject, String text) throws NewsCtrlException {
    if ((subject == null) || "".equals(subject.trim()))
      throw new NewsCtrlException("subject required");
    subject = subject.trim();
    if ((text == null) || "".equals(text.trim()))
      throw new NewsCtrlException("text required");
    try {
      News news = EJBGetter.getNewsHome().findByPrimaryKey(id);
      news.setSubject(subject);
      news.setText(text);
      return news;
    } catch (FinderException ex) {
      throw new NewsCtrlException("news ID=" + id + " does not exist");
    }
  }

}
