package ejb;

/*
 * $Log: NewsBean.java,v $
 * Revision 1.2  2002/11/18 22:51:54  paul
 * + Log keyword added
 *
 */

import java.util.*;
import com.caucho.ejb.*;
import javax.ejb.*;
import util.*;

public abstract class NewsBean extends AbstractEntityBean {

  private String subject;

  public abstract int getId();

  public abstract Date getPosted();
  public abstract void setPosted(Date posted);

  public abstract String getSubject();
  public abstract void setSubject(String subject);

  public abstract String getText();
  public abstract void setText(String text);

  public int ejbCreate(String subject, String text) throws CreateException {
    if ((subject == null) || ("".equals(subject)))
      throw new CreateException("empty subject is not allowed");
    if ((text == null) || ("".equals(text)))
      throw new CreateException("empty text is not allowed");
    setPosted(new Date());
    setSubject(subject);
    setText(text);
    return 0;
  }

  public void ejbPostCreate(String subject, String text) { }

  public void ejbRemove() throws RemoveException { }

  public boolean equals(Object obj) {
    if ((obj instanceof News) && (obj != null))
      return getId() == ((News)obj).getId();
    else
      return false;
  }

  public String toString() {
    return "[Id:" + getId() + " Posted:" + getPosted().toString() + " Subject:" + getSubject() + "]";
  }

}