package ejb;

import javax.ejb.*;
import javax.naming.*;
import java.util.*;
import com.caucho.ejb.*;

public abstract class ForumBean extends AbstractEntityBean {

  public abstract int getId();

  public abstract String getName();
  public abstract void setName(String name);

  public abstract String getDescription();
  public abstract void setDescription(String description);

  public abstract Date getLastPost();
  public abstract void setLastPost(Date lastPost);

  public abstract boolean getActive();
  public abstract void setActive(boolean active);

  public int ejbCreate(String name, String description) throws CreateException {
    if ((name == null) || (name.trim().length() == 0))
      throw new CreateException("empty forum name not allowed.");
    if (description == null)
      description = "";
    try {
      ForumHome home = (ForumHome)getEntityContext().getEJBLocalHome();
      if (home.findByName(name) != null)
        throw new CreateException(name + " is a duplicate forum.");
    } catch (FinderException e) { }
    setName(name);
    setDescription(description);
    setLastPost(null);
    setActive(true);
    return 0;
  }

  public void ejbPostCreate(String name, String description) { }

  public void ejbRemove() throws RemoveException {
    Iterator iter = null;
    try {
      iter = EJBGetter.getTopicHome().findRoot((Forum)getEntityContext().getEJBLocalObject()).iterator();
    }
    catch (FinderException fe) {
    }
    if (iter != null) {
      while (iter.hasNext()) {
        ((Topic)iter.next()).remove();
      }
    }
  }

  public abstract int ejbSelectMessagesCount(Forum forum) throws FinderException;

  public abstract int ejbSelectTopicsCount(Forum forum) throws FinderException;

  public int getMessagesCount() {
    try {
      return ejbSelectMessagesCount((Forum)getEntityContext().getEJBLocalObject());
    } catch (FinderException fe) {
      return 0;
    }
  }

  public int getTopicsCount() {
    try {
      return ejbSelectTopicsCount((Forum)getEntityContext().getEJBLocalObject());
    } catch (FinderException fe) {
      return 0;
    }
  }

  public boolean equals(Object obj) {
    if ((obj instanceof Forum) && (obj != null))
      return getId() == ((Forum)obj).getId();
    else
      return false;
  }

  public String toString() {
    return "[Id:" + getId() + " Name:" + getName() + "]";
  }
}
