package ejb;

import util.*;
import util.template.*;
import java.io.*;
import java.lang.reflect.*;
import java.net.*;
import java.util.*;
import javax.ejb.*;
import javax.naming.*;
import com.caucho.ejb.*;
import com.caucho.vfs.*;
import javax.servlet.http.*;

public class DownloadCtrlBean extends AbstractSessionBean implements Matcher {

  public String name;
  public String email;
  public String lastFile;

  public String getName() {
    return name;
  }

  public String getEmail() {
    return email;
  }

  public String getLastFile() {
    return lastFile;
  }

  public void ejbCreate(HttpServletRequest req) throws CreateException {
    String name = TextProcessor.normStr(req.getParameter("name"));
    String email = TextProcessor.normStr(req.getParameter("email"));
    if ("".equals(name) || "".equals(email))
      throw new CreateException("name and e-mail required");
    if ((email.indexOf('@')  < 0) || (email.indexOf('.') < 0))
      throw new CreateException("Invalid e-mail address");
    ejbCreate(name, email);

    if (req.getParameter("subscribe") != null) {
     SubscribeCtrl subsCtrl = EJBGetter.getSubscribeCtrlHome().create();
     subsCtrl.subscribe(email, Subscriber.FORMAT_HTML);
     try {
       subsCtrl.remove();
     } catch (Exception ex) {
     }
    }
  }

  public void ejbCreate(String name, String email) throws CreateException {
    this.name = name;
    this.email = email;
    this.lastFile = "";
  }

  public boolean check(String str) {
    return str.startsWith("download.");
  }

  public String match(String str) {
    String name = str.substring(9);
    try {
      Field f = this.getClass().getField(name);
      return f.get(this).toString();
    } catch (Exception ex) {
      System.out.println(ex.toString());
      return "[UNKNOWN]";
    }
  }

  private void sendDownloadEmail(Download download) {
    try {
      Template t = new Template();
      t.addMatcher(this);
      String text = t.parse(new File(System.getProperty("app.path") + "templates/download.template"));
      MailSender mail = EJBGetter.getMailSenderHome().create();
      try {
        mail.sendText(System.getProperty("mail.support"), download.getEmail(), "Thank you for your interest to AI Agent", text);
      } finally {
        mail.remove();
      }
    } catch (Exception ex) {
      System.out.println("sendDownloadEmail exception:" + ex.getMessage());
    }
  }

  public Download registerDownload(String file, String addr) throws EJBException {
    try {
      Download dl = EJBGetter.getDownloadHome().create(name, email, file, addr);
      if (!file.equals(lastFile)) {
        sendDownloadEmail(dl);
        lastFile = file;
      }
      return dl;
    } catch (CreateException ex) {
      throw new InternalControlException(ex);
    }
  }

  public void valueBound(HttpSessionBindingEvent event) {
  }

  public void valueUnbound(HttpSessionBindingEvent event) {
    try {
      getSessionContext().getEJBLocalObject().remove();
    } catch (RemoveException ex) {
      System.out.println("valueUnbound RemoveException:" + ex.getMessage());
    }
  }
}
