package ejb;

import javax.ejb.*;
import javax.naming.*;
import java.util.*;
import com.caucho.ejb.*;

public abstract class DownloadBean extends AbstractEntityBean {

  public abstract int getId();

  public abstract Date getDate();
  public abstract void setDate(Date date);

  public abstract String getName();
  public abstract void setName(String name);

  public abstract String getEmail();
  public abstract void setEmail(String email);

  public abstract String getFile();
  public abstract void setFile(String file);

  public abstract String getAddress();
  public abstract void setAddress(String address);

  public int ejbCreate(String name, String email, String file, String address) throws CreateException {
    setDate(new Date());
    setName(name);
    setEmail(email);
    setFile(file);
    setAddress(address);
    return 0;
  }

  public void ejbPostCreate(String name, String email, String agent, String address) { }

  public void ejbRemove() throws RemoveException { }

  public boolean equals(Object obj) {
    if ((obj instanceof Download) && (obj != null))
      return getId() == ((Download)obj).getId();
    else
      return false;
  }

  public String toString() {
    return "[Downloader id=" + getId() + " Name: \"" + getName() + "\" Email: " + getEmail() +"]";
  }
}
