package ejb;

import util.*;
import java.io.*;
import java.util.*;
import javax.ejb.*;
import javax.servlet.http.*;
import com.caucho.xml.*;
import com.caucho.ejb.*;
import org.w3c.dom.*;

public class BrainCtrlBean extends AbstractSessionBean {

  public void ejbCreate() { }

  private Specialty findSpecialty(HttpServletRequest request) throws ControlException {
    Specialty spec = null;
    String str = TextProcessor.normStr(request.getParameter("specialtyId"));
    if (str.equals("0") || str.equals("")) {
      str = TextProcessor.normStr(request.getParameter("specialty"));
      if (str.length() == 0)
        throw new ControlException("specialty required");
      try {
        spec = EJBGetter.getSpecialtyHome().findByName(str);
      } catch (FinderException ex) { }
      if (spec == null) {
        try {
          spec = EJBGetter.getSpecialtyHome().create(str);
        } catch (CreateException ex) {
          throw new InternalControlException(ex);
        }
      }
    } else {
      int specId = 0;
      try {
        specId = Integer.parseInt(str);
        spec = EJBGetter.getSpecialtyHome().findByPrimaryKey(specId);
      } catch (Exception ex) {
        throw new ControlException("specialty required");
      }
    }
    return spec;
  }

  private File copyFile(String fileName, String outFileName) throws ControlException {
    File inFile = new File(fileName);
    File outFile = new File(System.getProperty("app.path") + "brains/" + outFileName);
    try {
      FileInputStream fis = new FileInputStream(inFile);
      FileOutputStream fos = new FileOutputStream(outFile);
      byte[] buf = new byte[0xFFFF];
      int cnt;
      while ((cnt = fis.read(buf)) > 0) {
        fos.write(buf, 0, cnt);
      }
      fis.close();
      fos.close();
    } catch (IOException ex) {
      throw new ControlException(ex.getMessage());
    }
    return outFile;
  }
  
  private String extractFileName(String name) {
  	int idx = name.lastIndexOf('\\');
  	if (idx < 0) 
  	  idx = name.lastIndexOf('/');
  	if (idx >= 0)
  	  return name.substring(idx + 1);
  	else
  	  return name;
  }

  public Brain createBrain(HttpServletRequest request) throws ControlException {
    Brain brain;
    Specialty spec = findSpecialty(request);
    String name = TextProcessor.normStr(request.getParameter("name"));
    if ("".equals(name))
      throw new ControlException("name required");
    String author = TextProcessor.normStr(request.getParameter("author"));
    String description = TextProcessor.normStr(request.getParameter("description"));
    String fileName = TextProcessor.normStr(request.getParameter("file"));
    try {
      brain = EJBGetter.getBrainHome().create(spec, name, author, description);
    } catch (CreateException ex) {
      throw new InternalControlException(ex);
    }
    File file = copyFile(fileName, extractFileName(request.getParameter("file.filename")));
    brain.setFile(file.getName());
    return brain;
  }

  public Brain updateBrain(HttpServletRequest request) throws ControlException {
    Brain brain = null;
    try {
      int id = Integer.parseInt(request.getParameter("brainId"));
      brain = EJBGetter.getBrainHome().findByPrimaryKey(id);
    } catch (Exception ex) {
      throw new ControlException(ex.getMessage());
    }
    Specialty spec = findSpecialty(request);
    String name = TextProcessor.normStr(request.getParameter("name"));
    if ("".equals(name))
      throw new ControlException("name required");
    String author = TextProcessor.normStr(request.getParameter("author"));
    String description = TextProcessor.normStr(request.getParameter("description"));
    boolean visible = TextProcessor.normStr(request.getParameter("visible")).length() > 0;
    String fileName = TextProcessor.normStr(request.getParameter("file"));
    brain.setSpecialty(spec);
    brain.setName(name);
    brain.setAuthor(author);
    brain.setDescription(description);
    brain.setVisible(visible);
    if (TextProcessor.normStr(request.getParameter("file.filename")).length() > 0) {
    	new File(System.getProperty("app.path") + "brains/" + brain.getFile()).delete();
      File file = copyFile(fileName, extractFileName(request.getParameter("file.filename")));
      brain.setFile(file.getName());
      brain.setUpdated(new Date());
    }
    return brain;
  }

  public Document xmlList() {
    Document doc = Xml.createDocument();
    try {
      Node root = doc.createElement("brains-list");
      doc.appendChild(root);
      Iterator iter = EJBGetter.getBrainHome().findAll().iterator();
      while (iter.hasNext()) {
        Brain brain = (Brain)iter.next();
        File f = new File(System.getProperty("app.path") + "brains/" + brain.getFile());
        Element el = doc.createElement("brain");
        root.appendChild(el);
        el.setAttribute("id", brain.getId() + "");
        el.setAttribute("specialty", brain.getSpecialty().getName());
        el.setAttribute("name", brain.getName());
        el.setAttribute("created", util.Format.dateTime(brain.getCreated()));
        el.setAttribute("updated", util.Format.dateTime(brain.getUpdated()));
        el.setAttribute("size", brain.getSize() + "");
        el.setAttribute("file", brain.getFile());
        el.setAttribute("author", brain.getAuthor());
        el.setAttribute("description", brain.getDescription());
        el.setAttribute("visible", brain.getVisible() + "");
        el.setAttribute("file-exists", brain.getExists() + "");
      }
    } catch (Exception e) { }
    return doc;
  }

  public Document xmlSpecialtySelector(Specialty currSpec) {
    Document doc = Xml.createDocument();
    try {
      Node root = doc.createElement("specialty-selector");
      doc.appendChild(root);
      Iterator iter = EJBGetter.getSpecialtyHome().findAll().iterator();
      while (iter.hasNext()) {
        Specialty spec = (Specialty)iter.next();
        Element el = doc.createElement("specialty");
        root.appendChild(el);
        el.setAttribute("id", spec.getId() + "");
        el.setAttribute("name", spec.getName());
        if (spec.equals(currSpec)) {
          el.setAttribute("selected", "true");
        }
      }
    } catch (Exception e) { }
    return doc;
  }

  public Document xmlBookshelf(String filter) throws ControlException {
    Document doc = Xml.createDocument();
    try {
      Node root = doc.createElement("bookshelf");
      doc.appendChild(root);
      filter = TextProcessor.normStr(filter);
      Iterator iter = null;
      try {
        if (filter.trim().length() > 0)
          iter = EJBGetter.getBrainHome().findVisibleLike("%" + filter + "%").iterator();
        else
          iter = EJBGetter.getBrainHome().findVisible().iterator();
      } catch (FinderException ex) {}
      Hashtable tbl = new Hashtable();
      while ((iter != null) && iter.hasNext()) {
        Brain brain = (Brain)iter.next();
        if (brain.getVisible() && brain.getExists()) {
          Specialty spec = brain.getSpecialty();
          Element elSpec;
          if (tbl.containsKey(spec.getName())) {
            elSpec = (Element)tbl.get(spec.getName());
            if (elSpec.getChildNodes().getLength() >= 10) {
              Element newEl = doc.createElement("specialty");
              newEl.setAttribute("id", spec.getId() + "");
              newEl.setAttribute("name", spec.getName());
              root.replaceChild(newEl, elSpec);
              root.insertBefore(elSpec, newEl);
              elSpec = newEl;              
              tbl.put(spec.getName(), elSpec);
            }
          } else {
            elSpec = doc.createElement("specialty");
            tbl.put(spec.getName(), elSpec);
            root.appendChild(elSpec);
            elSpec.setAttribute("id", spec.getId() + "");
            elSpec.setAttribute("name", spec.getName());
          }
          Element elBrain = doc.createElement("brain");
          elSpec.appendChild(elBrain);
          elBrain.setAttribute("id", brain.getId() + "");
          elBrain.setAttribute("specialty", brain.getSpecialty().getName());
          elBrain.setAttribute("name", brain.getName());
          elBrain.setAttribute("created", util.Format.dateTime(brain.getCreated()));
          elBrain.setAttribute("updated", util.Format.dateTime(brain.getUpdated()));
          elBrain.setAttribute("size", Format.fileSize(brain.getSize()));
          elBrain.setAttribute("file", brain.getFile());
          elBrain.setAttribute("author", brain.getAuthor());
          elBrain.setAttribute("description", brain.getDescription());
          elBrain.setAttribute("image-number", ((brain.getId() % 11) + 1) + "");
        }
      }
    } catch (Exception ex) {
      throw new InternalControlException(ex);
    }
    return doc;
  }

}
