package ejb;

import java.io.*;
import java.util.*;
import javax.ejb.*;
import javax.naming.*;
import com.caucho.ejb.*;

public abstract class BrainBean extends AbstractEntityBean {

  public abstract int getId();

  public abstract Specialty getSpecialty();
  public abstract void setSpecialty(Specialty specialty);

  public abstract String getName();
  public abstract void setName(String value);

  public abstract Date getCreated();
  public abstract void setCreated(Date value);

  public abstract Date getUpdated();
  public abstract void setUpdated(Date value);

  public abstract String getFile();
  public abstract void setFile(String value);

  public abstract String getAuthor();
  public abstract void setAuthor(String value);

  public abstract String getDescription();
  public abstract void setDescription(String value);

  public abstract boolean getVisible();
  public abstract void setVisible(boolean visible);

  public long getSize() {
    return new File(System.getProperty("app.path") + "brains/" + getFile()).length();
  }

  public boolean getExists() {
    return new File(System.getProperty("app.path") + "brains/" + getFile()).exists();
  }

  public int ejbCreate(Specialty spec, String name, String author, String description) throws CreateException {
    Date now = new Date();
    setSpecialty(spec);
    setName(name);
    setCreated(now);
    setUpdated(now);
    if ("".equals(author))
      setAuthor("Unknown");
    else
      setAuthor(author);
    setDescription(description);
    setVisible(true);
    return 0;
  }

  public void ejbPostCreate(Specialty spec, String name, String author, String description) throws CreateException { }

  public void ejbRemove() throws RemoveException {
    File file = new File(System.getProperty("app.path") + "brains/" + getFile());
    file.delete();
  }

  public boolean equals(Object obj) {
    if ((obj instanceof Brain) && (obj != null))
      return getId() == ((Brain)obj).getId();
    else
      return false;
  }

  public String toString() {
    return "[Id:" + getId() + " Name:" + getName() + "]";
  }

  private boolean isEmptyStr(String str) {
    return ((str == null) || (str.trim().length() == 0));
  }

}
