#
# $Log: mysql.sql,v $
# Revision 1.2  2002/11/18 22:56:00  paul
# + Log keyword added
#
#

SET AUTOCOMMIT=0;

begin;

##### USER #####
drop table if exists user; 
create table user (
  id int not null auto_increment,
  login varchar(20) not null,
  password varchar(20) not null,
  name varchar(50) default '',
  email varchar(100) default '',
  registered datetime not null,
  prev_address varchar(15) default '[unknown]',
  prev_login datetime,
  curr_address varchar(15) default '[unknown]',
  curr_login datetime,
  primary key (id)) type=bdb;

create unique index idx_user_login on user (login);

insert into user (login, password, name, registered) values ('admin', '123123', '', now());
insert into user (login, password, name, registered) values ('anonymous', now(), '', now());
insert into user (login, password, name, registered) values ('dead', now(), '', now());
insert into user (login, password, name, registered) values ('reserved04', now(), '', now());
insert into user (login, password, name, registered) values ('reserved05', now(), '', now());
insert into user (login, password, name, registered) values ('reserved06', now(), '', now());
insert into user (login, password, name, registered) values ('reserved07', now(), '', now());
insert into user (login, password, name, registered) values ('reserved08', now(), '', now());
insert into user (login, password, name, registered) values ('reserved09', now(), '', now());
insert into user (login, password, name, registered) values ('reserved10', now(), '', now());
insert into user (login, password, name, registered) values ('reserved11', now(), '', now());
insert into user (login, password, name, registered) values ('reserved12', now(), '', now());
insert into user (login, password, name, registered) values ('reserved13', now(), '', now());
insert into user (login, password, name, registered) values ('reserved14', now(), '', now());
insert into user (login, password, name, registered) values ('reserved15', now(), '', now());
insert into user (login, password, name, registered) values ('reserved16', now(), '', now());
insert into user (login, password, name, registered) values ('reserved17', now(), '', now());
insert into user (login, password, name, registered) values ('reserved18', now(), '', now());
insert into user (login, password, name, registered) values ('reserved19', now(), '', now());
insert into user (login, password, name, registered) values ('reserved20', now(), '', now());

##### FORUM #####

drop table if exists forum; 
create table forum (
  id int not null auto_increment,
  name varchar(100) not null,
  description text default '',
  last_post datetime,
  active int(1) not null default 1,
  primary key (id)) type=bdb;

create unique index idx_forum_name on forum (name);

insert into forum (name, description) values ('forum1', 'test forum number one');
insert into forum (name, description) values ('forum2', 'test forum number two');

##### TOPIC #####

drop table if exists topic; 
create table topic (
  id int not null auto_increment,
  parent int,
  forum int not null,
  user int not null,
  subject varchar(100) not null,
  text text default '',
  posted datetime,
  viewed int not null default 0,
  active int(1) not null default 1,
  primary key (id)) type=bdb;

create index idx_topic_parent on topic (parent);
create index idx_topic_forum_parent on topic (forum, parent);

##### NEWS #####

drop table if exists news; 
create table news (
  id int not null auto_increment,
  posted datetime not null,
  subject varchar(250) not null default '',
  text text not null default '',
  primary key (id)) type=bdb;

create index idx_news_posted on news (posted);

##### SUBSCRIBER #####

drop table if exists subscriber; 
create table subscriber (
  id int not null auto_increment,
  email varchar(100) not null,
  subscribed datetime not null,
  noticed datetime not null,
  format int not null default 1,
  active int(1) not null default 1,
  primary key (id)) type=bdb;

create unique index idx_subscriber_email on subscriber (email);
create index idx_subscriber_active on subscriber (active);

##### DOWNLOAD #####

drop table if exists download; 
create table download (
  id int not null auto_increment,
  date datetime not null,
  name varchar(100) not null,
  email varchar(100) not null,
  file varchar(30) not null,
  address varchar(15) not null,
  primary key (id)) type=bdb;

commit;
