
// ========================================================================
// Copyright (c) 1999 Mort Bay Consulting (Australia) Pty. Ltd.
// $Id: MultiException.java,v 1.3 2001/09/17 01:25:31 gregwilkins Exp $
// ========================================================================

package org.mortbay.util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;


/* ------------------------------------------------------------ */
/** Wraps multiple exceptions.
 *
 * Allows multiple exceptions to be thrown as a single exception.
 *
 * @version 1.0 Thu Mar 29 2001
 * @author Greg Wilkins (gregw)
 */
public class MultiException extends Exception
{
    private LazyList nested;

    /* ------------------------------------------------------------ */
    public MultiException()
    {
        super("Multiple exceptions");
    }

    /* ------------------------------------------------------------ */
    public void add(Exception e)
    {
        nested=LazyList.add(nested,e);
    }

    /* ------------------------------------------------------------ */
    public int size()
    {
        return LazyList.size(nested);
    }
    
    /* ------------------------------------------------------------ */
    public List getExceptions()
    {
        return LazyList.getList(nested);
    }
    
    /* ------------------------------------------------------------ */
    public Exception getException(int i)
    {
        return (Exception) LazyList.get(nested,i);
    }

    /* ------------------------------------------------------------ */
    /** Throw a multiexception.
     * If this multi exception is empty then no action is taken. If it
     * contains a single exception that is thrown, otherwise the this
     * multi exception is thrown. 
     * @exception Exception 
     */
    public void ifExceptionThrow()
        throws Exception
    {
        switch (LazyList.size(nested))
        {
          case 0:
              break;
          case 1:
              throw (Exception)LazyList.get(nested,0);
          default:
              throw this;
        }
    }
    
    /* ------------------------------------------------------------ */
    /** Throw a multiexception.
     * If this multi exception is empty then no action is taken. If it
     * contains a any exceptions then this
     * multi exception is thrown. 
     */
    public void ifExceptionThrowMulti()
        throws MultiException
    {
        if (LazyList.size(nested)>0)
            throw this;
    }

    /* ------------------------------------------------------------ */
    public String toString()
    {
        if (LazyList.size(nested)>0)
            return "org.mortbay.util.MultiException"+
                LazyList.getList(nested);
        return "org.mortbay.util.MultiException[]";
    }
    
}
