// ========================================================================
// Copyright (c) 1999 Mort Bay Consulting (Australia) Pty. Ltd.
// $Id: LifeCycle.java,v 1.2 2001/09/11 05:32:00 gregwilkins Exp $
// ========================================================================

package org.mortbay.util;/* ------------------------------------------------------------ */
/** A component LifeCycle.
 * Represents the life cycle interface for an abstract
 * software component. Implementations should respect
 * the following state table:<PRE>
 * State: Destroyed (initial state)
 *    start()      -> Started
 *    stop()       -> Stopped
 *    destroy()    -> Destroyed
 *
 * State: Stopped
 *    start()      -> Started
 *    stop()       -> Stopped
 *    destroy()    -> Destroyed
 *
 * State: Started
 *    start()      -> Started
 *    stop()       -> Stopped
 *    destroy()    -> Destroyed
 * </PRE>
 *
 * @version $Id: LifeCycle.java,v 1.2 2001/09/11 05:32:00 gregwilkins Exp $
 * @author Greg Wilkins (gregw)
 */
public interface LifeCycle
{
    /* ------------------------------------------------------------ */
    /** Start the LifeCycle.
     * @exception Exception An arbitrary exception may be thrown.
     */
    public void start()
        throws Exception;
    
    /* ------------------------------------------------------------ */
    /** Stop the LifeCycle.
     * The LifeCycle may wait for current activities to complete
     * normally, but it can be interrupted.
     */
    public void stop()
        throws InterruptedException;
    
    /* ------------------------------------------------------------ */
    /** Destroy the LifeCycle.
     * Activities are terminated.
     */
    public void destroy();

    /* ------------------------------------------------------------ */
    /** 
     * @return True if the LifeCycle has been started. 
     */
    public boolean isStarted();
    
    /* ------------------------------------------------------------ */
    /** 
     * @return True if the LifeCycle has been destroyed. 
     */
    public boolean isDestroyed();
    
}

