// ========================================================================
// Copyright (c) 1999 Mort Bay Consulting (Australia) Pty. Ltd.
// $Id: HttpListener.java,v 1.1 2001/09/02 01:13:08 gregwilkins Exp $
// ========================================================================

package org.mortbay.http;
import org.mortbay.util.LifeCycle;
import java.net.UnknownHostException;
import java.net.ServerSocket;


/* ------------------------------------------------------------ */
/** HTTP Listener.
 *
 * @see HttpConnection
 * @version $Id: HttpListener.java,v 1.1 2001/09/02 01:13:08 gregwilkins Exp $
 * @author Greg Wilkins (gregw)
 */
public interface HttpListener extends LifeCycle
{
    public abstract void setHttpServer(HttpServer server);
    public abstract HttpServer getHttpServer();
    public abstract void setHost(String host)
        throws UnknownHostException;
    public abstract String getHost();
    public abstract void setPort(int port);
    public abstract int getPort();

    public abstract String getDefaultScheme();
    public abstract ServerSocket getServerSocket();
    
    public abstract void customizeRequest(HttpConnection connection,
                                          HttpRequest request);
    public abstract void persistConnection(HttpConnection connection);
    
    public abstract boolean isLowOnResources();
    public abstract boolean isOutOfResources();
}











