<?php
/***************************************************************************
 *                              viewtransto.php
 *                            -------------------
 *   begin                : Friday, November 08, 2002
 *   last modified        : Friday, April 25, 2003
 *   copyright            : (C) 2002 Conan Tran
 *   website			  : www.maihoatrang.com
 *   email                : conanqtran@maihoatrang.com
 *
 *   $Id: viewtransto.php,v 0.99 2002/11/08 10:37:00 conanqtran Exp $
 *
 *   $FMId: 2003/05/03 14:38:12 mj 
 *
 ***************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 ***************************************************************************/

define('IN_PHPBB', true);
$phpbb_root_path = './';
include($phpbb_root_path . 'extension.inc');
include($phpbb_root_path . 'common.'.$phpEx);

//
// Start session management
//
$userdata = session_pagestart($user_ip, PAGE_MY_TRANS, $session_length);
init_userprefs($userdata);
//
// End session management
//

$start = ( isset($HTTP_GET_VARS['start']) ) ? intval($HTTP_GET_VARS['start']) : 0;

if(isset($HTTP_POST_VARS['order']))
{
	$sort_order = ($HTTP_POST_VARS['order'] == 'ASC') ? 'ASC' : 'DESC';
}
else if(isset($HTTP_GET_VARS['order']))
{
	$sort_order = ($HTTP_GET_VARS['order'] == 'ASC') ? 'ASC' : 'DESC';
}
else
{
	$sort_order = 'ASC';
}

//
// Transactions sorting
//

$mode_types_text = array($lang['Sort_Trans_Date'], $lang['Sort_Trans_To'], $lang['Sort_Trans_Amount'], $lang['Sort_Top_Ten_Trans']);
$mode_types = array('transdate', 'transto', 'transamount', 'toptentrans');

$select_sort_mode = '<select name="mode">';
for($i = 0; $i < count($mode_types_text); $i++)
{
	$selected = ( $mode == $mode_types[$i] ) ? ' selected="selected"' : '';
	$select_sort_mode .= '<option value="' . $mode_types[$i] . '"' . $selected . '>' . $mode_types_text[$i] . '</option>';
}
$select_sort_mode .= '</select>';

$select_sort_order = '<select name="order">';
if($sort_order == 'ASC')
{
	$select_sort_order .= '<option value="ASC" selected="selected">' . $lang['Sort_Ascending'] . '</option><option value="DESC">' . $lang['Sort_Descending'] . '</option>';
}
else
{
	$select_sort_order .= '<option value="ASC">' . $lang['Sort_Ascending'] . '</option><option value="DESC" selected="selected">' . $lang['Sort_Descending'] . '</option>';
}
$select_sort_order .= '</select>';

//
// Generate page
//
$page_title = $lang['My_Trans'];

include($phpbb_root_path . 'includes/page_header.'.$phpEx);

$template->set_filenames(array(
	'body' => 'viewtransfrom.tpl')
);
make_jumpbox('viewforum.'.$phpEx);

$template->assign_vars(array(
	'L_SELECT_SORT_METHOD' => $lang['Select_sort_method'],
	'L_SUBMIT' => $lang['Sort'],
	'L_ORDER' => $lang['Order'],

	'L_TRANS_FROM' => $lang['Trans_From'],
	'L_TRANS_TO' => $lang['Trans_To'],
	'L_TRANS_AMOUNT' => $lang['Trans_Amount'],
	'L_TRANS_REASON' => $lang['Points_reason'],
	'L_TRANS_DATE' => $lang['Trans_Date'],
	'L_CUSTOM_POINT_NAME' => $lang['Custom_Point_Name'],
	'L_TOTAL_TRANS' => $lang['Total_Trans'],

	'S_MODE_SELECT' => $select_sort_mode,
	'S_ORDER_SELECT' => $select_sort_order,
	'S_MODE_ACTION' => append_sid("viewtransfrom.$phpEx"))
);

if ( isset($HTTP_GET_VARS['mode']) || isset($HTTP_POST_VARS['mode']) )
{
	$mode = ( isset($HTTP_POST_VARS['mode']) ) ? $HTTP_POST_VARS['mode'] : $HTTP_GET_VARS['mode'];

	switch( $mode )
	{
		case 'transdate':
			$order_by = "trans_date $sort_order LIMIT $start, " . $board_config['topics_per_page'];
			break;
		case 'transto':
			$order_by = "trans_to $sort_order LIMIT $start, " . $board_config['topics_per_page'];
			break;

		case 'transamount':
			$order_by = "trans_amount $sort_order LIMIT $start, " . $board_config['topics_per_page'];
			break;
		case 'toptentrans':
			$order_by = "trans_amount DESC LIMIT 10";
			break;

		default:
			$order_by = "trans_date DESC LIMIT $start, " . $board_config['topics_per_page'];
			break;
	}
}
else
{
	$order_by = "trans_date DESC LIMIT $start, " . $board_config['topics_per_page'];
}

$sql = "SELECT trans_date, trans_from, trans_to, trans_amount, trans_reason
	FROM " . TRANSACTION_TABLE . "
	WHERE trans_from = '" . $userdata['username'] . "'
	ORDER BY $order_by";


if( !($result = $db->sql_query($sql)) )
{
	message_die(GENERAL_ERROR, 'Could not query transaction', '', __LINE__, __FILE__, $sql);
}

if ( $row = $db->sql_fetchrow($result) )
{
	$i = 0;
	do
	{
		$trans_from = $row['trans_from'];
		$trans_to = $row['trans_to'];
		$trans_amount = ( $row['trans_amount'] ) ? $row['trans_amount'] : 0;
		$trans_reason = $row['trans_reason'];
		$trans_date = create_date($board_config['default_dateformat'], $row['trans_date'], $board_config['board_timezone']);

		$row_color = ( !($i % 2) ) ? $theme['td_color1'] : $theme['td_color2'];
		$row_class = ( !($i % 2) ) ? $theme['td_class1'] : $theme['td_class2'];

		$template->assign_block_vars('transrow', array(
			'ROW_NUMBER' => $i + ( $HTTP_GET_VARS['start'] + 1 ),
			'ROW_COLOR' => '#' . $row_color,
			'ROW_CLASS' => $row_class,
			'TRANS_FROM' => $trans_from,
			'TRANS_TO' => $trans_to,
			'TRANS_AMOUNT' => $trans_amount,
			'TRANS_REASON' => $trans_reason,
			'TRANS_DATE' => $trans_date)
		);

		$i++;
	}
	while ( $row = $db->sql_fetchrow($result) );
}


$sql = "SELECT sum(trans_amount) AS total_sent_from
	FROM " . TRANSACTION_TABLE . "
	WHERE trans_from = '" . $userdata['username'] . "'";

if ( !($result = $db->sql_query($sql)) )
{
	message_die(GENERAL_ERROR, 'Error getting total transactions', '', __LINE__, __FILE__, $sql);
}

if ( $total_sent_from = $db->sql_fetchrow($result) )
{
	$total_money = $total_sent_from['total_sent_from'];
	$template->assign_block_vars('totalsendfrom', array(
		'TOTAL_SENT_FROM' => $total_money)
	);

}


if ( $mode != 'topten' || $board_config['topics_per_page'] < 10 )
{
	$sql = "SELECT count(*) AS total
		FROM " . TRANSACTION_TABLE . "
		WHERE trans_from = '" . $userdata['username'] . "'";

	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Error getting total transactions', '', __LINE__, __FILE__, $sql);
	}

	if ( $total = $db->sql_fetchrow($result) )
	{
		$total_trans = $total['total'];

		$pagination = generate_pagination("viewtransfrom.$phpEx?mode=$mode&amp;order=$sort_order", $total_trans, $board_config['topics_per_page'], $start). '&nbsp;';
	}
}
else
{
	$pagination = '&nbsp;';
	$total_trans = 10;
}

$template->assign_vars(array(
	'PAGINATION' => $pagination,
	'PAGE_NUMBER' => sprintf($lang['Page_of'], ( floor( $start / $board_config['topics_per_page'] ) + 1 ), ceil( $total_trans / $board_config['topics_per_page'] )),
	'L_GOTO_PAGE' => $lang['Goto_page'])
);


$template->pparse('body');

include($phpbb_root_path . 'includes/page_tail.'.$phpEx);

?>
