<?php
/***************************************************************************
 *                               viewtopic.php
 *                            -------------------
 *   begin                : Saturday, Feb 13, 2001
 *   copyright            : (C) 2001 The phpBB Group
 *   email                : support@phpbb.com
 *
 *   $Id: viewtopic.php,v 1.186.2.32 2003/06/20 16:34:58 psotfx Exp $
 *
 ***************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 ***************************************************************************/

/***************************************************************************
 * This file has been modified by Fully Moddded phpBB
 *
 *   $FMId: 2003/08/13 23:00:12 mj
 *
 ***************************************************************************/

define('IN_PHPBB', true);
$phpbb_root_path = './';
include($phpbb_root_path . 'extension.inc');
include($phpbb_root_path . 'common.'.$phpEx);
include($phpbb_root_path . 'includes/bbcode.'.$phpEx);
include($phpbb_root_path . 'includes/functions_points.'.$phpEx);
include($phpbb_root_path . 'includes/functions_user_viewed_posts.'.$phpEx);
include($phpbb_root_path . 'calendar/mycalendar_functions.'.$phpEx);
$phpbb_host_path = 'http://'.$board_config['server_name'].$board_config['script_path'];


//
// Start initial var setup
//
$topic_id = $post_id = 0; 

if ( isset($HTTP_GET_VARS[POST_TOPIC_URL]) )
{
	$topic_id = intval($HTTP_GET_VARS[POST_TOPIC_URL]);
}
else if ( isset($HTTP_GET_VARS['topic']) )
{
	$topic_id = intval($HTTP_GET_VARS['topic']);
}
else if ( $HTTP_GET_VARS['view'] == 'random' ) 
{ 
    $sql = "SELECT t.topic_id 
        FROM " . TOPICS_TABLE . " t 
        ORDER BY RAND() 
        LIMIT 1"; 
    if ( !($result = $db->sql_query($sql)) ) 
    { 
        message_die(GENERAL_ERROR, "Could not obtain random topic information", '', __LINE__, __FILE__, $sql); 
    } 
    if ( !($row = $db->sql_fetchrow($result)) ) 
    { 
        message_die(GENERAL_MESSAGE, 'Topic_post_not_exist'); 
    } 
    else 
    { 
        $topic_id = $row['topic_id']; 
    } 
} 

if ( isset($HTTP_GET_VARS[POST_POST_URL]))
{
	$post_id = intval($HTTP_GET_VARS[POST_POST_URL]);
}

$start = ( isset($HTTP_GET_VARS['start']) ) ? intval($HTTP_GET_VARS['start']) : 0;

if ( !isset($topic_id) && !isset($post_id) && $HTTP_GET_VARS['view'] != 'random')
{
	message_die(GENERAL_MESSAGE, 'Topic_post_not_exist');
}

//
// Find topic id if user requested a newer
// or older topic
//
if ( isset($HTTP_GET_VARS['view']) && empty($HTTP_GET_VARS[POST_POST_URL]) )
{
	if ( $HTTP_GET_VARS['view'] == 'newest' )
	{
		if ( isset($HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_sid']) || isset($HTTP_GET_VARS['sid']) )
		{
			$session_id = isset($HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_sid']) ? $HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_sid'] : $HTTP_GET_VARS['sid'];

			if ( $session_id )
			{
				$sql = "SELECT p.post_id
					FROM " . POSTS_TABLE . " p, " . SESSIONS_TABLE . " s,  " . USERS_TABLE . " u
					WHERE s.session_id = '$session_id'
						AND u.user_id = s.session_user_id
						AND p.topic_id = $topic_id
						AND p.post_time >= u.user_lastvisit
					ORDER BY p.post_time ASC
					LIMIT 1";
				if ( !($result = $db->sql_query($sql)) )
				{
					message_die(GENERAL_ERROR, 'Could not obtain newer/older topic information', '', __LINE__, __FILE__, $sql);
				}

				if ( !($row = $db->sql_fetchrow($result)) )
				{
					message_die(GENERAL_MESSAGE, 'No_new_posts_last_visit');
				}

				$post_id = $row['post_id'];

				if (isset($HTTP_GET_VARS['sid']))
				{
					redirect("viewtopic.$phpEx?sid=$session_id&" . POST_POST_URL . "=$post_id#$post_id");
				}
				else
				{
					redirect("viewtopic.$phpEx?" . POST_POST_URL . "=$post_id#$post_id");
				}
			}
		}

		redirect(append_sid("viewtopic.$phpEx?" . POST_TOPIC_URL . "=$topic_id", true));
	}
	else if ( $HTTP_GET_VARS['view'] == 'next' || $HTTP_GET_VARS['view'] == 'previous' )
	{
		$sql_condition = ( $HTTP_GET_VARS['view'] == 'next' ) ? '>' : '<';
		$sql_ordering = ( $HTTP_GET_VARS['view'] == 'next' ) ? 'ASC' : 'DESC';

		$sql = "SELECT t.topic_id
			FROM " . TOPICS_TABLE . " t, " . TOPICS_TABLE . " t2
			WHERE
				t2.topic_id = $topic_id
				AND t.forum_id = t2.forum_id
				AND t.topic_last_post_id $sql_condition t2.topic_last_post_id
			ORDER BY t.topic_last_post_id $sql_ordering
			LIMIT 1";
		if ( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, "Could not obtain newer/older topic information", '', __LINE__, __FILE__, $sql);
		}

		if ( $row = $db->sql_fetchrow($result) )
		{
			$topic_id = intval($row['topic_id']);
		}
		else
		{
			$message = ( $HTTP_GET_VARS['view'] == 'next' ) ? 'No_newer_topics' : 'No_older_topics';
			message_die(GENERAL_MESSAGE, $message);
		}
	}
}

//
// This rather complex gaggle of code handles querying for topics but
// also allows for direct linking to a post (and the calculation of which
// page the post is on and the correct display of viewtopic)
//
$join_sql_table = ( empty($post_id) ) ? '' : ", " . POSTS_TABLE . " p, " . POSTS_TABLE . " p2 ";
$join_sql = ( empty($post_id) ) ? "t.topic_id = $topic_id" : "p.post_id = $post_id AND t.topic_id = p.topic_id AND p2.topic_id = p.topic_id AND p2.post_id <= $post_id";
$count_sql = ( empty($post_id) ) ? '' : ", COUNT(p2.post_id) AS prev_posts";

$order_sql = ( empty($post_id) ) ? '' : "GROUP BY p.post_id, t.topic_id, t.topic_title, t.topic_status, t.topic_replies, t.topic_time, t.topic_type, t.topic_vote, t.topic_last_post_id, f.forum_name, f.forum_status, f.forum_id, f.auth_view, f.auth_read, f.auth_post, f.auth_reply, f.auth_edit, f.auth_delete, f.auth_sticky, f.auth_announce, f.auth_pollcreate, f.auth_vote, f.auth_attachments, f.auth_ban, f.auth_voteban, f.auth_greencard, f.auth_bluecard ORDER BY p.post_id ASC";

$sql = "SELECT t.topic_id, t.topic_title, t.topic_status, t.topic_replies, t.topic_time, t.topic_type, t.topic_vote, t.topic_last_post_id, t.answer_status, f.forum_name, f.forum_status, f.forum_id, f.auth_view, f.auth_read, f.auth_post, f.auth_reply, f.auth_edit, f.auth_delete, f.auth_sticky, f.auth_announce, f.auth_pollcreate, f.auth_vote, f.auth_attachments, f.auth_ban, f.auth_voteban, f.auth_greencard, f.auth_bluecard" . $count_sql . ", f.cat_id
	FROM " . TOPICS_TABLE . " t, " . FORUMS_TABLE . " f" . $join_sql_table . "
	WHERE $join_sql
		AND f.forum_id = t.forum_id
		$order_sql";
attach_setup_viewtopic_auth($order_sql, $sql);
if ( !($result = $db->sql_query($sql)) )
{
	message_die(GENERAL_ERROR, "Could not obtain topic information", '', __LINE__, __FILE__, $sql);
}

if ( !($forum_topic_data = $db->sql_fetchrow($result)) )
{
	message_die(GENERAL_MESSAGE, 'Topic_post_not_exist');
}

$forum_id = intval($forum_topic_data['forum_id']);
$topic_id = $forum_topic_data['topic_id'];

//
// Start session management
//
$userdata = session_pagestart($user_ip, $forum_id, $topic_id);
init_userprefs($userdata);
//
// End session management
//

//
// Start auth check
//
$is_auth = array();
$is_auth = auth(AUTH_ALL, $forum_id, $userdata, $forum_topic_data);

if( !$is_auth['auth_view'] || !$is_auth['auth_read'] )
{
	if ( !$userdata['session_logged_in'] )
	{
		$redirect = ( isset($post_id) ) ? POST_POST_URL . "=$post_id" : POST_TOPIC_URL . "=$topic_id";
		$redirect .= ( isset($start) ) ? "&start=$start" : '';
		redirect(append_sid("login.$phpEx?redirect=viewtopic.$phpEx&$redirect", true));
	}

	$message = ( !$is_auth['auth_view'] ) ? $lang['Topic_post_not_exist'] : sprintf($lang['Sorry_auth_read'], $is_auth['auth_read_type']);

	message_die(GENERAL_MESSAGE, $message);
}
//
// End auth check
//

//
// Update topic view information
//
$user_id=$userdata['user_id'];
$sql='UPDATE '.TOPIC_VIEW_TABLE.' SET topic_id="'.$topic_id.'", view_time="'.time().'", view_count=view_count+1 WHERE topic_id='.$topic_id.' AND user_id='.$user_id;
if ( !$db->sql_query($sql) || !$db->sql_affectedrows() )
{
	$sql = 'INSERT IGNORE INTO '.TOPIC_VIEW_TABLE.' (topic_id, user_id, view_time,view_count)
		VALUES ("'.$topic_id.'", "'.$user_id.'", "'.time().'","1")';
	if ( !($db->sql_query($sql)) )
	{
		message_die(CRITICAL_ERROR, 'Error creating user view topic information', '', __LINE__, __FILE__, $sql);
	}
}

$forum_name = $forum_topic_data['forum_name'];
$topic_title = $forum_topic_data['topic_title'];
$topic_id = intval($forum_topic_data['topic_id']);
$topic_time = $forum_topic_data['topic_time'];

if ( !empty($post_id) )
{
	$start = floor(($forum_topic_data['prev_posts'] - 1) / intval($board_config['posts_per_page'])) * intval($board_config['posts_per_page']);
}

//
// Is user watching this thread?
//
if( $userdata['session_logged_in'] )
{
	$can_watch_topic = TRUE;

	$sql = "SELECT notify_status
		FROM " . TOPICS_WATCH_TABLE . "
		WHERE topic_id = $topic_id
			AND user_id = " . $userdata['user_id'];
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, "Could not obtain topic watch information", '', __LINE__, __FILE__, $sql);
	}

	if ( $row = $db->sql_fetchrow($result) )
	{
		if ( isset($HTTP_GET_VARS['unwatch']) )
		{
			if ( $HTTP_GET_VARS['unwatch'] == 'topic' )
			{
				$is_watching_topic = 0;

				$sql_priority = (SQL_LAYER == "mysql") ? "LOW_PRIORITY" : '';
				$sql = "DELETE $sql_priority FROM " . TOPICS_WATCH_TABLE . "
					WHERE topic_id = $topic_id
						AND user_id = " . $userdata['user_id'];
				if ( !($result = $db->sql_query($sql)) )
				{
					message_die(GENERAL_ERROR, "Could not delete topic watch information", '', __LINE__, __FILE__, $sql);
				}
			}

			$template->assign_vars(array(
				'META' => '<meta http-equiv="refresh" content="3;url=' . append_sid("viewtopic.$phpEx?" . POST_TOPIC_URL . "=$topic_id&amp;start=$start") . '">')
			);

			$message = $lang['No_longer_watching'] . '<br /><br />' . sprintf($lang['Click_return_topic'], '<a href="' . append_sid("viewtopic.$phpEx?" . POST_TOPIC_URL . "=$topic_id&amp;start=$start") . '">', '</a>');
			message_die(GENERAL_MESSAGE, $message);
		}
		else
		{
			$is_watching_topic = TRUE;

			if ( $row['notify_status'] )
			{
				$sql_priority = (SQL_LAYER == "mysql") ? "LOW_PRIORITY" : '';
				$sql = "UPDATE $sql_priority " . TOPICS_WATCH_TABLE . "
					SET notify_status = 0
					WHERE topic_id = $topic_id
						AND user_id = " . $userdata['user_id'];
				if ( !($result = $db->sql_query($sql)) )
				{
					message_die(GENERAL_ERROR, "Could not update topic watch information", '', __LINE__, __FILE__, $sql);
				}
			}
		}
	}
	else
	{
		if ( isset($HTTP_GET_VARS['watch']) )
		{
			if ( $HTTP_GET_VARS['watch'] == 'topic' )
			{
				$is_watching_topic = TRUE;

				$sql_priority = (SQL_LAYER == "mysql") ? "LOW_PRIORITY" : '';
				$sql = "INSERT $sql_priority INTO " . TOPICS_WATCH_TABLE . " (user_id, topic_id, notify_status)
					VALUES (" . $userdata['user_id'] . ", $topic_id, 0)";
				if ( !($result = $db->sql_query($sql)) )
				{
					message_die(GENERAL_ERROR, "Could not insert topic watch information", '', __LINE__, __FILE__, $sql);
				}
			}

			$template->assign_vars(array(
				'META' => '<meta http-equiv="refresh" content="3;url=' . append_sid("viewtopic.$phpEx?" . POST_TOPIC_URL . "=$topic_id&amp;start=$start") . '">')
			);

			$message = $lang['You_are_watching'] . '<br /><br />' . sprintf($lang['Click_return_topic'], '<a href="' . append_sid("viewtopic.$phpEx?" . POST_TOPIC_URL . "=$topic_id&amp;start=$start") . '">', '</a>');
			message_die(GENERAL_MESSAGE, $message);
		}
		else
		{
			$is_watching_topic = 0;
		}
	}
}
else
{
	if ( isset($HTTP_GET_VARS['unwatch']) )
	{
		if ( $HTTP_GET_VARS['unwatch'] == 'topic' )
		{
			redirect(append_sid("login.$phpEx?redirect=viewtopic.$phpEx&" . POST_TOPIC_URL . "=$topic_id&unwatch=topic", true));
		}
	}
	else
	{
		$can_watch_topic = 0;
		$is_watching_topic = 0;
	}
}

//
// Get the hierarchie
//
$cat_id = $forum_topic_data['cat_id'];

$sql = "SELECT concat(c.cat_title, ', ', f.forum_name) AS hierarchie_title, f.forum_id, f.forum_hier_level + 1 AS hierarchie_level
	FROM " . CATEGORIES_TABLE . " c, " . CAT_REL_CAT_PARENTS_TABLE . " ccp, " . FORUMS_TABLE . " f, " . CAT_REL_FORUM_PARENTS_TABLE . " cfp
	WHERE ccp.parent_cat_id = c.cat_id
	AND ccp.cat_id = $cat_id
	AND cfp.parent_forum_id = f.forum_id
	AND cfp.cat_id = $cat_id
	AND f.cat_id = c.cat_id
	ORDER BY c.cat_hier_level, f.forum_hier_level";

if( !($result = $db->sql_query($sql)) )
{
	message_die(GENERAL_ERROR, 'Could not query hierarchie title', '', __LINE__, __FILE__, $sql);
}
while( $row = $db->sql_fetchrow($result) )
{
	$template->assign_block_vars("navrow", array(
		'U_SUBINDEX' => append_sid("index.$phpEx?" . POST_HIERARCHIE_URL . "=" . $row['hierarchie_level'] . "&" . POST_PARENTFORUM_URL . "=" . $row['forum_id']),
		'L_SUBINDEX' => $row['hierarchie_title'])
	);
}

//
// Get the category title
//
$sql = "SELECT cat_title
	FROM " . CATEGORIES_TABLE . "
	WHERE cat_id = $cat_id";

if( !($result = $db->sql_query($sql)) )
{
	message_die(GENERAL_ERROR, 'Could not query category title', '', __LINE__, __FILE__, $sql);
}
$row = $db->sql_fetchrow($result);
$cf_title = $row['cat_title'] . ", " . $forum_topic_data['forum_name'];


//
// Is the topic answered or unanswered?
//
$sql = "SELECT t.topic_id, t.topic_first_post_id, t.answer_status, p.post_id, p.poster_id
	      FROM " . TOPICS_TABLE . " t, " . POSTS_TABLE . " p
	      WHERE t.topic_id = " . $topic_id . "
	      AND t.topic_first_post_id = p.post_id";
   $result = $db->sql_query($sql);
   $row = $db->sql_fetchrow($result);

if ($row['poster_id'] == $userdata['user_id'] AND $userdata['user_id'] != '-1')
{
	if( $userdata['session_logged_in'] )
	{
		if ($mode == 'answered')
		{
			$sql = "UPDATE " . TOPICS_TABLE . " 
					SET answer_status = 1 
					WHERE topic_id = $topic_id";
				if ( !$result = $db->sql_query($sql) )
				{
					message_die(GENERAL_ERROR, 'Could not update topic status', '', __LINE__, __FILE__, $sql);
				}
				$template->assign_vars(array(
				
				'META' => '<meta http-equiv="refresh" content="3;url=' . append_sid("viewtopic.$phpEx?" . POST_TOPIC_URL . "=$topic_id") . '">')
			);
	
			$message = $lang['Marked_answered'] . '<br /><br />' . sprintf($lang['Click_return_topic'], '<a href="' . append_sid("viewtopic.$phpEx?" . POST_TOPIC_URL . "=$topic_id") . '">', '</a>') . '<br /><br />' . sprintf($lang['Click_return_forum'], '<a href="' . append_sid("viewforum.$phpEx?" . POST_FORUM_URL . "=$forum_id") . '">', '</a>');
			message_die(GENERAL_MESSAGE, $message);
		}

		if ($mode == 'unanswered')
		{
			$sql = "UPDATE " . TOPICS_TABLE . " 
					SET answer_status = 0 
					WHERE topic_id = $topic_id";
				if ( !$result = $db->sql_query($sql) )
				{
					message_die(GENERAL_ERROR, 'Could not update topic status', '', __LINE__, __FILE__, $sql);
				}
				$template->assign_vars(array(
			
				'META' => '<meta http-equiv="refresh" content="3;url=' . append_sid("viewtopic.$phpEx?" . POST_TOPIC_URL . "=$topic_id") . '">')
			);
	
			$message = $lang['Marked_unanswered'] . '<br /><br />' . sprintf($lang['Click_return_topic'], '<a href="' . append_sid("viewtopic.$phpEx?" . POST_TOPIC_URL . "=$topic_id") . '">', '</a>') . '<br /><br />' . sprintf($lang['Click_return_forum'], '<a href="' . append_sid("viewforum.$phpEx?" . POST_FORUM_URL . "=$forum_id") . '">', '</a>');
			message_die(GENERAL_MESSAGE, $message);
		}

		if ( $row['answer_status'] == '1' )
		{
			$answer_link = '<a href="' . append_sid("viewtopic.$phpEx?t=$topic_id&mode=unanswered"). '"><img src="' . $images['icon_answered'] . '" border="0" alt="' . $lang['Marked_answered'] . '"></a>';
		}
		else
		{
			$answer_link = '<a href="' . append_sid("viewtopic.$phpEx?t=$topic_id&mode=answered"). '"><img src="' . $images['icon_unanswered'] . '" border="0" alt="' . $lang['Marked_unanswered'] . '"></a>';
		}
	}
}
else
{
	$answer_link = '';
}

//
// Generate a 'Show posts in previous x days' select box. If the postdays var is POSTed
// then get it's value, find the number of topics with dates newer than it (to properly
// handle pagination) and alter the main query
//
$previous_days = array(0, 1, 7, 14, 30, 90, 180, 364);
$previous_days_text = array($lang['All_Posts'], $lang['1_Day'], $lang['7_Days'], $lang['2_Weeks'], $lang['1_Month'], $lang['3_Months'], $lang['6_Months'], $lang['1_Year']);

if( !empty($HTTP_POST_VARS['postdays']) || !empty($HTTP_GET_VARS['postdays']) )
{
	$post_days = ( !empty($HTTP_POST_VARS['postdays']) ) ? $HTTP_POST_VARS['postdays'] : $HTTP_GET_VARS['postdays'];
	$min_post_time = time() - (intval($post_days) * 86400);

	$sql = "SELECT COUNT(p.post_id) AS num_posts
		FROM " . TOPICS_TABLE . " t, " . POSTS_TABLE . " p
		WHERE t.topic_id = $topic_id
			AND p.topic_id = t.topic_id
			AND p.post_time >= $min_post_time";
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, "Could not obtain limited topics count information", '', __LINE__, __FILE__, $sql);
	}

	$total_replies = ( $row = $db->sql_fetchrow($result) ) ? intval($row['num_posts']) : 0;

	$limit_posts_time = "AND p.post_time >= $min_post_time ";

	if ( !empty($HTTP_POST_VARS['postdays']))
	{
		$start = 0;
	}
}
else
{
	$total_replies = intval($forum_topic_data['topic_replies']) + 1;

	$limit_posts_time = '';
	$post_days = 0;
}

$select_post_days = '<select name="postdays">';
for($i = 0; $i < count($previous_days); $i++)
{
	$selected = ($post_days == $previous_days[$i]) ? ' selected="selected"' : '';
	$select_post_days .= '<option value="' . $previous_days[$i] . '"' . $selected . '>' . $previous_days_text[$i] . '</option>';
}
$select_post_days .= '</select>';

//
// Decide how to order the post display
//
if ( !empty($HTTP_POST_VARS['postorder']) || !empty($HTTP_GET_VARS['postorder']) )
{
	$post_order = (!empty($HTTP_POST_VARS['postorder'])) ? $HTTP_POST_VARS['postorder'] : $HTTP_GET_VARS['postorder'];
	$post_time_order = ($post_order == "asc") ? "ASC" : "DESC";
}
else
{
	$post_order = 'asc';
	$post_time_order = 'ASC';
}

$select_post_order = '<select name="postorder">';
if ( $post_time_order == 'ASC' )
{
	$select_post_order .= '<option value="asc" selected="selected">' . $lang['Oldest_First'] . '</option><option value="desc">' . $lang['Newest_First'] . '</option>';
}
else
{
	$select_post_order .= '<option value="asc">' . $lang['Oldest_First'] . '</option><option value="desc" selected="selected">' . $lang['Newest_First'] . '</option>';
}
$select_post_order .= '</select>';

update_user_viewed($userdata['user_id'], $topic_id);

//
// Go ahead and pull all data for this topic
//
$sql = 'SELECT user_style, COUNT(*) as total FROM ' . USERS_TABLE . ' GROUP BY user_style';
if ( !$result = $db->sql_query($sql) )
{
	message_die(GENERAL_ERROR, 'Could not obtain user style counts.', '', __LINE__, __FILE__, $sql);
}
while( $style_row = $db->sql_fetchrow($result) )
{
	$style_counts[$style_row['user_style']] = $style_row['total']; 
}

$sql = "SELECT u.*, u.user_avatar as current_user_avatar, u.user_avatar_type as current_user_avatar_type, p.*,  pt.post_text, pt.post_subject, pt.bbcode_uid, t.style_name
	FROM " . POSTS_TABLE . " p, " . USERS_TABLE . " u, " . POSTS_TEXT_TABLE . " pt, " . THEMES_TABLE . " t
	WHERE p.topic_id = $topic_id
		$limit_posts_time
		AND pt.post_id = p.post_id
		AND u.user_id = p.poster_id
		AND t.themes_id = u.user_style
	ORDER BY p.post_time $post_time_order
	LIMIT $start, ".$board_config['posts_per_page'];
if ( !($result = $db->sql_query($sql)) )
{
	message_die(GENERAL_ERROR, "Could not obtain post/user information.", '', __LINE__, __FILE__, $sql);
}

$postrow = $user_sig_cache = array();
if ($row = $db->sql_fetchrow($result))
{
	do
	{
		$postrow[] = $row;
	}
	while ($row = $db->sql_fetchrow($result));
	$db->sql_freeresult($result);

	$total_posts = count($postrow);
}
else 
{ 
   include($phpbb_root_path . 'includes/functions_admin.' . $phpEx); 
   sync('topic', $topic_id); 

   message_die(GENERAL_MESSAGE, $lang['No_posts_topic']); 
} 

$resync = FALSE; 
if ($forum_topic_data['topic_replies'] + 1 < $start + count($postrow)) 
{ 
   $resync = TRUE; 
} 
elseif ($start + $board_config['posts_per_page'] > $forum_topic_data['topic_replies']) 
{ 
   $row_id = intval($forum_topic_data['topic_replies']) % intval($board_config['posts_per_page']); 
   if ($postrow[$row_id]['post_id'] != $forum_topic_data['topic_last_post_id'] || $start + count($postrow) < $forum_topic_data['topic_replies']) 
   { 
      $resync = TRUE; 
   } 
} 
elseif (count($postrow) < $board_config['posts_per_page']) 
{ 
   $resync = TRUE; 
} 

if ($resync) 
{ 
   include($phpbb_root_path . 'includes/functions_admin.' . $phpEx); 
   sync('topic', $topic_id); 

   $result = $db->sql_query('SELECT COUNT(post_id) AS total FROM ' . POSTS_TABLE . ' WHERE topic_id = ' . $topic_id); 
   $row = $db->sql_fetchrow($result); 
   $total_replies = $row['total']; 
}

$sql = "SELECT *
	FROM " . RANKS_TABLE . "
	ORDER BY rank_special, rank_min";
if ( !($result = $db->sql_query($sql)) )
{
	message_die(GENERAL_ERROR, "Could not obtain ranks information.", '', __LINE__, __FILE__, $sql);
}

$ranksrow = array();
while ( $row = $db->sql_fetchrow($result) )
{
	$ranksrow[] = $row;
}
$db->sql_freeresult($result);

//
// Define censored word matches
//
if ( $userdata['user_level'] != ADMIN && $userdata['user_level'] != MOD )
{
    $orig_word = array();
    $replacement_word = array();
    obtain_word_list($orig_word, $replacement_word);
}

//
// Censor topic title
//
if ( count($orig_word) )
{
	$topic_title = preg_replace($orig_word, $replacement_word, $topic_title);
}

//
// Was a highlight request part of the URI?
//
$highlight_match = $highlight = '';
if (isset($HTTP_GET_VARS['highlight']))
{
	// Split words and phrases
	$words = explode(' ', trim(htmlspecialchars($HTTP_GET_VARS['highlight'])));

	for($i = 0; $i < sizeof($words); $i++)
	{
		if (trim($words[$i]) != '')
		{
			$highlight_match .= (($highlight_match != '') ? '|' : '') . str_replace('*', '\w*', phpbb_preg_quote($words[$i], '#'));
		}
	}
	unset($words);

	$highlight = urlencode($HTTP_GET_VARS['highlight']);
}

//
// Post, reply and other URL generation for
// templating vars
//
$new_topic_url = append_sid("posting.$phpEx?mode=newtopic&amp;" . POST_FORUM_URL . "=$forum_id");
$reply_topic_url = append_sid("posting.$phpEx?mode=reply&amp;" . POST_TOPIC_URL . "=$topic_id");
$view_forum_url = append_sid("viewforum.$phpEx?" . POST_FORUM_URL . "=$forum_id");
$view_prev_topic_url = append_sid("viewtopic.$phpEx?" . POST_TOPIC_URL . "=$topic_id&amp;view=previous");
$view_next_topic_url = append_sid("viewtopic.$phpEx?" . POST_TOPIC_URL . "=$topic_id&amp;view=next");

//
// Mozilla navigation bar
//
$nav_links['prev'] = array(
	'url' => $view_prev_topic_url,
	'title' => $lang['View_previous_topic']
);
$nav_links['next'] = array(
	'url' => $view_next_topic_url,
	'title' => $lang['View_next_topic']
);
$nav_links['up'] = array(
	'url' => $view_forum_url,
	'title' => $forum_name
);

$reply_img = ( $forum_topic_data['forum_status'] == FORUM_LOCKED || $forum_topic_data['topic_status'] == TOPIC_LOCKED ) ? $images['reply_locked'] : $images['reply_new'];
$reply_img_mini = ( $forum_topic_data['forum_status'] == FORUM_LOCKED || $forum_topic_data['topic_status'] == TOPIC_LOCKED ) ? $images['reply_locked_mini'] : $images['reply_new_mini'];
$reply_alt = ( $forum_topic_data['forum_status'] == FORUM_LOCKED || $forum_topic_data['topic_status'] == TOPIC_LOCKED ) ? $lang['Topic_locked'] : $lang['Reply_to_topic'];
$post_img = ( $forum_topic_data['forum_status'] == FORUM_LOCKED ) ? $images['post_locked'] : $images['post_new'];
$post_alt = ( $forum_topic_data['forum_status'] == FORUM_LOCKED ) ? $lang['Forum_locked'] : $lang['Post_new_topic'];
$print_topic_img = $images['topic_print'];
$tell_friend_img = $images['topic_tell_friend'];
$next_topic_img = $images['topic_next'];
$previous_topic_img = $images['topic_previous'];
$refresh_topic_img = $images['topic_refresh'];
$bookmark_topic_img = $images['topic_bookmark'];
$sub_topic_img = $images['topic_subscribe'];

//
// Set a cookie for this topic
//
if ( $userdata['session_logged_in'] )
{
	$tracking_topics = ( isset($HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_t']) ) ? unserialize($HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_t']) : array();
	$tracking_forums = ( isset($HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_f']) ) ? unserialize($HTTP_COOKIE_VARS[$board_config['cookie_name'] . '_f']) : array();

	if ( !empty($tracking_topics[$topic_id]) && !empty($tracking_forums[$forum_id]) )
	{
		$topic_last_read = ( $tracking_topics[$topic_id] > $tracking_forums[$forum_id] ) ? $tracking_topics[$topic_id] : $tracking_forums[$forum_id];
	}
	else if ( !empty($tracking_topics[$topic_id]) || !empty($tracking_forums[$forum_id]) )
	{
		$topic_last_read = ( !empty($tracking_topics[$topic_id]) ) ? $tracking_topics[$topic_id] : $tracking_forums[$forum_id];
	}
	else
	{
		$topic_last_read = $userdata['user_lastvisit'];
	}

	if ( count($tracking_topics) >= 150 && empty($tracking_topics[$topic_id]) )
	{
		asort($tracking_topics);
		unset($tracking_topics[key($tracking_topics)]);
	}

	$tracking_topics[$topic_id] = time();

	setcookie($board_config['cookie_name'] . '_t', serialize($tracking_topics), 0, $board_config['cookie_path'], $board_config['cookie_domain'], $board_config['cookie_secure']);
}

//
// Load templates
//
$template->set_filenames(array(
	'body' => 'viewtopic_body.tpl')
);
make_jumpbox('viewforum.'.$phpEx, $forum_id);

//
// Output page header
//
define('SHOW_ONLINE', true); 
$page_title = $lang['View_topic'] .' - ' . $topic_title;
include($phpbb_root_path . 'includes/page_header.'.$phpEx);

//
// User authorisation levels output
//
$s_auth_can = ( ( $is_auth['auth_post'] ) ? $lang['Rules_post_can'] : $lang['Rules_post_cannot'] ) . '<br />';
$s_auth_can .= ( ( $is_auth['auth_reply'] ) ? $lang['Rules_reply_can'] : $lang['Rules_reply_cannot'] ) . '<br />';
$s_auth_can .= ( ( $is_auth['auth_edit'] ) ? $lang['Rules_edit_can'] : $lang['Rules_edit_cannot'] ) . '<br />';
$s_auth_can .= ( ( $is_auth['auth_delete'] ) ? $lang['Rules_delete_can'] : $lang['Rules_delete_cannot'] ) . '<br />';
$s_auth_can .= ( ( $is_auth['auth_vote'] ) ? $lang['Rules_vote_can'] : $lang['Rules_vote_cannot'] ) . '<br />';
$s_auth_can .= ( $is_auth['auth_ban'] ) ? $lang['Rules_ban_can'] . "<br />" : ""; 
$s_auth_can .= ( $is_auth['auth_greencard'] ) ? $lang['Rules_greencard_can'] . "<br />" : ""; 
$s_auth_can .= ( $is_auth['auth_voteban'] ) ? $lang['Rules_voteban_can'] . "<br />" : ""; 
$s_auth_can .= ( $is_auth['auth_bluecard'] ) ? $lang['Rules_bluecard_can'] . "<br />" : ""; 
attach_build_auth_levels($is_auth, $s_auth_can);

$topic_mod = '';

if ( $is_auth['auth_mod'] )
{
	$s_auth_can .= sprintf($lang['Rules_moderate'], "<a href=\"modcp.$phpEx?" . POST_FORUM_URL . "=$forum_id&amp;sid=" . $userdata['session_id'] . '">', '</a>');

	$topic_mod .= "<a href=\"modcp.$phpEx?" . POST_TOPIC_URL . "=$topic_id&amp;mode=delete&amp;sid=" . $userdata['session_id'] . '"><img src="' . $images['topic_mod_delete'] . '" alt="' . $lang['Delete_topic'] . '" title="' . $lang['Delete_topic'] . '" border="0" /></a>&nbsp;';

	$topic_mod .= "<a href=\"modcp.$phpEx?" . POST_TOPIC_URL . "=$topic_id&amp;mode=move&amp;sid=" . $userdata['session_id'] . '"><img src="' . $images['topic_mod_move'] . '" alt="' . $lang['Move_topic'] . '" title="' . $lang['Move_topic'] . '" border="0" /></a>&nbsp;';

	$topic_mod .= ( $forum_topic_data['topic_status'] == TOPIC_UNLOCKED ) ? "<a href=\"modcp.$phpEx?" . POST_TOPIC_URL . "=$topic_id&amp;mode=lock&amp;sid=" . $userdata['session_id'] . '"><img src="' . $images['topic_mod_lock'] . '" alt="' . $lang['Lock_topic'] . '" title="' . $lang['Lock_topic'] . '" border="0" /></a>&nbsp;' : "<a href=\"modcp.$phpEx?" . POST_TOPIC_URL . "=$topic_id&amp;mode=unlock&amp;sid=" . $userdata['session_id'] . '"><img src="' . $images['topic_mod_unlock'] . '" alt="' . $lang['Unlock_topic'] . '" title="' . $lang['Unlock_topic'] . '" border="0" /></a>&nbsp;';

	$topic_mod .= "<a href=\"modcp.$phpEx?" . POST_TOPIC_URL . "=$topic_id&amp;mode=split&amp;sid=" . $userdata['session_id'] . '"><img src="' . $images['topic_mod_split'] . '" alt="' . $lang['Split_topic'] . '" title="' . $lang['Split_topic'] . '" border="0" /></a>&nbsp;';

	$topic_mod .= "<a href=\"modcp.$phpEx?" . POST_TOPIC_URL . "=$topic_id&amp;mode=link&amp;sid=" . $userdata['session_id'] . '"><img src="' . $images['topic_mod_link'] . '" alt="' . $lang['Link_topic'] . '" title="' . $lang['Link_topic'] . '" border="0" /></a>&nbsp;';

	$topic_mod .= ( $forum_topic_data['topic_type'] != 1 ) ? "<a href=\"modcp.$phpEx?" . POST_TOPIC_URL . "=$topic_id&amp;mode=sticky&amp;sid=" . $userdata['session_id'] . '"><img src="' . $images['topic_mod_sticky'] . '" alt="' . $lang['Sticky_topic'] . '" title="' . $lang['Sticky_topic'] . '" border="0" /></a>&nbsp;' : "<a href=\"modcp.$phpEx?" . POST_TOPIC_URL . "=$topic_id&amp;mode=unsticky&amp;sid=" . $userdata['session_id'] . '"><img src="' . $images['topic_mod_unsticky'] . '" alt="' . $lang['Unsticky_topic'] . '" title="' . $lang['Unsticky_topic'] . '" border="0" /></a>&nbsp;';

	$topic_mod .= ( $forum_topic_data['topic_type'] != 2 ) ? "<a href=\"modcp.$phpEx?" . POST_TOPIC_URL . "=$topic_id&amp;mode=announce&amp;sid=" . $userdata['session_id'] . '"><img src="' . $images['topic_mod_announce'] . '" alt="' . $lang['Announce_topic'] . '" title="' . $lang['Announce_topic'] . '" border="0" /></a>&nbsp;' : "<a href=\"modcp.$phpEx?" . POST_TOPIC_URL . "=$topic_id&amp;mode=unannounce&amp;sid=" . $userdata['session_id'] . '"><img src="' . $images['topic_mod_unannounce'] . '" alt="' . $lang['Unannounce_topic'] . '" title="' . $lang['Unannounce_topic'] . '" border="0" /></a>&nbsp;';
}

//
// Topic watch information
//
$s_watching_topic = '';
if ( $can_watch_topic )
{
	if ( $is_watching_topic )
	{
		$s_watching_topic = "<a href=\"viewtopic.$phpEx?" . POST_TOPIC_URL . "=$topic_id&amp;unwatch=topic&amp;start=$start&amp;sid=" . $userdata['session_id'] . '">' . $lang['Stop_watching_topic'] . '</a>';
		$s_watching_topic_img = ( isset($images['topic_un_watch']) ) ? "<a href=\"viewtopic.$phpEx?" . POST_TOPIC_URL . "=$topic_id&amp;unwatch=topic&amp;start=$start&amp;sid=" . $userdata['session_id'] . '"><img src="' . $images['topic_un_watch'] . '" alt="' . $lang['Stop_watching_topic'] . '" title="' . $lang['Stop_watching_topic'] . '" border="0"></a>' : '';
	}
	else
	{
		$s_watching_topic = "<a href=\"viewtopic.$phpEx?" . POST_TOPIC_URL . "=$topic_id&amp;watch=topic&amp;start=$start&amp;sid=" . $userdata['session_id'] . '">' . $lang['Start_watching_topic'] . '</a>';
		$s_watching_topic_img = ( isset($images['topic_watch']) ) ? "<a href=\"viewtopic.$phpEx?" . POST_TOPIC_URL . "=$topic_id&amp;watch=topic&amp;start=$start&amp;sid=" . $userdata['session_id'] . '"><img src="' . $images['topic_watch'] . '" alt="' . $lang['Start_watching_topic'] . '" title="' . $lang['Start_watching_topic'] . '" border="0"></a>' : '';
	}
}

//
// If we've got a hightlight set pass it on to pagination,
// I get annoyed when I lose my highlight after the first page.
//
$pagination = ( $highlight != '' ) ? generate_pagination("viewtopic.$phpEx?" . POST_TOPIC_URL . "=$topic_id&amp;postdays=$post_days&amp;postorder=$post_order&amp;highlight=$highlight", $total_replies, $board_config['posts_per_page'], $start) : generate_pagination("viewtopic.$phpEx?" . POST_TOPIC_URL . "=$topic_id&amp;postdays=$post_days&amp;postorder=$post_order", $total_replies, $board_config['posts_per_page'], $start);

//
// Send vars to template
//
$template->assign_vars(array(
	'FORUM_ID' => $forum_id,
      'FORUM_NAME' => $forum_name,
	'FORUM_NAVNAME' => $cf_title,
	'TOPIC_ID' => $topic_id,
	'TOPIC_POSTS' => $total_replies,
	'TOPIC_TITLE' => $topic_title,
	'TOPIC_TITLE_BOOKMARK' => str_replace("'", "&apos;", $topic_title),
	'PAGINATION' => $pagination,
	'PAGE_NUMBER' => sprintf($lang['Page_of'], ( floor( $start / intval($board_config['posts_per_page']) ) + 1 ), ceil( $total_replies / intval($board_config['posts_per_page']) )),
      'PREVIOUS_TOPIC_EXTRAS' => $previous_topic_extras,
      'NEXT_TOPIC_EXTRAS' => $next_topic_extras,

	'POST_IMG' => $post_img,
	'REPLY_IMG' => $reply_img,
	'REPLY_IMG_MINI' => $reply_img_mini,
	'PRINT_TOPIC_IMG' => $print_topic_img,
	'TELL_FRIEND_IMG' => $tell_friend_img,
	'NEXT_TOPIC_IMG' => $next_topic_img,
	'PREVIOUS_TOPIC_IMG' => $previous_topic_img,
	'REFRESH_TOPIC_IMG' => $refresh_topic_img,
	'BOOKMARK_TOPIC_IMG' => $bookmark_topic_img,
	'SUB_TOPIC_IMG' => $sub_topic_img,
	'ANSWER_STATUS' => $answer_link,

	'L_AUTHOR' => $lang['Author'],
	'L_MESSAGE' => $lang['Message'],
	'L_POSTED' => $lang['Posted'],
	'L_POST_SUBJECT' => $lang['Post_subject'],
	'L_MEMBER_NUMBER' => $lang['Member_number'],
	'L_VIEW_NEXT_TOPIC' => $lang['View_next_topic'],
	'L_VIEW_PREVIOUS_TOPIC' => $lang['View_previous_topic'],
	'L_POST_NEW_TOPIC' => $post_alt,
	'L_POST_REPLY_TOPIC' => $reply_alt,
	'L_BACK_TO_TOP' => $lang['Back_to_top'],
	'L_BACK_AT_BOTTOM' => $lang['Back_at_bottom'],
	'L_DISPLAY_POSTS' => $lang['Display_posts'],
	'L_LOCK_TOPIC' => $lang['Lock_topic'],
	'L_UNLOCK_TOPIC' => $lang['Unlock_topic'],
	'L_MOVE_TOPIC' => $lang['Move_topic'],
	'L_SPLIT_TOPIC' => $lang['Split_topic'],
	'L_DELETE_TOPIC' => $lang['Delete_topic'],
	'L_GOTO_PAGE' => $lang['Goto_page'],
	'L_PRINT' => $lang['Print_View'], 
	'L_TELL_FRIEND' => $lang['Tell_Friend'],
	'L_TOPIC_BOOKMARK' => $lang['Topic_bookmark'], 
	'L_SUB_TO_THREAD' => $lang['Sub_to_thread'],
	'L_REFRESH_PAGE' => $lang['Refresh_page'],	
	'L_USER_TIME' => $lang['Time'],
	'L_POSTS' => $lang['Posts'],

	'S_TOPIC_LINK' => POST_TOPIC_URL,
	'S_SELECT_POST_DAYS' => $select_post_days,
	'S_SELECT_POST_ORDER' => $select_post_order,
	'S_POST_DAYS_ACTION' => append_sid("viewtopic.$phpEx?" . POST_TOPIC_URL . '=' . $topic_id . "&amp;start=$start"),
	'S_AUTH_LIST' => $s_auth_can,
	'S_TOPIC_ADMIN' => $topic_mod,
	'S_WATCH_TOPIC' => $s_watching_topic,
	'S_WATCH_TOPIC_IMG' => $s_watching_topic_img,

	'U_SUB_TO_THREAD' => append_sid("subscp.$phpEx?" . POST_TOPIC_URL . "=$topic_id&amp;mode=add_t"),
	'U_TOPIC_BOOKMARK' => 'http://' . $board_config['server_name'] . ( ($board_config['server_port'] != '80') ? ':' . $board_config['server_port'] : '' ) . $board_config['script_path'] . "viewtopic.$phpEx?" . POST_TOPIC_URL . "=$topic_id&view=newest", 
	'U_PRINT' => append_sid("printview.$phpEx?" . POST_TOPIC_URL . "=$topic_id&amp;start=$start"), 
	'TELL_LINK' => append_sid($phpbb_host_path . "viewtopic.$phpEx?" . POST_TOPIC_URL . "=$topic_id&start=$start&postdays=$post_days&postorder=$post_order&highlight=$highlight"), 
	'U_VIEW_TOPIC' => append_sid("viewtopic.$phpEx?" . POST_TOPIC_URL . "=$topic_id&amp;start=$start&amp;postdays=$post_days&amp;postorder=$post_order&amp;highlight=$highlight"),
	'U_VIEW_FORUM' => $view_forum_url,
	'U_VIEW_OLDER_TOPIC' => $view_prev_topic_url,
	'U_VIEW_NEWER_TOPIC' => $view_next_topic_url,
	'U_POST_NEW_TOPIC' => $new_topic_url,
	'U_POST_REPLY_TOPIC' => $reply_topic_url)
);

//
// Quick reply
//
if ($is_auth['auth_reply'] == true)
{
	$quick_reply_img = ( $forum_topic_data['forum_status'] == FORUM_LOCKED || $forum_topic_data['topic_status'] == TOPIC_LOCKED ) ? $images['reply_locked'] : $images['quick_reply']; 
	$quick_reply_alt = ( $forum_topic_data['forum_status'] == FORUM_LOCKED || $forum_topic_data['topic_status'] == TOPIC_LOCKED ) ? $lang['Topic_locked'] : $lang['Quick_Reply_to_topic']; 
	
	if ( !$userdata['session_logged_in'] )
	{
		$template->assign_block_vars('switch_username_field', array());
	}
	
	$template->assign_block_vars('quick_reply', array(
	'QUOTE_IMG' => $quote_img,
	'QUICK_REPLY_IMG' => $quick_reply_img, 

	'L_QUICK_REPLY_TOPIC' => $quick_reply_alt,
	'L_EMPTY_MESSAGE' => $lang['Empty_message'], 		
	
	'U_QUICK_REPLY' => append_sid('posting.' . $phpEx),
	'U_HIDDEN_FORM_FIELDS' => ( ($userdata['user_attachsig'] ? '<input type="hidden" name="attach_sig" value="1" />' : "") . ($userdata['user_notify'] ? '<input type="hidden" name="notify" value="1" />' : "") . '<input type="hidden" name="mode" value="reply" /><input type="hidden" name="post" value="1"><input type="hidden" name="' . POST_TOPIC_URL . '" value="' . $topic_id . '" /> <input type="hidden" name="sid" value="' . $userdata['session_id'] . '" />' )));
}

//
// Does this topic contain a poll?
//
if ( !empty($forum_topic_data['topic_vote']) )
{
	$s_hidden_fields = '';

	$sql = "SELECT vd.vote_id, vd.vote_text, vd.vote_start, vd.vote_length, vd.vote_max, vd.vote_voted, vr.vote_option_id, vr.vote_option_text, vr.vote_result
		FROM " . VOTE_DESC_TABLE . " vd, " . VOTE_RESULTS_TABLE . " vr
		WHERE vd.topic_id = $topic_id
			AND vr.vote_id = vd.vote_id
		ORDER BY vr.vote_option_id ASC";
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, "Could not obtain vote data for this topic", '', __LINE__, __FILE__, $sql);
	}

	if ( $vote_info = $db->sql_fetchrowset($result) )
	{
		$db->sql_freeresult($result);
		$vote_options = count($vote_info);

		$vote_id = $vote_info[0]['vote_id'];
		$vote_title = $vote_info[0]['vote_text'];
		$max_vote = $vote_info[0]['vote_max'];
		$voted_vote = $vote_info[0]['vote_voted'];

		$sql = "SELECT vote_id
			FROM " . VOTE_USERS_TABLE . "
			WHERE vote_id = $vote_id
				AND vote_user_id = " . intval($userdata['user_id']);
		if ( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, "Could not obtain user vote data for this topic", '', __LINE__, __FILE__, $sql);
		}

		$user_voted = ( $row = $db->sql_fetchrow($result) ) ? TRUE : 0;
		$db->sql_freeresult($result);

		if ( isset($HTTP_GET_VARS['vote']) || isset($HTTP_POST_VARS['vote']) )
		{
			$view_result = ( ( ( isset($HTTP_GET_VARS['vote']) ) ? $HTTP_GET_VARS['vote'] : $HTTP_POST_VARS['vote'] ) == 'viewresult' ) ? TRUE : 0;
		}
		else
		{
			$view_result = 0;
		}

		$poll_expired = ( $vote_info[0]['vote_length'] ) ? ( ( $vote_info[0]['vote_start'] + $vote_info[0]['vote_length'] < time() ) ? TRUE : 0 ) : 0;

		if ( $user_voted || $view_result || $poll_expired || !$is_auth['auth_vote'] || $forum_topic_data['topic_status'] == TOPIC_LOCKED )
		{
			$template->set_filenames(array(
				'pollbox' => 'viewtopic_poll_result.tpl')
			);

			$vote_results_sum = 0;

			for($i = 0; $i < $vote_options; $i++)
			{
				$vote_results_sum += $vote_info[$i]['vote_result'];
			}

			$vote_graphic = 0;
			$vote_graphic_max = count($images['voting_graphic']);

			for($i = 0; $i < $vote_options; $i++)
			{
				$vote_percent = ( $vote_results_sum > 0 ) ? $vote_info[$i]['vote_result'] / $vote_results_sum : 0;
				$vote_graphic_length = round($vote_percent * $board_config['vote_graphic_length']);

				$vote_graphic_img = $images['voting_graphic'][$vote_graphic];
				$vote_graphic = ($vote_graphic < $vote_graphic_max - 1) ? $vote_graphic + 1 : 0;

				if ( count($orig_word) )
				{
					$vote_info[$i]['vote_option_text'] = preg_replace($orig_word, $replacement_word, $vote_info[$i]['vote_option_text']);
				}

				$template->assign_block_vars("poll_option", array(
					'POLL_OPTION_CAPTION' => $vote_info[$i]['vote_option_text'],
					'POLL_OPTION_RESULT' => $vote_info[$i]['vote_result'],
					'POLL_OPTION_PERCENT' => sprintf("%.1d%%", ($vote_percent * 100)),

					'POLL_OPTION_IMG' => $vote_graphic_img,
					'POLL_OPTION_IMG_WIDTH' => $vote_graphic_length)
				);
			}

				if ( $max_vote > 1 )
					$voted_vote_nb = $voted_vote;
				else
				{
					$lang['Voted_show'] = '';
					$voted_vote_nb = '';
				}

			$template->assign_vars(array(
				'VOTED_SHOW' => $lang['Voted_show'],
				'L_TOTAL_VOTES' => $lang['Total_votes'],
				'TOTAL_VOTES' => $vote_results_sum)
			);

		}
		else
		{
			$template->set_filenames(array(
				'pollbox' => 'viewtopic_poll_ballot.tpl')
			);

			if ( $max_vote > 1 )
			$vote_box = 'checkbox';
			else 	$vote_box = 'radio';

			for($i = 0; $i < $vote_options; $i++)
			{
				if ( count($orig_word) )
				{
					$vote_info[$i]['vote_option_text'] = preg_replace($orig_word, $replacement_word, $vote_info[$i]['vote_option_text']);
				}

				$template->assign_block_vars("poll_option", array(
					'POLL_VOTE_BOX' => $vote_box,
					'POLL_OPTION_ID' => $vote_info[$i]['vote_option_id'],
					'POLL_OPTION_CAPTION' => $vote_info[$i]['vote_option_text'])
				);
			}

			$template->assign_vars(array(
				'L_SUBMIT_VOTE' => $lang['Submit_vote'],
				'L_VIEW_RESULTS' => $lang['View_results'],

				'U_VIEW_RESULTS' => append_sid("viewtopic.$phpEx?" . POST_TOPIC_URL . "=$topic_id&amp;postdays=$post_days&amp;postorder=$post_order&amp;vote=viewresult"))
			);

			$s_hidden_fields = '<input type="hidden" name="topic_id" value="' . $topic_id . '" /><input type="hidden" name="mode" value="vote" />';
		}

		if ( $max_vote > 1 )
		{
			$vote_br = '<br />';
			$max_vote_nb = $max_vote;
		}
		else
		{
			$vote_br = '';
			$lang['Max_voting_1_explain'] = '';
			$lang['Max_voting_2_explain'] = '';
			$lang['Max_voting_3_explain'] = '';
			$max_vote_nb = '';
		}

		if ( count($orig_word) )
		{
			$vote_title = preg_replace($orig_word, $replacement_word, $vote_title);
		}

		$s_hidden_fields .= '<input type="hidden" name="sid" value="' . $userdata['session_id'] . '" />';

		$sql_votes = mysql_query("SELECT * 
				FROM " . VOTE_DESC_TABLE. " vote_desc 
				ORDER BY vote_id"); 
		      for ($v = 0; $v < mysql_num_rows($sql_votes); $v++) 

		      if (mysql_result($sql_votes, $v, "vote_id") == $vote_id) $vote_nr = $v; 
		      $vote_end = mysql_result($sql_votes, $vote_nr, "vote_start") + mysql_result($sql_votes, $vote_nr, "vote_length"); 
		      if (time() < $vote_end) 
			{ 
				$vote_end = sprintf($lang['Vote_until']) . ": " . date ("m.d.Y H:i:s",$vote_end); 
			} 
		      else if (mysql_result($sql_votes, $vote_nr, "vote_length") == 0) 
			{ 
				$vote_end = sprintf($lang['Vote_endless']) ; 
			} 
		      else 
			{ 
				$vote_end = sprintf($lang['Vote_closed']) ; 
			} 

		$template->assign_vars(array(
			'POLL_QUESTION' => $vote_title,
			'POLL_VOTE_BR' => $vote_br,
			'MAX_VOTING_1_EXPLAIN' => $lang['Max_voting_1_explain'],
			'MAX_VOTING_2_EXPLAIN' => $lang['Max_voting_2_explain'],
			'MAX_VOTING_3_EXPLAIN' => $lang['Max_voting_3_explain'],
			'max_vote' => $max_vote_nb,
			'voted_vote' => $voted_vote_nb,

			'S_HIDDEN_FIELDS' => $s_hidden_fields,
			'S_POLL_ACTION' => append_sid("posting.$phpEx?mode=vote&amp;" . POST_TOPIC_URL . "=$topic_id"),
		      'VOTE_END' => $vote_end) 
		);

		$template->assign_var_from_handle('POLL_DISPLAY', 'pollbox');
	}
}

init_display_post_attachments($forum_topic_data['topic_attachment']);

if ( isset($HTTP_GET_VARS['no']) )
{ 
	//
	// Update the forum view counter
	//
	$sql = "UPDATE " . FORUMS_TABLE . "
		SET forum_views = forum_views + 1
		WHERE forum_id = $forum_id";
	if ( !$db->sql_query($sql) )
	{
		message_die(GENERAL_ERROR, "Could not update forum views.", '', __LINE__, __FILE__, $sql);
	}
}

//
// Update the topic view counter
//
if (!($postrow[0]['user_id'] == $userdata['user_id'])) 
{
	$sql = "UPDATE " . TOPICS_TABLE . "
		SET topic_views = topic_views + 1
		WHERE topic_id = $topic_id";
	if ( !$db->sql_query($sql) )
	{
		message_die(GENERAL_ERROR, "Could not update topic views.", '', __LINE__, __FILE__, $sql);
	}
}

//
// Okay, let's do the loop, yeah come on baby let's do the loop
// and it goes like this ...
//
$this_year = create_date('Y', time(), $board_config['board_timezone']);
$this_date = create_date('md', time(), $board_config['board_timezone']);

$overall_total_posts = get_db_stat('postcount'); 

define('RATING_PATH', $phpbb_root_path.'ratings/');
include (RATING_PATH.'functions_rating.'.$phpEx);
$rating_config = get_rating_config('1,2,14');
if ( $rating_config[1] == 1 && $forum_topic_data['auth_view'] < 3 && $forum_topic_data['auth_read'] < 3 )
{
	get_rating_ranks();
	$target_window = ( $rating_config[14] == 1 ) ? 'phpbb_rating' : '_self';
}

for($i = 0; $i < $total_posts; $i++)
{
	if ( count($post_rank_set) > 0 && ( $i == 0 || $rating_config[2] == 0 ) )
	{
		$post_rating = ( $postrow[$i]['rating_rank_id'] > 0 ) ? $lang['Rate_post'].':'.$post_rank_set[$postrow[$i]['rating_rank_id']] : $lang['Rate_post'];
		$rating_url = append_sid('rating.php?p='.$postrow[$i]['post_id']);
		$post_rating = '<a href="'.$rating_url.'" target="'.$target_window.'" OnClick="window.open(\''.$rating_url.'\',\''.$target_window.'\',\'width=400,height=600,resize\')">'.$post_rating.'</a>';
	}
	else
	{
		$post_rating = '';
	}

	$poster_id = $postrow[$i]['user_id'];
	$poster = ( $poster_id == ANONYMOUS ) ? $lang['Guest'] : $postrow[$i]['username'];

	if ( $postrow[$i]['user_birthday'] != 999999 ) 
	{ 
		$poster_birthdate=realdate('md', $postrow[$i]['user_birthday']);
		$n=0;
		while ($n<26)
		{
			if ($poster_birthdate>=$zodiacdates[$n] & $poster_birthdate<=$zodiacdates[$n+1])
			{
				$zodiac = $lang[$zodiacs[($n/2)]];
				$u_zodiac = $images[$zodiacs[($n/2)]];
				$zodiac_img = '<img src="'.$u_zodiac.'" alt="'.$lang['Zodiac'].': '.$zodiac.'" title="'.$lang['Zodiac'].': '.$zodiac.'" border="0" />'; 
				$n=26;			
			} else 
			{
				$n=$n+2;
			}
		}
	
	   $poster_age = $this_year - realdate ('Y',$postrow[$i]['user_birthday']); 
	   if ($this_date < $poster_birthdate) $poster_age--; 
	   $poster_age = $lang['Age'] . ': ' . $poster_age .'<br />'; 
	}
	else 
	{
		$zodiac='';
		$u_zodiac='';
		$zodiac_img='';	
		$poster_age = '';
	}
	
	$post_date = create_date($board_config['default_dateformat'], $postrow[$i]['post_time'], $board_config['board_timezone']);

	if ( $board_config['time_today'] < $postrow[$i]['post_time'])
	{ 
		$post_date = sprintf($lang['Today_at'], create_date($board_config['default_timeformat'], $postrow[$i]['post_time'], $board_config['board_timezone'])); 
	}
	else if ( $board_config['time_yesterday'] < $postrow[$i]['post_time'])
	{ 
		$post_date = sprintf($lang['Yesterday_at'], create_date($board_config['default_timeformat'], $postrow[$i]['post_time'], $board_config['board_timezone'])); 
	}

	$poster_posts = ( $postrow[$i]['user_id'] != ANONYMOUS ) ? $lang['Posts'] . ': ' . $postrow[$i]['user_posts'] : '';

	$poster_from = ( $postrow[$i]['user_from'] && $postrow[$i]['user_id'] != ANONYMOUS ) ? $lang['Location'] . ': ' . $postrow[$i]['user_from'] . '<br />' : '';

	if ( !empty($postrow[$i]['user_from_flag']) ) 
	{ 
		$poster_from_flag = "<img src=\"images/flags/" . $postrow[$i]['user_from_flag'] . "\" alt=\"" . $lang['Country_Flag'] . ": " ; 
		
		$sql = "SELECT flag_name 
				FROM " . FLAG_TABLE . " 
				WHERE flag_image = '" . $postrow[$i]['user_from_flag']."' "; 
		if( !($result = $db->sql_query($sql)) ) 
		{ 
			message_die(GENERAL_ERROR, 'Could not query flagname', '', __LINE__, __FILE__, $sql); 
		} 

		$flag_name = $db->sql_fetchrow($result); 
		$flag_name_real = $flag_name['flag_name']; 
		$poster_from_flag .= $flag_name_real . "\" width=\"32\" height=\"20\"><br />"; 
	} 
	else 
	{ 
		$poster_from_flag = ''; 
	} 

	$poster_joined = ( $postrow[$i]['user_id'] != ANONYMOUS ) ? $lang['Joined'] . ': ' . create_date($lang['DATE_FORMAT'], $postrow[$i]['user_regdate'], $board_config['board_timezone']) : '';

	$poster_time = @gmdate("g:i a", time() + (3600 * $postrow[$i]['user_timezone']));

	$poster_avatar = '';
	if ( $postrow[$i]['user_avatar_type'] && $poster_id != ANONYMOUS && $postrow[$i]['user_allowavatar'] && $userdata['avatar_sticky'])
	{
		switch( $postrow[$i]['user_avatar_type'] )
		{
			case USER_AVATAR_UPLOAD:
				$poster_avatar = ( $board_config['allow_avatar_upload'] ) ? '<img src="' . $board_config['avatar_path'] . '/' . $postrow[$i]['user_avatar'] . '" alt="" border="0" />' : '';
				break;
			case USER_AVATAR_REMOTE:
				$poster_avatar = ( $board_config['allow_avatar_remote'] ) ? '<img src="' . $postrow[$i]['user_avatar'] . '" alt="" border="0" />' : '';
				break;
			case USER_AVATAR_GALLERY:
				$poster_avatar = ( $board_config['allow_avatar_local'] ) ? '<img src="' . $board_config['avatar_gallery_path'] . '/' . $postrow[$i]['user_avatar'] . '" alt="" border="0" />' : '';
				break;
		}
	}
	else
	if ( ($postrow[$i]['current_user_avatar_type']) && $poster_id != ANONYMOUS && $postrow[$i]['user_allowavatar'] )
	{
		switch( $postrow[$i]['current_user_avatar_type'] )
		{
			case USER_AVATAR_UPLOAD:
				$poster_avatar = ( $board_config['allow_avatar_upload'] ) ? '<img src="' . $board_config['avatar_path'] . '/' . $postrow[$i]['current_user_avatar'] . '" alt="" border="0" />' : '';
				break;
			case USER_AVATAR_REMOTE:
				$poster_avatar = ( $board_config['allow_avatar_remote'] ) ? '<img src="' . $postrow[$i]['current_user_avatar'] . '" alt="" border="0" />' : '';
				break;
			case USER_AVATAR_GALLERY:
				$poster_avatar = ( $board_config['allow_avatar_local'] ) ? '<img src="' . $board_config['avatar_gallery_path'] . '/' . $postrow[$i]['current_user_avatar'] . '" alt="" border="0" />' : '';
				break;
		}
	}

	//
	// Define the little post icon
	//
	if ( $userdata['session_logged_in'] && $postrow[$i]['post_time'] > $userdata['user_lastvisit'] && $postrow[$i]['post_time'] > $topic_last_read )
	{
		$mini_post_img = $images['icon_minipost_new'];
		$mini_post_alt = $lang['New_post'];
	}
	else
	{
		$mini_post_img = $images['icon_minipost'];
		$mini_post_alt = $lang['Post'];
	}

	$mini_post_url = append_sid("viewtopic.$phpEx?" . POST_POST_URL . '=' . $postrow[$i]['post_id']) . '#' . $postrow[$i]['post_id'];


	//
	// Generate the year stars
	//
	$minposts = $board_config['year_stars'];
	$yearstars = '';
	$years = floor((time() - $postrow[$i]['user_regdate']) / (365.25*24*60*60));
	if ( $years && $postrow[$i]['user_posts'] >= $minposts )
	{
		for ( $y=0 ; $y<$years ; $y++ )
		{
			$yearstars .= '<img src="' . $images['year_star'] . '">';
		}
		$yearstars .= '<br />';
	}
	
	//
	// Generate ranks, set them to empty string initially.
	//
	$poster_rank = '';
	$rank_image = '';
	$gender_image = '';
 
	if ( $postrow[$i]['user_id'] == ANONYMOUS )
	{
	}
	else if ( $postrow[$i]['user_rank'] )
	{
		for($j = 0; $j < count($ranksrow); $j++)
		{
			if ( $postrow[$i]['user_rank'] == $ranksrow[$j]['rank_id'] && $ranksrow[$j]['rank_special'] )
			{
				$poster_rank = $ranksrow[$j]['rank_title'];
				$rank_image = ( $ranksrow[$j]['rank_image'] ) ? '<img src="templates/' . $template_name . '/ranks/' . $ranksrow[$j]['rank_image'] . '" alt="' . $poster_rank . '" title="' . $poster_rank . '" border="0" /><br />' : '';
			}
		}
	}
	else
	{
		for($j = 0; $j < count($ranksrow); $j++)
		{
			if ( $postrow[$i]['user_posts'] >= $ranksrow[$j]['rank_min'] && !$ranksrow[$j]['rank_special'] )
			{
				$poster_rank = $ranksrow[$j]['rank_title'];
				$rank_image = ( $ranksrow[$j]['rank_image'] ) ? '<img src="templates/' . $template_name . '/ranks/' . $ranksrow[$j]['rank_image'] . '" alt="' . $poster_rank . '" title="' . $poster_rank . '" border="0" /><br />' : '';
			}
		}
	}

	//
	// Handle anon users posting with usernames
	//
	if ( $poster_id == ANONYMOUS && $postrow[$i]['post_username'] != '' )
	{
		$poster = $postrow[$i]['post_username'];
		$poster_rank = $lang['Guest'];
		$poster_age=''; 
	}

	$temp_url = '';

	if ( $poster_id != ANONYMOUS && $userdata['session_logged_in'] )
	{
		$temp_url = append_sid("profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . "=$poster_id");
		$profile_img = '<a href="' . $temp_url . '"><img src="' . $images['icon_profile'] . '" alt="' . $lang['Read_profile'] . '" title="' . $lang['Read_profile'] . '" border="0" /></a>';
		$profile = '<a href="' . $temp_url . '">' . $lang['Read_profile'] . '</a>';

		if ($board_config['referral_enable'] == '0')
		{
			$temp_url = append_sid("profile.$phpEx?mode=register&amp;ruid=$poster_id");
			$refer_img = '<a href="' . $temp_url . '"><img src="' . $images['icon_refer'] . '" alt="' . $lang['Referral_Viewtopic'] . '" title="' . $lang['Referral_Viewtopic'] . '" border="0" /></a>';
		}
		else
		{
	            $refer_img = '';
		}

		$temp_url = append_sid("privmsg.$phpEx?mode=post&amp;" . POST_USERS_URL . "=$poster_id");
		$pm_img = '<a href="' . $temp_url . '"><img src="' . $images['icon_pm'] . '" alt="' . $lang['Send_private_message'] . '" title="' . $lang['Send_private_message'] . '" border="0" /></a>';
		$pm = '<a href="' . $temp_url . '">' . $lang['Send_private_message'] . '</a>';

		if ( !empty($postrow[$i]['user_gender'])) 
		{ 
		   switch ($postrow[$i]['user_gender']) 
		   { 
		      case 1 : $gender_image = $lang['Gender'].": <img src=\"" . $images['icon_minigender_male'] . "\" alt=\"" . $lang['Gender'].  ":".$lang['Male']."\" title=\"" . $lang['Gender'] . ": ".$lang['Male']. "\" border=\"0\" /><br />"; break; 
		      case 2 : $gender_image = $lang['Gender'].": <img src=\"" . $images['icon_minigender_female'] . "\" alt=\"" . $lang['Gender']. ":".$lang['Female']. "\" title=\"" . $lang['Gender'] . ": ".$lang['Female']. "\" border=\"0\" /><br />"; break; 
		      case 3 : $gender_image = $lang['Gender'].":<img src=\"" . $images['icon_minigender_pair'] . "\" alt=\"" . $lang['Gender']. ":".$lang['Pair']. "\" title=\"" . $lang['Gender'] . ":".$lang['Pair']. "\" border=\"0\" /><br />"; break; 
		      default : $gender_image=""; 
		   } 
		} 

		if ( !empty($postrow[$i]['user_viewemail']) || $is_auth['auth_mod'] )
		{
			$email_uri = ( $board_config['board_email_form'] ) ? append_sid("profile.$phpEx?mode=email&amp;" . POST_USERS_URL .'=' . $poster_id) : 'mailto:' . $postrow[$i]['user_email'];

			$email_img = '<a href="' . $email_uri . '"><img src="' . $images['icon_email'] . '" alt="' . $lang['Send_email'] . '" title="' . $lang['Send_email'] . '" border="0" /></a>';
			$email = '<a href="' . $email_uri . '">' . $lang['Send_email'] . '</a>';
		}
		else
		{
			$email_img = '';
			$email = '';
		}

		$www_img = ( $postrow[$i]['user_website'] ) ? '<a href="' . $postrow[$i]['user_website'] . '" target="_userwww"><img src="' . $images['icon_www'] . '" alt="' . $lang['Visit_website'] . '" title="' . $lang['Visit_website'] . '" border="0" /></a>' : '';
		$www = ( $postrow[$i]['user_website'] ) ? '<a href="' . $postrow[$i]['user_website'] . '" target="_userwww">' . $lang['Visit_website'] . '</a>' : '';

		$buddy_img = ( '<a href="buddycp.php?mode=add&t='.$topic_id.'&u='.$poster_id.'"><img src="' . $images['icon_buddy'] . '" alt="'. $lang['Add_buddy'] . '" border="0" /></a>');

		if ( !empty($postrow[$i]['user_icq']) )
		{
			$icq_status_img = '<a href="http://wwp.icq.com/' . $postrow[$i]['user_icq'] . '#pager"><img src="http://web.icq.com/whitepages/online?icq=' . $postrow[$i]['user_icq'] . '&img=5" width="18" height="18" border="0" /></a>';
			$icq_img = '<a href="http://wwp.icq.com/scripts/search.dll?to=' . $postrow[$i]['user_icq'] . '"><img src="' . $images['icon_icq'] . '" alt="' . $lang['ICQ'] . '" title="' . $lang['ICQ'] . '" border="0" /></a>';
			$icq =  '<a href="http://wwp.icq.com/scripts/search.dll?to=' . $postrow[$i]['user_icq'] . '">' . $lang['ICQ'] . '</a>';
		}
		else
		{
			$icq_status_img = '';
			$icq_img = '';
			$icq = '';
		}

		$aim_img = ( $postrow[$i]['user_aim'] ) ? '<a href="aim:goim?screenname=' . $postrow[$i]['user_aim'] . '&amp;message=Hello+Are+you+there?"><img src="http://big.oscar.aol.com/' . $postrow[$i]['user_aim'] . '?on_url='.$images['icon_aim_online'].'&off_url='.$images['icon_aim_offline'].'" alt="' . $lang['AIM'] . '" title="' . $lang['AIM'] . '" border="0" /></a>' : '&nbsp;';
		$aim = ( $postrow[$i]['user_aim'] ) ? '<a href="aim:goim?screenname=' . $postrow[$i]['user_aim'] . '&amp;message=Hello+Are+you+there?">' . $lang['AIM'] . '</a>' : '';

		$temp_url = append_sid("profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . "=$poster_id");
		$msn_img = ( $postrow[$i]['user_msnm'] ) ? '<a href=\'javascript:DoInstantMessage("'.$postrow[$i]['user_msnm'].'","'.$postrow[$i]['username'].'");\'><img src="' . $images['icon_msnm'] . '" alt="' . $lang['MSNM'] . '" title="' . $lang['MSNM'] . '" border="0" /></a>' : '';
		$msn = $msn_img;

		$yim_img = ( $postrow[$i]['user_yim'] ) ? "<a href=\"ymsgr:sendIM?" . $postrow[$i]['user_yim'] . "&__you+there?\"><img src=\"http://opi.yahoo.com/online?u=" . $postrow[$i]['user_yim'] . "&m=g&t=1\" alt=\"" . $lang['YIM'] . "\" title=\"" . $lang['YIM'] . "\" border=\"0\" /></a>" : "";
		$yim = ( $postrow[$i]['user_yim'] ) ? '<a href="ymsgr:sendIM?' . $profiledata['user_yim'] . '&__you+there?">' . $lang['YIM'] . '</a>' : '';

		$regdate = $postrow[$i]['user_regdate']; 
		$user_posts = $postrow[$i]['user_posts']; 
		$memberdays = max(1, round( ( time() - $regdate ) / 86400 )); 
		$posts_per_day = $user_posts / $memberdays; 

		// Get the users percentage of total posts 
		if ( $postrow[$i]['user_posts'] != 0 ) 
		{ 
		$percentage = ( $overall_total_posts ) ? min(100, ($user_posts / $overall_total_posts) * 100) : 0; 
		} 
		else 
		{ 
		$percentage = 0; 
		} 
			$post_day_stats = sprintf($lang['User_post_day_stats'], $posts_per_day); 
			$post_percent_stats = sprintf($lang['User_post_pct_stats'], $percentage); 
		}
		else
		{
		$profile_img = '';
		$profile = '';
        	$refer_img = '';
		$pm_img = '';
		$pm = '';
		$email_img = '';
		$email = '';
		$www_img = '';
		$www = '';
		$icq_status_img = '';
		$icq_img = '';
		$icq = '';
		$aim_img = '';
		$aim = '';
		$msn_img = '';
		$msn = '';
		$yim_img = '';
		$yim = '';
		$post_day_stats = ''; 
		$post_percent_stats = ''; 
		$buddy_img = '';
	}

	$back_to_calendar = str_replace("&", "%26", $back_to_calendar);
	$temp_url = append_sid("posting.$phpEx?mode=quote&amp;" . POST_POST_URL . "=" . $postrow[$i]['post_id']);
//	$temp_url = append_sid("posting.$phpEx?mode=quote&amp;" . POST_POST_URL . "=" . $postrow[$i]['post_id'])."&amp;back_to_calendar=$back_to_calendar";
	$quote_img = '<a href="' . $temp_url . '"><img src="' . $images['icon_quote'] . '" alt="' . $lang['Reply_with_quote'] . '" title="' . $lang['Reply_with_quote'] . '" border="0" /></a>';
	$quote = '<a href="' . $temp_url . '">' . $lang['Reply_with_quote'] . '</a>';

	$temp_url = append_sid("search.$phpEx?search_author=" . urlencode($postrow[$i]['username']) . "&amp;showresults=posts");
	$search_img = '<a href="' . $temp_url . '"><img src="' . $images['icon_search'] . '" alt="' . $lang['Search_user_posts'] . '" title="' . $lang['Search_user_posts'] . '" border="0" /></a>';
	$search = '<a href="' . $temp_url . '">' . $lang['Search_user_posts'] . '</a>';

	if ( ( $userdata['user_id'] == $poster_id && $is_auth['auth_edit'] ) || $is_auth['auth_mod'] )
	{
		$temp_url = append_sid("posting.$phpEx?mode=editpost&amp;" . POST_POST_URL . "=" . $postrow[$i]['post_id']);
//		$temp_url = append_sid("posting.$phpEx?mode=editpost&amp;" . POST_POST_URL . "=" . $postrow[$i]['post_id'])."&amp;back_to_calendar=$back_to_calendar";
		$edit_img = '<a href="' . $temp_url . '"><img src="' . $images['icon_edit'] . '" alt="' . $lang['Edit_delete_post'] . '" title="' . $lang['Edit_delete_post'] . '" border="0" /></a>';
		$edit = '<a href="' . $temp_url . '">' . $lang['Edit_delete_post'] . '</a>';
	}
	else
	{
		$edit_img = '';
		$edit = '';
	}

	$topic_view_img = ($userdata['session_logged_in']) ? '<a href="' . append_sid("topic_view_users.$phpEx?".POST_TOPIC_URL."=$topic_id") . '"><img src="' . $images['icon_view'] . '" alt="' . $lang['Topic_view_users'] . '" title="' . $lang['Topic_view_users'] . '" border="0" /></a>':'';


	if( $userdata['user_level'] == ADMIN ) 
	{
		$sql = "SELECT holding FROM " . BANK_TABLE . " 
				WHERE name = '$poster_id'"; 
		if ( !($result = $db->sql_query($sql)) ) 
		{ 
			message_die(GENERAL_ERROR, 'Could not obtain user bank information', '', __LINE__, __FILE__, $sql);
		} 
		$row = mysql_fetch_array($result); 
		$bank_amount = '<br />' .$lang['Bank'] . ': ' . $row['holding'];

		$edit_post_date_id = $postrow[$i]['post_id'];
		$temp_url =  "javascript:window.open('includes/edit_post_date.php?p=$edit_post_date_id','edit_post_date','width=500,height=430');void(0);";
		$edit_date_img = '<a href="' . $temp_url . '"><img src="'  . $images['icon_edit_date'] . '" alt="' . $lang['Edit_post_date'] . '" title="' . $lang['Edit_post_date'] . '" border="0" /></a>';

		$temp_url = "modcp.$phpEx?mode=ip&amp;" . POST_POST_URL . "=" . $postrow[$i]['post_id'] . "&amp;" . POST_TOPIC_URL . "=" . $topic_id . "&amp;sid=" . $userdata['session_id'];
		$ip_img = '<a href="' . $temp_url . '"><img src="' . $images['icon_ip'] . '" alt="' . $lang['View_IP'] . '" title="' . $lang['View_IP'] . '" border="0" /></a>';
		$ip = decode_ip($postrow[$i]['poster_ip']);
		$ip = "IP: <a href='http://network-tools.com/default.asp?host=" . $ip . "' target='_blank'>" . $ip . "</a><br />";

	//	$temp_url = "posting.$phpEx?mode=delete&amp;" . POST_POST_URL . "=" . $postrow[$i]['post_id'] ."&amp;back_to_calendar=$back_to_calendar&amp;sid=" . $userdata['session_id'];
		$temp_url = "posting.$phpEx?mode=delete&amp;" . POST_POST_URL . "=" . $postrow[$i]['post_id'] . "&amp;sid=" . $userdata['session_id'];
		$delpost_img = '<a href="' . $temp_url . '"><img src="' . $images['icon_delpost'] . '" alt="' . $lang['Delete_post'] . '" title="' . $lang['Delete_post'] . '" border="0" /></a>';
		$delpost = '<a href="' . $temp_url . '">' . $lang['Delete_post'] . '</a>';
	}
	else if ( $is_auth['auth_mod'] )
	{
	//	$temp_url = "posting.$phpEx?mode=delete&amp;" . POST_POST_URL . "=" . $postrow[$i]['post_id'] ."&amp;back_to_calendar=$back_to_calendar&amp;sid=" . $userdata['session_id'];
		$temp_url = "posting.$phpEx?mode=delete&amp;" . POST_POST_URL . "=" . $postrow[$i]['post_id'] . "&amp;sid=" . $userdata['session_id'];
		$delpost_img = '<a href="' . $temp_url . '"><img src="' . $images['icon_delpost'] . '" alt="' . $lang['Delete_post'] . '" title="' . $lang['Delete_post'] . '" border="0" /></a>';
		$delpost = '<a href="' . $temp_url . '">' . $lang['Delete_post'] . '</a>';
	}
	else
	{
		$ip_img = '';
		$ip = '';
		$edit_date_img = '';
		$edit_date = '';
		$bank_amount ='';

		if ( $userdata['user_id'] == $poster_id && $is_auth['auth_delete'] && $forum_topic_data['topic_last_post_id'] == $postrow[$i]['post_id'] )
		{
//			$temp_url = "posting.$phpEx?mode=delete&amp;" . POST_POST_URL . "=" . $postrow[$i]['post_id'] ."&amp;back_to_calendar=$back_to_calendar&amp;sid=" . $userdata['session_id'];
			$temp_url = "posting.$phpEx?mode=delete&amp;" . POST_POST_URL . "=" . $postrow[$i]['post_id'] . "&amp;sid=" . $userdata['session_id'];
			$delpost_img = '<a href="' . $temp_url . '"><img src="' . $images['icon_delpost'] . '" alt="' . $lang['Delete_post'] . '" title="' . $lang['Delete_post'] . '" border="0" /></a>';
			$delpost = '<a href="' . $temp_url . '">' . $lang['Delete_post'] . '</a>';
		}
		else
		{
			$delpost_img = '';
			$delpost = '';
		}
	}

	//
	// Ban card system
	//
	if($poster_id != ANONYMOUS && $postrow[$i]['user_level'] != ADMIN) 
	{ 
		$current_user = str_replace("'","\'",$postrow[$i]['username']);
		if ($is_auth['auth_greencard']) 
		{ 
		      $g_card_img = '&nbsp;<input type="image" name="unban" value="unban" onClick="return confirm(\''.sprintf($lang['Green_card_warning'],$current_user).'\')" src="'. $images['icon_g_card'] . '" alt="' . $lang['Give_G_card'] . '" >'; 
		} 
		else 
		{
			$g_card_img = ''; 
		}
		$user_warnings = $postrow[$i]['user_warnings'];
		$card_img = ($user_warnings) ? (( $user_warnings < $board_config['max_user_bancard']) ? sprintf($lang['Warnings'], $user_warnings) : $lang['Banned'] ) : '';
		if ($user_warnings<$board_config['max_user_bancard'] && $is_auth['auth_ban'] )
		{ 
			$y_card_img = '&nbsp;<input type="image" name="warn" value="warn" onClick="return confirm(\''.sprintf($lang['Yellow_card_warning'],$current_user).'\')" src="'. $images['icon_y_card'] . '" alt="' . sprintf($lang['Give_Y_card'],$user_warnings+1) . '" >'; 
	     		$r_card_img = '&nbsp;<input type="image" name="ban" value="ban"  onClick="return confirm(\''.sprintf($lang['Red_card_warning'],$current_user).'\')" src="'. $images['icon_r_card'] . '" alt="' . $lang['Give_R_card'] . '" >'; 
		}
		else
		{
			$y_card_img = '';
			$r_card_img = ''; 
		} 
		if ($user_votewarnings<$board_config['max_user_votebancard'] && $is_auth['auth_voteban'])
		{ 
			$bk_card_img = '&nbsp;<input type="image" name="voteban" value="voteban" onClick="return confirm(\''.sprintf($lang['Black_card_warning'],$current_user).'\')" src="'. $images['icon_bk_card'] . '" alt="' . sprintf($lang['Give_BK_card'],$user_votewarnings+1) . '" >'; 
		}
		else
		{
			$bk_card_img = '';
		} 
	}
	else
	{
		$card_img = '';
		$g_card_img = '';
		$y_card_img = '';
		$bk_card_img = '';
		$r_card_img = '';
	}
	
	if ($is_auth['auth_bluecard']) 
	{ 
		if ($is_auth['auth_mod']) 
		{ 
			$b_card_img = (($postrow[$i]['post_bluecard'])) ? '&nbsp;<input type="image" name="report_reset" value="report_reset" onClick="return confirm(\''.$lang['Clear_blue_card_warning'].'\')" src="'. $images['icon_bhot_card'] . '" alt="'. sprintf($lang['Clear_b_card'],$postrow[$i]['post_bluecard']) . '">':'&nbsp;<input type="image" name="report" value="report" onClick="return confirm(\''.$lang['Blue_card_warning'].'\')" src="'. $images['icon_b_card'] . '" alt="'. $lang['Give_b_card'] . '" >'; 
		} 
		else 
		{ 
			$b_card_img = '&nbsp;<input type="image" name="report" value="report" src="'. $images['icon_b_card'] . '" alt="'. $lang['Give_b_card'] . '" >'; 
		}
	} 
	else $b_card_img = '';
	
	// parse hidden fields if cards visible
	$card_hidden = ($g_card_img || $r_card_img || $y_card_img || $bk_card_img || $b_card_img) ? '<input type="hidden" name="post_id" value="'. $postrow[$i]['post_id'].'">' :'';
	
	$post_subject = ( $postrow[$i]['post_subject'] != '' ) ? $postrow[$i]['post_subject'] : $lang['No_Subject'];

	$message = $postrow[$i]['post_text'];
	$bbcode_uid = $postrow[$i]['bbcode_uid'];

	$user_sig = $user_sig_bbcode_uid = $cached_sig = ''; 
	if ($postrow[$i]['enable_sig'] && $board_config['allow_sig']) 
	{ 
	   if (isset($user_sig_cache[$poster_id])) 
	   { 
	      $cached_sig = $user_sig_cache[$poster_id]; 
	   } 
	   else 
	   { 
	      $user_sig = $postrow[$i]['user_sig']; 
	      $user_sig_bbcode_uid = $postrow[$i]['user_sig_bbcode_uid']; 
	   } 
	} 
	
	//
	// Points System
	//
	if ($poster_id != ANONYMOUS)
	{
		$user_points = ($userdata['user_level'] == ADMIN || user_is_authed($userdata['user_id'])) ? '<a href="' . append_sid("pointscp.$phpEx?" . POST_USERS_URL . "=" . $postrow[$i]['user_id']) . '" title="' . sprintf($lang['Points_link_title'], $board_config['points_name']) . '">' . $board_config['points_name'] . '</a>' : $board_config['points_name'];
		$user_points = '<br />' . $user_points . ': ' . $postrow[$i]['user_points'];

		if ($board_config['points_donate'] && $userdata['user_id'] != ANONYMOUS && $userdata['user_id'] != $poster_id)
		{
			$donate_points = ' (' . sprintf($lang['Points_donate'], '<a href="' . append_sid("pointscp.$phpEx?mode=donate&amp;" . POST_USERS_URL . "=" . $postrow[$i]['user_id']) . '" title="' . sprintf($lang['Points_link_title_2'], $board_config['points_name']) . '">', '</a>)');
		}
		else
		{
			$donate_points = '';
		}
	}
	else
	{
		$user_points = '';
		$donate_points = '';
	}

	//
	// Shop - Display items
	//
	if ($vtstopper != on) {
		$gsql = "SELECT * FROM " . CONFIG_TABLE . " WHERE config_name='viewtopic'";
		if ( !($gresult = $db->sql_query($gsql)) ) 
		{ 
			message_die(GENERAL_MESSAGE, 'Could not obtain shop items'); 
		}
		$grow = mysql_fetch_array($gresult);
		$gsql = "SELECT * FROM " . CONFIG_TABLE . " WHERE config_name='viewtopiclimit'";
		if ( !($gresult = $db->sql_query($gsql)) ) 
		{ 
			message_die(GENERAL_MESSAGE, 'Could not obtain viewtopic item limit'); }
		$grow1 = mysql_fetch_array($gresult);
		$vtstopper = "on";
	}
	if ($grow['config_value'] == images)
	{
		$itempurge = str_replace("", "", $postrow[$i]['user_items']);
		$itemarray = explode('',$itempurge);
		$itemcount = count ($itemarray);
		$user_items = "<br />";
     		for ($xe = 0;$xe < $itemcount;$xe++)
		{
			if ($itemarray[$xe] != NULL)
			{
				if ($grow1[config_value] < $xe) { $user_items .= ' <a href="'.append_sid("shop.".$phpEx."?action=inventory&searchname=".$postrow[$i][username]).'" title="'.$postrow[$i][username].'\'s '.$lang[Inventory].'">'.$lang[More].'</a>'; break; }
				if (file_exists("images/shop/".$itemarray[$xe].".jpg"))
				{
					$user_items .= ' <img src="images/shop/'.$itemarray[$xe].'.jpg" title="'.$itemarray[$xe].'" alt="'.$itemaray[$xe].'">';
				}
				elseif (file_exists("images/shop/".$itemarray[$xe].".gif"))
				{
					$user_items .= ' <img src="images/shop/'.$itemarray[$xe].'.gif" title="'.$itemarray[$xe].'" alt="'.$itemaray[$xe].'">';
				}
			}
		}
	}
	$ususername = str_replace("'","\'",$postrow[$i]['username']);
	$usernameurl = append_sid("shop.".$phpEx."?action=inventory&searchname=".$ususername);

	$usql = "SELECT user_privs, user_effects, user_custitle FROM " . USERS_TABLE . " WHERE username='$ususername'";
	if ( !($uresult = $db->sql_query($usql)) ) 
	{ 
		message_die(GENERAL_MESSAGE, 'Could not obtain user special effects'); 
	}
	$urow = mysql_fetch_array($uresult);
	$usereffects = explode("", $urow['user_effects']);
	$userprivs = explode("", $urow['user_privs']);
	$usercustitle = explode("", $urow['user_custitle']);
	$userbs = array();
	$usercount = count($userprivs);
	for ($x = 0; $x < $usercount; $x++) 
	{ 
		$temppriv = explode("", 
		$userprivs[$x]); 
		$userbs[] = $temppriv[0]; 
		$userbs[] = $temppriv[1]; 
	}
	$usercount = count($usereffects);
	for ($x = 0; $x < $usercount; $x++) 
	{ 
		$temppriv = explode("", 
		$usereffects[$x]); 
		$userbs[] = $temppriv[0]; 
		$userbs[] = $temppriv[1]; 
	}
	$usercount = count($usercustitle);
	for ($x = 0; $x < $usercount; $x++) 
	{ 
		$temppriv = explode("", 
		$usercustitle[$x]); 
		$userbs[] = $temppriv[0]; 
		$userbs[] = $temppriv[1]; 
	}
	if ($specialstopper != on) 
	{ 
		$sql = "SELECT config_value FROM " . CONFIG_TABLE . " WHERE config_name='specialshop'";
		if ( !($result = $db->sql_query($sql)) ) 
		{ 
			message_die(GENERAL_MESSAGE, 'Could not query special shop configuration'); 
		}
		$row = mysql_fetch_array($result);
		if (!$board_config['shopstopper']) 
		{
			$specialstopper = "on";
		}
	}
	$shoparray = explode("", $row['config_value']);
	$shoparraycount = count ($shoparray);
	$shopstatarray = array();
	for ($x = 0; $x < $shoparraycount; $x++)
	{
		$temparray = explode("", $shoparray[$x]);
		$shopstatarray[] = $temparray[0];
		$shopstatarray[] = $temparray[1];
	}
	if (($userbs[10] == on) && ($shopstatarray[12] == on)) 
	{ 
		$poster = '<font color="'.$userbs[11].'">'.$poster.'</font>'; 
	}
	if ((($userbs[12] == on) && ($shopstatarray[14] == on)) || (($userbs[14] == on) && ($shopstatarray[16] = on))) 
	{
		$nameeffects = "<span style=\"width:100";
		if (($userbs[12] == on) && ($shopstatarray[14] == on)) 
		{ 
			$nameeffects .= "; filter:shadow(color=#".$userbs[13].", strength=5)"; 
		}
		if (($userbs[14] == on) && ($shopstatarray[16] == on)) 
		{ 
			$nameeffects .= "; filter:glow(color=#".$userbs[15].", strength=5)"; 
		}
		$nameeffects .= '">'.$poster.'</span>';
		$poster = $nameeffects;
	}
	if ((($userbs[24] == on) && ($shopstatarray[24] == on)) || (($userbs[20] == on) && ($shopstatarray[22] == on)) || (($userbs[22] == on) && ($shopstatarray[20] = on)) || (($userbs[18] == on) && ($shopstatarray[18] == on))) 
	{
		$titleeffects = '<span style="height:10';
		if (($userbs[22] == on) && ($shopstatarray[20] == on)) 
		{ 
			$titleeffects .= "; filter:shadow(color=#".$userbs[23].", strength=5)"; 
		}
		if (($userbs[20] == on) && ($shopstatarray[22] == on)) 
		{ 
			$titleeffects .= "; filter:glow(color=#".$userbs[21].", strength=5)"; 
		}
		if (($userbs[24] == on) && ($shopstatarray[24] == on)) 
		{ 
			$poster_rank = $userbs[25]; 
		}
		if (($userbs[18] == on) && ($shopstatarray[18] == on)) 
		{ 
			$poster_rank = '<font color="'.$userbs[19].'">'.$poster_rank.'</font>'; 
		}
		$titleeffects .= '">'.$poster_rank.'</span>';
		$poster_rank = $titleeffects;
	}
	if (($shopstatarray[6] == on) && ($userbs[2] != on) && ($poster_rank != "Site Admin")) 
	{ 
		$poster_avatar = ""; 
	}
	if (($shopstatarray[8] == on) && ($userbs[4] != on) && ($poster_rank != "Site Admin")) 
	{ 
		$user_sig = ""; 
	}
	if (($shopstatarray[10] == on) && ($userbs[6] != on) && ($poster_rank != "Site Admin")) 
	{ 
		$poster_rank = $lang['None']; 
		$rank_image = ""; 
	}

	//
	// Note! The order used for parsing the message _is_ important, moving things around could break any
	// output
	//

	//
	// If the board has HTML off but the post has HTML
	// on then we process it, else leave it alone
	//
	if ( !$board_config['allow_html'] )
	{
		if ( $user_sig != '' && $userdata['user_allowhtml'] )
		{
			$user_sig = preg_replace('#(<)([\/]?.*?)(>)#is', "&lt;\\2&gt;", $user_sig);
		}

		if ( $postrow[$i]['enable_html'] )
		{
			$message = preg_replace('#(<)([\/]?.*?)(>)#is', "&lt;\\2&gt;", $message);
		}
	}

	//
	// Parse message and/or sig for BBCode if reqd
	//
	if ( $board_config['allow_bbcode'] )
	{
		if ( $user_sig != '' && $user_sig_bbcode_uid != '' )
		{
			$user_sig = ( $board_config['allow_bbcode'] ) ? bbencode_second_pass($user_sig, $user_sig_bbcode_uid) : preg_replace('/\:[0-9a-z\:]+\]/si', ']', $user_sig);
		}

		if ( $bbcode_uid != '' )
		{
			$message = ( $board_config['allow_bbcode'] ) ? bbencode_second_pass($message, $bbcode_uid) : preg_replace('/\:[0-9a-z\:]+\]/si', ']', $message);
		}
	}

	if ( $user_sig != '' )
	{
		$user_sig = make_clickable($user_sig);
	}
	$message = make_clickable($message);

	//
	// Highlight active words (primarily for search)
	//
	if ($highlight_match)
	{
		// This was shamelessly 'borrowed' from volker at multiartstudio dot de
		// via php.net's annotated manual
		$message = str_replace('\"', '"', substr(preg_replace('#(\>(((?>([^><]+|(?R)))*)\<))#se', "preg_replace('#\b(" . $highlight_match . ")\b#i', '<span style=\"color:#" . $theme['fontcolor3'] . "\"><b>\\\\1</b></span>', '\\0')", '>' . $message . '<'), 1, -1));
	}

	//
	// Replace naughty words
	//
	if (count($orig_word))
	{
		$post_subject = preg_replace($orig_word, $replacement_word, $post_subject);

		if ($user_sig != '')
		{
			$user_sig = str_replace('\"', '"', substr(preg_replace('#(\>(((?>([^><]+|(?R)))*)\<))#se', "preg_replace(\$orig_word, \$replacement_word, '\\0')", '>' . $user_sig . '<'), 1, -1));
		}

		$message = str_replace('\"', '"', substr(preg_replace('#(\>(((?>([^><]+|(?R)))*)\<))#se', "preg_replace(\$orig_word, \$replacement_word, '\\0')", '>' . $message . '<'), 1, -1));
	}

	//
	// Parse smilies
	//
	if ( $board_config['allow_smilies'] )
	{
		if ( $postrow[$i]['user_allowsmile'] && $user_sig != '' )
		{
			$user_sig = smilies_pass($user_sig);
		}

		if ( $postrow[$i]['enable_smilies'] )
		{
			$message = smilies_pass($message);
		}
	}

	//
	// Replace newlines (we use this rather than nl2br because
	// till recently it wasn't XHTML compliant)
	//
	if (!empty($cached_sig)) 
	{ 
	   $user_sig = $cached_sig; 
	} 
	elseif (!empty($user_sig)) 
	{ 
	   $user_sig = '<br />_________________<br />' . str_replace("\n", "\n<br />\n", $user_sig); 
	   $user_sig_cache[$poster_id] = $user_sig; 
	} 
	$message = str_replace("\n", "\n<br />\n", $message);

	//
	// Editing information
	//
	$sql = "SELECT pe.*, u.username
			FROM " . POSTS_EDIT_TABLE . " pe, " . USERS_TABLE . " u
			WHERE pe.post_id = " . $postrow[$i]['post_id'] . "
				AND pe.user_id = u.user_id
			ORDER BY pe.post_edit_time DESC";
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Could not obtain posts edit count information', '', __LINE__, __FILE__, $sql);
	}

	$l_edited_by = '';
	while ( $row = $db->sql_fetchrow($result) )
	{
		$l_edit_time_total = ( $row['post_edit_count'] == 1 ) ? $lang['Edited_time_total'] : $lang['Edited_times_total'];
		$l_edited_by .= ( ($l_edited_by == '') ? '<br />' : '' ) . '<br />' . sprintf($l_edit_time_total, $row['username'], create_date($board_config['default_dateformat'], $row['post_edit_time'], $board_config['board_timezone']), $row['post_edit_count']);
	}

	//
	// Post icon
	//
	if ( $postrow[$i]['post_icon'] == 0 ) 
	{ 
		$icon = ""; 
	} 
	else 
	{ 
		$icon = "<img width=\"19\" height=\"19\" src=\"" . $images['msg_icons'] . $postrow[$i]['post_icon'] . ".gif\" alt=\"Message Icon\" border=\"0\">"; 
	} 

	$temp_url = append_sid("search.$phpEx?search_author=" . urlencode($postrow[$i]['username']) . "&showresults=posts"); 
	$search = $lang['Posts'] . ': ' . '<a href="' . $temp_url . '">' . $postrow[$i]['user_posts'] . '</a>'; 

	//
	// Again this will be handled by the templating
	// code at some point
	//
	$row_color = ( !($i % 2) ) ? $theme['td_color1'] : $theme['td_color2'];
	$row_class = ( !($i % 2) ) ? $theme['td_class1'] : $theme['td_class2'];

	//
	// Calendar events
	//
	$message = mycal_show_event($topic_id, $postrow[$i]['post_id'], $message);

	//
	// Profile photo link
	//
	if ($postrow[$i]['user_photo'] != '' )
	{
      	$profile_photo = '<a href="profile.php?mode=viewprofile&amp;u=' . $poster_id.'#photo">'.$lang['Profile_photo'].'</a><br />';
      }
	else $profile_photo = '';

	//
	// Online/Offline/Hidden
	//
	if ( $postrow[$i]['user_id'] == ANONYMOUS )
	{
		$status = '';
	}
	if ( $poster_id != ANONYMOUS )
	{
		if($postrow[$i]['user_session_time'] >= (time()-300))
		{
			if($postrow[$i]['user_allow_viewonline'])
			{
				$status = '<img src="' . $images['icon_online'] . '" alt="' . $lang['Online'] . '" title="' . $lang['Online'] . '" border="0" />';
			}
			else if( $is_auth['auth_mod'] )
			{
				$status = '<img src="' . $images['icon_hidden'] . '" alt="' . $lang['Hidde_last_logon'] . '" title="' . $lang['Hidde_last_logon'] . '" border="0" />';
			}
			else
			{
				$status = '<img src="' . $images['icon_offline'] . '" alt="' . $lang['Offline'] . '" title="' . $lang['Offline'] . '" border="0" />';
			}
		}
		else
		{
			$status = '<img src="' . $images['icon_offline'] . '" alt="' . $lang['Offline'] . '" title="' . $lang['Offline'] . '" border="0" />';
		}
	}

	$template->assign_block_vars('postrow', array(
		'ICON' => $icon, 
		'ROW_COLOR' => '#' . $row_color,
		'ROW_CLASS' => $row_class,
		'POSTER_NAME' => $poster,
		'POSTER_AGE' => $poster_age, 
		'POSTER_RANK' => $poster_rank,
		'RANK_IMAGE' => $rank_image,
		'YEARSTARS' => $yearstars,
		'POSTER_USER_ID' => number_format($poster_id), 
		'POSTER_JOINED' => $poster_joined,
		'POSTER_TIME' => $poster_time,
		'POSTER_POSTS' => $poster_posts,
		'POST_DAY_STATS' => $post_day_stats, 
		'POST_PERCENT_STATS' => $post_percent_stats, 
		'POSTER_FROM' => $poster_from,
		'POSTER_FROM_FLAG' => $poster_from_flag,
		'POSTER_AVATAR' => $poster_avatar,
		'POSTER_STATUS' => $status,
		'POSTER_GENDER' => $gender_image, 
		'POST_DATE' => $post_date,
		'POST_SUBJECT' => $post_subject,
		'POST_RATING' => $post_rating,
		'MESSAGE' => $message,
		'SIGNATURE' => $user_sig,
		'EDITED_MESSAGE' => $l_edited_by,
		'SEARCH' => $search, 

		'MINI_POST_IMG' => $mini_post_img,
       	'REFERRAL_IMG' => $refer_img,
		'PROFILE_IMG' => $profile_img,
		'MINIPROFILE' => append_sid("profile.$phpEx?mode=miniprofile&amp;" . POST_USERS_URL .'=' . $poster_id),
		'PROFILE' => $profile,
		'SEARCH_IMG' => $search_img,
		'SEARCH' => $search,
		'PM_IMG' => $pm_img,
		'PM' => $pm,
		'EMAIL_IMG' => $email_img,
		'EMAIL' => $email,
		'WWW_IMG' => $www_img,
		'WWW' => $www,
		'ICQ_STATUS_IMG' => $icq_status_img,
		'ICQ_IMG' => $icq_img,
		'ICQ' => $icq,
		'AIM_IMG' => $aim_img,
		'AIM' => $aim,
		'MSN_IMG' => $msn_img,
		'MSN' => $msn,
		'YIM_IMG' => $yim_img,
		'YIM' => $yim,
		'EDIT_IMG' => $edit_img,
		'EDIT' => $edit,
		'EDIT_DATE_IMG' => $edit_date_img,
		'QUOTE_IMG' => $quote_img,
		'QUOTE' => $quote,
		'IP_IMG' => $ip_img,
		'IP' => $ip,
		'DELETE_IMG' => $delpost_img,
		'DELETE' => $delpost,
		'STYLE_NAME' => $postrow[$i]['style_name'],
		'THEME_ID' => $postrow[$i]['user_style'],
		'THEME_NUM' => $style_counts[$postrow[$i]['user_style']],
		'TOPIC_VIEW_IMG' => $topic_view_img,
		'PROFILE_PHOTO' => $profile_photo,
		'BUDDY_IMG' => $buddy_img,
		'PHOTO_GALLERY' => '<a href="'.append_sid("album_personal.$phpEx?user_id" . "=$poster_id").'"><img src="' . $images['icon_gallery'] . '" alt="' . $lang['Personal_gallery'] . '" border="0" /></a>',
		'BANK_AMOUNT' => $bank_amount,
		'USER_WARNINGS' => $user_warnings,
		'USER_VOTEWARNINGS' => $user_votewarnings,
		'CARD_IMG' => $card_img,
		'CARD_HIDDEN_FIELDS' => $card_hidden,
		'CARD_EXTRA_SPACE' => ($r_card_img || $y_card_img || $g_card_img || $bk_card_img || $b_card_img) ? '&nbsp;' : '',

		'POINTS' => $user_points,
		'DONATE_POINTS' => $donate_points,
		'ITEMSNAME' => $usernameurl,
		'ITEMS' => $user_items,

		'ZODIAC' => $zodiac, 
		'ZODIAC_IMG' => $zodiac_img, 
		'U_ZODIAC' => $u_zodiac, 

		'L_GENDER' => $lang['Gender'], 
		'L_MINI_POST_ALT' => $mini_post_alt,

		'U_MINI_POST' => $mini_post_url,
		'U_G_CARD' => $g_card_img, 
		'U_Y_CARD' => $y_card_img, 
		'U_BK_CARD' => $bk_card_img, 
		'U_R_CARD' => $r_card_img, 
		'U_B_CARD' => $b_card_img,
		'S_CARD' => append_sid("card.".$phpEx),
		'U_POST_ID' => $postrow[$i]['post_id'])
	);

	display_post_attachments($postrow[$i]['post_id'], $postrow[$i]['post_attachment']);

	//
	// Show member of 
	// First find all non hidden groups 
	$group_list ='';
	$sql = "SELECT  g.group_name, g.group_id, g.group_type, SUM(ug.user_id = '".$postrow[$i][user_id]."') as member FROM " . GROUPS_TABLE . " g, " . USER_GROUP_TABLE . " ug 
	 WHERE  g.group_id = ug.group_id AND NOT g.group_single_user AND NOT ug.user_pending
		AND ug.user_id IN ('".$userdata[user_id]."','".$postrow[$i][user_id]."')
	 GROUP BY ug.group_id having member ORDER BY g.group_name ";
	if(!$result = $db->sql_query($sql)) 
	   message_die(GENERAL_ERROR, "Error getting group information", "", __LINE__, __FILE__, $sql); 
	$group_list =array();
	$group_list = $db->sql_fetchrowset($result);
	if (!empty($group_list))
	{
		$template->assign_block_vars('postrow.show_groups', array());
		while (list($group_number, $group) = each($group_list))
		{
			$group_img = ($images['groups'][$group['group_id']]) ? '<img src="'.$images['groups'][$group['group_id']].'" border="0" alt="'.$group['group_name'].'">' : '';
			$group_url = append_sid("groupcp.$phpEx?g=".$group['group_id']); 
			$template->assign_block_vars('postrow.show_groups.group', array(
				'GROUP_ID' => $group['group_id'],
				'GROUP_NAME' => $group['group_name'],
				'GROUP_IMG' => $group_img,
				'U_GROUP' => $group_url,
			));
			if ($group['group_type']==GROUP_HIDDEN)
			{
				$template->assign_block_vars('postrow.show_groups.group.is_hidden', array());
			} else
			{
				$template->assign_block_vars('postrow.show_groups.group.is_not_hidden', array());
			}
		}
	}
}

$template->pparse('body');

include($phpbb_root_path . 'includes/page_tail.'.$phpEx);

?>
