<?php
/***************************************************************************
 *                              user_info.php
 *                            -------------------
 *   begin                : Friday, Apr 4, 2001
 *   copyright            : (C) 2003 MJ
 *   email                : mj@phpbbfm.net
 *
 *   $Id: user_info.php,v 0.0.1 2003/04/04 01:19:54 mj Exp $
 *
 *
 ***************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 ***************************************************************************/

if ( !defined('IN_PHPBB') )
{
	die("Hacking attempt");
}

$sql = "SELECT *
	FROM " . RANKS_TABLE . "
	ORDER BY rank_special, rank_min";
if ( !($result = $db->sql_query($sql)) )
{
	message_die(GENERAL_ERROR, 'Could not obtain ranks information', '', __LINE__, __FILE__, $sql);
}

while ( $row = $db->sql_fetchrow($result) )
{
	$ranksrow[] = $row;
}
$db->sql_freeresult($result);

$avatar_img = '';
if ( $userdata['user_avatar_type'] && $userdata['user_allowavatar'] ) 
{ 
	switch( $userdata['user_avatar_type'] ) 
	{ 
	case USER_AVATAR_UPLOAD: 
		$avatar_img = ( $board_config['allow_avatar_upload'] ) ? '<img src="' . $board_config['avatar_path'] . '/' . $userdata['user_avatar'] . '" alt="" border="0" />' : ''; 
		break; 
	case USER_AVATAR_REMOTE: 
		$avatar_img = ( $board_config['allow_avatar_remote'] ) ? '<img src="' . $userdata['user_avatar'] . '" alt="" border="0" />' : ''; 
		break; 
	case USER_AVATAR_GALLERY: 
		$avatar_img = ( $board_config['allow_avatar_local'] ) ? '<img src="' . $board_config['avatar_gallery_path'] . '/' . $userdata['user_avatar'] . '" alt="" border="0" />' : ''; 
	break; 
	}
}
if ( empty($avatar_img) && $userdata != ANONYMOUS)
{
	$avatar_img = '<img src="'.  $images['default_avatar'] .'" alt="" border="0" />';
}
if ( $userdata == ANONYMOUS )
{
	$avatar_img = '<img src="'.  $images['guest_avatar'] .'" alt="" border="0" />';
}
$poster_rank = '';
$rank_image = '';
if ( $userdata['user_rank'] )
{
	for($i = 0; $i < count($ranksrow); $i++)
	{
		if ( $userdata['user_rank'] == $ranksrow[$i]['rank_id'] && $ranksrow[$i]['rank_special'] )
		{
			$poster_rank = $ranksrow[$i]['rank_title'];
			$rank_image = ( $ranksrow[$i]['rank_image'] ) ? '<img src="templates/' . $template_name . '/ranks/' . $ranksrow[$i]['rank_image'] . '" alt="' . $poster_rank . '" title="' . $poster_rank . '" border="0" /><br />' : '';
		}
	}
}
else
{
	for($i = 0; $i < count($ranksrow); $i++)
	{
		if ( $userdata['user_posts'] >= $ranksrow[$i]['rank_min'] && !$ranksrow[$i]['rank_special'] )
		{
			$poster_rank = $ranksrow[$i]['rank_title'];
			$rank_image = ( $ranksrow[$i]['rank_image'] ) ? '<img src="templates/' . $template_name . '/ranks/' . $ranksrow[$i]['rank_image'] . '" alt="' . $poster_rank . '" title="' . $poster_rank . '" border="0" /><br />' : '';
		}
	}
}

$template->set_filenames(array(
	'usercp_user_info' => 'usercp_user_info_body.tpl')
);

$template->assign_vars(array(
	'L_USER_INFO' => sprintf($lang['UCP_Userinfo'], $userdata['username']), 
	'L_JOINED'=> $lang['Joined'],
	'L_POSTS'=> $lang['Posts'],
	'L_LOCATION' => $lang['Location'],
	'L_POINTS' => $board_config['points_name'], 
	'L_FORUM_LOCATION' => $lang['Forum_Location'],

	'RANK' => $poster_rank,
	'RANK_IMAGE' => $rank_image,
	'JOINED' => create_date($lang['DATE_FORMAT'], $userdata['user_regdate'], $board_config['board_timezone']),
	'POSTS' => $userdata['user_posts'],
	'LOCATION' => ( $userdata['user_from'] ) ? $userdata['user_from'] : '&nbsp;',
	'AVATAR' => $avatar_img,
	'POINTS' => $userdata['user_points'],

	'U_VIEWPROFILE' => append_sid("profile.php?mode=viewprofile&amp;u=" . $userdata['user_id']))
);

$template->assign_var_from_handle('USERCP_USER_INFO_OUTPUT', 'usercp_user_info');

?>