<?php
/***************************************************************************
 *                            topics_anywhere.php
 *                            -------------------
 *   begin                : Wednesday, Aug 28, 2002
 *   copyright            : (C) 2001 The phpBB Group
 *   email                : support@phpbb.com
 *
 *   $Id: topics_anywhere.php,v 1.8.0 2003/06/20 11:29:00 DtM Exp $
 *
 *
 ***************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 ***************************************************************************/

/***************************************************************************
 * This file has been modified by Fully Moddded phpBB
 *
 *   $FMId: 2003/08/10 00:59:12 mj
 *
 ***************************************************************************/

//
// Config Section
//

// You can change the format of date and time here...
// For American type dates you probably want to switch the 'd' and 'm', 'M' or 'F'
// You can also make your own formats, as long as you use the syntax of PHP's function date()
// Of course, do not add or remove any quotes! (unless escaped)
$date_formats = array('d/m/y', 'd/m/Y', 'd/m/Y H:i:s', 'D d-M-y', 'D d-M-Y', 'D d-M-Y H:i:s', 'l d F Y', 'l d F Y H:i:s');

// Array of possible bullets
// You can add your own bullets if you want.
// Do not add or remove any quotes! (unless escaped)
$bullets = array('-', '+', '&gt;', '&#155;', '&#187;', '', '*');

// Who may view the Topics Anywhere setup page?
// Everybody: 0
// Administrators only: 1
// Moderators only: 2
// Administrators and moderators: 3
// Administrators, Super moderators and moderators: 4
// All registered users: 5
$topics_anywhere_authlevel = 4;

// Hide following forums from the picklist on the setup page
// This is an array of numbers which are the forum ID's.
// For example use "$hide_forums = array(1, 5, 10);" to hide forums with ID 1, 5 and 10
// Leave the array empty (as below) to show all the forums.
$hide_forums = array();

//
// End Config Section - nothing needs to be modified below...
//

define('IN_PHPBB', true);
$phpbb_root_path = './';

include($phpbb_root_path . 'extension.inc');
include($phpbb_root_path . 'common.'.$phpEx);

include($phpbb_root_path . 'language/lang_' . $board_config['default_lang'] . '/lang_main.' . $phpEx);
include($phpbb_root_path . 'language/lang_' . $board_config['default_lang'] . '/lang_topics_anywhere.' . $phpEx);

$full_url = 'http://'.$board_config['server_name'].$board_config['script_path'];

//
// Start session management
//
$userdata = session_pagestart($user_ip, PAGE_INDEX);
init_userprefs($userdata);
//
// End session management
//

define('TA_SCRIPT_NAME', 'topics_anywhere');
define('TA_VERSION', '');

$lastpostby_formats = array($lang['Username'], $lang['Lastpost_from'] . ' ' . $lang['Username']);

function output_die($msg)
{
	$error = true;
	$msg = '<font color=\"red\"><b>' . $msg . '<br>Use the Topics Anywhere link builder again - browse to topics_anywhere.php</b><br><br>TA_VERSION ' . TA_VERSION . '</font>';
	exit("document.writeln('$msg');\n");
}

function forum_select() // generates select of all available forums (modified make_jumpbox()-function)
{
	global $template, $lang, $db, $SID, $nav_links, $phpEx, $hide_forums;

	$sql = "SELECT c.cat_id, c.cat_title, c.cat_order
		FROM " . CATEGORIES_TABLE . " c, " . FORUMS_TABLE . " f
		WHERE f.cat_id = c.cat_id
		GROUP BY c.cat_id, c.cat_title, c.cat_order
		ORDER BY c.cat_order";
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, "Couldn't obtain category list.", "", __LINE__, __FILE__, $sql);
	}

	$category_rows = array();
	while ( $row = $db->sql_fetchrow($result) )
	{
		$category_rows[] = $row;
	}

	if ( $total_categories = count($category_rows) )
	{
		$sql = "SELECT *
			FROM " . FORUMS_TABLE . "
			ORDER BY cat_id, forum_order";
		if ( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Could not obtain forums information', '', __LINE__, __FILE__, $sql);
		}

		$boxstring = '<select multiple name="' . POST_FORUM_URL . '[]" size=6>';

		$forum_rows = array();
		while ( $row = $db->sql_fetchrow($result) )
		{
			$forum_rows[] = $row;
		}

		if ( $total_forums = count($forum_rows) )
		{
			for($i = 0; $i < $total_categories; $i++)
			{
				$boxstring_forums = '';
				for($j = 0; $j < $total_forums; $j++)
				{
					if ( $forum_rows[$j]['cat_id'] == $category_rows[$i]['cat_id'])
					{
						if (!in_array($forum_rows[$j]['forum_id'], $hide_forums))
						{
							$boxstring_forums .=  '<option value="' . $forum_rows[$j]['forum_id'] . '">' . $forum_rows[$j]['forum_name'] . '</option>';
						}
					}
				}

				if ( $boxstring_forums != '')
				{
					if ($i != 0)
					{
						$boxstring .= '<option value="-1">&nbsp;</option>';
					}
					$boxstring .= '<option value="cat' . $category_rows[$i]['cat_id'] . '">' . $category_rows[$i]['cat_title'] . '</option>';
					$boxstring .= '<option value="-1">----------------</option>';
					$boxstring .= $boxstring_forums;
				}
			}
		}

		$boxstring .= '</select>';
	}
	else
	{
		$boxstring .= '<select multiple name="' . POST_FORUM_URL . '[]" size=1></select>';
	}
	$data = array($boxstring, $total_forums);
	return $data;
}

function bullet_select($bullets) // generates select of all available bullets from array $bullets
{
	global $lang;
	$select = '<select name="bullet_type">';
	$select .= '<option value="non">' . $lang['None'] . '</option>';
	$select .= '<option value="dis">HTML ' . $lang['disc'] . '</option>';
	$select .= '<option value="cir">HTML ' . $lang['circle'] . '</option>';
	$select .= '<option value="squ">HTML ' . $lang['square'] . '</option>';
	$select .= '<option value="num">HTML ' . $lang['numbered'] . '</option>';
	for ($i = 0; $i < count($bullets); $i++)
	{
		$select .= '<option value="' . $i . '">' . $bullets[$i] . '</option>';
	}
	$select .= '</select>';
	return $select;
}

function lastpostby_select($lastpostby_formats) // generates select of "last post by" text formats
{
	global $lang;
	$select = '<select name="lastpostby_format">';
	for ($i = 0; $i < count($lastpostby_formats); $i++)
	{
		$select .= '<option value="' . $i . '">' . $lastpostby_formats[$i] . '</option>';
	}
	$select .= '</select>';
	return $select;
}

function lastpostdate_select($date_formats) // generates select of date formats from array $dateformats
{
	global $lang;
	$now = time();
	$select = '<select name="lastpostdate_format">';
	for ($i = 0; $i < count($date_formats); $i++)
	{
		$select .= '<option value="' . $i . '">' . create_date($date_formats[$i], $now, $board_config['board_timezone']) . '</option>';
	}
	$select .= '</select>';
	return $select;
}


function show_the_page()
{
	global $template, $lang, $db, $SID, $nav_links, $phpEx, $phpbb_root_path, $theme, $images, $date_formats, $lastpostby_formats, $bullets, $board_config, $full_url;

	$page_title = $lang['Topics_anywhere'];
	include($phpbb_root_path . 'includes/page_header.'.$phpEx);

	$template->set_filenames(array(
		'body' => 'topics_anywhere_body.tpl')
	);

	$outputarray = forum_select();

	$template->assign_vars(array(
		'L_TOPICS_ANYWHERE' => $lang['Topics_anywhere'] . ' ' . TA_VERSION,
		'L_TOPICS_ANYWHERE_EXPLAIN' => $lang['Topics_anywhere_explain'],
		'L_NOT_CHANGED' => $not_changed,
		'L_SELECT_FORUM' => $lang['Forum_select'] . $lang['Category_select'],
		'L_SELECT_FORUM_EXPLAIN' => $lang['Select_forum_explain'] . $lang['Category_explain'],
		'SELECT_FORUM_SELECT' => $outputarray[0],
		'L_OR' => $lang['Or'],
		'L_CHECK_ALLFORA' => $lang['All_available'],
		'L_AMOUNT_TOPICS' => $lang['Amount_topics'],
		'L_AMOUNT_TOPICS_EXPLAIN' => $lang['Amount_topics_explain'],
		'L_SHOW_FORUM_NAME' => $lang['Show_forum_name'],
		'L_SHOW_FORUM_NAME_EXPLAIN' => $lang['Show_forum_name_explain'],
		'L_LINK_FORUM_NAME' => $lang['Link_forum_name'],
		'L_LINK_FORUM_NAME_EXPLAIN' => $lang['Link_forum_name_explain'],
		'L_SHOW_REPLIES' => $lang['Show_replies'],
		'L_SHOW_REPLIES_EXPLAIN' => $lang['Show_replies_explain'],
		'L_SHOW_REPLIES_WORD' => $lang['Show_replies_word'],
		'L_SHOW_REPLIES_WORD_EXPLAIN' => $lang['Show_replies_word_explain'],
		'L_SHOW_ANNOUNCEMENTS' => $lang['Show_announce'],
		'L_SHOW_STICKYS' => $lang['Show_sticky'],
		'L_SHOW_LOCKED' => $lang['Show_locked'],
		'L_SHOW_MOVED' => $lang['Show_moved'],
		'L_SHOW_REGULAR' => $lang['Show_regular'],
		'L_HIDE_LABELS' => $lang['Hide_labels'],
		'L_HIDE_LABELS_EXPLAIN' => $lang['Hide_labels_explain'],
		'O_ANNOUNCEMENT' => strip_tags($lang['Topic_Announcement']),
		'O_STICKY' => strip_tags($lang['Topic_Sticky']),
		'O_MOVED' => strip_tags($lang['Topic_Moved']),
		'O_POLL' => strip_tags($lang['Topic_Poll']),
		'O_LOCKED' => strip_tags($lang['Topic_Locked']),
		'L_SORT_ORDER' => $lang['Sort_order'],
		'L_SORT_ORDER_EXPLAIN' => $lang['Sort_order_explain'],
		'O_PRIORITY' => $lang['Priority'],
		'O_ON_DATE' => $lang['On_date'],
		'L_BULLET_TYPE' => $lang['Bullet_type'],
		'L_BULLET_TYPE_EXPLAIN' => $lang['Bullet_type_explain'],
		'BULLET_TYPE_SELECT' => bullet_select($bullets),
		'L_SHOW_LASTPOSTBY' => $lang['Show_lastpostby'],
		'L_SHOW_LASTPOSTBY_EXPLAIN' => $lang['Show_lastpostby_explain'],
		'L_LASTPOSTBY_FORMAT' => $lang['Lastpostby_format'],
		'L_LASTPOSTBY_FORMAT_EXPLAIN' => $lang['Lastpostby_format_explain'],
		'L_LASTPOSTBY_FORMAT_SELECT' => lastpostby_select($lastpostby_formats),
		'L_SHOW_LASTPOSTDATE' => $lang['Show_lastpostdate'],
		'L_SHOW_LASTPOSTDATE_EXPLAIN' => $lang['Show_lastpostdate_explain'],
		'L_LASTPOSTDATE_FORMAT' => $lang['Lastpostdate_format'],
		'L_LASTPOSTDATE_FORMAT_EXPLAIN' => $lang['Lastpostdate_format_explain'],
		'L_LASTPOSTDATE_FORMAT_SELECT' => lastpostdate_select($date_formats),
		'L_SHOW_LASTPOSTICON' => $lang['Show_lastposticon'],
		'L_SHOW_LASTPOSTICON_EXPLAIN' => $lang['Show_lastposticon_explain'],
		'L_LASTPOSTICON_AS_BULLET' => $lang['Lastposticon_as_bullet'],
		'L_LASTPOSTICON_AS_BULLET_EXPLAIN' => $lang['Lastposticon_as_bullet_explain'],
		'L_ADD_BREAK' => $lang['Add_break'],
		'L_ADD_BREAK_EXPLAIN' => $lang['Add_break_explain'],
		'L_ADD_BLANK_LINE' => $lang['Add_blank_line'],
		'L_ADD_BLANK_LINE_EXPLAIN' => $lang['Add_blank_line_explain'],
		'L_LIMIT_LENGTH' => $lang['Limit_title_length'],
		'L_LIMIT_LENGTH_EXPLAIN' => $lang['Limit_title_length_explain'],
		'L_LIMIT_WHERE' => $lang['Limit_title_where'],
		'L_LIMIT_WHERE_EXPLAIN' => $lang['Limit_title_where_explain'],
		'L_PREVIOUS_SPACE' => $lang['Limit_title_previous_space'],
		'L_EXACT' => $lang['Limit_title_exact'],
		'L_NEXT_SPACE' => $lang['Limit_title_next_space'],
		'L_CSS_LINK' => $lang['CSS_link'],
		'L_CSS_LINK_EXPLAIN' => $lang['CSS_link_explain'],
		'L_CSS_TEXT' => $lang['CSS_text'],
		'L_CSS_TEXT_EXPLAIN' => $lang['CSS_text_explain'],
		'L_TARGET_LINK' => $lang['Target_link'],
		'L_TARGET_LINK_EXPLAIN' => $lang['Target_link_explain'],
		'L_YES' => $lang['Yes'],
		'L_NO' => $lang['No'],
		'L_SUBMIT' => $lang['Submit'],
		'L_RESET' => $lang['Reset'],
		'H_TOTAL_FORUMS' => $outputarray[1],
		'S_FORM_ACTION' => append_sid(TA_SCRIPT_NAME . ".$phpEx?mode=generate"))
	);

	$template->pparse('body');

	include($phpbb_root_path . 'includes/page_tail.'.$phpEx);
}


if ($HTTP_GET_VARS['mode'] == "show") // generates topics for output on any page using JavaScript document.writeln (quite heavily modified code from viewtopic.php)
{
	if ($board_config['board_disable']) // Board is disabled, no topics are available
	{
		if (isset($HTTP_GET_VARS['ct']))
		{
			if ($HTTP_GET_VARS['ct'] != '')
			{
				$css_text_wrap_before = '<span class=\"' . $HTTP_GET_VARS['ct'] . '\">';
				$css_text_wrap_after = '</span>';
			}
			else
			{
				$error = true;
				output_die('Error: No value for argument (css_text)<br>');
			}
		}
		$msg = $css_text_wrap_before . $lang['Board_disable'] . $css_text_wrap_after;
		exit("document.writeln('$msg');\n");
	}

	$error = false;
	$errorstring = '';

	if (!isset($HTTP_GET_VARS['f']) || $HTTP_GET_VARS['f'] == '')
	{
		$error = true;
		$errorstring .= 'Error: Missing argument (forum_id)<br>';
	}
	else
	{
		if (is_numeric($HTTP_GET_VARS['f']))
		{
			if (sizeof($hide_forums))
			{
				if (in_array(intval($HTTP_GET_VARS['f']), $hide_forums))
				{
					$error = true;
					$errorstring .= 'Error: Not allowed to show topics from this forum<br>';
				}
				else
				{
					$forum_id = intval($HTTP_GET_VARS['f']);
					$forum_sql = "AND t.forum_id = $forum_id";
				}
			}
			else
			{
				$forum_id = intval($HTTP_GET_VARS['f']);
				$forum_sql = "AND t.forum_id = $forum_id";
			}
		}
		else
		{
			if ($HTTP_GET_VARS['f'] == 'a')
			{
				if (sizeof($hide_forums))
				{
					$hidelist = "(" . implode(",", $hide_forums) . ")";
					$forum_sql = 'AND t.forum_id NOT IN ' . $hidelist;
				}
				else
				{
					$forum_sql = '';
				}
			}
			else
			{
				if (substr($HTTP_GET_VARS['f'], 0, 1) == 'b')
				{
					$forumlist = base64_decode(substr($HTTP_GET_VARS['f'], 1));
					$forum_sql = "AND t.forum_id in $forumlist";
				}
				else
				{
					$error = true;
					$errorstring .= 'Error: Wrong argument (forum_id)<br>';
				}
			}
		}
	}

	if (!isset($HTTP_GET_VARS['n']) || $HTTP_GET_VARS['n'] == '')
	{
		$error = true;
		$errorstring .= 'Error: Missing argument (limit)<br>';
	}
	else
	{
		if (is_numeric($HTTP_GET_VARS['n']))
		{
			$limit = intval($HTTP_GET_VARS['n']);
		}
		else
		{
			$error = true;
			$errorstring .= 'Error: Wrong argument (limit)<br>';
		}
	}

	if (!$error) // there are no critical arguments missing, let's do the sql...
	{
		$outputarray = array();

		$css_link = '';
		if (isset($HTTP_GET_VARS['cl']))
		{
			if ($HTTP_GET_VARS['cl'] != '')
			{
				$css_link = ' class=\"' . $HTTP_GET_VARS['cl'] . '\"';
			}
			else
			{
				$error = true;
				output_die('Error: No value for argument (css_link)<br>');
			}
		}

		$css_text_wrap_before = '';
		$css_text_wrap_after = '';
		if (isset($HTTP_GET_VARS['ct']))
		{
			if ($HTTP_GET_VARS['ct'] != '')
			{
				$css_text_wrap_before = '<span class=\"' . $HTTP_GET_VARS['ct'] . '\">';
				$css_text_wrap_after = '</span>';
			}
			else
			{
				$error = true;
				output_die('Error: No value for argument (css_text)<br>');
			}
		}

		$target_link = ' target=\"_self\"';
		if (isset($HTTP_GET_VARS['t']))
		{
			if ($HTTP_GET_VARS['t'] != '')
			{
				$target_link = ' target=\"' . $HTTP_GET_VARS['t'] . '\"';
			}
			else
			{
				$error = true;
				output_die('Error: No value for argument (target_link)<br>');
			}
		}

		if (isset($HTTP_GET_VARS['so']) && $HTTP_GET_VARS['so'] == 'd')
		{
			if (isset($HTTP_GET_VARS['a']))
			{
				if ($HTTP_GET_VARS['a'] == 'y')
				{
					$announce_sql = '';
				}
				else
				{
					$error = true;
					output_die('Error: Wrong value for argument (announcement)<br>');
				}
			}
			else
			{
				$announce_sql = 'AND t.topic_type <> ' . POST_ANNOUNCE;
			}

			if (isset($HTTP_GET_VARS['s']))
			{
				if ($HTTP_GET_VARS['s'] == 'y')
				{
					$sticky_sql = '';
				}
				else
				{
					$error = true;
					output_die('Error: Wrong value for argument (sticky)<br>');
				}
			}
			else
			{
				$sticky_sql = "AND t.topic_type <> " . POST_STICKY;
			}

			if (isset($HTTP_GET_VARS['l']))
			{
				if ($HTTP_GET_VARS['l'] == 'y')
				{
					$locked_sql = '';
				}
				else
				{
					$error = true;
					output_die('Error: Wrong value for argument (locked)<br>');
				}
			}
			else
			{
				$locked_sql = "AND t.topic_status <> " . TOPIC_LOCKED;
			}

			if (isset($HTTP_GET_VARS['m']))
			{
				if ($HTTP_GET_VARS['m'] == 'y')
				{
					$locked_sql = '';
				}
				else
				{
					$error = true;
					output_die('Error: Wrong value for argument (moved)<br>');
				}
			}
			else
			{
				$moved_sql = "AND t.topic_status <> " . TOPIC_MOVED;
			}

			$sql = "SELECT t.*, u.username, u.user_id, u2.username as user2, u2.user_id as id2, p.post_username, p2.post_username AS post_username2, p2.post_time, f.forum_name
				FROM " . TOPICS_TABLE . " t, " . USERS_TABLE . " u, " . POSTS_TABLE . " p, " . POSTS_TABLE . " p2, " . USERS_TABLE . " u2, " . FORUMS_TABLE . " f
				WHERE t.topic_poster = u.user_id
				    $forum_sql
					AND p.post_id = t.topic_first_post_id
					AND p2.post_id = t.topic_last_post_id
					AND t.forum_id = f.forum_id
					AND u2.user_id = p2.poster_id
					$announce_sql
					$sticky_sql
					$locked_sql
					$moved_sql
				ORDER BY t.topic_last_post_id DESC
				LIMIT $limit";
			if ( !($result = $db->sql_query($sql)) )
			{
			   $error = true;
			   output_die('General Error: Could not obtain topic information (topics sql)<br>');
			}

			$total_topics = 0;
			while( $row = $db->sql_fetchrow($result) )
			{
				$topic_rowset[] = $row;
				$total_topics++;
			}

			$db->sql_freeresult($result);
		}
		else
		{
			if (isset($HTTP_GET_VARS['a']))
			{
				if ($HTTP_GET_VARS['a'] == 'y')
				{
					$sql = "SELECT t.*, u.username, u.user_id, u2.username as user2, u2.user_id as id2, p.post_time, p.post_username, f.forum_name
						FROM " . TOPICS_TABLE . " t, " . USERS_TABLE . " u, " . POSTS_TABLE . " p, " . USERS_TABLE . " u2, " . FORUMS_TABLE . " f
						WHERE t.topic_poster = u.user_id
						    $forum_sql
							AND p.post_id = t.topic_last_post_id
							AND p.poster_id = u2.user_id
							AND t.forum_id = f.forum_id
							AND t.topic_type = " . POST_ANNOUNCE . "
						ORDER BY t.topic_last_post_id DESC
						LIMIT $limit";
					if ( !($result = $db->sql_query($sql)) )
					{
					   $error = true;
					   output_die('General Error: Could not obtain topic information (announce sql)<br>');
					}

					$topic_rowset = array();
					$total_announcements = 0;
					while( $row = $db->sql_fetchrow($result) )
					{
						$topic_rowset[] = $row;
						$total_announcements++;
					}

					$db->sql_freeresult($result);

				}
				else
				{
					$error = true;
					output_die('Error: Wrong value for argument (announce)<br>');
				}
			}
			else
			{
				$topic_rowset = array();
				$total_announcements = 0;
			}

			$max = $limit - $total_announcements;

			if ($max < 1)
			{
				$max = 0;
			}

			if (isset($HTTP_GET_VARS['s']))
			{
				if ($HTTP_GET_VARS['s'] == 'y')
				{
					$sticky_sql = '';
				}
				else
				{
					$error = true;
					output_die('Error: Wrong value for argument (sticky)<br>');
				}
			}
			else
			{
				$sticky_sql = "AND t.topic_type <> " . POST_STICKY;
			}

			if (isset($HTTP_GET_VARS['l']))
			{
				if ($HTTP_GET_VARS['l'] == 'y')
				{
					$locked_sql = '';
				}
				else
				{
					$error = true;
					output_die('Error: Wrong value for argument (locked)<br>');
				}
			}
			else
			{
				$locked_sql = "AND t.topic_status <> " . TOPIC_LOCKED;
			}

			if (isset($HTTP_GET_VARS['m']))
			{
				if ($HTTP_GET_VARS['m'] == 'y')
				{
					$moved_sql = '';
				}
				else
				{
					$error = true;
					output_die('Error: Wrong value for argument (moved)<br>');
				}
			}
			else
			{
				$moved_sql = "AND t.topic_status <> " . TOPIC_MOVED;
			}

			if (isset($HTTP_GET_VARS['rt']))
			{
				if ($HTTP_GET_VARS['rt'] == 'n')
				{
					$reg_sql = "AND t.topic_type <> " . POST_NORMAL;
				}
				else
				{
					$error = true;
					output_die('Error: Wrong value for argument (regular topics)<br>');
				}
			}
			else
			{
				$reg_sql = '';
			}

			if ($max)
			{

			$sql = "SELECT t.*, u.username, u.user_id, u2.username as user2, u2.user_id as id2, p.post_username, p2.post_username AS post_username2, p2.post_time, f.forum_name
				FROM " . TOPICS_TABLE . " t, " . USERS_TABLE . " u, " . POSTS_TABLE . " p, " . POSTS_TABLE . " p2, " . USERS_TABLE . " u2, " . FORUMS_TABLE . " f
				WHERE t.topic_poster = u.user_id
				    $forum_sql
					AND p.post_id = t.topic_first_post_id
					AND p2.post_id = t.topic_last_post_id
					AND t.forum_id = f.forum_id
					AND u2.user_id = p2.poster_id
					AND t.topic_type <> " . POST_ANNOUNCE . "
					$sticky_sql
					$locked_sql
					$moved_sql
						$reg_sql
				ORDER BY t.topic_type DESC, t.topic_last_post_id DESC
				LIMIT $max";
			if ( !($result = $db->sql_query($sql)) )
			{
			   $error = true;
			   output_die('General Error: Could not obtain topic information (topics sql)<br>');
			}

			$total_topics = 0;
			while( $row = $db->sql_fetchrow($result) )
			{
				$topic_rowset[] = $row;
				$total_topics++;
			}

			$db->sql_freeresult($result);
			}

			//
			// Total topics ...
			//
			$total_topics += $total_announcements;
		}

		//
		// Define censored word matches
		//
		$orig_word = array();
		$replacement_word = array();
		obtain_word_list($orig_word, $replacement_word);

		$html_list = false;
		$list_wrap_before = '';
		$list_wrap_after = '';
		if (isset($HTTP_GET_VARS['b']))
		{
			if ($HTTP_GET_VARS['b'] == 'dis' || $HTTP_GET_VARS['b'] == 'cir' || $HTTP_GET_VARS['b'] == 'squ' || $HTTP_GET_VARS['b'] == 'num')
			{
				$html_list = true;
				switch($HTTP_GET_VARS['b'])
				{
					case "dis":
						$html_wrap_before = '<ul type=\"disc\">';
						$html_wrap_after = '</ul>';
						break;
					case "cir":
						$html_wrap_before = '<ul type=\"circle\">';
						$html_wrap_after = '</ul>';
						break;
					case "squ":
						$html_wrap_before = '<ul type=\"square\">';
						$html_wrap_after = '</ul>';
						break;
					case "num":
						$html_wrap_before = '<ol type=\"1\">';
						$html_wrap_after = '</ol>';
						break;
					default:
						break;
				}
			}
		}

		if ($css_text_wrap_before != '')
		{
			array_push($outputarray, $css_text_wrap_before);
		}

		if ($html_wrap_before != '')
		{
			array_push($outputarray, $html_wrap_before);
		}

		if($total_topics)
		{
			for($i = 0; $i < $total_topics; $i++)
			{
				$topic_id = $topic_rowset[$i]['topic_id'];
				$topic_title = ( count($orig_word) ) ? preg_replace($orig_word, $replacement_word, $topic_rowset[$i]['topic_title']) : $topic_rowset[$i]['topic_title'];
				$replies = $topic_rowset[$i]['topic_replies'];
				$topic_type = $topic_rowset[$i]['topic_type'];
				$forum_id = $topic_rowset[$i]['forum_id'];
				$forum_name = $topic_rowset[$i]['forum_name'];

				if( $topic_type == POST_ANNOUNCE )
				{
					if (isset($HTTP_GET_VARS['h']))
					{
						if (strstr($HTTP_GET_VARS['h'], 'a'))
						{
							$topic_type = '';
						}
						else
						{
							$topic_type = $lang['Topic_Announcement'] . ' ';
						}
					}
					else
					{
						$topic_type = $lang['Topic_Announcement'] . ' ';
					}
				}
				else if( $topic_type == POST_STICKY )
				{
					if (isset($HTTP_GET_VARS['h']))
					{
						if (strstr($HTTP_GET_VARS['h'], 's'))
						{
							$topic_type = '';
						}
						else
						{
							$topic_type = $lang['Topic_Sticky'] . ' ';
						}
					}
					else
					{
						$topic_type = $lang['Topic_Sticky'] . ' ';
					}
				}
				else
				{
					$topic_type = '';
				}

				if( $topic_rowset[$i]['topic_vote'] )
				{
					if (isset($HTTP_GET_VARS['h']))
					{
						if (!strstr($HTTP_GET_VARS['h'], 'p'))
						{
							$topic_type .= $lang['Topic_Poll'] . ' ';
						}
					}
					else
					{
						$topic_type .= $lang['Topic_Poll'] . ' ';
					}
				}

				if( $topic_rowset[$i]['topic_status'] == TOPIC_MOVED )
				{
					if (isset($HTTP_GET_VARS['h']))
					{
						if (!strstr($HTTP_GET_VARS['h'], 'm'))
						{
							$topic_type .= $lang['Topic_Moved'] . ' ';
						}
					}
					else
					{
						$topic_type .= $lang['Topic_Moved'] . ' ';
					}
					$topic_id = $topic_rowset[$i]['topic_moved_id'];
				}

				if( $topic_rowset[$i]['topic_status'] == TOPIC_LOCKED )
				{
					if (isset($HTTP_GET_VARS['h']))
					{
						if (!strstr($HTTP_GET_VARS['h'], 'l'))
						{
							$topic_type .= $lang['Topic_Locked'] . ' ';
						}
					}
					else
					{
						$topic_type .= $lang['Topic_Locked'] . ' ';
					}
				}

				$separator = ' - ';
				if (isset($HTTP_GET_VARS['br']))
				{
					if ($HTTP_GET_VARS['br'] == 'y')
					{
						$separator = '<br>';
					}
				}

				$last_post_author = '';
				if (isset($HTTP_GET_VARS['lpb']))
				{
					$last_post_author = ( $topic_rowset[$i]['id2'] == ANONYMOUS ) ? ( ($topic_rowset[$i]['post_username2'] != '' ) ? $topic_rowset[$i]['post_username2'] . ' ' : $lang['Guest'] . ' ' ) : $topic_rowset[$i]['user2'];
					if (is_numeric($HTTP_GET_VARS['lpb']))
					{
						if (intval($HTTP_GET_VARS['lpb']) == 1)
						{
							$last_post_author = $separator . $lang['Lastpost_from'] . ' ' . $last_post_author;
						}
						else
						{
							$last_post_author = $separator . $last_post_author;
						}
					}
				}

				$in_forum = '';
				if (isset($HTTP_GET_VARS['sfn']))
				{
					if ($HTTP_GET_VARS['sfn'] == 'y')
					{
						if (isset($HTTP_GET_VARS['fnl']))
						{
							if ($HTTP_GET_VARS['fnl'] == 'y')
							{
								$view_forum_url = $full_url . "viewforum.$phpEx?" . POST_FORUM_URL . "=$forum_id";
								$in_forum = '<br />' . $lang['In'] . ' <a href=\"' . $view_forum_url . '\"' . $css_link . $target_link . '>' . addslashes($forum_name) . '</a>';
							}
							else
							{
								$in_forum = ' ' . $lang['In'] . ' ' . addslashes($forum_name);
							}
						}
						else
						{
							$in_forum = ' ' . $lang['In'] . ' ' . addslashes($forum_name);
						}
					}
					else
					{
						$error = true;
						output_die('Error: Wrong value for argument (locked)<br>');
					}
				}

				$last_post_time = '';
				if (isset($HTTP_GET_VARS['lpd']))
				{
					if (is_numeric($HTTP_GET_VARS['lpd']))
					{
						if (intval($HTTP_GET_VARS['lpd']) < count($date_formats))
						{
							$last_post_time = create_date($date_formats[$HTTP_GET_VARS['lpd']], $topic_rowset[$i]['post_time'], $board_config['board_timezone']);
						}
						else
						{
							$last_post_time = create_date($board_config['default_dateformat'], $topic_rowset[$i]['post_time'], $board_config['board_timezone']);
						}
					}
					else
					{
						$last_post_time = create_date($board_config['default_dateformat'], $topic_rowset[$i]['post_time'], $board_config['board_timezone']);
					}
					$last_post_time = ', ' . $last_post_time;
				}

				if (isset($HTTP_GET_VARS['r']))
				{
					if ($HTTP_GET_VARS['r'] == 'y')
					{
						if (isset($HTTP_GET_VARS['sr']))
						{
							if ($HTTP_GET_VARS['sr'] == 'y')
							{
								$replies = ' (' . $replies . ' ' . (($replies == '1')? $lang['Reply'] : $lang['Replies']) . ')';
							}
							else
							{
								$error = true;
								output_die('Error: Wrong value for argument (showrepliesword)<br>');
							}
						}
						else
						{
							$replies = ' (' . $replies . ')';
						}
					}
					else
					{
						$error = true;
						output_die('Error: Wrong value for argument (replies)<br>');
					}
				}
				else
				{
					$replies = '';
				}

				$view_topic_url = $full_url . "viewtopic.$phpEx?" . POST_TOPIC_URL . "=$topic_id";

				$views = $topic_rowset[$i]['topic_views'];

				if (isset($HTTP_GET_VARS['ch']))
				{
					if (is_numeric($HTTP_GET_VARS['ch']))
					{
						$max_title_length = intval($HTTP_GET_VARS['ch']);
						if ($max_title_length > 0)
						{
							$trans = get_html_translation_table(HTML_ENTITIES);
							$trans = array_flip($trans);
							$topic_title = strtr($topic_title, $trans);

							if (strlen($topic_title) > $max_title_length)
							{
								if (isset($HTTP_GET_VARS['chw']))
								{
									if ($HTTP_GET_VARS['chw'] == 'p')
									{
										$topic_title = (strstr(strrev(substr($topic_title, 0, $max_title_length)), ' ')) ? strrev(strstr(strrev(substr($topic_title, 0, $max_title_length)), ' ')) . '...' : substr($topic_title, 0, $max_title_length) . '...';
									}
									else if ($HTTP_GET_VARS['chw'] == 'n')
									{
										$topic_title_orig = $topic_title;
										$topic_title = substr($topic_title_orig, 0, $max_title_length);
										$lastpart = substr($topic_title_orig, strlen($topic_title));
										if (strrpos(strrev($lastpart), ' ') === false)
										{
											$topic_title = $topic_title_orig;
										}
										else
										{
											$topic_title .= substr($lastpart, 0, -(strrpos(strrev($lastpart), ' ')))  . '...';
										}
									}
									else
									{
										$topic_title = substr($topic_title, 0, $max_title_length) . '...';
									}
								}
								else
								{
									$topic_title = substr($topic_title, 0, $max_title_length) . '...';
								}
							}

							$trans = array_flip($trans);
							$topic_title = strtr($topic_title, $trans);
						}
					}
				}

				$item = $topic_type . '<a href=\"' . $view_topic_url . '\"' . $css_link . $target_link . '>' . addslashes($topic_title) . '</a>' . $in_forum . $replies . addslashes($last_post_author) . $last_post_time;

				$last_post_url = ' <a href=\"' . $full_url . "viewtopic.$phpEx?"  . POST_POST_URL . '=' . $topic_rowset[$i]['topic_last_post_id'] . '#' . $topic_rowset[$i]['topic_last_post_id'] . '\"' . $css_link . $target_link . '><img src=\"' . $full_url . $images['icon_latest_reply'] . '\" alt=\"' . $lang['View_latest_post'] . '\" title=\"' . $lang['View_latest_post'] . '\" border=\"0\" /></a>';
				if (isset($HTTP_GET_VARS['lpi']))
				{
					if ($HTTP_GET_VARS['lpi'] == 'y' && $HTTP_GET_VARS['b'] != 'lpi')
					{
						$item = $item . $last_post_url;
					}
				}

				if (isset($HTTP_GET_VARS['bl']))
				{
					if ($HTTP_GET_VARS['bl'] == 'y')
					{
						$item = $item . '<br>';
					}
				}

				if ($html_list)
				{
					$item = '<li>' . $item . '</li>';
				}
				else
				{
					if (isset($HTTP_GET_VARS['b']))
					{
						if ($HTTP_GET_VARS['b'] == 'non')
						{
							$item = $item . '<br>';
						}
						else if ($HTTP_GET_VARS['b'] == 'lpi')
						{
							$item = $last_post_url . ' ' . $item . '<br>';
						}
						else if (is_numeric($HTTP_GET_VARS['b']))
						{
							if (intval($HTTP_GET_VARS['b']) < count($bullets))
							{
								$item = $bullets[intval($HTTP_GET_VARS['b'])] . ' ' . $item . '<br>';
							}
							else
							{
								$error = true;
								output_die('Error: Wrong value for argument (bullet)<br>');
							}
						}
						else
						{
							$error = true;
							output_die('Error: Wrong value for argument (bullet)<br>');
						}
					}
				}

				array_push($outputarray, $item);
			}
		}
		else
		{
			//
			// No topics
			//
			if ($html_list)
			{
				$item = '<li>' . $lang['No_topics'] . '</li>';
			}
			else
			{
				if (isset($HTTP_GET_VARS['b']))
				{
					if ($HTTP_GET_VARS['b'] == 'non' || $HTTP_GET_VARS['b'] == 'lpi')
					{
						$item = $lang['No_topics'] . '<br>';
					}
					else if (is_numeric($HTTP_GET_VARS['b']))
					{
						if (intval($HTTP_GET_VARS['b']) < count($bullets))
						{
							$item = $bullets[intval($HTTP_GET_VARS['b'])] . ' ' . $lang['No_topics'] . '<br>';
						}
						else
						{
							$error = true;
							output_die('Error: Wrong value for argument (bullet)<br>');
						}
					}
				}
			}

			array_push($outputarray, $item);
		}

		if ($html_wrap_before != '')
		{
			array_push($outputarray, $html_wrap_after);
		}

		if ($css_text_wrap_before != '')
		{
			array_push($outputarray, $css_text_wrap_after);
		}

		while ($item = array_shift($outputarray))
		{
			echo "document.writeln('$item');\n";
		}
	}

	if ($error)
	{
		output_die($errorstring);
	}
}
else if ($HTTP_GET_VARS['mode'] == "generate") // makes and shows the code that the user has to put into the page where the topics are to be displayed
{
	$page_title = $lang['Topics_anywhere'];
	include($phpbb_root_path . 'includes/page_header.'.$phpEx);

	$template->set_filenames(array(
		'body' => 'topics_anywhere_result.tpl')
	);

	$htmlstring = '<script language="JavaScript" type="text/javascript" src="' . $full_url . TA_SCRIPT_NAME . '.' . $phpEx . '?mode=show';

	if (isset($HTTP_POST_VARS['f']))
	{
		$farray = $HTTP_POST_VARS['f'];
	}
	else
	{
		$farray = array();
	}

	$carray = array();

	if (count($farray) != 0)
	{
		$farray = array_unique($farray);
		sort($farray);
		for ($j = 0; $j < count($farray); $j++) {
			if ($farray[$j] == '-1') {
				array_splice($farray, $j, 1);
			}
		}

		for ($j = 0; $j < count($farray); $j++) {
			if (strpos($farray[$j], 'cat') !== false) {
				$carray = array_merge($carray, array_splice($farray, $j, 1));
				$j--;
			}
		}
	}

	if (count($carray) != 0)
	{
		$carray = str_replace('cat', '', $carray);
		$catsql = '(' . implode(', ', $carray) . ')';

		$sql = "SELECT forum_id
			FROM " . FORUMS_TABLE . "
			WHERE cat_id IN " . $catsql . "
			ORDER BY forum_id";
		if ( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Could not obtain forums information', '', __LINE__, __FILE__, $sql);
		}

		$carray = array();
		while ( $row = $db->sql_fetchrow($result) )
		{
			$carray[] = $row['forum_id'];
		}

		$farray = array_merge($farray, $carray);
		$farray = array_unique($farray);
		sort($farray);
	}

	if (count($farray) == 0 && !$HTTP_POST_VARS['allfora'])
	{
		message_die(GENERAL_ERROR, ($lang['Pick_a_forum'] . '<br /><br /><a href="javascript:history.back()">' . $lang['Click_return'] . '</a>'));
	}
	else
	{
		if ($HTTP_POST_VARS['allfora'] || ($HTTP_POST_VARS['total_forums'] == count($farray)))
		{
			$htmlstring .= '&f=a';
		}
		else
		{
			$htmlstring .= '&f=b' . base64_encode('(' . implode(', ', $farray) . ')');
		}
	}

	if (!isset($HTTP_POST_VARS['amount_topics']))
	{
		message_die(GENERAL_ERROR, ($lang['Invalid_amount'] . '<br /><br /><a href="javascript:history.back()">' . $lang['Click_return'] . '</a>'));
	}
	else
	{
		if (!is_numeric($HTTP_POST_VARS['amount_topics']))
		{
			message_die(GENERAL_ERROR, ($lang['Invalid_amount'] . '<br /><br /><a href="javascript:history.back()">' . $lang['Click_return'] . '</a>'));
		}
		else
		{
			$amount = floor(intval($HTTP_POST_VARS['amount_topics']));
			if ($amount > 0)
			{
				$htmlstring .= '&n=' . $amount;
			}
			else
			{
				message_die(GENERAL_ERROR, ($lang['Invalid_amount'] . '<br /><br /><a href="javascript:history.back()">' . $lang['Click_return'] . '</a>'));
			}
		}
	}

	if ($HTTP_POST_VARS['show_forum_name'])
	{
		$htmlstring .= '&sfn=y';
		if ($HTTP_POST_VARS['link_forum_name'])
		{
			$htmlstring .= '&fnl=y';
		}
	}

	if ($HTTP_POST_VARS['show_replies'])
	{
		$htmlstring .= '&r=y';
		if ($HTTP_POST_VARS['show_replies_word'])
		{
			$htmlstring .= '&sr=y';
		}
	}

	if ($HTTP_POST_VARS['show_announce'])
	{
		$htmlstring .= '&a=y';
	}

	if ($HTTP_POST_VARS['show_sticky'])
	{
		$htmlstring .= '&s=y';
	}

	if ($HTTP_POST_VARS['show_locked'])
	{
		$htmlstring .= '&l=y';
	}

	if ($HTTP_POST_VARS['show_moved'])
	{
		$htmlstring .= '&m=y';
	}

	if (!$HTTP_POST_VARS['show_regular'])
	{
		$htmlstring .= '&rt=n';
	}

	if (isset($HTTP_POST_VARS['hidelabel']))
	{
		$htmlstring .= '&h=';
		$hidelabel = $HTTP_POST_VARS['hidelabel'];
		foreach ($hidelabel as $key => $val)
		{
			$htmlstring .= substr($key, 1, -1);
		}
	}

	if ($HTTP_POST_VARS['sort_order'] == 'ondate')
	{
		$htmlstring .= '&so=d';
	}

	if ($HTTP_POST_VARS['lastposticon_bullet'])
	{
		$htmlstring .= '&b=lpi';
	}
	else
	{
		$htmlstring .= '&b=' . $HTTP_POST_VARS['bullet_type'];
	}

	if ($HTTP_POST_VARS['show_lastpostby'])
	{
		$htmlstring .= '&lpb=' . $HTTP_POST_VARS['lastpostby_format'];
	}

	if ($HTTP_POST_VARS['show_lastpostdate'])
	{
		$htmlstring .= '&lpd=' . $HTTP_POST_VARS['lastpostdate_format'];
	}

	if ($HTTP_POST_VARS['show_lastposticon'])
	{
		$htmlstring .= '&lpi=y';
	}

	if ($HTTP_POST_VARS['add_break'])
	{
		$htmlstring .= '&br=y';
	}

	if ($HTTP_POST_VARS['add_blank_line'])
	{
		$htmlstring .= '&bl=y';
	}

	if (isset($HTTP_POST_VARS['limit_length']))
	{
		if (!is_numeric($HTTP_POST_VARS['limit_length']))
		{
			message_die(GENERAL_ERROR, ($lang['Invalid_title_length'] . '<br /><br /><a href="javascript:history.back()">' . $lang['Click_return'] . '</a>'));
		}
		else
		{
			$limitlength = floor(intval($HTTP_POST_VARS['limit_length']));
			if ($limitlength > 0)
			{
				$htmlstring .= '&ch=' . $limitlength . '&chw=' . $HTTP_POST_VARS['limit_where'];
			}
		}
	}

	if (isset($HTTP_POST_VARS['css_link']))
	{
		$css_link = trim($HTTP_POST_VARS['css_link']);
		if (preg_match("/[^a-zA-Z0-9]+$/s", $css_link) || strstr($css_link, ' '))
		{
			message_die(GENERAL_ERROR, ($lang['Invalid_class'] . '<br /><br /><a href="javascript:history.back()">' . $lang['Click_return'] . '</a>'));
		}
		else
		{
			if ($css_link != '')
			{
				$htmlstring .= '&cl=' . $css_link;
			}
		}
	}

	if (isset($HTTP_POST_VARS['css_text']))
	{
		$css_text = trim($HTTP_POST_VARS['css_text']);
		if (preg_match("/[^a-zA-Z0-9]+$/s", $css_text) || strstr($css_text, ' '))
		{
			message_die(GENERAL_ERROR, ($lang['Invalid_class'] . '<br /><br /><a href="javascript:history.back()">' . $lang['Click_return'] . '</a>'));
		}
		else
		{
			if ($css_text != '')
			{
				$htmlstring .= '&ct=' . $css_text;
			}
		}
	}

	if (isset($HTTP_POST_VARS['target_link']))
	{
		$target_link = trim($HTTP_POST_VARS['target_link']);
		if (preg_match("/[^a-zA-Z0-9_]+$/s", $target_link) || strstr($target_link, ' '))
		{
			message_die(GENERAL_ERROR, ($lang['Invalid_target'] . '<br /><br /><a href="javascript:history.back()">' . $lang['Click_return'] . '</a>'));
		}
		else
		{
			if ($target_link != '')
			{
				$htmlstring .= '&t=' . $target_link;
			}
		}
	}

	$htmlstring .= '"></script>';

	$template->assign_vars(array(
		'L_COPYPASTE' => $lang['Copy_paste'],
		'L_COPYPASTE_EXPLAIN' => $lang['Copy_paste_explain'],
		'RESULT' => str_replace("&amp;", "&", htmlspecialchars($htmlstring, ENT_QUOTES)),
		'L_RESULT' => $lang['The_result'],
		'L_CLASSES_REMARK' => $lang['Classes_remark'],
		'HTMLCODE' => $htmlstring)
	);

	$template->pparse('body');

	include($phpbb_root_path . 'includes/page_tail.'.$phpEx);
}
else // shows option page - page will be shown if no or wrong $mode arguments are given
{
	if ($topics_anywhere_authlevel == 0)
	{
		show_the_page();
	}
	else
	{
		if ( !$userdata['session_logged_in'] )
		{
			$header_location = ( @preg_match("/Microsoft|WebSTAR|Xitami/", getenv("SERVER_SOFTWARE")) ) ? "Refresh: 0; URL=" : "Location: ";
			header($header_location . append_sid("login." . $phpEx . "?redirect=" . TA_SCRIPT_NAME . "." . $phpEx, true));
			exit;
		}
		else // user is logged in - check userlevel
		{
			switch($topics_anywhere_authlevel)
			{
				case 1:
					if ($userdata['user_level'] == ADMIN)
					{
						show_the_page();
					}
					else
					{
						$message = sprintf($lang['Sorry_auth_topicsanywhere'], $lang['Auth_Administrators']);
						message_die(GENERAL_MESSAGE, $message, $lang['Not_Authorised']);
					}
					break;
				case 2:
					if ($userdata['user_level'] == MOD)
					{
						show_the_page();
					}
					else
					{
						$message = sprintf($lang['Sorry_auth_topicsanywhere'], $lang['Auth_Moderators']);
						message_die(GENERAL_MESSAGE, $message, $lang['Not_Authorised']);
					}
					break;
				case 3:
					if ($userdata['user_level'] == ADMIN || $userdata['user_level'] == MOD)
					{
						show_the_page();
					}
					else
					{
						$message = sprintf($lang['Sorry_auth_topicsanywhere'], $lang['Auth_Administrators'] . ' ' . strtolower($lang['Or']) . ' ' . $lang['Auth_Moderators']);
						message_die(GENERAL_MESSAGE, $message, $lang['Not_Authorised']);
					}
					break;
				case 4:
					if ($userdata['user_level'] == ADMIN || $userdata['user_level'] == LESS_ADMIN || $userdata['user_level'] == MOD)
					{
						show_the_page();
					}
					else
					{
						$message = sprintf($lang['Sorry_auth_topicsanywhere'], $lang['Auth_Administrators'] . ' ' . strtolower($lang['Or']) . ' ' . $lang['Auth_Moderators']);
						message_die(GENERAL_MESSAGE, $message, $lang['Not_Authorised']);
					}
					break;
				case 5:
					if ($userdata['user_level'] == USER || $userdata['user_level'] == ADMIN || $userdata['user_level'] == MOD)
					{
						show_the_page();
					}
					else
					{
						$message = sprintf($lang['Sorry_auth_topicsanywhere'], $lang['Auth_Registered_Users']);
						message_die(GENERAL_MESSAGE, $message, $lang['Not_Authorised']);
					}
					break;
				default:
					message_die(GENERAL_MESSAGE, $lang['Error']);
					break;
			}
		}
	}
}

// EOF
?>
