<?php
/***************************************************************************
 *                              shop_transactions.php
 *                            -------------------
 *   begin                : Saturday, January 04, 2003
 *   copyright            : (C)2003 LaZeR : Original Concept by Conan Tran
 *   website	          : http://www.oasisforum.valcato.net/phpbb/portal.php
 *   email                : lzerace@msn.com
 *
 *   $Id: shop_transactions.php,v 0.90 2003/1/04 20:00:00 LaZeR
 *
 ***************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 ***************************************************************************/

define('IN_PHPBB', true);
$phpbb_root_path = './';
include($phpbb_root_path . 'extension.inc');
include($phpbb_root_path . 'common.'.$phpEx);

//
// Start session management
//
$userdata = session_pagestart($user_ip, PAGE_SHOP_TRANSACTIONS, $session_length);
init_userprefs($userdata);
//
// End session management
//

if ( !$userdata['session_logged_in'] ) 
{ 
	redirect("login.".$phpEx."?redirect=shop_transactions.".$phpEx); 
	exit; 
} 

$start = ( isset($HTTP_GET_VARS['start']) ) ? intval($HTTP_GET_VARS['start']) : 0;

if(isset($HTTP_POST_VARS['order']))
{
	$sort_order = ($HTTP_POST_VARS['order'] == 'ASC') ? 'ASC' : 'DESC';
}
else if(isset($HTTP_GET_VARS['order']))
{
	$sort_order = ($HTTP_GET_VARS['order'] == 'ASC') ? 'ASC' : 'DESC';
}
else
{
	$sort_order = 'ASC';
}

//
// Transactions sorting
//

$mode_types_text = array($lang['Date'], $lang['Username'], $lang['Trans_Item'], $lang['Trans_Type'], $lang['Trans_Cost'], $lang['Sort_Trans_Top_Ten']);
$mode_types = array('shoptransdate', 'transuser', 'transitem', 'transtype', 'transtotal', 'toptenshoptrans');

$select_sort_mode = '<select name="mode">';
for($i = 0; $i < count($mode_types_text); $i++)
{
	$selected = ( $mode == $mode_types[$i] ) ? ' selected="selected"' : '';
	$select_sort_mode .= '<option value="' . $mode_types[$i] . '"' . $selected . '>' . $mode_types_text[$i] . '</option>';
}
$select_sort_mode .= '</select>';

$select_sort_order = '<select name="order">';
if($sort_order == 'ASC')
{
	$select_sort_order .= '<option value="ASC" selected="selected">' . $lang['Sort_Ascending'] . '</option><option value="DESC">' . $lang['Sort_Descending'] . '</option>';
}
else
{
	$select_sort_order .= '<option value="ASC">' . $lang['Sort_Ascending'] . '</option><option value="DESC" selected="selected">' . $lang['Sort_Descending'] . '</option>';
}
$select_sort_order .= '</select>';

//
// Generate page
//
$page_title = $lang['Shop_Transaction'];

include($phpbb_root_path . 'includes/page_header.'.$phpEx);

$template->set_filenames(array(
	'body' => 'shop_transactions_body.tpl')
);

make_jumpbox('viewforum.'.$phpEx);

$template->assign_vars(array(
	'L_SELECT_SORT_METHOD' => $lang['Select_sort_method'],
	'L_ORDER' => $lang['Order'],
	'L_SUBMIT' => $lang['Sort'],

	'L_TRANS_USER' => $lang['Username'],
	'L_TRANS_ITEM' => $lang['Trans_Item'],
	'L_TRANS_TOTAL' => $lang['Trans_Cost'],
	'L_SHOPTRANS_DATE' => $lang['Date'],
	'L_MONEY_SYMBOL' => $lang['Money_Symbol'],
	'L_TRANS_TYPE' => $lang['Trans_Type'],

	'S_MODE_SELECT' => $select_sort_mode,
	'S_ORDER_SELECT' => $select_sort_order,
	'S_MODE_ACTION' => append_sid("shop_transactions.$phpEx"))
);

if ( isset($HTTP_GET_VARS['mode']) || isset($HTTP_POST_VARS['mode']) )
{
	$mode = ( isset($HTTP_POST_VARS['mode']) ) ? $HTTP_POST_VARS['mode'] : $HTTP_GET_VARS['mode'];

	switch( $mode )
	{
		case 'shoptransdate':
			$order_by = "shoptrans_date $sort_order LIMIT $start, " . $board_config['topics_per_page'];
			break;
		case 'transuser':
			$order_by = "trans_user $sort_order LIMIT $start, " . $board_config['topics_per_page'];
			break;
		case 'transitem':
			$order_by = "trans_item $sort_order LIMIT $start, " . $board_config['topics_per_page'];
			break;
		case 'transtype':
                        $order_by = "trans_type $sort_order LIMIT $start, " . $board_config['topics_per_page'];
			break;
		case 'transtotal':
			$order_by = "trans_total $sort_order LIMIT $start, " . $board_config['topics_per_page'];
			break;
		case 'toptenshoptrans':
			$order_by = "trans_total DESC LIMIT 10";
			break;
		default:
			$order_by = "shoptrans_date DESC LIMIT $start, " . $board_config['topics_per_page'];
			break;
	}
}
else
{
	$order_by = "shoptrans_date DESC LIMIT $start, " . $board_config['topics_per_page'];
}

$sql = "SELECT shoptrans_date, trans_user, trans_item, trans_type, trans_total
	FROM " . SHOPTRANS_TABLE . "
	ORDER BY $order_by";
if( !($result = $db->sql_query($sql)) )
{
	message_die(GENERAL_ERROR, 'Could not query transaction', '', __LINE__, __FILE__, $sql);
}

if ( $row = $db->sql_fetchrow($result) )
{
	$i = 0;
	do
	{
		$trans_user = $row['trans_user'];
		$trans_item = $row['trans_item'];
		$trans_type = $row['trans_type'];
		$trans_total = ( $row['trans_total'] ) ? $row['trans_total'] : 0;
		$shoptrans_date = create_date($board_config['default_dateformat'], $row['shoptrans_date'], $board_config['board_timezone']);

		$row_color = ( !($i % 2) ) ? $theme['td_color1'] : $theme['td_color2'];
		$row_class = ( !($i % 2) ) ? $theme['td_class1'] : $theme['td_class2'];

		$template->assign_block_vars('transrow', array(
			'ROW_NUMBER' => $i + ( $HTTP_GET_VARS['start'] + 1 ),
			'ROW_COLOR' => '#' . $row_color,
			'ROW_CLASS' => $row_class,
			'TRANS_USER' => $trans_user,
			'TRANS_ITEM' => $trans_item,
			'TRANS_TYPE' => $trans_type,
			'TRANS_TOTAL' => $trans_total,
			'SHOPTRANS_DATE' => $shoptrans_date)
		);

		$i++;
	}
	while ( $row = $db->sql_fetchrow($result) );
}

if ( $mode != 'topten' || $board_config['topics_per_page'] < 10 )
{
	$sql = "SELECT count(*) AS total
		FROM " . SHOPTRANS_TABLE . "";

	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Error getting total transactions', '', __LINE__, __FILE__, $sql);
	}

	if ( $total = $db->sql_fetchrow($result) )
	{
		$total_transactions = $total['total'];

		$pagination = generate_pagination("shop_transaction.$phpEx?mode=$mode&amp;order=$sort_order", $total_transactions, $board_config['topics_per_page'], $start). '&nbsp;';
	}
}
else
{
	$pagination = '&nbsp;';
	$total_transactions = 10;
}

$template->assign_vars(array(
	'PAGINATION' => $pagination,
	'PAGE_NUMBER' => sprintf($lang['Page_of'], ( floor( $start / $board_config['topics_per_page'] ) + 1 ), ceil( $total_transactions / $board_config['topics_per_page'] )),
	'L_GOTO_PAGE' => $lang['Goto_page'])
);

$template->pparse('body');

include($phpbb_root_path . 'includes/page_tail.'.$phpEx);

?>