<?php
/////////////////////////////////////////////////////////////////
/// foing by the foing group                                   //
//        available at http://foing.sourceforge.net           ///
/////////////////////////////////////////////////////////////////
//                                                             //
// song.php         -  part of foing                           //
//                                                             //
/////////////////////////////////////////////////////////////////

/***************************************************************************
 * This file has been modified by Fully Moddded phpBB
 *
 *   $FMId: 2003/06/15 04:15:08 krystal
 *
 ***************************************************************************/

include('includes/common.php');
$page_title = 'Add/Edit mp3';
check_perm('add'); // can the user add an mp3?
$getid3powered = true;

//
// Begin action switch. Default is 'new';
//

if (!isset($foing_mode))
{
	$foing_mode = 'new';
}

switch ($foing_mode)
{
	case 'die':
		foing_die('This file does not exist.', 'song.php');
		break;

	case 'edit':
		
		// fetch the data from the database
		$sql = 'SELECT song_id, artist_id, genre_id, user_id, album_id, status_id, song_title, song_url, song_length, song_quality, song_size FROM ' .
				SONGS_TABLE . ' WHERE song_id = "'. $songid .'" LIMIT 1';
		//echo $sql;
		$result = $db->sql_query($sql);
		$song_info = $db->sql_fetchrow($result);

		// check if user has rights to edit this song
		if (!(($userdata['user_id'] == $song_info['user_id'] && $song_info['user_id'] != -1) || $userdata['foing_mod']))
		{
			foing_die('you may not edit this song');
		}

		// fetch the artist data
		$sql = 'SELECT artist_name, artist_prefix, artist_url FROM ' . ARTISTS_TABLE .' WHERE artist_id = "'. $song_info['artist_id'] .'"';
		$result = $db->sql_query($sql);
		$artist_info = $db->sql_fetchrow($result);

		unset($song_data);
		session_register('song_data'); // we're passing the mp3 file info through with sessions
		unset($song_data);
		$song_data = Array (
			'update'	=> TRUE,
			'user_id'	=> $song_info['user_id'],
			'song_id'	=> $song_info['song_id'],
			'status_id' => $song_info['status_id'],
			'url'		=> Array ($song_info['song_url'], TRUE),
			'title'		=> Array ($song_info['song_title'], FALSE),
			'artist_prefix' => Array($artist_info['artist_prefix'], FALSE),
			'artist'	=> Array ($artist_info['artist_name'], FALSE, TRUE), // third parameter for matching
			'artist_id'	=> Array ($song_info['artist_id'], FALSE), // if 2nd parameter is TRUE, we have the artist in the db
			'length'	=> Array ($song_info['song_length'], TRUE),
			'quality'	=> Array ($song_info['song_quality'], TRUE), // in kbps
			'album'		=> Array ($mp3info['album'], FALSE, FALSE), // third parameter for matching
			'album_id'	=> Array ($song_info['album_id'], FALSE), // if 2nd parameter is TRUE, we have the album in the db
			'year'		=> Array ($mp3info['year'], FALSE),
			'genre'		=> Array ($mp3info['genre'], FALSE),
			'genre_id'	=> Array ($song_info['genre_id'], FALSE),
			'website'	=> Array ($artist_info['artist_url'], FALSE),
			'size'		=> Array ($song_info['song_size'], TRUE) // in 1-decimal rounded mb
		); 		
		// we're not putting these values in the database, so don't bother to set the 2nd argument to TRUE
		$song_data['length_min']['0'] = floor($song_data['length']['0'] / 60);
		$song_data['length_sec']['0'] = $song_data['length']['0'] - ($song_data['length_min']['0'] * 60);
		
		$HTTP_SESSION_VARS['song_data'] = $song_data;
		
		$sql = 'SELECT artist_id, artist_name, artist_prefix FROM ' . ARTISTS_TABLE . ' ORDER BY artist_name ASC';
		$result = $db->sql_query($sql);
		while ($sql_data = $db->sql_fetchrow($result))
		{
			$song_data['artist_list'] .= '<OPTION VALUE="' . $sql_data['artist_id'] . '"';
			if ($sql_data['artist_id'] == $song_data['artist_id']['0'])
			{
				$song_data['artist_list'] .= ' SELECTED ';
			}
			$song_data['artist_list'] .= '>' . artist_add_prefix($sql_data['artist_name'], $sql_data['artist_prefix']) . "</OPTION>\n";
		} 

		//
		// start the output
		//
		
		include('includes/page_header.php');
		song_form('artist', 'info');
		include('includes/page_tail.php');
		break;
		

	case 'new':

		include('includes/page_header.php');
		song_form($foing_mode, 'fetch');
		include('includes/page_tail.php');
		break;

	case 'fetch';

		if (empty($HTTP_POST_VARS['song_url']))
		{
			foing_die("You haven't entered an URL.");
		}

		//is the song already in the database?
		$sql = 'SELECT song_id FROM ' . SONGS_TABLE . ' 
				WHERE ( song_url = "' . $song_url . '" ) LIMIT 1';
		$result = $db->sql_query($sql);
		if ($db->sql_numrows($result) == 1)
		{
			$re_msg = 'This song already in the database';
			$re_url = append_sid($PHP_SELF);
			foing_die($re_msg, $re_url);
		}

		include('includes/page_header.php');
		echo '<script language="JavaScript" src="' . $foing_config['remote_getid3'] . '?song_url=' . rawurlencode($song_url) . '&sid=' . $userdata['session_id'] .'"></script>';
		$template->set_filenames(array(
			'body' 	=> 'song_fetch.tpl')
		);
		$template->pparse('body');
		include('includes/page_tail.php');
		break;

	case 'remote':
		
		//
		// right session?
		//
		if (!isset($HTTP_GET_VARS['sid']) || $HTTP_GET_VARS['sid'] != $userdata['session_id'])
		{
			foing_die('Invalid session', 'song.php');
		}

		// we're here with a lot of GET variables, all starting with 'song_'.
		// so let's put them in the song_data array
		unset($HTTP_SESSION_VARS['song_data']);
		if (!session_is_registered('song_data'))
		{
			session_register('song_data');
		}
		$song_data = Array (
			'url'		=> Array ($song_url, TRUE),
			'title'		=> Array ($song_title, FALSE),
			'artist'	=> Array ($song_artist, FALSE, FALSE), // third parameter for matching
			'artist_id'	=> Array (null, FALSE), // if 2nd parameter is TRUE, we have the artist in the db
			'length'	=> Array ($song_length, TRUE),
			'quality'	=> Array ($song_quality, TRUE), // in kbps
			'album'		=> Array ($song_album, FALSE, FALSE), // third parameter for matching
			'album_id'	=> Array (null, FALSE), // if 2nd parameter is TRUE, we have the album in the db
			'year'		=> Array ($song_year, FALSE),
			'genre'		=> Array ($song_genre, FALSE),
			'genre_id'	=> Array ($song_genre_id, FALSE),
			'website'	=> Array ($song_website, FALSE),
			'size'		=> Array ($song_size, TRUE) // in 1-decimal rounded mb
		); 


		// check on the filesize, bitrate and length
		if ($song_data['quality']['0'] == 0)
		{
			$song_data['quality']['0'] = 128;
		}
		if ($song_data['length']['0'] == 0)
		{
			$song_data['length']['0'] = round(($song_data['size']['0'] / 0.0152587890625),0);
		}

		// we're not putting these values in the database, so don't bother to set the 2nd argument to TRUE
		$song_data['length_min']['0'] = floor($song_data['length']['0'] / 60);
		$song_data['length_sec']['0'] = $song_data['length']['0'] - ($song_data['length_min']['0'] * 60);
		
		$HTTP_SESSION_VARS['song_data'] = $song_data;
		
		//
		// see if we have an 'artist' match in our database
		//
		
		// first, see if we have an exact match
		$sql = 'SELECT artist_id 
			FROM ' . ARTISTS_TABLE . ' 
			WHERE artist_name = "' . $song_data['artist']['0'] . '"';
		$result = $db->sql_query($sql);
		if ($db->sql_numrows($result) == 1)  // we should have 1 row in our result set
		{
			$sql_data = $db->sql_fetchrow($result);
			$HTTP_SESSION_VARS['song_data']['artist_id']['0'] = $sql_data['artist_id'];
			$HTTP_SESSION_VARS['song_data']['artist_id']['1'] = TRUE;
			echo '<script language="JavaScript">window.location="'.append_sid($PHP_SELF . '?foing_mode=info') . '"; </script>';
			exit;
		}
		echo '<script language="JavaScript">window.location="'.append_sid($PHP_SELF . '?foing_mode=artist') . '"; </script>';

		break;		
		
	case 'artist':
	  
		session_start();
		// obviously we do not have an exact artist match, cause else we wouldn't be here. 
		// get the preferred artists and put them on top
		if (trim($song_data['artist']['0'] != ''))
		{
			$sql = 'SELECT artist_id, artist_name, artist_prefix 
				FROM ' . ARTISTS_TABLE . ' 
				WHERE artist_name LIKE "%' . $song_data['artist']['0'] . '%" 
				ORDER BY artist_name ASC';
			$result = $db->sql_query($sql);
			while ($sql_data = $db->sql_fetchrow($result))
			{
				$song_data['artist_list'] .= '<OPTION VALUE="' . $sql_data['artist_id'] . '">' . artist_add_prefix($sql_data['artist_name'], $sql_data['artist_prefix']) . "</OPTION>\n";
				if (!$song_data['artist']['2'])
				{
					$song_data['artist']['2'] = TRUE;
				}
			} 
		}
		
		// in case of  a false matches, output the entire artist table
		$sql = 'SELECT artist_id, artist_name, artist_prefix FROM ' . ARTISTS_TABLE . ' ORDER BY artist_name ASC';
		$result = $db->sql_query($sql);
		while ($sql_data = $db->sql_fetchrow($result))
		{
			$song_data['artist_list'] .= '<OPTION VALUE="' . $sql_data['artist_id'] . '">' . artist_add_prefix($sql_data['artist_name'], $sql_data['artist_prefix']) . "</OPTION>\n";
		} 

		//
		// start the output
		//
		
		include('includes/page_header.php');
		song_form($foing_mode, 'info');
		include('includes/page_tail.php');
		break;

	case 'info':

		//
		// handler for the artist info
		//

		if ($artist_type == 'new')
		{
			if (trim($song_artist) == '') // has the user entered something?
			{
				$re_msg = 'You didn\'t enter an artist name.';
				$re_url = append_sid($PHP_SELF. '?foing_mode=artist&song_url=' . $song_data['url']['0']);
				foing_die($re_msg, $re_url);
			}
			$sql = 'SELECT artist_id, artist_prefix 
				FROM ' . ARTISTS_TABLE . ' 
				WHERE artist_name = "' . $song_artist . '" 
				LIMIT 1';
			$row = @$db->sql_fetchrow($db->sql_query($sql));
			if ($row['artist_id'] > 0) // do we have the same name in the database?
			{
				$song_data['artist_id']['0'] = $row['artist_id'];
				$song_data['artist']['0'] = artist_add_prefix($song_artist, $row['artist_prefix']);
			} 
			else // we don't so insert a new one
			{
				$sql = 'INSERT INTO ' . ARTISTS_TABLE . '
					(artist_name, artist_prefix) 
					VALUES ("' . $song_artist . '", "' . $song_artist_prefix . '")';
				$db->sql_query($sql);
				$song_data['artist_id']['0'] = $db->sql_nextid($sql);
				$song_data['artist']['0'] = artist_add_prefix($song_artist, $song_artist_prefix);
			}
			$song_data['artist_id']['1'] = TRUE; 
		}
		if ($artist_type == 'existing' || $song_data['artist_id']['1'] == TRUE)
		{
			if ($artist_type == 'existing')
			{
				$song_data['artist_id']['0'] = $song_artist_id;
				$song_data['artist_id']['1'] = TRUE; // we don't have to insert a new artist to the db
			}
			$sql = 'SELECT artist_name, artist_prefix, artist_url 
				FROM ' . ARTISTS_TABLE . ' 
				WHERE artist_id = "' . $song_data['artist_id']['0'] . '" 
				LIMIT 1';
			$result 	= $db->sql_query($sql);
			$sql_data 	= $db->sql_fetchrow($result);
			$song_data['artist']['0'] = artist_add_prefix($sql_data['artist_name'], $sql_data['artist_prefix']);
			$song_data['artist']['1'] = TRUE;
			if ($sql_data['artist_url']['0'] != '') // if we have a stored website, it overrides the one in the mp3 id3 tag.
			{
				$song_data['website']['0'] = $sql_data['artist_url'];
				$song_data['website']['1'] = TRUE; // indicating we already have an url in the db
			}
			else
			{
				 $song_data['website']['1'] = FALSE;
			}
		}

		//		
		// see if have an 'album' match in our database
		//
		
		if ($song_data['artist_id']['1']) // we only have albums of artists which are already in our database
		{
			// first, see if we have an exact match
			$sql = 'SELECT album_title, album_year, album_id 
				FROM ' . ALBUMS_TABLE . ' WHERE 
				artist_id = "' . $song_data['artist_id']['0'] . '" AND
				album_title = "' . $song_data['album']['0'] . '"';
			$result = $db->sql_query($sql);
			if ($db->sql_numrows($result) == 1)  // we should have 1 row in our result set
			{
				$sql_data = $db->sql_fetchrow($result);
				$song_data['album_id']['0']	= $sql_data['album_id'];
				$song_data['album_id']['1'] = TRUE; // indicating we already have the album in the db
				$song_data['album']['0']	= $sql_data['album_title'];
				$song_data['album']['1']	= TRUE;
				if ($sql_data['album_year'] != null) // year default is 'null'
				{
					$song_data['year']['0']	= $sql_data['album_year'];
					$song_data['year']['1']	= TRUE; // indicating we already have the year in the db
				}
				else
				{
					$song_data['year']['1']	= FALSE; // indicating we do not already have the year in the db
				}
			}

			// in case we don't have an exact match, list the albums by the given artist
			if (!$song_data['album_id']['1'])
			{
				$sql = 'SELECT album_title, album_id 
					FROM ' . ALBUMS_TABLE . ' WHERE
					artist_id = "' . $song_data['artist_id']['0'] . '"';
				$result = $db->sql_query($sql);
				if ($db->sql_numrows($result) != 0)
				{
					while ($sql_data = $db->sql_fetchrow($result))
					{
						$song_data['album_list'] .= '<OPTION VALUE="' . $sql_data['album_id'] . '"';
						if ($song_data['album_id']['0'] == $sql_data['album_id'])
						{
							$song_data['album_list'] .= ' SELECTED ';
						}
						$song_data['album_list'] .= '>' . $sql_data['album_title'] . "</OPTION>\n";
						if (!$song_data['album']['2'])
						{
							$song_data['album']['2'] = TRUE;
						}
					}
				}
			}
		}
		
		//
		// list the genres
		//

		$sql = 'SELECT genre_id, genre_name FROM ' . GENRES_TABLE . ' ORDER BY genre_name ASC';
		$result = $db->sql_query($sql);
		while ($sql_data = $db->sql_fetchrow($result))
		{
			$song_data['genre_list'] .= '<OPTION VALUE="' . $sql_data['genre_id'] . '"';
			if (($song_data['genre']['0'] == $sql_data['genre_name']) || ($song_data['genre_id']['0'] == $sql_data['genre_id']))
			{
				$song_data['genre_list'] .= ' SELECTED ';
			}
			$song_data['genre_list'] .= '>' . $sql_data['genre_name'] . "</OPTION>\n";
		} 

		include('includes/page_header.php');
		song_form($foing_mode, 'insert');
		include('includes/page_tail.php');
		break;

	case 'insert':
		
		//
		// check the song variables, and insert them into the database
		//

		// check if user has rights to edit this song
		if ($song_data['update'])
		{
			if (!(($userdata['user_id'] == $song_data['user_id'] && $song_data['user_id'] != -1) || $userdata['foing_mod']))
			{
				foing_die('you may not edit this song');
			}
		}

		if (!$song_data['website']['1'] && (trim($song_website) != ''))
		{
			$song_data['website']['0'] = trim($song_website);
			$song_data['website']['1'] = TRUE;
			$sql = 'UPDATE ' . ARTISTS_TABLE . ' 
				SET artist_url = "' . $song_data['website']['0'] . '"
				WHERE artist_id = "' . $song_data['artist_id']['0'] . '"';
			$db->sql_query($sql);
		}

		if (trim($song_title) == '')
		{
			$re_msg = 'you have not entered a song title';
			$re_url = append_sid($PHP_SELF.'?foing_mode=info');
			foing_die($re_msg, $re_url);
		}
		else
		{
			$song_data['title']['0'] = trim($song_title);
			$song_data['title']['1'] = TRUE;
		}

		//is the song already in the database?
		if (!$song_data['update'])
		{
			$sql = 'SELECT song_id FROM ' . SONGS_TABLE . ' 
				WHERE ( song_title = "' . $song_data['title']['0'] . '" ) 
				AND ( artist_id = "' . $song_data['artist_id']['0'] . '" )
				LIMIT 1';
			$result = $db->sql_query($sql);
			if ($db->sql_numrows($result) == 1)
			{
				foing_die('this song already in the database');
			}
		}

		if (trim($song_album != ''))
		{
			if (($album_type == 'new') || (!$song_data['album']['2'] && !$song_data['album_id']['1']))
			{
				if (trim($song_year) != '')
				{
					$song_data['year']['0'] = trim($song_year);
					$song_data['year']['1'] = TRUE;
				}
				else
				{
					$song_data['year']['0'] = null;
				}
				$song_data['album']['0'] = trim($song_album);
				$sql = 'SELECT album_id 
					FROM ' . ALBUMS_TABLE . ' 
					WHERE ( album_title = "' . $song_data['album']['0'] . '" )
					AND ( artist_id = "'. $song_data['artist_id']['0'] .'" )
					LIMIT 1';
				$album_id = @$db->sql_fetchfield('album_id',-1,$db->sql_query($sql));
				if ($album_id > 0) // do we have the same name in the database?
				{
					$song_data['album_id']['0'] = $album_id;
				} 
				else // we don't, so insert a new one
				{
					$sql = 'INSERT INTO ' . ALBUMS_TABLE . ' (artist_id, album_title, album_year)
					VALUES ("' . $song_data['artist_id']['0'] .'","' . $song_data['album']['0'] . '",';
					if ($song_data['year']['1'])
					{
						$sql .= '"' . $song_data['year']['0'] . '")';
					}
					else
					{
						$sql .= 'NULL )';
					}
					$db->sql_query($sql);
					$song_data['album_id']['0'] = $db->sql_nextid($sql);
				}
				$song_data['album_id']['1'] = TRUE; 
			}
		}
		else
		{
			if (!$song_data['album_id']['1'])
			{
				$song_data['album_id']['0'] = '0';
			}
		}
		if ($album_type == 'existing')
		{
			$song_data['album_id']['0'] = $song_album_id;
			$song_data['album_id']['1'] = TRUE;
		}

		$song_data['genre_id']['0'] = $song_genre_id;
		$song_data['genre_id']['1'] = TRUE;

		if (!$song_data['update'])
		{
			$sql = 'INSERT INTO ' . SONGS_TABLE . ' (artist_id, genre_id, user_id, album_id, status_id, song_title, song_url, song_quality, song_size, song_length)
				VALUES ("'	. $song_data['artist_id']['0'] . '","'
							. $song_data['genre_id']['0'] . '","'
							. $userdata['user_id'] . '","'
							. $song_data['album_id']['0'] . '", "';
			if ((isset($song_status)) && ($userdata['foing_mod']) && (in_array($song_status, (array_flip($foing_status)))))
			{
				$sql .= $song_status . '","';
			}
			else
			{
				$sql .= $foing_config['pending_status'] . '","';
			}
			$sql .=	$song_data['title']['0'] . '","'
				. $song_data['url']['0'] . '","'
				. $song_data['quality']['0'] . '","'
				. $song_data['size']['0'] . '","'
				. $song_data['length']['0'] . '")';
			$re_msg = 'Mp3 Added Successfully.';
		}
		else
		{
			$sql = 'UPDATE ' . SONGS_TABLE . ' SET ' .
				' artist_id = "' . $song_data['artist_id']['0'] . '",' .
				' genre_id = "'  . $song_data['genre_id']['0'] . '",' .
				' user_id = "'	 . $song_data['user_id'] . '",' .
				' album_id = "'  . $song_data['album_id']['0'] . '",' .
				' song_title = "'. $song_data['title']['0'] . '",' .
				' song_url = "'  . $song_data['url']['0'] . '",' .
				' song_quality = "' . $song_data['quality']['0'] . '",' .
				' song_size = "'    . $song_data['size']['0'] . '",' .
				' song_length = "'  . $song_data['length']['0'] . '"';
			if ((isset($song_status)) && ($userdata['foing_mod']) && (in_array($song_status, (array_flip($foing_status)))))
			{
				$sql .= ', status_id = "' . $song_status . '"';
			}
			else
			{
				$sql .= ', status_id = "1"';
			}
			$sql .= ' WHERE song_id = "'. $song_data['song_id'] . '" LIMIT 1';
			$re_msg = 'mp3 Information Updated Successfully.';
		}
		$db->sql_query($sql);
		unset($song_data);
		$re_url = append_sid($PHP_SELF);
		foing_die($re_msg, $re_url);
		exit();
		break;
}

function song_form($mode, $next)
{
	global $PHP_SELF, $song_data, $foing_status, $userdata;

	?>
	
	<form name="add_song" method="post" action="<?php echo append_sid($PHP_SELF); ?>">
	<input type="hidden" name="foing_mode" value="<?php echo $next; ?>">
	<table width="100%" cellspacing="2" cellpadding="2" border="0">
  		<tr>
		    <td class="nav"><a href="../index.php" class="nav">Forum Index</a> -> <a href="index.php" class="nav">Foing Index</a></td>
		</tr>
	</table>	
	<table class="forumline" width="100%" cellspacing="1" cellpadding="3" border="0">
  		<tr>
		    <th class="thHead" colspan="2">Add/Edit mp3</th>
		</tr>
		<tr>
		<td class="row1">
		  <?php if ($mode != 'new') echo '<span class="invisible">'; ?>
		  Enter the URL of the mp3 file
		  <?php if ($mode != 'new') 
		    {
		      echo '</span>'; 
		    } else {
		      echo '<br><span class="gensmall">Only legal and non copyright-violating material allowed</span>';
		    } ?>
		</td>
		<td class="row2"> 
			<?php if ($mode == 'new') { ?>
			<input class="post" type="text" name="song_url" size="50">
	   	      <?php } else { echo $song_data['url']['0']; } ?>
		</td>
	  </tr>
	  <tr> 
		<td  class="row1">
		  <?php if ($mode != 'artist') echo '<span class="invisible">'; ?>
		  Enter the Artist information
		  <?php if ($mode != 'artist') echo '</span>'; ?>
		</td>
		<td class="row2"> 
			<?php if (($mode == 'artist') || ($mode =='info')) { ?>
			<table width="100%">
			  <tr>
				<td>
				<?php
				if ($mode == 'artist') 
				{
					echo '<table border="0"><tr><td><input type="radio" name="artist_type" value="existing" ';
					if ($song_data['artist']['2'])
					{
						echo 'checked';
					}
					echo '></td><td><span class="gensmall">select from database</span></td><td>';
					echo '<select name="song_artist_id" onFocus="document.add_song.artist_type[0].checked=true" style="width: 250 px">' . $song_data['artist_list'] . '</select></td>';
					echo '</tr><tr><td><input type="radio" name="artist_type" value="new" ';
					if (!$song_data['artist']['2'])
					{
						echo 'checked';
					}
					echo '></td><td><span class="gensmall">enter new artist name</span></td><td>';
					echo '<input class="post" type="text" onFocus="document.add_song.artist_type[1].checked=true" name="song_artist" style="width: 250 px" value="';
				} 
				echo $song_data['artist']['0'];
				if ($mode == 'artist') 
				{ 
					echo '"></td></tr><tr><td>&nbsp;</td><td><span class="gensmall">artist prefix <i>(optional)</i></span></td><td>';
					echo '<input class="post" type="text" onFocus="document.add_song.artist_type[1].checked=true" name="song_artist_prefix" style="width: 50 px" value="' . $song_data['artist_prefix']['0'] . '">';
					echo '</td></tr></table>';
				}
				unset($song_data['artist_list']); 
				?>
				</td>
			  </tr>
			</table>
			<?php } ?>
		</td>
	  </tr>
	  <tr> 
		<td class="row1" nowrap="nowrap">
		  <?php if ($mode != 'info') echo '<span class="invisible">'; ?>
		  Enter other Song information
		  <?php if ($mode != 'info') echo '</span>'; ?>
		</td>
		<td class="row2"> 
			<?php if ($mode == 'info') { ?>
			<table width="100%">
			  <tr> 
				<td>Song title: *</td>
				<td> 
				  <input class="post" type="text" name="song_title" size="50" value="<?php echo $song_data['title']['0']; ?>">	
				</td>
			  </tr>	
			  <tr> 
				<td>Genre: *</td>
				<td> 
				  <span class="gensmall"><select name="song_genre_id">
				  <?php 
				  echo $song_data['genre_list'];
				  unset($song_data['genre_list']);
				  ?>
				  </select></span>
				</td>	
			  </tr>
			  <tr> 
				<td nowrap="nowrap">Artist website:</td>
				<td> 
				  <?php 
				  if (!$song_data['website']['1']) //we do yet not have a website in our database,
				  {
				  	echo '<input class="post" type="text" name="song_website" size="50" value="' . $song_data['website']['0'] . '">';
				  }
				  else // we do have a website in the db, so don't bother to ask the user for input
				  {
				  	echo $song_data['website']['0'];
				  }
				  ?>
				</td>
			  </tr>
			  <tr> 
				<td>Album title:</td>
				<td> 
				  <?php 
				  if (!$song_data['album_id']['1']) //we do not yet have the album in our database,
				  {
					if ($song_data['album']['2'])
					{
				  		echo '<table><tr><td><input type="radio" name="album_type" value="existing"';
						if ($song_data['album_id']['0'] != '0' && $song_data['album_id']['0'] != null) 
						{
						  $album_checked = TRUE;
						  echo ' checked ';
				  		}
						else
						{
						  $album_checked = FALSE;
						}
						echo '></td><td><span class="gensmall">select from database:</span></td>';
				  		echo '<td><select name="song_album_id" onFocus="document.add_song.album_type[0].checked=true">' . $song_data['album_list'] . '</select></td></tr>';
						echo '<tr><td><input type="radio" name="album_type" value="new"';
						if (!$album_checked) echo ' checked ';
						echo '></td><td><span class="gensmall">enter new album, or leave blank:</span></td>';
						echo '<td>';
				  		unset($song_data['album_list']);
						echo '<input type="text" onFocus="document.add_song.album_type[1].checked=true" name="song_album" size="50" value="' . $song_data['album']['0'] . '">';
					}
					else
					{
					  echo '<input class="post" type="text" name="song_album" size="50" value="' . $song_data['album']['0'] . '">';
					}
					if ($song_data['album']['2'])
					{
						echo '</td></tr></table>';
					}
				  }
				  else // we already have the album in the db, so don't bother to ask the user for input
				  {
				  	echo $song_data['album']['0'];
				  }
				  ?>
				</td>
			  </tr>
			  <tr> 
				<td>Year:</td>
				<td> 
				  <?php 
				  if (!$song_data['year']['1']) 
				  {
				  	echo '<input class="post" type="text" name="song_year" size="4 " maxlength="4" value="' . $song_data['year']['0'] . '">';
				  }
				  else
				  {
				  	echo $song_data['year']['0'];
				  }
				  ?>
				</td>
			  </tr>
			  <tr> 
				<td>Length:</td>
				<td class="genmed"><?php echo $song_data['length_min']['0'].' min '.$song_data['length_sec']['0'].' sec'; ?></td>
			  </tr>
			  <tr> 
				<td>Quality:</td>
				<td class="genmed"><?php echo $song_data['quality']['0'].' kbps'; ?></td>
			  </tr>
			  <tr> 
				<td>File size:</td>
				<td class="genmed"><?php echo $song_data['size']['0'].' MB'; ?></td>
			  </tr>
			  <tr> 
				<td>Status:</td>
				<td class="genmed">
					<?php
					if ($userdata['foing_mod'])
					{	
						for ($i = 1; $i < count($foing_status) +1; $i++)
						{
							echo '<input type="radio" name="song_status" VALUE="' . $i . '"';
							if ($song_data['status_id'] == $i)
							{
								echo ' checked ';
							}
							echo '>' . $foing_status[$i] . '&nbsp; ';
						}
					}
					else
					{
						echo 'only moderators can change the song status';
					}
					?>
				</td>
			  </tr>
			</table>
			<?php } ?>
		</td>
	  </tr>
	  <tr> 
		<td class="catBottom" colspan="2" align="center"><input type="submit" class="mainoption" name="Submit" value="Submit"></td>
	  </tr>
	</table>
	</form>

	<?php
}
?>
