<?php
/////////////////////////////////////////////////////////////////
/// foing by the foing group                                   //
//        available at http://foing.sourceforge.net           ///
/////////////////////////////////////////////////////////////////
//                                                             //
// page_header  - part of foing                                //
//                                                             //
/////////////////////////////////////////////////////////////////

define('HEADER_INC', true);

$template->set_filenames(array(
	'overall_header' 	=> 'overall_header.tpl')
);

//
// gzip_compression
//
$do_gzip_compress = FALSE;
if ( $board_config['gzip_compress'] )
{
	$phpver = phpversion();

	$useragent = (isset($_SERVER["HTTP_USER_AGENT"]) ) ? $_SERVER["HTTP_USER_AGENT"] : $HTTP_USER_AGENT;

	if ( $phpver >= '4.0.4pl1' && ( strstr($useragent,'compatible') || strstr($useragent,'Gecko') ) )
	{
		if ( extension_loaded('zlib') )
		{
			ob_start('ob_gzhandler');
		}
	}
	else if ( $phpver > '4.0' )
	{
		if ( strstr($HTTP_SERVER_VARS['HTTP_ACCEPT_ENCODING'], 'gzip') )
		{
			if ( extension_loaded('zlib') )
			{
				$do_gzip_compress = TRUE;
				ob_start();
				ob_implicit_flush(0);

				header('Content-Encoding: gzip');
			}
		}
	}
}

if ( $userdata['session_logged_in'] )
{
	$u_login_logout = append_sid($phpbb_root_path.'login.'.$phpEx.'?logout=true&sid='.$userdata['session_id'].'&redirect='.$foing_rel_path.'index.php');
	$l_login_logout = $lang['Logout'] . ' [ ' . $userdata['username'] . ' ]';
	$u_register = append_sid($phpbb_root_path.'usercp.php');
	$l_register = $lang['User_CP'];	
}
else
{
	$u_login_logout = append_sid($phpbb_root_path.'login.'.$phpEx.'?redirect='.$foing_rel_path.'index.php');
	$l_login_logout = $lang['Login'];
	$u_register = append_sid($phpbb_root_path.'profile.php?mode=register');
	$l_register = $lang['Register'];
}


//
// build the filter lists
//

$sql = 'SELECT DISTINCT ' . ARTISTS_TABLE .'.artist_id, artist_name, artist_prefix FROM ' . ARTISTS_TABLE . ', ' . SONGS_TABLE .'
        WHERE (' . ARTISTS_TABLE . '.artist_id = ' . SONGS_TABLE . '.artist_id )
        ORDER BY artist_name ASC';
$result = $db->sql_query($sql);
while ($sql_data = $db->sql_fetchrow($result))
{
	if ($sql_data['artist_id'] == $ff['artist'])
	{
		$selected = 'SELECTED';
	}
	else
	{
		$selected = '';
	}
	$template->assign_block_vars('ff_artist', Array(
		'ID' 		=> $sql_data['artist_id'],
		'NAME' 		=> artist_add_prefix($sql_data['artist_name'], $sql_data['artist_prefix']),
		'SELECTED' 	=> $selected
		)
	);
} 

$sql = 'SELECT DISTINCT ' . GENRES_TABLE .'.genre_id, genre_name FROM ' . GENRES_TABLE . ', ' . SONGS_TABLE .'
        WHERE (' . GENRES_TABLE . '.genre_id = ' . SONGS_TABLE . '.genre_id )
        ORDER BY genre_name ASC';
$result = $db->sql_query($sql);
while ($sql_data = $db->sql_fetchrow($result))
{
	if ($ff['genre'] == $sql_data['genre_id'])
	{
		$selected = 'SELECTED';
	}
	else
	{
		$selected = '';
	}
	$template->assign_block_vars('ff_genre', Array(
		'ID' 		=> $sql_data['genre_id'],
		'NAME' 		=> $sql_data['genre_name'],
		'SELECTED' 	=> $selected
		)
	);
} 

@reset($foing_status);
while(list($key, $val) = @each($foing_status))
{
	if ($ff['status'] == $key)
	{
		$selected = 'SELECTED';
	}
	else
	{
		$selected = '';
	}
	$template->assign_block_vars('ff_status', Array(
		'ID' 		=> $key,
		'NAME' 		=> $val,
		'SELECTED' 	=> $selected
		)
	);
}

$sql = 'SELECT DISTINCT list_id, list_title FROM ' . PLAYLIST_TABLE . '
        ORDER BY list_title ASC';
$result = $db->sql_query($sql);
while ($sql_data = $db->sql_fetchrow($result))
{
	if ($fpl['id'] == $sql_data['list_id'])
	{
		$selected = 'SELECTED';
	}
	else
	{
		$selected = '';
	}
	$template->assign_block_vars('ff_pl', Array(
		'ID' 		=> $sql_data['list_id'],
		'NAME' 		=> $sql_data['list_title'],
		'SELECTED' 	=> $selected
		)
	);
} 

//
// Obtain number of new private messages
// if user is logged in
//
if ( $userdata['session_logged_in'] )
{
	if ( $userdata['user_new_privmsg'] )
	{
		$l_message_new = ( $userdata['user_new_privmsg'] == 1 ) ? $lang['New_pm'] : $lang['New_pms'];
		$l_privmsgs_text = sprintf($l_message_new, $userdata['user_new_privmsg']);

		if ( $userdata['user_last_privmsg'] > $userdata['user_lastvisit'] )
		{
			$sql = "UPDATE " . USERS_TABLE . "
				SET user_last_privmsg = " . $userdata['user_lastvisit'] . "
				WHERE user_id = " . $userdata['user_id'];
			if ( !$db->sql_query($sql) )
			{
				message_die(GENERAL_ERROR, 'Could not update private message new/read time for user', '', __LINE__, __FILE__, $sql);
			}

			$s_privmsg_new = 1;
		}
		else
		{
			$s_privmsg_new = 0;
		}
	}
	else
	{
		$l_privmsgs_text = $lang['No_new_pm'];

		$s_privmsg_new = 0;
	}

	if ( $userdata['user_unread_privmsg'] )
	{
		$l_message_unread = ( $userdata['user_unread_privmsg'] == 1 ) ? $lang['Unread_pm'] : $lang['Unread_pms'];
		$l_privmsgs_text_unread = sprintf($l_message_unread, $userdata['user_unread_privmsg']);
	}
	else
	{
		$l_privmsgs_text_unread = $lang['No_unread_pm'];
	}
	if ( !empty($userdata['user_popup_pm']) )
	{
		$template->assign_block_vars('switch_enable_pm_popup', array());
	}
}
else
{
	$l_privmsgs_text = $lang['Login_check_pm'];
	$l_privmsgs_text_unread = '';
	$s_privmsg_new = 0;
}


$template->assign_vars(array(
	'IMAGE_DIR'	=> $image_dir,
	'OLD_TEMPLATE_DIR' => $old_template_dir,
	'TEMPLATE_DIR' => $template->root,
	'FOING_ROOT_PATH' => $foing_root_path,
	'PHPBB_ROOT_PATH'	=> $phpbb_root_path,
	'PAGE_TITLE' => $page_title,
	'SITENAME' => $board_config['sitename'],
	'SITE_DESCRIPTION' => $board_config['site_desc'],
	'PRIVATE_MESSAGE_INFO' => $l_privmsgs_text,
	'PRIVATE_MESSAGE_NEW_FLAG' => $s_privmsg_new,
	'U_FORUM_INDEX' => append_sid($phpbb_root_path.'index.php'),
	'U_FOING_INDEX' => append_sid('index.php'),
	'U_FAQ' => append_sid('faq.php'),
	'U_GENM3U' => append_sid('gen_m3u.php'),
	'U_GENPLS' => append_sid('gen_pls.php'),
	'U_LIST' => append_sid('list.php'),
	'U_PLAYLISTS' => append_sid('playlist.php'),
	'U_ADDSONG'	=> append_sid('song.php'),
	'U_REGISTER' => $u_register,
	'L_REGISTER' => $l_register,
	'U_LOGIN_LOGOUT' => $u_login_logout,
	'L_LOGIN_LOGOUT' => $l_login_logout,
	'U_PRIVATEMSGS' => append_sid($phpbb_root_path.'privmsg.'.$phpEx.'?folder=inbox'),
	'U_PRIVATEMSGS_POPUP' => append_sid($phpbb_root_path.'privmsg.'.$phpEx.'?mode=newpm'),
	'U_MEMBERLIST' => append_sid($phpbb_root_path.'memberlist.'.$phpEx),
	'U_GROUP_CP' => append_sid($phpbb_root_path.'groupcp.'.$phpEx),
	'U_SELF_BLA' => append_sid($PHP_SELF . '?flba='),
	'U_LIST_BLA' => append_sid('list.php?flba='),
	'T_HEAD_STYLESHEET' => $theme['head_stylesheet'])
);

$template->pparse('overall_header');

?>
