<?php
/////////////////////////////////////////////////////////////////
/// foing by the foing group                                   //
//        available at http://foing.sourceforge.net           ///
/////////////////////////////////////////////////////////////////
//                                                             //
// list.php         -  part of foing                           //
//                                                             //
/////////////////////////////////////////////////////////////////


// here we're getting the information about the total songs in the list
// we're also creating the page-jump-thingy
$sql = 'SELECT COUNT(' . SONGS_TABLE . '.song_id) AS num FROM ' . SONGS_TABLE;
if (isset($active_pl))
{
	$sql .= ' , ' . PLAYLIST_DATA_TABLE . ' WHERE (' . SONGS_TABLE . '.song_id = ' . PLAYLIST_DATA_TABLE . '.song_id ) 
		AND (' . PLAYLIST_DATA_TABLE . '.list_id = "' . $active_pl . '" )';
}
else
{
	$sql = append_ff_sql($sql);
}
$result = $db->sql_query($sql);
$list_data['top'] = $db->sql_fetchfield('num', '0', $result); // the total songs in the list
$list_data['num'] = ceil($list_data['top'] / $foing_config['max_songs']); // number of pages
$list_data['off'] = $lo; // the GET - offset variable
$list_data['cur'] = floor($list_data['off'] / $foing_config['max_songs']) + 1; // current page

$list_pages_topl = $list_data['top'] . ' songs in result set. ';
if ($list_data['top'] > 0)
{
	$list_pages_topl .= ' showing songs ' . ($list_data['off'] + 1) . ' through ' . min($list_data['top'],($list_data['off'] + $foing_config['max_songs'])) .'.';
	$list_pages_topr = ' page ' . $list_data['cur'] . ' of ' . $list_data['num'];
	if ($list_data['cur'] != 1)
	{
		$u_list_prev = append_sid($PHP_SELF.'?lo='.($foing_config['max_songs'] * ($list_data['cur'] - 2)));
		$l_list_prev = 'previous';
	}
	if ($list_data['cur'] != $list_data['num'])
	{
		$u_list_next = append_sid($PHP_SELF.'?lo='.($foing_config['max_songs'] * $list_data['cur']));
		$l_list_next = 'next';
	}
}
if ($list_data['num'] > 1)
{
	$list_pages_bottom = 'Go to page ';
	for ($i = 0; $i < $list_data['num']; $i++)
	{
		if ($list_data['cur'] == ($i + 1)) //this page?
		{
			$list_pages_bottom .= ($i + 1);
		}
		else
		{
			$list_pages_bottom .= '<a class="nav" href="'.append_sid($PHP_SELF.'?lo='.($foing_config['max_songs'] * $i)).'">'.($i + 1).'</a>';
		}
		if ($i != ($list_data['num'] -1))
		{
			$list_pages_bottom .= ', ';
		}
	}
}	

$template->assign_vars(Array(
	'U_LIST_PREV' => $u_list_prev,
	'L_LIST_PREV' => $l_list_prev,
	'U_LIST_NEXT' => $u_list_next,
	'L_LIST_NEXT' => $l_list_next,
	'LIST_TOP_LEFT' 	=> $list_pages_topl,
	'LIST_TOP_RIGHT'	=> $list_pages_topr,
	'LIST_BOTTOM' 		=> $list_pages_bottom,
	'U_CHANGE_STATUS' 	=> append_sid('manage_songs.php'),
	'BUTTON_CHANGE_STATUS' => $button_change_status,
	'U_SELF_BLA'	=> append_sid($PHP_SELF . '?bla='),
	'U_GENM3U'		=> append_sid('gen_m3u.php'),
	'U_GENPLS'		=> append_sid('gen_pls.php')
	)
);

if ($ff['flip_order'] == 1)
{
	$list_arrow = '&uarr; ';
}
else
{
	$list_arrow = '&darr; ';
}

switch ($ff['order']['0'])
{
	case 'artist_name':
		$template->assign_vars(Array('ARROW_ARTIST' => $list_arrow));
		break;		
	case 'album_title':
		$template->assign_vars(Array('ARROW_ALBUM' => $list_arrow));
		break;		
	case 'song_title':
		$template->assign_vars(Array('ARROW_TITLE' => $list_arrow));
		break;		
	case 'genre_name':
		$template->assign_vars(Array('ARROW_GENRE' => $list_arrow));
		break;		
	case 'song_length':
		$template->assign_vars(Array('ARROW_LENGTH' => $list_arrow));
		break;		
	case 'song_quality':
		$template->assign_vars(Array('ARROW_QUALITY' => $list_arrow));
		break;		
	case 'song_size':
		$template->assign_vars(Array('ARROW_SIZE' => $list_arrow));
		break;		
	case 'status_id':
		$template->assign_vars(Array('ARROW_STATUS' => $list_arrow));
		break;		
	case 'user_id':
		$template->assign_vars(Array('ARROW_USER' => $list_arrow));
		break;
}

//
// built the actual list
//

$sql = 'SELECT ' . USERS_TABLE . '.user_id, username, ' . SONGS_TABLE . '.song_id, song_title, song_url, ' . SONGS_TABLE . '.artist_id, ' . SONGS_TABLE . '.album_id, album_title, album_year, artist_name, artist_prefix, artist_url, ' . SONGS_TABLE .'.genre_id, genre_name, song_length, song_quality, song_size, status_id FROM 
		' . SONGS_TABLE . ', ' . ARTISTS_TABLE . ', ' . ALBUMS_TABLE . ', ' . GENRES_TABLE . ', ' . USERS_TABLE;

if (isset($active_pl))
{
	$sql .= ', ' . PLAYLIST_DATA_TABLE;
}
$sql .= ' WHERE (' . SONGS_TABLE . '.artist_id = ' . ARTISTS_TABLE . '.artist_id ) AND
		(' . SONGS_TABLE . '.album_id = ' . ALBUMS_TABLE . '.album_id ) AND
		(' . SONGS_TABLE . '.genre_id = ' . GENRES_TABLE . '.genre_id ) AND
		(' . SONGS_TABLE . '.user_id  = ' . USERS_TABLE  . '.user_id ) ';
if (isset($active_pl))
{
	$sql .= ' AND (' . SONGS_TABLE . '.song_id = ' . PLAYLIST_DATA_TABLE . '.song_id ) 
		AND (' . PLAYLIST_DATA_TABLE . '.list_id = "' . $active_pl . '" )';
	$sql = append_order_sql($sql);
}
else
{
	$sql = append_ff_sql($sql, TRUE);
}
$sql .= ' LIMIT ';
if ($list_data['off'] > $foing_config['max_songs'] -1)
{
	$sql .= $list_data['off'] . ', ';
}
$sql .= $foing_config['max_songs'];
$result = $db->sql_query($sql);
while ($sql_data = $db->sql_fetchrow($result))
{
	$pos = strrpos ($sql_data['song_size'], '.');
	if ($pos === false)
	{
		$sql_data['song_size'] .= '.0';
	}
	
	if ($prev_artist != $sql_data['artist_id'])
	{
		if ($ff['artist'] == $sql_data['artist_id'])
		{
			$u_ffartist = append_sid($PHP_SELF.'?ffartist=0');
			$img_ffartist = 'filter_rem.gif';
		}
		else
		{
			$u_ffartist = append_sid($PHP_SELF.'?ffartist=' . $sql_data['artist_id']);
			$img_ffartist = 'filter.gif';
		}

		if ($userdata['foing_mod']) 
		{
			$u_admin_artist = append_sid('admin/edit_artist.php?artist='.$sql_data['artist_id'].'&action=edit');
			$img_admin_artist = 'edit.gif';
		}
		else
		{
			$img_admin_artist = 'spacer.gif';
		}
		
		$u_web_artist = $sql_data['artist_url'];
		$sql_data['artist_name'] = artist_add_prefix($sql_data['artist_name'], $sql_data['artist_prefix']);
		$t_web_artist = '';
		$t_artist_name = '<a href="view_artist.php?id=' . $sql_data['artist_id'] . '">' . cut_string($sql_data['artist_name'], 32) . '</a>';
	}
	else
	{	
		$u_ffartist = '';
		$img_ffartist = 'spacer.gif';
		$u_admin_artist = '';
		$img_admin_artist = 'spacer.gif';
		$u_web_artist = '';
		$t_web_artist = '';
		$t_artist_name = '';
	}
	if ($prev_album != $sql_data['album_id'] || $prev_artist != $sql_data['artist_id'])
	{
		if ($userdata['foing_mod'] && $sql_data['album_id'] != '0') 
		{
			$u_admin_album = append_sid('admin/edit_album.php?action=edit&album=' . $sql_data['album_id']);
			$img_admin_album = 'edit.gif';
		}
		else
		{
			$u_admin_album = '';
			$img_admin_album = 'spacer.gif';
		}
		$t_album_title =  cut_string($sql_data['album_title'], 18);
		if ($sql_data['album_year'] > 0)
		{
			$t_album_year =  " (".$sql_data['album_year'].")";
		}
		else
		{
			$t_album_year = '';
		}
	}
	else
	{
		$u_admin_album = '';
		$img_admin_album = 'spacer.gif';
		$t_album_title = '';
		$t_album_year = '';
	}
	$u_genm3u = append_sid('gen_m3u.php?songs[]='.$sql_data['song_id']);
	$u_genpls = append_sid('gen_pls.php?songs[]='.$sql_data['song_id']);
	if (isset($active_pl))
	{
		if ($fpl['owner'])
		{
			$u_addto_pl = append_sid('playlist.php?songmin='.$sql_data['song_id']);
			$img_addto_pl = 'playlistmin.gif';
		}
		else
		{
			$u_addto_pl = '';
			$img_addto_pl = 'spacer.gif';
		}
	}
	else
	{
		if ($fpl['owner'])
		{
			$u_addto_pl = append_sid('playlist.php?songadd='.$sql_data['song_id']);
			$img_addto_pl = 'playlistadd.gif';
		}
		else
		{
			$u_addto_pl = '';
			$img_addto_pl = 'spacer.gif';
		}
	}
	$t_song_title = '<a href="'. append_sid('view_song.php?id=' . $sql_data['song_id']) . '">'
		. cut_string($sql_data['song_title'], 24)
		. '</a>';

	if ($ff['genre'] == $sql_data['genre_id'])
	{
		$u_ffgenre = append_sid($PHP_SELF.'?ffgenre=-1');
		$img_ffgenre = 'filter_rem.gif';
	}
	else
	{
		$u_ffgenre = append_sid($PHP_SELF.'?ffgenre='.$sql_data['genre_id']);
		$img_ffgenre = 'filter.gif';
	}
	
	if ($ff['status'] == $sql_data['status_id'])
	{
		$u_ffstatus = append_sid($PHP_SELF.'?ffstatus=0');
		$img_ffstatus = 'filter_rem.gif';
	}
	else
	{
		$u_ffstatus = append_sid($PHP_SELF.'?ffstatus='.$sql_data['status_id']);
		$img_ffstatus = 'filter.gif';
	}
	$t_ffstatus = $foing_status[$sql_data['status_id']];

	if (($userdata['user_id'] == $sql_data['user_id'] && $sql_data['user_id'] != -1) || $userdata['foing_mod'])
	{
		$u_edit_song = append_sid('song.php?foing_mode=edit&songid='.$sql_data['song_id']);
		$img_edit_song = 'edit.gif';
	}
	else
	{
		$u_edit_song = '';
		$img_edit_song = 'spacer.gif';
	}
	$song_box = '<input type="checkbox" name="song_box[]" value="' . $sql_data['song_id'] . '" id="checkbox_' . $sql_data['song_id'] . '" />';

	$template->assign_block_vars('list',Array(
		'U_FFARTIST' => $u_ffartist,
		'IMG_FFARTIST' => $image_dir . $img_ffartist,
		'U_ADMIN_ARTIST' => $u_admin_artist,
		'IMG_ADMIN_ARTIST' => $image_dir . $img_admin_artist,
		'U_WEB_ARTIST' => $u_web_artist,
		'T_WEB_ARTIST' => $t_web_artist,
		'T_ARTIST_NAME' => $t_artist_name,
		'U_ADMIN_ALBUM' => $u_admin_album,
		'IMG_ADMIN_ALBUM' => $image_dir . $img_admin_album,
		'T_ALBUM_TITLE' => $t_album_title,
		'T_ALBUM_YEAR' => $t_album_year,
		'U_GENM3U' => $u_genm3u,
		'U_GENPLS' => $u_genpls,
		'U_DOWNLOAD' => $sql_data['song_url'],
		'U_ADDTO_PL' => $u_addto_pl,
		'IMG_ADDTO_PL' => $image_dir . $img_addto_pl,
		'SONG_ID' => $sql_data['song_id'],
		'T_SONG_TITLE' => $t_song_title,
		'U_FFGENRE' => $u_ffgenre,
		'IMG_FFGENRE' => $image_dir . $img_ffgenre,
		'T_FFGENRE' => $sql_data['genre_name'],
		'SONG_LENGTH' => format_length($sql_data['song_length']),
		'SONG_QUALITY' => $sql_data['song_quality'],
		'SONG_SIZE' => $sql_data['song_size'],
		'U_FFSTATUS' => $u_ffstatus,
		'IMG_FFSTATUS' => $image_dir . $img_ffstatus,
		'T_FFSTATUS' => $t_ffstatus,
		'U_EDIT_SONG' => $u_edit_song,
		'IMG_EDIT_SONG' => $image_dir . $img_edit_song,
		'RADIO_CHANGE_STATUS' => $radio_change_status,
		'SONG_BOX' => $song_box,
		'ADDED_BY' => cut_string($sql_data['username'], 10)
		)
	);
		
	$prev_artist = $sql_data['artist_id'];
	$prev_album  = $sql_data['album_id'];
}
if ($fpl['owner'] && !isset($active_pl))
{
	$template->assign_block_vars('song_jumpbox', Array(
		'ID' 		=> 'playlist_add',
		'NAME' 		=> 'Add to playlist'
		)
	);
}
if ($fpl['owner'] && isset($active_pl))
{
	$template->assign_block_vars('song_jumpbox', Array(
		'ID' 		=> 'playlist_rem',
		'NAME' 		=> 'Remove from playlist'
		)
	);
}
if ($userdata['foing_mod'])
{
	$template->assign_block_vars('song_jumpbox', Array(
		'ID' 		=> '0',
		'NAME' 		=> '-- change status --'
		)
	);

	reset($foing_status);

	while(list($key, $val) = each($foing_status))
	{
		$template->assign_block_vars('song_jumpbox', Array(
			'ID' 		=> $key,
			'NAME' 		=> $val
			)
		);
	}
	$template->assign_block_vars('song_jumpbox', Array(
		'ID' 		=> 'delete',
		'NAME' 		=> 'delete'
		)
	);
}

?>
