<?php
/////////////////////////////////////////////////////////////////
/// foing by the foing group                                   //
//        available at http://foing.sourceforge.net           ///
/////////////////////////////////////////////////////////////////
//                                                             //
// functions.php    -  part of foing                           //
//                                                             //
/////////////////////////////////////////////////////////////////

function artist_add_prefix($artist, $prefix)
{
	if ($prefix != '')
	{
		$artist = $prefix . ' ' . $artist;
	}
	return $artist;
}

function prepare_text($text)
{
	$text = str_replace("\n", "\n<br />\n", $text);
	return $text;
}

function rem_song_from_pl($song_id)
{
	global $fpl, $db;

	if ($fpl['owner'])
	{
		$sql = 'DELETE FROM ' . PLAYLIST_DATA_TABLE .  ' WHERE ( song_id = "' . $song_id . '" ) AND ( list_id = "'. $fpl['id'] .'") LIMIT 1';
		if ( $db->sql_query($sql) )
		{
			return true;
		}
		else
		{
			return false;
		}
	}
	else
	{
		return false;
	}
}

function add_song_to_pl($song_id)
{
	global $fpl, $db;

	// check if the user has right to do it
	if (!$fpl['owner'])
	{
		return false;
	} // end check

	// check if we have a good song_id
	$sql = 'SELECT song_id FROM ' . SONGS_TABLE . ' WHERE ( song_id = "' . $song_id . '" ) LIMIT 1';
	$result = $db->sql_query($sql);
	if ($db->sql_numrows($result) != 1)
	{
		return false;
	} // end check

	// check if the song is already in the playlist
	$sql = 'SELECT song_id FROM ' . PLAYLIST_DATA_TABLE .
		' WHERE ( song_id = "' . $song_id . '" ) AND ( list_id ="' . $fpl['id'] . '" ) LIMIT 1';
	$result = $db->sql_query($sql);
	if ($db->sql_numrows($result) == 1)
	{
		return false;
	} // end check
	
	// add the song to the user's playlist
	$sql = 'INSERT INTO ' . PLAYLIST_DATA_TABLE . ' (list_id, song_id) VALUES ("'.$fpl['id'].'","'.$song_id.'")';
	if ($db->sql_query($sql))
	{
		return true;
	}
	else
	{
		return false;
	}
}

//
// foing's replacement for message_die()
//
function foing_die($message = '', $re_url = '')
{
	global $db, $template, $foing_config, $board_config, $theme, $old_template_dir, $image_dir, $foing_root_path, $phpbb_root_path, $foing_rel_path, $phpEx, $foing_status, $userdata, $lang, $HTTP_REFERER, $ff, $fpl;
	
	if ($re_url == '')
	{
		if ($HTTP_REFERER != '')
		{ 
			$re_url = $HTTP_REFERER;
		}
		else
		{
			$re_url = 'index.php';
		}
	}
	if (!defined('HEADER_INC'))
	{
		if ( !defined('IN_ADMIN') )
		{
			include($foing_root_path . 'includes/page_header.php');
		}
		else
		{
			include($foing_root_path . 'admin/page_header_admin.php');
		}
	}
	$template->assign_vars(Array(
		'MESSAGE'	=> $message,
		'RE_URL'	=> $re_url,
		'U_LIST'	=> append_sid($foing_root_path . 'list.php')
		)
	);
	$template->set_filenames(Array('body' => 'message_body.tpl'));
	$template->pparse('body');
	if ( !defined('IN_ADMIN') )
	{
		include($foing_root_path . 'includes/page_tail.php');
	}
	else
	{
		include($foing_root_path . 'admin/page_footer_admin.php');
	}
	exit();
}

// same as below, except this function dies if the users
// doesn't have permission and returns TRUE otherwise.
function check_perm ($what = 'admin')
{
	if (!check_perm_dd($what))
	{
		foing_die("You haven't got sufficient rights to do this.");
	}
	else
	{
		return true;
	}
}

// this function checks if the current user has permission to do:
//	* add mp3's  ('add')
//	* perform moderating tasks ('mod')
//	* administrative tasks ('admin')
// returns TRUE if this is the case, else FALSE
// (the _dd is for 'dont die')
function check_perm_dd ($what = 'admin')
{
	global $foing_config, $userdata, $template, $db, $foing_root_path, $phpbb_root_path;
	
	switch ($what)
	{
		case 'admin':

			if ($userdata['user_level'] != ADMIN) 
			{
				return false;
			}
			else
			{
				return true;
			}
			break;

		case 'mod':
			
			if ($userdata['user_level'] == ADMIN)
			{
				return true;
			}
			else
			{
				$sql = 'SELECT user_id
					FROM ' . USER_GROUP_TABLE . '
					WHERE (group_id = "' . $foing_config['mod_group'] .'")
					AND (user_pending = "0") 
					AND (user_id = "' . $userdata['user_id'] . '")
					LIMIT 1';
				$result = $db->sql_query($sql);
				if ($db->sql_numrows($result) != 1)
				{
					return false;
				}
				else
				{
					return true;
				}
			}
			break;

		case 'add':
			
			switch ($foing_config['add_level'])
			{
				case ANONYMOUS: // anonymous level ... always true
					return true;
					break;
				case USER:
					if ($userdata['user_id'] == ANONYMOUS)
					{
						return false;
					}
					else
					{
						return true;
					}
					break;
				case MOD:
					return check_perm('mod');
					break;
				case ADMIN:
					if ($userdata['user_level'] != ADMIN)
					{
						return false;
					}
					else
					{
						return true;
					}
					break;
			}
			break;

	} // switch ($what)
	$foing_die('Sorry, something went wrong.');
	exit();
}

function append_where_sql ($sql)
{
	$pos = strrpos ($sql, 'WHERE');
	if ($pos === false)
	{
		$sql .= ' WHERE ';
	}
	else
	{
		$sql .= ' AND ';
	}
	return($sql);
}

function append_or_sql ($sql)
{
	$pos = strrpos ($sql, 'WHERE');
	if ($pos === false)
	{
		$sql .= ' WHERE ';
	}
	else
	{
		$sql .= ' OR ';
	}
	return($sql);
}

function append_ff_sql ($sql, $order = FALSE)
{
	global $ff;
	
	if ($ff['artist'] > 0)
	{
		$sql = append_where_sql($sql);
		$sql .= ' ( ' . SONGS_TABLE . '.artist_id = "'. $ff['artist'] . '") ';
	}
	if ($ff['status'] > 0)
	{
		$sql = append_where_sql($sql);
		$sql .= ' ( ' . SONGS_TABLE . '.status_id = "'. $ff['status'] . '") ';
	}
	if ($ff['genre'] > -1)
	{
		$sql = append_where_sql($sql);
		$sql .= ' ( '. SONGS_TABLE . '.genre_id = "'. $ff['genre'] . '") ';
	}
	$sql = append_status_sql($sql);
	if ($order)
	{
		$sql = append_order_sql($sql);
	}
	return($sql);
}

function append_status_sql ($sql)
{
	global $foing_status_pub, $userdata;
	if (!$userdata['foing_mod'])
	{
		reset($foing_status_pub);
		while (list($key, $val) = each($foing_status_pub))
		{
			if (!$val)
			{
				$sql = append_where_sql($sql);
				$sql .= ' ( ' . SONGS_TABLE . '.status_id != "' . $key . '") ';
			}
		}
	}
	return($sql);
}

function append_order_sql ($sql)
{
	global $ff;

	$sql .= ' ORDER BY ';
	reset($ff['order']);
	$addcomma = FALSE;
	while($order = each($ff['order']))
	{
		if ($addcomma)
		{
			$sql .= ', ';
		}
		$sql .= $order['1'];
		if (!$addcomma)
		{
			if ($ff['flip_order'] == 1)
			{
				$sql .= ' ASC ';
			}
			else
			{
				$sql .= ' DESC ';
			}
		}
		$addcomma = TRUE;
	}
	return($sql);
}

function cut_string($string, $length)
{
	if (strlen($string) > $length)
	{
		$string = substr($string, 0, $length - 2) . '...';
	}
	return($string);
}

function format_length($length)
{
	$length_hour = floor($length / 3600);
	$length_min = floor(($length - ($length_hour * 3600)) / 60);
	$length_sec = $length - (($length_min * 60) + ($length_hour * 3600)) ;
	if ($length_hour > 0)
	{
		$f_length = $length_hour . ':';
	}
	if ($length_min < 10 && $length_hour > 0)
	{
		$f_length .= '0';
	}
	$f_length .= $length_min . ':';
	if ($length_sec < 10)
	{
		$f_length .= '0';
	}
	$f_length .= $length_sec;
	
	return($f_length);

}

?>