<?php
/***************************************************************************
 *                                pafiledb_common.php
 *                            -------------------
 *   begin                : Saturday, Feb 23, 2001
 *   copyright            : (C) 2003 Mohd Web Site!
 *   email                : mohdalbasri@hotmail.com
 *
 *   $Id: 
 *
 *
 ***************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 ***************************************************************************/

if ( !defined('IN_PHPBB') )
{
	die("Hacking attempt");
}

//===================================================
// to make it work with php version under 4.1 and other stuff
//===================================================

if ( @phpversion()  < '4.1' )
{
	$_GET = &$HTTP_GET_VARS;
	$_POST = &$HTTP_POST_VARS;
	$_COOKIE = &$HTTP_COOKIE_VARS;
	$_SERVER = &$HTTP_SERVER_VARS;
	$_ENV = &$HTTP_ENV_VARS;
	$_FILES = &$HTTP_POST_FILES;
}

if (!isset($_REQUEST))
{
	$_REQUEST = array_merge($_GET, $_POST, $_COOKIE);
}

if (!get_magic_quotes_gpc())
{
	$_GET = slash_input_data($_GET);
	$_POST = slash_input_data($_POST);
	$_COOKIE = slash_input_data($_COOKIE);
	$_REQUEST = slash_input_data($_REQUEST);
}



 
//===================================================
// Get Language
//===================================================
 
$language = $board_config['default_lang']; 

if( !file_exists($phpbb_root_path . 'language/lang_' . $language . '/lang_pafiledb.'.$phpEx) ) 
{ 
   $language = 'english'; 
} 

if( !file_exists($phpbb_root_path . 'language/lang_' . $language . '/lang_admin_pafiledb.'.$phpEx) ) 
{ 
   $language = 'english'; 
} 

include($phpbb_root_path . 'language/lang_' . $language . '/lang_pafiledb.' . $phpEx); 
include($phpbb_root_path . 'language/lang_' . $language . '/lang_admin_pafiledb.' . $phpEx);

//===================================================
// Include pafiledb data file
//===================================================

include($phpbb_root_path . 'pafiledb/includes/pafiledb_constants.'.$phpEx);
include($phpbb_root_path . 'pafiledb/includes/functions.'.$phpEx);
include($phpbb_root_path . 'pafiledb/includes/auth.'.$phpEx);
include($phpbb_root_path . 'pafiledb/includes/template.'.$phpEx);

//===================================================
// Pafiledb Configuration data
//===================================================

$cache_dir = $phpbb_root_path . 'pafiledb/cache';
$cache_file = $cache_dir . '/pafiledb_config.'.$phpEx;
$pafiledb_config = array();


if ((file_exists($cache_dir)) && (is_dir($cache_dir)))
{
	if (file_exists($cache_file) && !defined('IN_PA_CONFIG_ADMIN'))
	{
		include($cache_file);
	}
	else
	{
		$pafiledb_config = pafiledb_config();
		$fp = @fopen($cache_file, 'wt+');
		if ($fp)
		{
			@reset($pafiledb_config);
			fwrite($fp, "<?php\n");
			while (list($key, $value) = @each($pafiledb_config) )
			{
				fwrite($fp, '$pafiledb_config[\'' . $key . '\'] = \'' . trim($value) . '\';' . "\n");
			}
			fwrite($fp, '?>');
			fclose($fp);
		}
	}
}
else
{
	$pafiledb_config = pafiledb_config();
}

//===================================================
// addslashes to vars if magic_quotes_gpc is off
//===================================================

function slash_input_data(&$data)
{
	if (is_array($data))
	{
		foreach ($data as $k => $v)
		{
			$data[$k] = (is_array($v)) ? slash_input_data($v) : addslashes($v);
		}
	}
	return $data;
}

//===================================================
// get an array of all categories
//===================================================

function cat_rowset(&$cat_rowset,&$total_cat)
{
	global $db, $userdata;
	$sql = "SELECT * 
		FROM " . PA_CATEGORY_TABLE . "
		ORDER BY cat_order ASC";
	
	if ( !($result = pafiledb_sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Couldnt Query categories info', '', __LINE__, __FILE__, $sql);
	}
	
	while( $row = $db->sql_fetchrow($result) )
	{
		$pafiledb_auth = pafiledb_auth(PA_AUTH_ALL, $row['cat_id'], $userdata, $row);
		if($pafiledb_auth['auth_view'])
		{
			$cat_rowset[] = $row;
			$total_cat++;
		}
	}
}

$cat_rowset = array();
$total_cat = 0;
cat_rowset(&$cat_rowset, &$total_cat);

//===================================================
// get an array of all files
//===================================================
function file_rowset(&$file_rowset)
{
	global $db, $userdata, $cat_rowset;
	
	$sql = "SELECT * 
		FROM " . PA_FILES_TABLE . " 
		WHERE file_approved = '1' 
		ORDER BY file_time DESC";

	if ( !($result = pafiledb_sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Couldnt Query Files info', '', __LINE__, __FILE__, $sql);
	}

	while( $file_row = $db->sql_fetchrow($result) )
	{
		$pafiledb_auth = pafiledb_auth(PA_AUTH_ALL, $file_row['file_catid'], $userdata, $cat_rowset);
		if($pafiledb_auth['auth_read'])
		{
			$file_rowset[] = $file_row;
		}
	}
}

$file_rowset = array();
file_rowset(&$file_rowset);

$user_info = new User_info();
$pafiledb_template = new Pafiledb_template();
$pafiledb_template->set_template($theme['template_name']);

?>