<?php                  
/*
  paFileDB 3.0
  2001/2002 PHP Arena
  Written by Todd
  todd@phparena.net
  http://www.phparena.net
  Keep all copyright links on the script visible
  Please read the license included with this script for more information.
*/

class pafiledb_user_upload extends pafiledb
{
	function main($action)
	{
		global $_REQUEST, $_POST, $_FILES, $pafiledb_config, $phpbb_root_path;
		global $pafiledb_template, $db, $lang, $userdata, $user_ip, $phpEx;
		
		// =======================================================
		// Get Vars
		// =======================================================
		
		include($phpbb_root_path . 'pafiledb/includes/functions_field.'.$phpEx);

		$custom_field = new custom_field();
		$custom_field->init();		
		
		$user_screen_shot = ( !empty($_POST['screen_shot_url']) ) ? htmlentities(trim(preg_replace('#\s{2,}#s', ' ', strtr((string) $_POST['screen_shot_url'], array_flip(get_html_translation_table(HTML_ENTITIES)))))) : ( ( !empty($_FILES['screen_shot']['tmp_name']) ) ? $_FILES['screen_shot']['tmp_name'] : '' );
		$ss_upload = ( empty($_POST['screen_shot_url']) ) ? TRUE : FALSE;

		$screen_shot_name = ( !empty($_FILES['screen_shot']['name']) ) ? $_FILES['screen_shot']['name'] : '';

		$screen_shot_size = ( !empty($_FILES['screen_shot']['size']) ) ? $_FILES['screen_shot']['size'] : '';
		
		$userfile = ( !empty($_POST['download_url']) ) ? htmlentities(trim(preg_replace('#\s{2,}#s', ' ', strtr((string) $_POST['download_url'], array_flip(get_html_translation_table(HTML_ENTITIES)))))) : ( ( !empty($_FILES['userfile']['tmp_name'])) ? $_FILES['userfile']['tmp_name'] : '' );
		$file_upload = ( empty($_POST['download_url']) ) ? TRUE : FALSE;
		
		$MAX_FILE_SIZE = ( isset($_POST['MAX_FILE_SIZE']) ) ? $_POST['MAX_FILE_SIZE'] : '';

		$userfile_name = ( !empty($_FILES['userfile']['name']) ) ? $_FILES['userfile']['name'] : '';

		$userfile_size = ( !empty($_FILES['userfile']['size']) ) ? $_FILES['userfile']['size'] : '';		

		$cat_id = ( isset($_REQUEST['cat_id']) ) ? intval($_REQUEST['cat_id']) : 0;

		$file_name = ( isset($_POST['name']) ) ? htmlentities(trim(preg_replace('#\s{2,}#s', ' ', strtr((string) $_POST['name'], array_flip(get_html_translation_table(HTML_ENTITIES)))))) : '';
		
		$file_long_desc = ( isset($_POST['long_desc']) ) ? $_POST['long_desc'] : '';
		
		$file_short_desc = ( isset($_POST['short_desc']) ) ? htmlentities(trim(preg_replace('#\s{2,}#s', ' ', strtr((string) $_POST['short_desc'], array_flip(get_html_translation_table(HTML_ENTITIES)))))) : ((!empty($file_long_desc)) ? substr($file_long_desc, 0, 50) . '...' : '');
		
		$file_author = ( isset($_POST['author']) ) ? htmlentities(trim(preg_replace('#\s{2,}#s', ' ', strtr((string) $_POST['author'], array_flip(get_html_translation_table(HTML_ENTITIES)))))) : ( ($userdata['user_id'] != ANONYMOUS) ? $userdata['username'] : '' );
		
		$file_version = ( isset($_POST['version']) ) ? htmlentities(trim(preg_replace('#\s{2,}#s', ' ', strtr((string) $_POST['version'], array_flip(get_html_translation_table(HTML_ENTITIES)))))) : '';
		
		$file_website = ( isset($_POST['website']) ) ? $_POST['website'] : '';
		if(!empty($file_website))
		{
			$file_website = (!preg_match('#^http[s]?:\/\/#i', $file_website)) ? 'http://' . $file_website : $file_website;
			$file_website = (preg_match('#^http[s]?\\:\\/\\/[a-z0-9\-]+\.([a-z0-9\-]+\.)?[a-z]+#i', $file_website)) ? $file_website : '';			
		}
		
		$file_posticon = ( isset($_POST['posticon']) ) ? $_POST['posticon'] : '';
		
		$file_license = ( isset($_POST['license']) ) ? intval($_POST['license']) : 0;
		
		$file_pin = ( isset($_POST['pin']) ) ? intval($_POST['pin']) : 0;
		
		$file_ss_link = ( isset($_POST['sshot_link']) ) ? intval($_POST['sshot_link']) : 0;


		// =======================================================
		// IF submit then upload the file and update the sql for it
		// =======================================================
		
		if ( isset($_POST['submit']) )
		{
			if($cat_id == -1)
			{
				message_die(GENERAL_ERROR, $lang['Missing_field']);
			}
			
			if(empty($file_name))
			{
				message_die(GENERAL_ERROR, $lang['Missing_field']);
			}
			
			if(empty($file_long_desc))
			{
				message_die(GENERAL_ERROR, $lang['Missing_field']);
			}
			
			if(empty($userfile))
			{
				message_die(GENERAL_ERROR, $lang['Missing_field']);
			}
			// =======================================================
			// if the file already exit then give the user a nice error message 
			// =======================================================
			
			if($file_upload)
			{
				$file_info = upload_file($userfile, $userfile_name, $userfile_size, $MAX_FILE_SIZE);
				
				if($file_info['error'])
				{
					message_die(GENERAL_ERROR, $file_info['message']);
				}
				$file_url = $file_info['url'];
			}
			else
			{
				$file_url = $userfile;
			}
			
			if(!empty($user_screen_shot))
			{
				if($ss_upload)
				{
					$screen_shot_info = upload_file($user_screen_shot, $screen_shot_name, $screen_shot_size, $MAX_FILE_SIZE);
	
					if($screen_shot_info['error'])
					{
						message_die(GENERAL_ERROR, $screen_shot_info['message']);
					}
					$screen_shot_url = $screen_shot_info['url'];
				}
				else
				{
					$screen_shot_url = $user_screen_shot;
				}
			}

			$time = time();

			$sql = "INSERT INTO " . PA_FILES_TABLE . " (user_id, poster_ip, file_name, file_desc, file_creator, file_version, file_longdesc, file_ssurl, file_sshot_link, file_dlurl, file_time, file_update_time, file_catid, file_posticon, file_license, file_dls, file_last, file_pin, file_docsurl, file_approved)
					VALUES('" . $userdata['user_id'] . "', '" . $user_ip . "', '" . str_replace("\'", "''", $file_name) . "', '" . str_replace("\'", "''", $file_short_desc) . "', '" . str_replace("\'", "''", $file_author) . "', '" . str_replace("\'", "''", $file_version) . "', '" . str_replace("\'", "''", $file_long_desc) . "', '" . $screen_shot_url . "', '" . $file_ss_link . "', '" . $file_url . "', '" . $time . "', '" . $time . "', '" . $cat_id . "', '" . $file_posticon . "', '" . $file_license . "', '0', '0', '" . $file_pin . "', '" . $file_website . "', '0')";

			if ( !(pafiledb_sql_query($sql)) )
			{
				message_die(GENERAL_ERROR, 'Couldnt Add the file information to the database', '', __LINE__, __FILE__, $sql);
			}

			$file_id = $db->sql_nextid();

			$custom_field->file_update_data($file_id);

			$message = $lang['Fileadded'] . '<br /><br />' . sprintf($lang['Click_return'], '<a href="' . append_sid("dload.$phpEx?action=user_upload") . '">', '</a>');

			message_die(GENERAL_MESSAGE, $message);
		}

		if ( !isset($_POST['submit']) )
		{
			$curicons = 1;

			$posticons .= '<input type="radio" name="posticon" value="none" checked><a class="gensmall">' . $lang['None'] . '</a>&nbsp;';

			$handle = @opendir($phpbb_root_path . ICONS_DIR);
          
			while ($icon = @readdir($handle)) 
			{
				if ($icon !== "." && $icon !== ".." && $icon !== 'index.htm') 
				{
					$posticons .= '<input type="radio" name="posticon" value="' . $icon . '"><img src="' . $phpbb_root_path . ICONS_DIR . $icon . '">&nbsp;';

					$curicons++;

					if ($curicons == 8)
					{
						$posticons .= '<br />';

						$curicons = 0;
					}
				}
			}
			
			$dropmenu = (!$cat_id) ? jumpmenu('', 'admin', '', 'cat', TRUE) : jumpmenu('', 'admin', array($cat_id => 1), 'cat', TRUE);
                
			$sql = "SELECT license_id, license_name
				FROM " . PA_LICENSE_TABLE . " 
				ORDER BY license_id";

			if ( !($result = pafiledb_sql_query($sql)) )
			{
				message_die(GENERAL_ERROR, 'Couldnt Query info', '', __LINE__, __FILE__, $sql);
			}

			while ($license = $db->sql_fetchrow($result)) 
			{
				$ldropmenu .= '<option value="' . $license['license_id'] . '">' . $license['license_name'] . '</option>';
			}
			
			$custom_exist = $custom_field->display_edit($file_id);

			$pafiledb_template->assign_vars(array(
				'S_ADD_FILE_ACTION' => append_sid("dload.$phpEx"),
				
				'CUSTOM_EXIST' => $custom_exist,
				'L_INDEX' => sprintf($lang['Forum_Index'], $board_config['sitename']),
				'L_UPLOAD' => $lang['User_upload'],
				'L_AFILETITLE' => $lang['Afiletitle'],                    
				'L_FILEEXPLAIN' => $lang['Fileexplain'],                    
				'L_FILENAME' => $lang['Filename'],
				'L_FILENAMEINFO' => $lang['Filenameinfo'],
				'L_FILESD' => $lang['Filesd'],
				'L_FILESDINFO' => $lang['Filesdinfo'],
				'L_FILELD' => $lang['Fileld'],
				'L_FILELDINFO' => $lang['Fileldinfo'],
				'L_FILECREATOR' => $lang['Filecreator'],
				'L_FILECREATORINFO' => $lang['Filecreatorinfo'],
				'L_FILEVERSION' => $lang['Fileversion'],
				'L_FILEVERSIONINFO' => $lang['Fileversioninfo'],
				'L_SCREENSHOT' => $lang['Scrsht'],
				'L_FILESS' => $lang['Filess'],
				'L_FILESSINFO' => $lang['Filessinfo'],
				'L_FILESS_UPLOAD' => $lang['Filess_upload'],
				'L_FILESSINFO_UPLOAD' => $lang['Filessinfo_upload'],
				'L_FILE_SSLINK' => $lang['Filess_link'],
				'L_FILE_SSLINK_INFO' => $lang['Filess_link_info'],					
				'L_FILEDOCS' => $lang['Filedocs'],
				'L_FILEDOCSINFO' => $lang['Filedocsinfo'],
				'L_FILES' => $lang['Files'],
				'L_FILE_UPLOAD' => $lang['File_upload'],
				'L_FILEINFO_UPLOAD' => $lang['Fileinfo_upload'],
				'L_FILEURL' => $lang['Fileurl'],
				'L_FILEURLINFO' => $lang['Fileurlinfo'],
				'L_FILEPI' => $lang['Filepi'],
				'L_FILEPIINFO' => $lang['Filepiinfo'],
				'L_FILECAT' => $lang['Filecat'],
				'L_FILECATINFO' => $lang['Filecatinfo'],
				'L_FILELICENSE' => $lang['Filelicense'],
				'L_NONE' => $lang['None'],
				'L_FILELICENSEINFO' => $lang['Filelicenseinfo'],
				'L_FILEPIN' => $lang['Filepin'],
				'L_FILEPININFO' => $lang['Filepininfo'],
				'L_ADDTIONAL_FIELD' => $lang['Addtional_field'],
				'L_NO' => $lang['No'],
				'L_YES' => $lang['Yes'],

				'DOWNLOAD' => $pafiledb_config['settings_dbname'],
				'POSTICONS' => $posticons,
				'LDROPMENU' => $ldropmenu,                                                                    
				'DROPMENU' => $dropmenu,

				'U_INDEX' => append_sid('index.'.$phpEx),
				'U_DOWNLOAD' => append_sid('dload.'.$phpEx))
			);

			$this->output($lang['Download'], 'pa_file_add.tpl');
		}
	}
}
?>
