<?php
/*
  paFileDB 3.0
  2001/2002 PHP Arena
  Written by Todd
  todd@phparena.net
  http://www.phparena.net
  Keep all copyright links on the script visible
  Please read the license included with this script for more information.
*/


class pafiledb_toplist extends pafiledb
{
	function main($action)
	{
		global $pafiledb_template, $lang, $board_config, $phpEx, $pafiledb_config, $db, $images;
		global $_REQUEST, $cat_rowset, $file_rowset, $phpbb_root_path, $userdata;

		if ( isset($_REQUEST['mode']) )
		{
			$mode = htmlspecialchars($_REQUEST['mode']);
		}
		else
		{
			$mode = 'newest';
		}
		
		if ( isset($_REQUEST['days']) )
		{
			$days = intval($_REQUEST['days']);
		}
		else
		{
			$days = 7;
		}
		
		if ( isset($_REQUEST['selected_date']) )
		{
			$selected_date = $_REQUEST['selected_date'];
		}
		else
		{
			$selected_date = '';
		}
		
		if ( isset($_REQUEST['most_num']) )
		{
			$most_num = intval($_REQUEST['most_num']);
		}
		else
		{
			$most_num = 10;
		}
		
		if ( isset($_REQUEST['most_type']) )
		{
			$most_type = htmlspecialchars($_REQUEST['most_type']);
		}
		else
		{
			$most_type = 'num';
		}
		
		if ($mode == 'downloads')
		{
			$l_current_toplist = $lang['Most_downloads'];
		}
		elseif ($mode == 'rating')
		{
			$l_current_toplist = $lang['Rated_downloads'];
		}
		else
		{
			$l_current_toplist = $lang['Latest_downloads'];
		}

		$pafiledb_template->assign_vars(array(
			'DOWNLOAD' => $pafiledb_config['settings_dbname'],
	
			'U_INDEX' => append_sid('index.'.$phpEx),
			'U_DOWNLOAD' => append_sid('dload.'.$phpEx),
			'U_NEWEST_FILE' => append_sid('dload.'.$phpEx.'?action=toplist&mode=newest'),
			'U_MOST_POPULAR' => append_sid('dload.'.$phpEx.'?action=toplist&mode=downloads'),
			'U_TOP_RATED' => append_sid('dload.'.$phpEx.'?action=toplist&mode=rating'),
			
			'L_CURRENT_TOPLIST'	=> $l_current_toplist,
			'L_NEWEST_FILE' => $lang['Latest_downloads'],
			'L_MOST_POPULAR' => $lang['Most_downloads'],
			'L_TOP_RATED' => $lang['Rated_downloads'],
			'L_INDEX' => sprintf($lang['Forum_Index'], $board_config['sitename']),
			'L_TOPLIST' => $lang['Toplist'])
		);

		switch ($mode)
		{
			case 'newest':
				//get number of files in the last week
				$file_num_week = 0;
				$day_time = (time()-(86400 * 7));
				for($i = 0; $i < count($file_rowset); $i++)
				{
					if( ($file_rowset[$i]['file_time']) >= $day_time )
					{
						$file_num_week++;
					}
				}


				$file_num_month = 0;

				$day_time = (time()-(86400 * 30));
				for($i = 0; $i < count($file_rowset); $i++)
				{
					if( ($file_rowset[$i]['file_time']) >= $day_time )
					{
						$file_num_month++;
					}
				}

				$pafiledb_template->assign_vars(array(
					'IS_NEWEST' => TRUE,
					'FILE_DATE' => (empty($selected_date)) ? TRUE : FALSE,

					'TOTAL_FILE_WEEK' => $file_num_week,
					'TOTAL_FILE_MONTH' => $file_num_month,
					
					'L_TOTAL_NEW_FILE' => $lang['Total_new_files'],
					'L_LAST_WEEK' => $lang['Last_week'],
					'L_LAST_30_DAYS' => $lang['Last_30_days'],
					'L_SHOW' => $lang['Show'],
					'L_ONE_WEEK' => $lang['One_week'],
					'L_TWO_WEEK' => $lang['Two_week'],
					'L_30_DAYS' => $lang['30_days'],
					'L_NEW_FILES' => sprintf($lang['New_Files'], $days),
					
					'U_ONE_WEEK' => append_sid('dload.'.$phpEx.'?action=toplist&mode=newest&days=7'),
					'U_TWO_WEEK' => append_sid('dload.'.$phpEx.'?action=toplist&mode=newest&days=14'),
					'U_30_DAYS' => append_sid('dload.'.$phpEx.'?action=toplist&mode=newest&days=30'))
				);

				if(empty($selected_date))
				{
					for($j = 0; $j <= $days - 1; $j++)
					{
						$day_time = (time()-(86400 * $j));
						$day_date = Date('Y-m-d', $day_time);
						$file_num = 0;
						for($i = 0; $i < count($file_rowset); $i++)
						{
							$file_date = Date('Y-m-d', $file_rowset[$i]['file_time']);
							if( $file_date == $day_date )
							{
								$file_num++;
							}
						}

						$pafiledb_template->assign_block_vars('files_date', array(
							'U_DATES' => append_sid('dload.'.$phpEx.'?action=toplist&mode=newest&days=7&selected_date='.$day_time),
							'DATES' => date('F d, Y', $day_time),
							'TOTAL_DOWNLOADS' => $file_num)
						);
					}
				}
				else
				{
					$pafiledb_template->assign_vars(array(
						'FILE_LIST' => TRUE,

						'L_NEW_FILE' => $lang['New_file'],
						'L_RATE' => $lang['DlRating'],
						'L_DOWNLOADS' => $lang['Dls'],
						'L_DATE' => $lang['Date'],
						'L_NAME' => $lang['Name'],
						'L_FILE' => $lang['File'],
						'L_SUBMITER' => $lang['Submiter'],
						'L_CATEGORY' => $lang['Category'])
					);
					for ($i = 0; $i < count($file_rowset); $i++) 
					{
						$formated_date = Date('Y-m-d', $selected_date);
						$file_date = Date('Y-m-d', $file_rowset[$i]['file_time']); 
						if($file_date == $formated_date)
						{
							$cat_url = append_sid('dload.'.$phpEx.'?action=category&cat_id=' . $file_rowset[$i]['file_catid']);
							$file_url = append_sid('dload.'.$phpEx.'?action=file&file_id=' . $file_rowset[$i]['file_id']);							
							//===================================================
							// Format the date for the given file
							//===================================================

							$date = create_date($board_config['default_dateformat'], $file_rowset[$i]['file_time'], $board_config['board_timezone']);

							//===================================================
							// Get rating for the file and format it
							//===================================================

							$rating = get_rating($file_rowset[$i]['file_id']);

							//===================================================
							// If the file is new then put a new image in front of it
							//===================================================
		
							$is_new = FALSE;
							if (time() - ($pafiledb_config['settings_newdays'] * 24 * 60 * 60) < $file_rowset[$i]['file_time'])
							{
								$is_new = TRUE;
							}

							$sql = "SELECT cat_name 
								FROM " . PA_CATEGORY_TABLE . " 
								WHERE cat_id = '" . $file_rowset[$i]['file_catid'] . "'";

							if ( !($result = pafiledb_sql_query($sql)) )
							{
								message_die(GENERAL_ERROR, 'Couldnt get file info for this category', '', __LINE__, __FILE__, $sql);
							}
							$row = $db->sql_fetchrow($result);
							$cat_name = $row['cat_name'];
							
							
							
							//===================================================
							// Get the post icon fot this file
							//===================================================
							if ($file_rowset[$i]['file_pin'] != FILE_PINNED)
							{
								if ($file_rowset[$i]['file_posticon'] == 'none' || $file_rowset[$i]['file_posticon'] == 'none.gif') 
								{
									$posticon = '&nbsp;';
								} 
								else 
								{
									$posticon = '<img src="' . ICONS_DIR . $file_rowset[$i]['file_posticon'] . '" border="0" />';
								}
							}
							else
							{
								$posticon = '<img src="' . $images['folder_sticky'] . '" border="0" />';
							}
							
							$sql = "SELECT username 
								FROM " . USERS_TABLE . " 
								WHERE user_id = '" . $file_rowset[$i]['user_id'] . "'";

							if ( !($result = pafiledb_sql_query($sql)) )
							{
								message_die(GENERAL_ERROR, 'Couldnt get file info for this category', '', __LINE__, __FILE__, $sql);
							}
							$row = $db->sql_fetchrow($result);


							$poster = ( $file_rowset[$i]['user_id'] != ANONYMOUS ) ? '<a href="' . append_sid('profile.'.$phpEx.'?mode=viewprofile&amp;' . POST_USERS_URL . '=' . $file_rowset[$i]['user_id']) . '">' : '';
							$poster .= ( $file_rowset[$i]['user_id'] != ANONYMOUS ) ? $row['username'] : $lang['Guest'];
							$poster .= ( $file_rowset[$i]['user_id'] != ANONYMOUS ) ? '</a>' : '';
		
							//===================================================
							// Assign Vars
							//===================================================

							$pafiledb_template->assign_block_vars('files_row', array(
								'CAT_NAME' => $cat_name,
								'FILE_NEW_IMAGE' => $images['pa_file_new'],
								'PIN_IMAGE' => $posticon,

								'IS_NEW_FILE' => $is_new,
								'FILE_NAME' => $file_rowset[$i]['file_name'],
								'FILE_DESC' => $file_rowset[$i]['file_desc'],
								'FILE_SUBMITER' => $poster,
								'DATE' => $date,
								'RATING' => $rating,
								'DOWNLOADS' => $file_rowset[$i]['file_dls'],

								'U_FILE' => $file_url,
								'U_CAT' => $cat_url)
							);
						}
					}
				}
				

				break;
			case 'downloads':
			case 'rating':
				$rating_field = ($mode == 'rating') ? ', AVG(r.rate_point) AS rating' : '';
				$join_statement = ($mode == 'rating') ? 'LEFT JOIN ' . PA_VOTES_TABLE . ' AS r ON f.file_id = r.votes_file' : '';
				$group_statement = ($mode == 'rating') ? 'GROUP BY f.file_id' : '';

				$sql = "SELECT file_id$rating_field 
					FROM " . PA_FILES_TABLE . " AS f
					$join_statement
					WHERE f.file_approved = '1' 
					$group_statement
					ORDER BY f.file_time DESC";
					
				if ( !($result = pafiledb_sql_query($sql)) )
				{
					message_die(GENERAL_ERROR, 'Couldnt Query category info for parent categories', '', __LINE__, __FILE__, $sql);
				}
				
				$file_num = 0;
				
				if($mode == 'downloads')
				{
					$file_num = $db->sql_numrows($result);
				}
				else
				{
					while($row = $db->sql_fetchrow($result))
					{
						if(!empty($row['rating']))
						{
							$file_num++;
						}
					}
				}

				$limit = $most_num;
				if($most_type == 'per')
				{
			    	$limit = $most_num / 100;
			    	$limit = $file_num * $limit;
			    	$limit = round($limit);
				}

				$pafiledb_template->assign_vars(array(
					'IS_POPULAR' => TRUE,
					'FILE_LIST' => TRUE,
					
					'L_NEW_FILES' => sprintf( ($most_type == 'num') ? $lang['Popular_num'] : $lang['Popular_per'], $most_num, $file_num),
					'L_NEW_FILE' => $lang['New_file'],
					'L_SHOW_TOP' => $lang['Show_top'],
					'L_OR_TOP' => $lang['Or_top'],
					'L_RATE' => $lang['DlRating'],
					'L_DOWNLOADS' => $lang['Dls'],
					'L_DATE' => $lang['Date'],
					'L_NAME' => $lang['Name'],
					'L_FILE' => $lang['File'],
					'L_SUBMITER' => $lang['Submiter'],
					'L_CATEGORY' => $lang['Category'],
					
					
					'U_TOP_10' => append_sid('dload.'.$phpEx.'?action=toplist&mode='.$mode.'&most_type=num&most_num=10'),
					'U_TOP_25' => append_sid('dload.'.$phpEx.'?action=toplist&mode='.$mode.'&most_type=num&most_num=25'),
					'U_TOP_50' => append_sid('dload.'.$phpEx.'?action=toplist&mode='.$mode.'&most_type=num&most_num=50'),
					
					'U_TOP_PER_1' => append_sid('dload.'.$phpEx.'?action=toplist&mode='.$mode.'&most_type=per&most_num=1'),
					'U_TOP_PER_5' => append_sid('dload.'.$phpEx.'?action=toplist&mode='.$mode.'&most_type=per&most_num=5'),
					'U_TOP_PER_10' => append_sid('dload.'.$phpEx.'?action=toplist&mode='.$mode.'&most_type=per&most_num=10'))
				);
				if ($limit)
				{
					$sort_method = ($mode == 'downloads') ? 'file_dls' : 'rating';
					$sql_limit = ($mode == 'downloads') ? "LIMIT 0, $limit " : '';
					switch(SQL_LAYER)
					{
						case 'oracle':
							$sql = "SELECT f1.*, AVG(r.rate_point) AS rating, COUNT(r.votes_file) AS total_votes, u.user_id, u.username, c.cat_id, c.cat_name
								FROM " . PA_FILES_TABLE . " AS f1, " . PA_VOTES_TABLE . " AS r, " . USERS_TABLE . " AS u, " . PA_CATEGORY_TABLE . " AS c
								WHERE f1.file_id = r.votes_file(+) 
								AND f1.user_id = u.user_id(+) 
								AND c.cat_id = f1.file_catid 
								AND f1.file_approved = '1' 
								GROUP BY f1.file_id 
								ORDER BY $sort_method DESC 
								$sql_limit";
							break;

						default:
							$sql = "SELECT f1.*, AVG(r.rate_point) AS rating, COUNT(r.votes_file) AS total_votes, u.user_id, u.username, c.cat_id, c.cat_name
								FROM " . PA_FILES_TABLE . " AS f1, " . PA_CATEGORY_TABLE . " AS c
								LEFT JOIN " . PA_VOTES_TABLE . " AS r ON f1.file_id = r.votes_file
								LEFT JOIN ". USERS_TABLE ." AS u ON f1.user_id = u.user_id
								WHERE c.cat_id = f1.file_catid
								AND f1.file_approved = '1' 
								GROUP BY f1.file_id 
								ORDER BY $sort_method DESC 
								$sql_limit";
							break;
					}
					if ( !($result = pafiledb_sql_query($sql)) )
					{
						message_die(GENERAL_ERROR, 'Couldnt Query category info for parent categories', '', __LINE__, __FILE__, $sql);
					}
				}
				$searchset = array();
				if($mode == 'downloads')
				{
					while( $row = $db->sql_fetchrow($result) )
					{
						$searchset[] = $row;
					}
				}
				else
				{
					$i = 1;
					while($i <= $limit)
					{
						$row = $db->sql_fetchrow($result);
						if($row['rating'])
						{
							$i++;
							$searchset[] = $row;
						}
					}
				}
				
				for($i = 0; $i < count($searchset); $i++)
				{
					$cat_url = append_sid('dload.'.$phpEx.'?action=category&cat_id=' . $searchset[$i]['cat_id']);
					$file_url = append_sid('dload.'.$phpEx.'?action=file&file_id=' . $searchset[$i]['file_id']);
					//===================================================
					// Format the date for the given file
					//===================================================

					$date = create_date($board_config['default_dateformat'], $searchset[$i]['file_time'], $board_config['board_timezone']);

					//===================================================
					// Get rating for the file and format it
					//===================================================

					$rating = ($searchset[$i]['rating'] != 0) ? round($searchset[$i]['rating'], 2) . ' / 10' : $lang['Not_rated'];

					//===================================================
					// If the file is new then put a new image in front of it
					//===================================================
		
					$is_new = FALSE;
					if (time() - ($pafiledb_config['settings_newdays'] * 24 * 60 * 60) < $searchset[$i]['file_time'])
					{
						$is_new = TRUE;
					}

					//===================================================
					// Get the post icon fot this file
					//===================================================
					if ($searchset[$i]['file_pin'] != FILE_PINNED)
					{
						if ($searchset[$i]['file_posticon'] == 'none' || $searchset[$i]['file_posticon'] == 'none.gif') 
						{
							$posticon = '&nbsp;';
						} 
						else 
						{
							$posticon = '<img src="' . ICONS_DIR . $searchset[$i]['file_posticon'] . '" border="0" />';
						}
					}
					else
					{
						$posticon = '<img src="' . $images['folder_sticky'] . '" border="0" />';
					}

					$poster = ( $searchset[$i]['user_id'] != ANONYMOUS ) ? '<a href="' . append_sid('profile.'.$phpEx.'?mode=viewprofile&amp;' . POST_USERS_URL . '=' . $searchset[$i]['user_id']) . '">' : '';
					$poster .= ( $searchset[$i]['user_id'] != ANONYMOUS ) ? $searchset[$i]['username'] : $lang['Guest'];
					$poster .= ( $searchset[$i]['user_id'] != ANONYMOUS ) ? '</a>' : '';

					$pafiledb_template->assign_block_vars('files_row', array( 
						'CAT_NAME' => $searchset[$i]['cat_name'],
						'FILE_NEW_IMAGE' => $images['pa_file_new'],
						'PIN_IMAGE' => $posticon,

						'IS_NEW_FILE' => $is_new,
						'FILE_NAME' => $searchset[$i]['file_name'],
						'FILE_DESC' => $searchset[$i]['file_desc'],
						'FILE_SUBMITER' => $poster,
						'DATE' => $date,
						'RATING' => $rating,
						'DOWNLOADS' => $searchset[$i]['file_dls'],
						'U_FILE' => $file_url,
						'U_CAT' => $cat_url)
					);
				}
				break;
		}
		
		$this->output($lang['Download'], 'pa_toplist_body.tpl');
	}
}
?>
