<?php
/*
  paFileDB 3.0
  2001/2002 PHP Arena
  Written by Todd
  todd@phparena.net
  http://www.phparena.net
  Keep all copyright links on the script visible
  Please read the license included with this script for more information.
*/

class pafiledb_stats extends pafiledb
{
	function main($action)
	{
		global $pafiledb_template, $lang, $board_config, $phpEx, $pafiledb_config, $db, $images;
		global $_REQUEST, $cat_rowset, $file_rowset, $phpbb_root_path, $userdata;
		
		if( isset($_REQUEST['type']) )
		{
			switch ($_REQUEST['type'])
			{
				case 'bars':
					$type = 'bars';
					break;
				case 'lines':
					$type = 'lines';
					break;
				case 'area':
					$type = 'area';
					break;
				case 'linepoints':
					$type = 'linepoints';
					break;
				case 'points':
					$type = 'points';
					break;
				default:
					$type = 'bars';
			}
		}
		else
		{
			$type = 'bars';
		}
         
		$sql = "SELECT cat_id 
			FROM " . PA_CATEGORY_TABLE;

		if ( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Couldnt Query stat info', '', __LINE__, __FILE__, $sql);
		}

		$num['cats'] = $db->sql_numrows($result);
		$db->sql_freeresult($result);
		
		$sql = "SELECT file_id 
			FROM " . PA_FILES_TABLE;

		if ( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Couldnt Query stat info', '', __LINE__, __FILE__, $sql);
		}

		$num['files'] = $db->sql_numrows($result);
		$db->sql_freeresult($result);
		
		$sql = "SELECT file_id, file_name 
			FROM " . PA_FILES_TABLE . " 
			ORDER BY file_time DESC";

		if ( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Couldnt Query stat info', '', __LINE__, __FILE__, $sql);
		}

		$newest = $db->sql_fetchrow($result);
		$db->sql_freeresult($result);

		$sql = "SELECT file_id, file_name 
			FROM " . PA_FILES_TABLE . " 
			ORDER BY file_time ASC";

		if ( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Couldnt Query stat info', '', __LINE__, __FILE__, $sql);
		}

		$oldest = $db->sql_fetchrow($result);
		$db->sql_freeresult($result);		
		
		$sql = "SELECT r.votes_file, AVG(r.rate_point) AS rating, f.file_id, f.file_name
			FROM " . PA_VOTES_TABLE . " AS r, " . PA_FILES_TABLE . " AS f
			WHERE r.votes_file = f.file_id
			GROUP BY f.file_id 
			ORDER BY rating DESC";

		if ( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Couldnt Query stat info', '', __LINE__, __FILE__, $sql);
		}
		$popular = $db->sql_fetchrow($result);
		$db->sql_freeresult($result);

		$sql = "SELECT r.votes_file, AVG(r.rate_point) AS rating, f.file_id, f.file_name
			FROM " . PA_VOTES_TABLE . " AS r, " . PA_FILES_TABLE . " AS f
			WHERE r.votes_file = f.file_id
			GROUP BY f.file_id 
			ORDER BY rating ASC";

		if ( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Couldnt Query stat info', '', __LINE__, __FILE__, $sql);
		}

		$lpopular = $db->sql_fetchrow($result);
		$total_votes = $total_rating = 0;

		while($row = $db->sql_fetchrow($result))
		{
			$total_rating += $row['rating'];
			$total_votes++;
		}
		$db->sql_freeresult($result);
		$sql = "SELECT file_id, file_name, file_dls 
			FROM " . PA_FILES_TABLE . " 
			ORDER BY file_dls DESC";

		if ( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Couldnt Query stat info', '', __LINE__, __FILE__, $sql);
		}

		$mostdl = $db->sql_fetchrow($result);
		$db->sql_freeresult($result);
		
		$sql = "SELECT file_id, file_name, file_dls 
			FROM " . PA_FILES_TABLE . " 
			ORDER BY file_dls ASC";

		if ( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Couldnt Query stat info', '', __LINE__, __FILE__, $sql);
		}

		$leastdl = $db->sql_fetchrow($result);
		$db->sql_freeresult($result);

		$sql = "SELECT file_dls 
			FROM " . PA_FILES_TABLE;

		if ( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Couldnt Query stat info', '', __LINE__, __FILE__, $sql);
		}

		while($row = $db->sql_fetchrow($result))
		{
			$totaldls += $row['file_dls'];
		}
		$db->sql_freeresult($result);

		$avg = @round($total_rating/$total_votes);

		$avgdls = @round($totaldls/$num['files']);

		require($phpbb_root_path . 'language/lang_' . $board_config['default_lang'] . '/lang_pafiledb.' . $phpEx);

		$lang['Stats_text'] = str_replace("{total_files}", $num['files'], $lang['Stats_text']);
		$lang['Stats_text'] = str_replace("{total_categories}", $num['cats'], $lang['Stats_text']);
		$lang['Stats_text'] = str_replace("{total_downloads}", $totaldls, $lang['Stats_text']);
		$lang['Stats_text'] = str_replace("{u_newest_file}", append_sid("dload.php?action=file&id=" . $newest['file_id']), $lang['Stats_text']);
		$lang['Stats_text'] = str_replace("{newest_file}", $newest['file_name'], $lang['Stats_text']);
		$lang['Stats_text'] = str_replace("{u_oldest_file}", append_sid("dload.php?action=file&id=" . $oldest['file_id']), $lang['Stats_text']);
		$lang['Stats_text'] = str_replace("{oldest_file}", $oldest['file_name'], $lang['Stats_text']);
		$lang['Stats_text'] = str_replace("{average}", $avg, $lang['Stats_text']);
		$lang['Stats_text'] = str_replace("{u_popular}", append_sid("dload.php?action=file&id=" . $popular['file_id']), $lang['Stats_text']);
		$lang['Stats_text'] = str_replace("{popular}", $popular['file_name'], $lang['Stats_text']);
		$lang['Stats_text'] = str_replace("{most}", round($popular['rating'], 2), $lang['Stats_text']);
		$lang['Stats_text'] = str_replace("{u_lpopular}", append_sid("dload.php?action=file&id=" . $lpopular['file_id']), $lang['Stats_text']);
		$lang['Stats_text'] = str_replace("{lpopular}", $lpopular['file_name'], $lang['Stats_text']);
		$lang['Stats_text'] = str_replace("{least}", round($lpopular['rating'], 2), $lang['Stats_text']);
		$lang['Stats_text'] = str_replace("{avg_dls}", $avgdls, $lang['Stats_text']);
		$lang['Stats_text'] = str_replace("{u_most_dl}", append_sid("dload.php?action=file&id=" . $mostdl['file_id']), $lang['Stats_text']);
		$lang['Stats_text'] = str_replace("{most_dl}", $mostdl['file_name'], $lang['Stats_text']);
		$lang['Stats_text'] = str_replace("{most_no}", $mostdl['file_dls'], $lang['Stats_text']);
		$lang['Stats_text'] = str_replace("{u_least_dl}", append_sid("dload.php?action=file&id=" . $leastdl['file_id']), $lang['Stats_text']);
		$lang['Stats_text'] = str_replace("{least_dl}", $leastdl['file_name'], $lang['Stats_text']);
		$lang['Stats_text'] = str_replace("{least_no}", $leastdl['file_dls'], $lang['Stats_text']);
		
		$agent_lang = array('OPERA' => 'Opera', 'IE' => 'Internet Explorer', 'MOZILLA' => 'Mozilla', 'NETSCAPE' => 'NetScape', 'OTHER' => 'Other');
		$agent_image = array('OPERA' => 'opera.gif', 'IE' => 'explorer.gif', 'MOZILLA' => 'mozilla.gif', 'NETSCAPE' => 'netscape.gif', 'OTHER' => 'irix.gif');
		$agent_point = array('OPERA' => 0, 'IE' => 0, 'MOZILLA' => 0, 'NETSCAPE' => 0, 'OTHER' => 0);
		
		$os_lang = array('Win' => 'Windows', 'Mac' => 'Macintosh', 'Linux' => 'Linux', 'Unix' => 'Unix', 'Other' => 'Other');
		$os_image = array('Win' => 'windows.gif', 'Mac' => 'mac.gif', 'Linux' => 'linux.gif', 'Unix' => 'linux.gif', 'Other' => 'os2.gif');
		$os_point = array('Win' => 0, 'Mac' => 0, 'Linux' => 0, 'Unix' => 0, 'Other' => 0);
		
		$sql = "SELECT downloader_os, downloader_browser
			FROM " . PA_DOWNLOAD_INFO_TABLE;
			
		if ( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Could not obtain downloads info', '', __LINE__, __FILE__, $sql);
		}
		
		$row_downloads = $db->sql_fetchrowset($result);
		$db->sql_freeresult($result);

		for($i = 0; $i < count($row_downloads); $i++)
		{
			$os_point[$row_downloads[$i]['downloader_os']]++;
			$agent_point[$row_downloads[$i]['downloader_browser']]++;
		}

		$os_graphic = 0;
		$os_graphic_max = count($images['voting_graphic']);

		foreach($os_point as $index => $point)
		{
			$os_graphic_img = $images['voting_graphic'][$os_graphic];
			$os_graphic = ($os_graphic < $os_graphic_max - 1) ? $os_graphic + 1 : 0;
			$pafiledb_template->assign_block_vars("downloads_os", array(
				'OS_IMG' => $os_image[$index],
				'OS_NAME' => $os_lang[$index],
				'OS_OPTION_RESULT' => $point,
				'OS_OPTION_IMG' => $os_graphic_img,
				'OS_OPTION_IMG_WIDTH' => $point * 2)
			);			
		}


		$b_graphic = 0;
		$b_graphic_max = count($images['voting_graphic']);

		foreach($agent_point as $index => $point)
		{
			$b_graphic_img = $images['voting_graphic'][$b_graphic];
			$b_graphic = ($b_graphic < $b_graphic_max - 1) ? $b_graphic + 1 : 0;
			$pafiledb_template->assign_block_vars("downloads_b", array(
				'B_IMG' => $agent_image[$index],
				'B_NAME' => $agent_lang[$index],
				'B_OPTION_RESULT' => $point,
				'B_OPTION_IMG' => $b_graphic_img,
				'B_OPTION_IMG_WIDTH' => $point * 2)
			);			
		}

		$agent_point = array('OPERA' => 0, 'IE' => 0, 'MOZILLA' => 0, 'NETSCAPE' => 0, 'OTHER' => 0);
		$os_point = array('Win' => 0, 'Mac' => 0, 'Linux' => 0, 'Unix' => 0, 'Other' => 0);
				
		$sql = "SELECT voter_os, voter_browser
			FROM " . PA_VOTES_TABLE;

		if ( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Could not obtain downloads info', '', __LINE__, __FILE__, $sql);
		}
		
		$row_ratings = $db->sql_fetchrowset($result);
		$db->sql_freeresult($result);

		for($i = 0; $i < count($row_ratings); $i++)
		{
			$os_point[$row_ratings[$i]['voter_os']]++;
			$agent_point[$row_ratings[$i]['voter_browser']]++;
		}

		$os_graphic = 0;
		$os_graphic_max = count($images['voting_graphic']);

		foreach($os_point as $index => $point)
		{
			$os_graphic_img = $images['voting_graphic'][$os_graphic];
			$os_graphic = ($os_graphic < $os_graphic_max - 1) ? $os_graphic + 1 : 0;
			$pafiledb_template->assign_block_vars("rating_os", array(
				'OS_IMG' => $os_image[$index],
				'OS_NAME' => $os_lang[$index],
				'OS_OPTION_RESULT' => $point,
				'OS_OPTION_IMG' => $os_graphic_img,
				'OS_OPTION_IMG_WIDTH' => $point * 2)
			);			
		}


		$b_graphic = 0;
		$b_graphic_max = count($images['voting_graphic']);

		foreach($agent_point as $index => $point)
		{
			$b_graphic_img = $images['voting_graphic'][$b_graphic];
			$b_graphic = ($b_graphic < $b_graphic_max - 1) ? $b_graphic + 1 : 0;
			$pafiledb_template->assign_block_vars("rating_b", array(
				'B_IMG' => $agent_image[$index],
				'B_NAME' => $agent_lang[$index],
				'B_OPTION_RESULT' => $point,
				'B_OPTION_IMG' => $b_graphic_img,
				'B_OPTION_IMG_WIDTH' => $point * 2)
			);			
		}
		
		$pafiledb_template->assign_vars(array(
			'S_ACTION_CHART' => append_sid('dload.'.$phpEx.'?action=stats'),

		 	'L_STATISTICS' => $lang['Statistics'],
			'L_INDEX' => sprintf($lang['Forum_Index'], $board_config['sitename']),
			'L_GENERAL_INFO' => $lang['General_Info'],
			'L_DOWNLOADS_STATS' => $lang['Downloads_stats'],
			'L_RATING_STATS' => $lang['Rating_stats'],
			'L_SELECT_CHART_TYPE' => $lang['Select_chart_type'],
			'L_BARS' => $lang['Bars'],
			'L_LINES' => $lang['Lines'],
			'L_AREA' => $lang['Area'],
			'L_LINEPOINTS' => $lang['Linepoints'],
			'L_POINTS' => $lang['Points'],
			'L_GO' => $lang['Go'],
			'L_OS' => $lang['Os'],
			'L_BROWSERS' => $lang['Browsers'],

			'U_INDEX' => append_sid('index.'.$phpEx),
			'U_DOWNLOAD' => append_sid('dload.'.$phpEx),
			'U_IMAGE' => 'pafiledb/includes/image_stats.'.$phpEx.'?type='.$type,

			'CHART_BARS' => ($type == 'bars') ? 'selected="selected"' : '',
			'CHART_LINES' => ($type == 'lines') ? 'selected="selected"' : '',
			'CHART_AREA' => ($type == 'area') ? 'selected="selected"' : '',
			'CHART_LINEPOINTS' => ($type == 'linepoints') ? 'selected="selected"' : '',
			'CHART_POINTS' => ($type == 'points') ? 'selected="selected"' : '',
			'DOWNLOAD' => $pafiledb_config['settings_dbname'],
		 	'STATS_TEXT' => $lang['Stats_text'])
		);
		$this->output($lang['Download'], 'pa_stats_body.tpl');
	}
}
?>
