<?php
/*
  paFileDB 3.0
  2001/2002 PHP Arena
  Written by Todd
  todd@phparena.net
  http://www.phparena.net
  Keep all copyright links on the script visible
  Please read the license included with this script for more information.
*/
class pafiledb_file extends pafiledb
{
	function main($action)
	{
		global $pafiledb_template, $lang, $board_config, $phpEx, $pafiledb_config, $db, $images;
		global $_REQUEST, $cat_rowset, $file_rowset, $phpbb_root_path, $userdata;
		
		if ( isset($_REQUEST['file_id']))
		{
			$file_id = intval($_REQUEST['file_id']);
		}
		else
		{
			message_die(GENERAL_MESSAGE, $lang['File_not_exist']);
		}

		// =======================================================
		// file id is not set, give him/her a nice error message
		// =======================================================

		switch(SQL_LAYER)
		{
			case 'oracle':
				$sql = "SELECT f.*, AVG(r.rate_point) AS rating, COUNT(r.votes_file) AS total_votes 
					FROM " . PA_FILES_TABLE . " AS f, " . PA_VOTES_TABLE . " AS r, " . USERS_TABLE . " AS u
					WHERE f.file_id = r.votes_file(+)
					AND f.user_id = u.user_id(+)
					AND f.file_id = '" . $file_id . "'
					AND f.file_approved='1'
					GROUP BY f.file_id ";
				break;

			default:
				$sql = "SELECT f.*, AVG(r.rate_point) AS rating, COUNT(r.votes_file) AS total_votes, u.user_id, u.username
					FROM " . PA_FILES_TABLE . " AS f
					LEFT JOIN " . PA_VOTES_TABLE . " AS r ON f.file_id = r.votes_file 
					LEFT JOIN ". USERS_TABLE ." AS u ON f.user_id = u.user_id
					WHERE f.file_id = '" . $file_id . "'
					AND f.file_approved='1'
					GROUP BY f.file_id ";
				break;
		}

		if ( !($result = pafiledb_sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Couldnt Query file info', '', __LINE__, __FILE__, $sql);
		}
		
		//===================================================
		//file doesn't exist'
		//===================================================
		if(!$file = $db->sql_fetchrow($result))
		{
			message_die(GENERAL_MESSAGE, $lang['File_not_exist']);
		}
		$db->sql_freeresult($result);
		
		//===================================================
		// Pafiledb auth for viewing file
		//===================================================

		$pafiledb_auth = pafiledb_auth(PA_AUTH_ALL, $file['file_catid'], $userdata, $cat_rowset);

		if( (!$pafiledb_auth['auth_view_file']) )
		{
			if ( !$userdata['session_logged_in'] )
			{
				redirect(append_sid("login.$phpEx?redirect=dload.$phpEx?action=file&file_id=" . $file_id, true));
			}

			$message = sprintf($lang['Sorry_auth_view'], $pafiledb_auth['auth_view_file_type']);
			message_die(GENERAL_MESSAGE, $message);
		}

		generate_category_nav($file['file_catid']);

		$pafiledb_template->assign_vars(array(
			'L_INDEX' => sprintf($lang['Forum_Index'], $board_config['sitename']),

			'U_INDEX' => append_sid('index.'.$phpEx),
			'U_DOWNLOAD_HOME' => append_sid('dload.'.$phpEx),

			'FILE_NAME' => $file['file_name'],
			'DOWNLOAD' => $pafiledb_config['settings_dbname'])
		); 
		
		//===================================================
		// Prepare file info to display them
		//===================================================

		$file_time = create_date($board_config['default_dateformat'], $file['file_time'], $board_config['board_timezone']);

		if (!$file['file_last'])
		{
			$last = $lang['never'];
		}
		else
		{
			$last = create_date($board_config['default_dateformat'], $file['file_last'], $board_config['board_timezone']);
		}
		
		$file_update_time = create_date($board_config['default_dateformat'], $file['file_update_time'], $board_config['board_timezone']);

		$file['file_creator'] = trim($file['file_creator']);

		$file['file_version'] = trim($file['file_version']);

		$file['file_ssurl'] = trim($file['file_ssurl']);

		$file['file_docsurl'] = trim($file['file_docsurl']);

		$rating = get_rating($file_id, $file['rating']);

		if ($file['file_license'] == 0)
		{
			$download_link = append_sid('dload.php?action=download&file_id=' . $file_id);
		}

		if ($file['file_license'] > 0)
		{
			$download_link = append_sid('dload.php?action=license&license_id=' . $file['file_license'] . '&file_id=' . $file_id);
		}

		$file_size = get_file_size($file_id, $file);
		
		$poster = ( $file['user_id'] != ANONYMOUS ) ? '<a href="' . append_sid('profile.'.$phpEx.'?mode=viewprofile&amp;' . POST_USERS_URL . '=' . $file['user_id']) . '">' : '';
		$poster .= ( $file['user_id'] != ANONYMOUS ) ? $file['username'] : $lang['Guest'];
		$poster .= ( $file['user_id'] != ANONYMOUS ) ? '</a>' : '';

		$pafiledb_template->assign_vars(array(
			'L_CLICK_HERE' => $lang['Click_here'],
			'L_AUTHOR' => $lang['Creator'],
			'L_VERSION' => $lang['Version'],
			'L_SCREENSHOT' => $lang['Scrsht'],
			'L_WEBSITE' => $lang['Docs'],
			'L_FILE' => $lang['File'],
		 	'L_DESC' => $lang['Desc'],
			'L_VOTES' => $lang['Votes'],
			'L_DATE' => $lang['Date'],
			'L_UPDATE_TIME' => $lang['Update_time'],
			'L_LASTTDL' => $lang['Lastdl'],
			'L_DLS' => $lang['Dls'],
			'L_RATING' => $lang['DlRating'],
			'L_SIZE' => $lang['File_size'],
			'L_DOWNLOAD' => $lang['Downloadfile'],
			'L_RATE' => $lang['Rate'],
			'L_EMAIL' => $lang['Emailfile'],
			'L_SUBMITED_BY' => $lang['Submiter'],

			'SHOW_AUTHOR' => (!empty($file['file_creator'])) ? TRUE : FALSE,
			'SHOW_VERSION' => (!empty($file['file_version'])) ? TRUE : FALSE,
			'SHOW_SCREENSHOT' => (!empty($file['file_ssurl'])) ? TRUE : FALSE,
			'SHOW_WEBSITE' => (!empty($file['file_docsurl'])) ? TRUE : FALSE,
			'SS_AS_LINK' => ($file['file_sshot_link']) ? TRUE : FALSE,
			'FILE_NAME' => $file['file_name'],
		  	'FILE_LONGDESC' => nl2br($file['file_longdesc']),
			'FILE_SUBMITED_BY' => $poster,
			'FILE_AUTHOR' => $file['file_creator'],
			'FILE_VERSION' => $file['file_version'],
			'FILE_SCREENSHOT' => $file['file_ssurl'],
			'FILE_WEBSITE' => $file['file_docsurl'],
			'AUTH_DOWNLOAD' => ($pafiledb_auth['auth_download']) ? TRUE : FALSE,
			'AUTH_RATE' => ($pafiledb_auth['auth_rate']) ? TRUE : FALSE,
			'AUTH_EMAIL' => ($pafiledb_auth['auth_email']) ? TRUE : FALSE,
			'INCLUDE_COMMENTS' => ($pafiledb_auth['auth_view_comment']) ? TRUE : FALSE,
			'DOWNLOAD_IMG' => $images['pa_download'],
			'RATE_IMG' => $images['pa_rate'],
			'EMAIL_IMG' => $images['pa_email'],
			'FILE_VOTES' => $file['total_votes'],
			'TIME' => $file_time,
			'UPDATE_TIME' => ($file['file_update_time'] != $file['file_time']) ? $file_update_time : $lang['never'],
			'RATING' => $rating,
			'FILE_DLS' => $file['file_dls'],
			'FILE_SIZE' => $file_size,
			'LAST' => $last,

			'U_DOWNLOAD' => $download_link,
			'U_RATE' => append_sid("dload.php?action=rate&file_id=" . $file_id),
		 	'U_EMAIL' => append_sid("dload.php?action=email&file_id=" . $file_id))
		);

/*		$sql = "SELECT c.*, d.* 
			FROM " . PA_CUSTOM_TABLE . " c, " . PA_CUSTOM_DATA_TABLE . " d 
			WHERE d.customdata_file = '" . $file_id . "' 
			AND c.custom_id = d.customdata_custom";

		if ( !($result = pafiledb_sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Couldnt Query Custom field data', '', __LINE__, __FILE__, $sql);
		}

		while ($custom = $db->sql_fetchrow($result))
		{
			$custom['data'] = trim($custom['data']);

			if (!empty($custom['data']))
			{
				$pafiledb_template->assign_block_vars("custom_field", array(
					'CUSTOM_NAME' => $custom['custom_name'],
					'DATA' => $custom['data']) 
				);
			}

		}
		$db->sql_freeresult($result);*/
		include($phpbb_root_path . 'pafiledb/includes/functions_field.'.$phpEx);
		$custom_field = new custom_field();
		$custom_field->init();
		$custom_field->display_data($file_id);


		if($pafiledb_auth['auth_view_comment'])
		{
			include($phpbb_root_path . 'pafiledb/includes/comment.'.$phpEx);
		}
		$this->output($lang['Download'], 'pa_file_body.tpl');
	}
}
?>
