<?php
/*
  paFileDB 3.0
  2001/2002 PHP Arena
  Written by Todd
  todd@phparena.net
  http://www.phparena.net
  Keep all copyright links on the script visible
  Please read the license included with this script for more information.
*/
class pafiledb_category extends pafiledb
{
	function main($action)
	{
		global $pafiledb_template, $db, $lang, $board_config, $phpEx, $pafiledb_config;
		global $_REQUEST, $cat_rowset, $file_rowset, $images, $userdata;

		// =======================================================
		// Get the id
		// =======================================================

		if ( isset($_REQUEST['cat_id']))
		{
			$cat_id = intval($_REQUEST['cat_id']);
		}
		else
		{
			message_die(GENERAL_MESSAGE, $lang['Cat_not_exist']);
		}
		
		if( isset($_REQUEST['start']) )
		{
			$start = intval($_REQUEST['start']);
		}
		else
		{
			$start = 0;
		}

		if( isset($_REQUEST['sort_method']) )
		{
			switch ($_REQUEST['sort_method'])
			{
				case 'file_name':
					$sort_method = 'file_name';
					break;
				case 'file_time':
					$sort_method = 'file_time';
					break;
				case 'file_dls':
					$sort_method = 'file_dls';
					break;
				case 'file_rating':
					$sort_method = 'rating';
					break;
				case 'file_update_time':
					$sort_method = 'file_update_time';
					break;
				default:
					$sort_method = $pafiledb_config['sort_method'];
			}
		}
		else
		{
			$sort_method = $pafiledb_config['sort_method'];
		}

		if( isset($_REQUEST['sort_order']) )
		{
			switch ($_REQUEST['sort_order'])
			{
				case 'ASC':
					$sort_order = 'ASC';
					break;
				case 'DESC':
					$sort_order = 'DESC';
					break;
				default:
					$sort_order = $pafiledb_config['sort_order'];
			}
		}
		else
		{
			$sort_order = $pafiledb_config['sort_order'];
		}

		// =======================================================
		// If user not allowed to view file listing (read) and there is no sub Category
		// or the user is not allowed to view these category we gave him a nice message.
		// =======================================================s

		$pafiledb_auth = pafiledb_auth(PA_AUTH_READ, $cat_id, $userdata, $cat_rowset);

		$check_sub_cat = get_sub_category($cat_id, '', $cat_rowset);

		if( (!$pafiledb_auth['auth_read']) && (empty($check_sub_cat)) )
		{
			if ( !$userdata['session_logged_in'] )
			{
				redirect(append_sid("login.$phpEx?redirect=dload.$phpEx?action=category&cat_id=" . $cat_id, true));
			}
			
			$message = sprintf($lang['Sorry_auth_view'], $pafiledb_auth['auth_read_type']);
			message_die(GENERAL_MESSAGE, $message);
		}
		
		unset($check_sub_cat);

		$sql = "SELECT cat_id 
			FROM " . PA_CATEGORY_TABLE . " 
			WHERE cat_id = '" . $cat_id . "'";

		if ( !($result = pafiledb_sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Couldnt Query category info', '', __LINE__, __FILE__, $sql);
		}

		if(!$category = $db->sql_fetchrow($result))
		{
			message_die(GENERAL_MESSAGE, $lang['Cat_not_exist']);	
		}
		
		$db->sql_freeresult($result);

		//===================================================
		// assign var for naviagation
		//===================================================
		generate_category_nav($cat_id);
		$pafiledb_template->assign_vars(array(
			'L_INDEX' => sprintf($lang['Forum_Index'], $board_config['sitename']),

			'U_INDEX' => append_sid('index.'.$phpEx),
			'U_DOWNLOAD' => append_sid('dload.'.$phpEx),

			'DOWNLOAD' => $pafiledb_config['settings_dbname'])
		);

		$sql = "SELECT cat_id 
			FROM " . PA_CATEGORY_TABLE . " 
			WHERE cat_parent = '" . $cat_id . "'";

		if ( !($result = pafiledb_sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Couldnt Query category info for parent categories', '', __LINE__, __FILE__, $sql);
		}

		$row_number = $db->sql_numrows($result);
		
		$db->sql_freeresult($result);

		$no_file_message = TRUE;

		$filelist = FALSE;

		if ($row_number > 0) 
		{
			$no_file_message = FALSE;
			
			include($phpbb_root_path . 'pafiledb/includes/functions_display.'.$phpEx);
			category_display($cat_id);
		}

		//===================================================
		// Pinned file (sticky)
		//===================================================

		for ($i = 0; $i < count($file_rowset); $i++) 
		{
			if($file_rowset[$i]['file_pin'] == FILE_PINNED && $file_rowset[$i]['file_catid'] == $cat_id)
			{
				//===================================================
				// Format the date for the given file
				//===================================================

				$date = create_date($board_config['default_dateformat'], $file_rowset[$i]['file_time'], $board_config['board_timezone']);

				//===================================================
				// Get rating for the file and format it
				//===================================================

				$rating = get_rating($file_rowset[$i]['file_id']);

				//===================================================
				// If the file is new then put a new image in front of it
				//===================================================
		
				$is_new = FALSE;
				if (time() - ($pafiledb_config['settings_newdays'] * 24 * 60 * 60) < $file_rowset[$i]['file_time'])
				{
					$is_new = TRUE;
				}
		
				//===================================================
				// Assign Vars
				//===================================================

				$pafiledb_template->assign_block_vars("file_rows", array(
					'L_NEW_FILE' => $lang['New_file'],

					'U_FILE' => append_sid('dload.'.$phpEx.'?action=file&file_id=' . $file_rowset[$i]['file_id']),

					'PIN_IMAGE' => $images['folder_sticky'],
					'FILE_NEW_IMAGE' => $images['pa_file_new'],
					'HAS_SCREENSHOTS' => (!empty($file_rowset[$i]['file_ssurl'])) ? TRUE : FALSE,
					'SS_AS_LINK' => ($file_rowset[$i]['file_sshot_link']) ? TRUE : FALSE,
					'FILE_SCREENSHOT' => $file_rowset[$i]['file_ssurl'],
					'IS_NEW_FILE' => $is_new,
					'FILE_NAME' => $file_rowset[$i]['file_name'],
					'FILE_DESC' => $file_rowset[$i]['file_desc'],
					'DATE' => $date,
					'RATING' => $rating,
					'FILE_DLS' => $file_rowset[$i]['file_dls'])
				);
				$filelist = TRUE;
			}
		}

		//======================================================
		// Get all info for the file inside this category
		//======================================================

		$limit_sql = ($start == 0) ? $pafiledb_config['settings_file_page'] : $start .','. $pafiledb_config['settings_file_page'];

		switch(SQL_LAYER)
		{
			case 'oracle':
				$sql = "SELECT f1.*, r.votes_file, AVG(r.rate_point) AS rating, COUNT(r.votes_file) AS total_votes, u.user_id, u.username 
					FROM " . PA_FILES_TABLE . " AS f1, " . PA_VOTES_TABLE . " AS r, " . USERS_TABLE . " AS u
					WHERE f1.file_id = r.votes_file(+)
					AND f1.user_id = u.user_id(+)
					AND f1.file_pin <> '" . FILE_PINNED . "' 
					AND f1.file_approved = '1' 
					AND f1.file_catid = '$cat_id' 
					GROUP BY f1.file_id 
					ORDER BY $sort_method $sort_order 
					LIMIT $limit_sql";			
				break;

			default:
				$sql = "SELECT f1.*, r.votes_file, AVG(r.rate_point) AS rating, COUNT(r.votes_file) AS total_votes, u.user_id, u.username
					FROM " . PA_FILES_TABLE . " AS f1 
					LEFT JOIN " . PA_VOTES_TABLE . " AS r ON f1.file_id = r.votes_file 
					LEFT JOIN ". USERS_TABLE ." AS u ON f1.user_id = u.user_id
					WHERE f1.file_pin <> '" . FILE_PINNED . "' 
					AND f1.file_approved = '1' 
					AND f1.file_catid = '$cat_id' 
					GROUP BY f1.file_id 
					ORDER BY $sort_method $sort_order 
					LIMIT $limit_sql";
				break;
		}

		if ( !($result = pafiledb_sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Couldnt get file info for this category', '', __LINE__, __FILE__, $sql);
		}
		while( $file_row = $db->sql_fetchrow($result) )
		{
			$pafiledb_auth = pafiledb_auth(PA_AUTH_READ, $file_row['file_catid'], $userdata, $cat_rowset);
			if($pafiledb_auth['auth_read'])
			{
				$file_rowset_pin[] = $file_row;
			}
		}

		//======================================================
		// Get number of files inside this category
		//======================================================

		$sql = "SELECT file_catid, file_pin, file_approved, file_id 
			FROM " . PA_FILES_TABLE . " 
			WHERE file_catid = '$cat_id' 
			AND file_approved='1'";

		if ( !($res = pafiledb_sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Couldnt Query number of files', '', __LINE__, __FILE__, $sql);
		}

		$total_file = $db->sql_numrows($res);

		for ($i = 0; $i < count($file_rowset_pin); $i++) 
		{
			//===================================================
			// Format the date for the given file
			//===================================================

			$date = create_date($board_config['default_dateformat'], $file_rowset_pin[$i]['file_time'], $board_config['board_timezone']);
		
			//===================================================
			// Get rating for the file and format it
			//===================================================

			$rating = ($file_rowset_pin[$i]['rating'] != 0) ? round($file_rowset_pin[$i]['rating'], 2) . ' / 10' : $lang['Not_rated'];

			//===================================================
			// If the file is new then put a new image in front of it
			//===================================================
		
			$is_new = FALSE;
			if (time() - ($pafiledb_config['settings_newdays'] * 24 * 60 * 60) < $file_rowset_pin[$i]['file_time'])
			{
				$is_new = TRUE;
			}
		
			//===================================================
			// Get the post icon fot this file
			//===================================================

			if ($file_rowset_pin[$i]['file_posticon'] == 'none' || $file_rowset_pin[$i]['file_posticon'] == 'none.gif') 
			{
				$posticon = 'pafiledb/images/spacer.gif';
			} 
			else 
			{
				$posticon = ICONS_DIR . $file_rowset_pin[$i]['file_posticon'];
			}

			//===================================================
			// Assign Vars
			//===================================================

			$pafiledb_template->assign_block_vars("file_rows", array(
				'L_NEW_FILE' => $lang['New_file'],

				'PIN_IMAGE' => $posticon,
				'FILE_NEW_IMAGE' => $images['pa_file_new'],
				'HAS_SCREENSHOTS' => (!empty($file_rowset_pin[$i]['file_ssurl'])) ? TRUE : FALSE,
				'SS_AS_LINK' => ($file_rowset_pin[$i]['file_sshot_link']) ? TRUE : FALSE,
				'FILE_SCREENSHOT' => $file_rowset_pin[$i]['file_ssurl'],

				'IS_NEW_FILE' => $is_new,
				'U_FILE' => append_sid('dload.'.$phpEx.'?action=file&file_id=' . $file_rowset_pin[$i]['file_id']),
				'FILE_NAME' => $file_rowset_pin[$i]['file_name'],
				'FILE_DESC' => $file_rowset_pin[$i]['file_desc'],
				'DATE' => $date,
				'RATING' => $rating,
				'FILE_DLS' => $file_rowset_pin[$i]['file_dls'])
			);
			$filelist = TRUE;
		}

		if ($filelist) 
		{
			$pafiledb_template->assign_vars(array(
				'L_RATING' => $lang['DlRating'],
				'L_DOWNLOADS' => $lang['Dls'],
				'L_DATE' => $lang['Date'],
				'L_NAME' => $lang['Name'],
				'L_FILE' => $lang['File'],
				'L_UPDATE_TIME' => $lang['Update_time'],
				'L_SCREENSHOTS' => $lang['Scrsht'],

				'L_SELECT_SORT_METHOD' => $lang['Select_sort_method'],
				'L_ORDER' => $lang['Order'],
				'L_SORT' => $lang['Sort'],

				'L_ASC' => $lang['Sort_Ascending'],
				'L_DESC' => $lang['Sort_Descending'],
		
				'SORT_NAME' => ($sort_method == 'file_name') ? 'selected="selected"' : '',
				'SORT_TIME' => ($sort_method == 'file_time') ? 'selected="selected"' : '',
				'SORT_RATING' => ($sort_method == 'rating') ? 'selected="selected"' : '',
				'SORT_DOWNLOADS' => ($sort_method == 'file_dls') ? 'selected="selected"' : '',
				'SORT_UPDATE_TIME' => ($sort_method == 'file_update_time') ? 'selected="selected"' : '',

				'SORT_ASC' => ($sort_order == 'ASC') ? 'selected="selected"' : '',
				'SORT_DESC' => ($sort_order == 'DESC') ? 'selected="selected"' : '',
				'PAGINATION' => generate_pagination(append_sid("dload.$phpEx?action=category&amp;cat_id=$cat_id&amp;sort_method=$sort_method&amp;sort_order=$sort_order"), $total_file, $pafiledb_config['settings_file_page'], $start),
				'PAGE_NUMBER' => sprintf($lang['Page_of'], ( floor( $start / $pafiledb_config['settings_file_page'] ) + 1 ), ceil( $total_file / $pafiledb_config['settings_file_page'] )),
				'FILELIST' => $filelist,
				'ID' => $cat_id,
				'START' => $start,

				'S_ACTION_SORT' => append_sid("dload.$phpEx?action=category&amp;cat_id=$cat_id")) 
			);
		}
		else 
		{
			$pafiledb_template->assign_vars(array(
				'NO_FILE' => $no_file_message,
				'L_NO_FILES' => $lang['No_files'],
				'L_NO_FILES_CAT' => $lang['No_files_cat']) 
			);
		}
		$this->output($lang['Download'], 'pa_category_body.tpl');
	}
}
?>
