<?php
define('IN_PHPBB', true);
$phpbb_root_path = './../../';
include($phpbb_root_path . 'extension.inc');
include($phpbb_root_path . 'common.'.$phpEx);

//
// Start session management
//
$userdata = session_pagestart($user_ip, PAGE_DOWNLOAD);
init_userprefs($userdata);
//
// End session management
//


if( isset($HTTP_GET_VARS['type']) )
{
	switch ($HTTP_GET_VARS['type'])
	{
		case 'bars':
			$type = 'bars';
			break;
		case 'lines':
			$type = 'lines';
			break;
		case 'area':
			$type = 'area';
			break;
		case 'linepoints':
			$type = 'linepoints';
			break;
		case 'points':
			$type = 'points';
			break;
		default:
			$type = 'bars';
	}
}
else if( isset($HTTP_POST_VARS['type']) )
{
	switch ($HTTP_POST_VARS['type'])
	{
		case 'bars':
			$type = 'bars';
			break;
		case 'lines':
			$type = 'lines';
			break;
		case 'area':
			$type = 'area';
			break;
		case 'linepoints':
			$type = 'linepoints';
			break;
		case 'points':
			$type = 'points';
			break;
		default:
			$type = 'bars';
	}
}
else
{
	$type = 'bars';
}


//===================================================
// Include the common file
//===================================================

include($phpbb_root_path . 'pafiledb/pafiledb_common.'.$phpEx);
include($phpbb_root_path . 'pafiledb/includes/function_stats.'.$phpEx);

$graph = new Chart;

$graph->SetImageSize(500, 400);
$graph->SetTitleFont($phpbb_root_path . 'pafiledb/includes/Verdana.ttf');
$graph->SetFont($phpbb_root_path . 'pafiledb/includes/Verdana.ttf');
$graph->SetFileFormat('png');
$graph->SetBackgroundColor('#F0F0F0');
$graph->SetChartBackgroundColor('#E5E5E5');
$graph->SetMaxStringSize(9);
$graph->SetChartBorderColor('#000000');
$graph->SetChartType($type);
$graph->SetChartTitleSize(14);
$graph->SetChartTitle($lang['Chart_header']);
$graph->SetChartTitleColor('#000000');
$graph->SetFontColor('#000000');
$graph->SetBarColor(array('#006699', '#DD6900'));
$graph->SetBarBorderColor(array('#000000'));
$graph->SetLegend(array($lang['Chart_legend']));
$graph->SetLegendPosition(2);
$graph->SetTitleAxisX($lang['X_label']);
$graph->SetTitleAxisY($lang['Y_label']);
$graph->SetAxisFontSize(12);
$graph->SetAxisColor('#000000');
$graph->SetAxisTitleSize(9);
$graph->SetTickLength(2);
$graph->SetTickInterval(6);
$graph->SetGridX(6);
$graph->SetGridY(0);
$graph->SetGridColor('#FFFFFF');
$graph->SetLineThickness(1);
$graph->SetPointSize(2); 
$graph->SetPointShape('dots');
$graph->SetShading(0);
$graph->SetNoData('Sorry, No Data available');

$months = array(31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31);

if( Date('y', time()) % 4 == 0 )
{
	$months[1] = 28;
}

for($j = 11; $j >= 0; $j--)
{
	$index = $j % 11;
	$day_time = (time()-(60 * 60 * 24 * $months[$index] * $j));
	$day_date = Date('Y-m', $day_time);
	$file_num = 0;
	for($i = 0; $i < count($file_rowset); $i++)
	{
		$file_date = Date('Y-m', $file_rowset[$i]['file_time']);
		if( $file_date == $day_date )
		{
			$file_num++;
		}
	}
	$data[$j] = array(Date('Y-m', $day_time), $file_num);
}

$graph->SetDataValues($data);
$graph->DrawGraph();
?>
