<?php
/***************************************************************************
 *                                functions_display.php
 *                            -------------------
 *   begin                : Saturday, Feb 23, 2001
 *   copyright            : (C) 2001 The phpBB Group
 *   email                : support@phpbb.com
 *
 *   $Id: common.php,v 1.74.2.5 2002/12/17 23:59:37 psotfx Exp $
 *
 *
 ***************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 ***************************************************************************/
 
 
function category_display($cat_id = PA_ROOT_CAT)
{
	global $db, $pafiledb_template, $lang, $userdata, $phpEx, $images;
	global $pafiledb_config, $board_config, $cat_rowset, $total_cat, $file_rowset;

	$pafiledb_template->assign_vars(array(
		'CAT_PARENT' => TRUE,
		'L_SUB_CAT' => $lang['Sub_category'],
		'L_CATEGORY' => $lang['Category'],
		'L_LAST_FILE' => $lang['Last_file'],
		'L_FILES' => $lang['Files'])
	); 

	//output the root level category that allow file
		
	for($i = 0; $i < $total_cat; $i++)
	{
		if( ($cat_rowset[$i]['cat_parent'] == $cat_id) && ($cat_rowset[$i]['cat_allow_file'] == PA_CAT_ALLOW_FILE) )
		{
			$last_file_info = array();
			last_file_in_cat($cat_rowset[$i]['cat_id'], '', $last_file_info, $cat_rowset, $file_rowset);

			if(!empty($last_file_info['file_id']))
			{
				$last_file_time = create_date($board_config['default_dateformat'], $last_file_info['file_time'], $board_config['board_timezone']);
				$last_file = '<a href="' . append_sid("dload.php?action=file&file_id=" . $last_file_info['file_id']) . '">' . $last_file_info['file_name'] . '</a> ';
				$last_file .= '<a href="' . append_sid("dload.php?action=file&file_id=" . $last_file_info['file_id']) . '"><img src="' . $images['icon_latest_reply'] . '" border="0" alt="' . $lang['View_latest_file'] . '" title="' . $lang['View_latest_file'] . '" /></a><br />';
				$last_file .= $last_file_time;
			}
			else
			{
				$last_file = $lang['No_file'];
			}
			$is_new = FALSE;
			if(new_file_in_cat($cat_rowset[$i]['cat_id'], 0, $cat_rowset, $file_rowset))
			{
				$is_new = TRUE;
			}

			$sub_cat = get_sub_category($cat_rowset[$i]['cat_id'], '', $cat_rowset);

			$pafiledb_template->assign_block_vars("no_cat_parent", array(
				'IS_HIGHER_CAT' => FALSE,
				'U_CAT' => append_sid("dload.php?action=category&cat_id=" . $cat_rowset[$i]['cat_id']),
				'SUB_CAT' => ( !empty($sub_cat) ) ? $sub_cat : $lang['None'],
				'CAT_IMAGE' => ($is_new) ? $images['folder_new'] : $images['folder'],
				'CAT_NEW_FILE' => ($is_new) ? $lang['New_file'] : $lang['No_new_file'],
				'CAT_NAME' => $cat_rowset[$i]['cat_name'],
				'FILECAT' => file_in_cat($cat_rowset[$i]['cat_id'], 0, $cat_rowset, $file_rowset),
				'LAST_FILE' => $last_file,
				'CAT_DESC' => $cat_rowset[$i]['cat_desc'])
			);
		}
	}

	for($i = 0; $i < $total_cat; $i++)
	{
		$total_sub_cat = 0;
		for($j = 0; $j < $total_cat; $j++)
		{
			if(($cat_rowset[$j]['cat_allow_file'] == PA_CAT_ALLOW_FILE) && ($cat_rowset[$j]['cat_parent'] == $cat_rowset[$i]['cat_id']))
			{				
				$sub_cat_rowset[$total_sub_cat] = $cat_rowset[$j];
				$total_sub_cat++; 
			}
		}
		
		if(($cat_rowset[$i]['cat_allow_file'] != PA_CAT_ALLOW_FILE) && ($cat_rowset[$i]['cat_parent'] == $cat_id))
		{	
			if($total_sub_cat)
			{
				$pafiledb_template->assign_block_vars("no_cat_parent", array(
					'IS_HIGHER_CAT' => TRUE,
					'U_CAT' => append_sid("dload.php?action=category&cat_id=" . $cat_rowset[$i]['cat_id']),
					'CAT_NAME' => $cat_rowset[$i]['cat_name'] . $count)
				);
			}
			for($k = 0; $k < $total_sub_cat; $k++)
			{
				$last_file_info = array();
				last_file_in_cat($sub_cat_rowset[$k]['cat_id'], '', $last_file_info, $cat_rowset, $file_rowset);

				if ($sub_cat_rowset[$k]['cat_parent'] == $cat_rowset[$i]['cat_id'])
				{
					if(!empty($last_file_info['file_id']))
					{
						$last_file_time = create_date($board_config['default_dateformat'], $last_file_info['file_time'], $board_config['board_timezone']);
						$last_file = $last_file_time . '<br />';
						$last_file .= '<a href="' . append_sid("dload.php?action=file&file_id=" . $last_file_info['file_id']) . '">' . $last_file_info['file_name'] . '</a> ';
						$last_file .= '<a href="' . append_sid("dload.php?action=file&file_id=" . $last_file_info['file_id']) . '"><img src="' . $images['icon_latest_reply'] . '" border="0" alt="' . $lang['View_latest_file'] . '" title="' . $lang['View_latest_file'] . '" /></a>';
					}
					else
					{
						$last_file = $lang['No_file'];
					}

					$is_new = FALSE;

					if(new_file_in_cat($sub_cat_rowset[$k]['cat_id'], 0, $cat_rowset, $file_rowset))
					{
						$is_new = TRUE;
					}

					$sub_cat = get_sub_category($sub_cat_rowset[$k]['cat_id'], '', $cat_rowset);

					$pafiledb_template->assign_block_vars("no_cat_parent", array(
						'IS_HIGER_CAT' => FALSE,
						'U_CAT' => append_sid("dload.php?action=category&cat_id=" . $sub_cat_rowset[$k]['cat_id']),
						'SUB_CAT' => ( !empty($sub_cat) ) ? $sub_cat : $lang['None'],
						'CAT_IMAGE' => ($is_new) ? $images['folder_new'] : $images['folder'],
						'CAT_NEW_FILE' => ($is_new) ? $lang['New_file'] : $lang['No_new_file'],
						'CAT_NAME' => $sub_cat_rowset[$k]['cat_name'],
						'FILECAT' => file_in_cat($sub_cat_rowset[$k]['cat_id'], 0, $cat_rowset, $file_rowset),
						'LAST_FILE' => $last_file,
						'CAT_DESC' => $sub_cat_rowset[$k]['cat_desc'])
					);
				} // Have a permission to view the category
			} // It is not parent category
		}
	} //higher Category
}

?>