<?php
/*
  paFileDB 3.0
  2001/2002 PHP Arena
  Written by Todd
  todd@phparena.net
  http://www.phparena.net
  Keep all copyright links on the script visible
  Please read the license included with this script for more information.
*/

if ( !defined('IN_PHPBB') )
{
	die("Hacking attempt");
}
//===================================================
// This function used to get the jump menu for 
// both admin in ACP, and user in the download pages
// $pageurl will handle current page url
// $type will handle if the function will used in admin interface or user interface
// $default if there is a catgeory must be selected you should send an array for it
//===================================================

function jumpmenu($pageurl, $type = 'jump', $default = '', $mode = 'cat', $check_upload = false)
{
	global $db, $lang;

	switch ($type)
	{
		default:
		case 'jump':
		{
			$cache = jumpmenu_option(0, 0, 'jump', '');

			$out .=  '<form name="form1">'
			.'<select name="menu1" onChange="MM_jumpMenu(\'parent\',this,0)" class="forminput">'
			.'<option value="' . $pageurl . '" selected="selected">' . $lang['jump'] . '</option>'
			.'<option value="' . $pageurl . '">---------</option>';

			$out .= $cache;

			$out .= '</select></form>';

			return $out;
			break;
		}

		case 'admin':
		{
			$out = jumpmenu_option(0, 0, 'admin', $default, $mode, $check_upload);

			return $out;

			break;
		}
	}
}
//===================================================
//This function related to the above function
//===================================================

function jumpmenu_option($par, $depth, $type = 'jump', $default = '', $mode = 'cat', $check_upload = false)
{
	global $db, $lang, $userdata;

	static $cats = false;

	if (!is_array($cats))
	{
		$sql =  'SELECT * 
			FROM ' . PA_CATEGORY_TABLE . ' 
			ORDER BY cat_order ASC';

		if ( !($result = pafiledb_sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Couldnt Query Jump Menu', '', __LINE__, __FILE__, $sql);
		}

		while ($cat = $db->sql_fetchrow($result))
		{
			$pafiledb_auth = pafiledb_auth(PA_AUTH_ALL, $cat['cat_id'], $userdata, $cat);
			if(!$check_upload)
			{
				if($pafiledb_auth['auth_view'])
				{
					$cats[$cat['cat_id']] = $cat;
				}
			}
			else
			{
				if($pafiledb_auth['auth_view'] && $pafiledb_auth['auth_upload'])
				{
					$cats[$cat['cat_id']] = $cat;
				}
			}
		}
		
		$db->sql_freeresult($result);
	}

	$out = '';

	$pre = str_repeat('&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;', $depth);

	$meow = $cats; // whatever, it works...
	if(!empty($meow))
	{
		foreach ($meow as $cat)
		{
			if ($cat['cat_parent'] == $par)
			{
				switch ($type)
				{
					default:

					case 'jump':
					{
						$cat_pre = (!$cat['cat_allow_file']) ? '+ ' : '- ';
						$out .= '<option value="' . append_sid('dload.php?action=category&amp;cat_id=' . $cat['cat_id']) . '">' . $pre . $cat_pre .$cat['cat_name'] . "</option>\n"
						.jumpmenu_option($cat['cat_id'], ($depth + 1), 'jump', $default);

						break;
					}

					case 'admin':
					{
						if (is_array($default))
						{
							if (isset($default[$cat['cat_id']]))
							{
								$sel = ' selected="selected"';
							}
							else
							{
								$sel = '';
							}
						}

						$cat_pre = (!$cat['cat_allow_file']) ? '+ ' : '- ';
						$cat_id = ($mode == 'cat') ? ( (!$cat['cat_allow_file']) ? -1 : $cat['cat_id'] ) : $cat['cat_id'];
						$cat_class = (!$cat['cat_allow_file']) ? 'class="greyed"' : '';
						$out .= '<option value="' . $cat_id . '"' . $sel . ' ' . $cat_class . ' />' . $pre . $cat_pre . $cat['cat_name'] . '</option>'
                        .jumpmenu_option($cat['cat_id'], ($depth + 1), 'admin', $default, $mode, $check_upload);

						break;
					}
				}
			}
		}
		return $out;
	}
	else
	{
		return;
	}
}

//===================================================
// you can use this function to get sub category inside category
//===================================================

function get_sub_category($cat_id, $cat_sub, $cat_rowset = '')
{
	global $db, $lang, $userdata;
	
	if(empty($cat_rowset))
	{
		$sql = "SELECT c1.* 
			FROM " . PA_CATEGORY_TABLE . " as c1
			WHERE cat_parent = '" . $cat_id . "'
			ORDER BY c1.cat_order ASC";
	
		if ( !($cat_result = pafiledb_sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Couldnt Query Jump Menu', '', __LINE__, __FILE__, $sql);
		}
		
		while( $row = $db->sql_fetchrow($cat_result) )
		{
			$pafiledb_auth = pafiledb_auth(PA_AUTH_ALL, $row['cat_id'], $userdata, $row);
			if($pafiledb_auth['auth_view'])
			{
				$cat_rowset[] = $row;
				$total_cat++;
			}
		}

		$db->sql_freeresult($result);
	}
	
	$cat_sub .= '';
	
	for ($i = 0; $i < count($cat_rowset); $i++)
	{
		if($cat_rowset[$i]['cat_parent'] == $cat_id && $cat_rowset[$i]['cat_allow_file'])	
		{
			$cat_sub .= '<a href="' . append_sid("dload.php?action=category&cat_id=" . $cat_rowset[$i]['cat_id']) . '">' . $cat_rowset[$i]['cat_name'] . '</a>, ';
		}
		
		if($cat_rowset[$i]['cat_parent'] == $cat_id && !$cat_rowset[$i]['cat_allow_file'])
		{
			for ($j = 0; $j < count($cat_rowset); $j++)
			{
				if($cat_rowset[$j]['cat_parent'] == $cat_rowset[$i]['cat_id'] && $cat_rowset[$j]['cat_allow_file'])
				{
					$cat_sub .= '<a href="' . append_sid("dload.php?action=category&cat_id=" . $cat_rowset[$j]['cat_id']) . '">' . $cat_rowset[$j]['cat_name'] . '</a>, ';
				}
			}
		}
	}
	
	return (!empty($cat_sub)) ? $cat_sub : '';
}

//===================================================
//This function is used to get last file added to certain category
//===================================================


function last_file_in_cat($cat_id, $last_file, &$file_info, $cat_rowset, $file_rowset)
{
	global $db, $lang, $userdata;

	for($i = 0; $i < count($file_rowset); $i++)
	{		
		if($file_rowset[$i]['file_catid'] == $cat_id)
		{
			if(empty($last_file))
			{
				$last_file = $file_rowset[$i]['file_time'];
				$file_info = $file_rowset[$i];
			}		

			if(!empty($last_file) && $file_rowset[$i]['file_time'] > $last_file)
			{
				$last_file = $file_rowset[$i]['file_time'];
				$file_info = $file_rowset[$i];
			}
		}
	}

	for($i = 0; $i < count($cat_rowset); $i++)	
	{
		if($cat_rowset[$i]['cat_parent'] == $cat_id)
		{
			$last_file = last_file_in_cat($cat_rowset[$i]['cat_id'], $last_file, $file_info, $cat_rowset, $file_rowset);
		}
	}
	return $last_file;
}
//===================================================
// generate navigation for unlimited sub category using recursion
//===================================================

/*function category_nav($cat_id, $cat_nav, $cat_rowset)
{
	global $db;

	$check_cat = FALSE;
	
	for($i = 0; $i < count($cat_rowset); $i++)
	{
		if($cat_rowset[$i]['cat_id'] == $cat_id)
		{
			$cat = $cat_rowset[$i];
			$check_cat = TRUE;
			break;
		}
	}
	
	if($check_cat)
	{
		$cat_nav .= category_nav($cat['cat_parent'], $cat_nav, $cat_rowset);
		$cat_nav .= ' -> <a href="' . append_sid("dload.php?action=category&cat_id=" . $cat['cat_id']) . '" class="nav">' . $cat['cat_name'] . '</a> ';
	}
	
	return $cat_nav;
}*/

function generate_category_nav($cat_id)
{
	global $cat_rowset, $db, $pafiledb_template;

	for($i = 0; $i < count($cat_rowset); $i++)
	{	
		if($cat_rowset[$i]['cat_id'] == $cat_id)
		{
			$cat = $cat_rowset[$i];
			$check_cat = TRUE;
			if($cat_rowset[$i]['parents_data'] == '')
			{
				$cat_nav = array();
				category_nav($cat_rowset[$i]['cat_parent'], &$cat_nav, $cat_rowset);				
				$sql = 'UPDATE ' . PA_CATEGORY_TABLE . "
					SET parents_data = '" . serialize($cat_nav) . "'
					WHERE cat_parent = " . $cat_rowset[$i]['cat_parent'];
				if ( !(pafiledb_sql_query($sql)) )
				{
					message_die(GENERAL_ERROR, 'Couldnt Query categories info', '', __LINE__, __FILE__, $sql);
				}
			}
			else
			{
				$cat_nav = unserialize($cat_rowset[$i]['parents_data']);
			}
			break;
		}
	}
	
	foreach ($cat_nav as $parent_cat_id => $parent_name)
	{
		$pafiledb_template->assign_block_vars('navlinks', array(
			'CAT_NAME'	=>	$parent_name,
			'U_VIEW_CAT'	=>	append_sid('dload.php?action=category&cat_id=' . $parent_cat_id))
		);
	}

	$pafiledb_template->assign_block_vars('navlinks', array(
		'CAT_NAME'	=>	$cat['cat_name'],
		'U_VIEW_CAT'	=>	append_sid('dload.php?action=category&cat_id=' . $cat['cat_id']))
	);
	
}


function category_nav($parent_id, &$cat_nav, $cat_rowset)
{
	$check_cat = FALSE;
	
	for($i = 0; $i < count($cat_rowset); $i++)
	{
		if($cat_rowset[$i]['cat_id'] == $parent_id)
		{
			$cat = $cat_rowset[$i];
			$check_cat = TRUE;
			break;
		}
	}
	
	if($check_cat)
	{
		category_nav($cat['cat_parent'], &$cat_nav, $cat_rowset);
		$cat_nav[$cat['cat_id']] = $cat['cat_name'];
	}	
	return;
}

//===================================================
// calculate number of files inside certain category using recursion
//===================================================

function file_in_cat($cat_id, $files_no, $cat_rowset, $file_rowset)
{
	global $db, $userdata;
	
	$file_no = 0;

	for($i = 0; $i < count($file_rowset); $i++)
	{
		if($file_rowset[$i]['file_catid'] == $cat_id)
		{
			$file_no++;
		}
	}
	$files_no += $file_no;

	for($i = 0; $i < count($cat_rowset); $i++)	
	{
		if($cat_rowset[$i]['cat_parent'] == $cat_id)
		{
			$files_no = file_in_cat($cat_rowset[$i]['cat_id'], $files_no, $cat_rowset, $file_rowset);
		}
	}
	
	return ($files_no);
	
}

//===================================================
// check if there is a new file inside certain category using recursion
//===================================================

function new_file_in_cat($cat_id, $files_new, $cat_rowset, $file_rowset)
{
	global $db, $pafiledb_config, $userdata;

	for($i = 0; $i < count($file_rowset); $i++)
	{
		if($file_rowset[$i]['file_catid'] == $cat_id)
		{
			if (time() - ($pafiledb_config['settings_newdays'] * 24 * 60 * 60) < $file_rowset[$i]['file_time'])
			{
				$files_new++;
			}
		}
	}

	for($i = 0; $i < count($cat_rowset); $i++)
	{
		if($cat_rowset[$i]['cat_parent'] == $cat_id)
		{
			$files_new = new_file_in_cat($cat_rowset[$i]['cat_id'], $files_new, $cat_rowset, $file_rowset);
		}
	}
	
	return ($files_new);
	
}

//===================================================
// this funciton is used to parase comments text for url and images
// and perform operation on them according to your option in admin settings
//===================================================

function comment_suite($comments_text)
{
	global $pafiledb_config;
	
	// Start Remove images/links in comments text
	if ( $comments_text != "" )
	{	
		if($pafiledb_config['allow_comment_images'] == 0)
		{
			$no_image_message = $pafiledb_config['no_comment_image_message'];
			if(preg_match('/(<img src=)(.+?)(\>)/i', $comments_text))
			{
				$comments_text = preg_replace('/(<img src=)(.+?)(\>)/i', $no_image_message, $comments_text); 
			}
			
			if(preg_match('/(\[img\])([^\[]*)(\[\/img\])/i', $comments_text))
			{
				$sig = preg_replace('/(\[img\])([^\[]*)(\[\/img\])/i', $no_image_message, $comments_text); 
			}
		}
		
		if($pafiledb_config['allow_comment_links'] == 0)
		{
			$no_link_message = $pafiledb_config['no_comment_link_message'];
			
			if(preg_match('/(\[url=(.*?)\])([^\[]*)(\[\/url\])/i', $comments_text))
			{
				$comments_text = preg_replace('/(\[url=(.*?)\])([^\[]*)(\[\/url\])/i', $no_link_message, $comments_text); 
			}
			
			if(preg_match('/(\[url\])([^\[]*)(\[\/url\])/i', $comments_text))
			{
				$comments_text = preg_replace('/(\[url\])([^\[]*)(\[\/url\])/i', $no_link_message, $comments_text); 
			}
			
			if (preg_match("#([\n ])http://www\.([a-z0-9\-]+)\.([a-z0-9\-.\~]+)((?:/[^,\t \n\r]*)?)#i", $comments_text) )
			{
				$comments_text = preg_replace("#([\n ])http://www\.([a-z0-9\-]+)\.([a-z0-9\-.\~]+)((?:/[^,\t \n\r]*)?)#i", $no_link_message, $comments_text);
			}

			if (preg_match("#([\n ])www\.([a-z0-9\-]+)\.([a-z0-9\-.\~]+)((?:/[^,\t \n\r]*)?)#i", $comments_text) )
			{
				$comments_text = preg_replace("#([\n ])www\.([a-z0-9\-]+)\.([a-z0-9\-.\~]+)((?:/[^,\t \n\r]*)?)#i", $no_link_message, $comments_text);
			}
		}
	}
	return $comments_text;
}

//===================================================
// Upload file function
//===================================================

function upload_file($userfile, $userfile_name, $userfile_size, $MAX_FILE_SIZE, $upload_dir = UPLOAD_DIR)
{
	global $phpbb_root_path, $lang, $phpEx, $board_config;
	
	$file_info = array();
	
	$file_info['error'] = FALSE;
	
	if (file_exists($phpbb_root_path . $upload_dir . $userfile_name)) 
	{	
		$file_info['error'] = TRUE;
		$file_info['message'] .= $lang['Uploaderror'];
	}
			
	// =======================================================
	// if the file size is more than the allowed size another error message
	// =======================================================
			
	if ($userfile_size > $MAX_FILE_SIZE)
	{
		$file_info['error'] = TRUE;
		if(!empty($file_info['message']))
		{
			$file_info['message'] .= '<br>';
		}
		$file_info['message'] .= $lang['Filetoobig'];
	}

	// =======================================================
	// Then upload the file, and check the php version
	// =======================================================

	else 
	{
		$ini_val = ( @phpversion() >= '4.0.0' ) ? 'ini_get' : 'get_cfg_var';

		if ( @$ini_val('open_basedir') != '' )
		{
			if ( @phpversion() < '4.0.3' )
			{
				message_die(GENERAL_ERROR, 'open_basedir is set and your PHP version does not allow move_uploaded_file<br /><br />Please contact your server admin', '', __LINE__, __FILE__);
			}

			$move_file = 'move_uploaded_file';
		}
		else
		{
			$move_file = 'copy';
		}

		@$move_file($userfile, $phpbb_root_path . $upload_dir . $userfile_name);

		$file_info['url'] = get_formated_url() . '/' . $upload_dir . $userfile_name;

		@chmod($phpbb_root_path . UPLOAD_DIR . $userfile_name, 0777);
	}
	return $file_info;
}

//===================================================
// get pafiledb general settings
//===================================================

function pafiledb_config() 
{
	global $db;

	$sql = "SELECT * 
		FROM " . PA_CONFIG_TABLE;

	if ( !($result = pafiledb_sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Couldnt query Download configuration', '', __LINE__, __FILE__, $sql);
	}
	
	while ($row = $db->sql_fetchrow($result))
	{
		$pafiledb_config[$row['config_name']] = trim($row['config_value']);
	}

	$db->sql_freeresult($result);

	return ($pafiledb_config);
}

//===================================================
// sql query for pafiledb to count the microtime
//===================================================

function pafiledb_sql_query($query)
{
	global $db, $dbms, $pafiledb_num_queries;

	$pafiledb_num_queries++;
	
	if ( defined('PAFILEDB_QUERY_DEBUG') )
	{
		global $pafiledb_sql_report, $pafiledb_sql_time, $starttime;
		$curtime = explode(' ', microtime());
		$curtime = $curtime[0] + $curtime[1] - $starttime;
	}

	$pafiledb_result = $db->sql_query($query);

	if ( defined('PAFILEDB_QUERY_DEBUG') )
	{
		$endtime = explode(' ', microtime());
		$endtime = $endtime[0] + $endtime[1] - $starttime;

		$pafiledb_sql_report .= "<pre>Query:\t" . preg_replace('/[\s]*[\n\r\t]+[\n\r\s\t]*/', "\n\t", $query) . "\n\n";
		$affected_rows = $db->sql_affectedrows($result);
		if ($pafiledb_result)
		{
			$attach_sql_report .= "Time before:  $curtime\nTime after:   $endtime\nElapsed time: <b>" . ($endtime - $curtime) . "</b>\n</pre>";
		}
		else
		{
			$error = $db->sql_error();
			$pafiledb_sql_report .= '<b>FAILED</b> - MySQL Error ' . $error['code'] . ': ' . $error['message'] . '<br><br><pre>';
		}
		$pafiledb_sql_time += $endtime - $curtime;

		if (($dbms == 'mysql') || ($dbms == 'mysql4'))
		{
			if (preg_match('/^SELECT/', $query))
			{
				$html_table = FALSE;
				if ($result = mysql_query("EXPLAIN $query", $db->db_connect_id))
				{
					$i = 0;
					while ($row = mysql_fetch_assoc($result))
					{
						$extra = array_pop($row);
						if (!$html_table && count($row))
						{
							$html_table = TRUE;
							$pafiledb_sql_report .= "<table width=100% border=1 cellpadding=2 cellspacing=1>\n";
							$pafiledb_sql_report .= "<tr>\n<td><b>" . implode("</b></td>\n<td><b>", array_keys($row));
							$pafiledb_sql_report .= "</b></td>\n<td><b>affected_rows";
							$pafiledb_sql_report .= "</b></td>\n<td><b>Extra"	. "</b></td>\n</tr>\n";
						}
						$pafiledb_sql_report .= "<tr>\n<td>" . implode("&nbsp;</td>\n<td>", array_values($row));
						$pafiledb_sql_report .= "&nbsp;</td>\n<td>" . ( ($i == 0) ? $affected_rows : '' );
						$pafiledb_sql_report .= "&nbsp;</td>\n<td>" . $extra . "&nbsp;</td>\n</tr>\n";
						$i++;
					}
				}
				if ($html_table)
				{
					$pafiledb_sql_report .= '</table><br>';
				}
			}
			$pafiledb_sql_report .= "<hr>\n";
		}
	}

	return ($pafiledb_result);
}

//===================================================
//get file size
//===================================================

function get_file_size($file_id, $file = '')
{
	global $db, $lang, $phpbb_root_path;
	
	$directory = UPLOAD_DIR;
	
	if(empty($file))
	{
		$sql = "SELECT file_dlurl 
			FROM " . PA_FILES_TABLE . " 
			WHERE file_id = '" . $file_id . "'";
	
		if ( !($result = pafiledb_sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Couldnt query Download URL', '', __LINE__, __FILE__, $sql);
		}	

		$file = $db->sql_fetchrow($result);

		$db->sql_freeresult($result);
	}

		
	$file_url = $file['file_dlurl'];
	$formated_url = get_formated_url();
	$html_path = $formated_url . '/' . UPLOAD_DIR;
	
	if (substr($file_url, 0, strlen($html_path)) == $html_path)
	{
		$file_url = basename($file_url) ;
		$file_name = basename($file_url);
		if(!file_exists($directory . $file_name))
		{
			$file_size_out = $lang['Not_available'];
			return $file_size_out;
		}
	
		$file_size = @filesize($directory . $file_name);
	
		if ($file_size < 1024)
		{
			$file_size_out = intval($file_size) . ' ' . $lang['Bytes'];
		}
		if ($file_size >= 1025)
		{
			$file_size_out = round(intval($file_size) / 1024 * 100) / 100 . ' ' . $lang['KB'];
		}
		if ($file_size >= 1048575)
		{
			$file_size_out = round(intval($file_size) / 1048576 * 100) / 100 . ' ' . $lang['MB'];
		}
		
		return $file_size_out;
	}
	else
	{
		if(!$file_size = file_size_cache($file_id))
		{
			$ourhead = "";
			$url = parse_url($file_url);
			$host = $url['host']; 
			$path = $url['path']; 
			$port = (!empty($url['port'])) ? $url['port'] : 80;

			$fp = @fsockopen($host, $port, &$errno, &$errstr, 20);
		
			if(!$fp)
			{ 
				return ($file_size_out = $lang['Not_available']);
			}
			else
			{ 
				fputs($fp,"HEAD $file_url HTTP/1.1\r\n"); 
				fputs($fp,"HOST: dummy\r\n"); 
				fputs($fp,"Connection: close\r\n\r\n"); 

				while (!feof($fp))
				{
					$ourhead = sprintf("%s%s", $ourhead, fgets ($fp,128)); 
				}
			} 
			fclose ($fp);

			$split_head = explode("Content-Length: ",$ourhead);
		
			$file_size = round(abs($split_head[1]));
			
			file_size_write_cache($file_id, $file_size);
		}

		if ($file_size < 1024)
		{
			$file_size_out = intval($file_size) . ' ' . $lang['Bytes'];
		}
		if ($file_size >= 1025)
		{
			$file_size_out = round(intval($file_size) / 1024 * 100) / 100 . ' ' . $lang['KB'];
		}
		if ($file_size >= 1048575)
		{
			$file_size_out = round(intval($file_size) / 1048576 * 100) / 100 . ' ' . $lang['MB'];
		}

		return $file_size_out;
	}
}


//===================================================
// if the file size is cached then load it.
//===================================================
function file_size_cache($file_id)
{
	$cache_dir = 'pafiledb/cache/files_size/';
	if(file_exists($cache_dir . $file_id . '.txt'))
	{
		$file_size = file($cache_dir . $file_id . '.txt');
		$file_size = implode('', $file_size);
		return $file_size;
	}
	else
	{
		return FALSE;
	}
}

//===================================================
// Write cache for the file size
//===================================================

function file_size_write_cache($file_id, $file_size)
{
	$cache_dir = 'pafiledb/cache/files_size/';

	$file_name = $cache_dir . $file_id . '.txt';

	if ($fp = @fopen($file_name, 'w+'))
	{
		@flock($fp, LOCK_EX);
		@fwrite ($fp, $file_size);
		@flock($fp, LOCK_UN);
		@fclose($fp);

		@umask(0);
		@chmod($filename, 0644);
	}	
}

//===================================================
// get the sub category ids from the root category
//===================================================

function gen_cat_ids($cat_id, $cat_ids, $cat_rowset)
{
	global $db;
	
	for($i = 0; $i < count($cat_rowset); $i++)
	{	
		if($cat_rowset[$i]['cat_parent'] == $cat_id)
		{
			$cat_ids = gen_cat_ids($cat_rowset[$i]['cat_id'], $cat_ids, $cat_rowset);
		}
	}
	
	for($i = 0; $i < count($cat_rowset); $i++)
	{	
		if($cat_rowset[$i]['cat_id'] == $cat_id)
		{
			$cat_ids .= ( ( $cat_ids != '' ) ? ', ' : '' ) . $cat_id;
		}
	}
	
	return $cat_ids;
}

//===================================================
// get rating
//===================================================
function get_rating($file_id, $file_rating = '')
{
	global $db, $lang;
	
	$sql = "SELECT AVG(rate_point) AS rating 
		FROM " . PA_VOTES_TABLE . " 
		WHERE votes_file = '" . $file_id . "'";
	
	if(!($result = pafiledb_sql_query($sql)))
	{
		message_die(GENERAL_ERROR, 'Couldnt rating info for the giving file', '', __LINE__, __FILE__, $sql);
	}

	$row = $db->sql_fetchrow($result);
	$db->sql_freeresult($result);
	$file_rating = $row['rating'];

	return ($file_rating != 0) ? round($file_rating, 2) . ' / 10' : $lang['Not_rated'];
}

//===================================================
// since that I can't use the original function with new template system
// I just copy it and chagne it
//===================================================
function pa_generate_smilies($mode, $page_id)
{
	global $db, $board_config, $pafiledb_template, $lang, $images, $theme, $phpEx, $phpbb_root_path;
	global $user_ip, $session_length, $starttime;
	global $userdata;

	$inline_columns = 4;
	$inline_rows = 5;
	$window_columns = 8;

	if ($mode == 'window')
	{
		$userdata = session_pagestart($user_ip, $page_id);
		init_userprefs($userdata);

		$gen_simple_header = TRUE;

		$page_title = $lang['Review_topic'] . " - $topic_title";
		include($phpbb_root_path . 'includes/page_header.'.$phpEx);

		$pafiledb_template->set_filenames(array(
			'smiliesbody' => 'posting_smilies.tpl')
		);
	}

	$sql = "SELECT emoticon, code, smile_url   
		FROM " . SMILIES_TABLE . " 
		ORDER BY smilies_id";
	if ($result = $db->sql_query($sql))
	{
		$num_smilies = 0;
		$rowset = array();
		while ($row = $db->sql_fetchrow($result))
		{
			if (empty($rowset[$row['smile_url']]))
			{
				$rowset[$row['smile_url']]['code'] = str_replace("'", "\\'", str_replace('\\', '\\\\', $row['code']));
				$rowset[$row['smile_url']]['emoticon'] = $row['emoticon'];
				$num_smilies++;
			}
		}

		if ($num_smilies)
		{
			$smilies_count = ($mode == 'inline') ? min(19, $num_smilies) : $num_smilies;
			$smilies_split_row = ($mode == 'inline') ? $inline_columns - 1 : $window_columns - 1;

			$s_colspan = 0;
			$row = 0;
			$col = 0;

			while (list($smile_url, $data) = @each($rowset))
			{
				if (!$col)
				{
					$pafiledb_template->assign_block_vars('smilies_row', array());
				}

				$pafiledb_template->assign_block_vars('smilies_row.smilies_col', array(
					'SMILEY_CODE' => $data['code'],
					'SMILEY_IMG' => $board_config['smilies_path'] . '/' . $smile_url,
					'SMILEY_DESC' => $data['emoticon'])
				);

				$s_colspan = max($s_colspan, $col + 1);

				if ($col == $smilies_split_row)
				{
					if ($mode == 'inline' && $row == $inline_rows - 1)
					{
						break;
					}
					$col = 0;
					$row++;
				}
				else
				{
					$col++;
				}
			}

			if ($mode == 'inline' && $num_smilies > $inline_rows * $inline_columns)
			{
				$pafiledb_template->assign_block_vars('switch_smilies_extra', array());

				$pafiledb_template->assign_vars(array(
					'L_MORE_SMILIES' => $lang['More_emoticons'], 
					'U_MORE_SMILIES' => append_sid("posting.$phpEx?mode=smilies"))
				);
			}

			$pafiledb_template->assign_vars(array(
				'L_EMOTICONS' => $lang['Emoticons'], 
				'L_CLOSE_WINDOW' => $lang['Close_window'], 
				'S_SMILIES_COLSPAN' => $s_colspan)
			);
		}
	}

	if ($mode == 'window')
	{
		$pafiledb_template->display('smiliesbody');

		include($phpbb_root_path . 'includes/page_tail.'.$phpEx);
	}
}

//===================================================
// Delete a file
//===================================================
function pafiledb_unlink($filename, $mode = FALSE)
{
	global $pafiledb_config, $lang;

	$deleted = @unlink($filename);

	if (@file_exists(@phpbb_realpath($filename)) ) 
	{
		$filesys = eregi_replace('/','\\', $filename);
		$deleted = @system("del $filesys");

		if (@file_exists(@phpbb_realpath($filename))) 
		{
			$deleted = @chmod ($filename, 0775);
			$deleted = @unlink($filename);
			$deleted = @system("del $filesys");
		}
	}

	return ($deleted);
}

//===================================================
// Similar to phpbb realpath
//===================================================
function pafiledb_realpath($path)
{
	global $phpbb_root_path, $phpEx;

	return (!@function_exists('realpath') || !@realpath($phpbb_root_path . 'includes/functions.'.$phpEx)) ? $path : @realpath($path);
}

//===================================================
// get the board url according to the setting in the database
//===================================================
function get_formated_url()
{
	global $board_config;
	
	$server_protocol = ($board_config['cookie_secure']) ? 'https://' : 'http://';
	$server_name = preg_replace('#^\/?(.*?)\/?$#', '\1', trim($board_config['server_name']));
	$server_port = ($board_config['server_port'] <> 80) ? ':' . trim($board_config['server_port']) : '';
	$script_name = preg_replace('#^\/?(.*?)\/?$#', '\1', trim($board_config['script_path']));
	$script_name = ($script_name == '') ? $script_name : '/' . $script_name;
	$formated_url = $server_protocol . $server_name . $server_port . $script_name;
	
	return $formated_url;
}

//===================================================
// Page header for pafiledb
//===================================================

function pafiledb_page_header($page_title)
{
	global $pafiledb_config, $lang, $pafiledb_template, $images;
	
	$pafiledb_template->assign_vars(array(
		'VIEW_ALL_FILES' => ($pafiledb_config['settings_viewall']) ? TRUE : FALSE,

		'L_OPTIONS' => $lang['Options'],
		'L_SEARCH' => $lang['Search'],
		'L_STATS' => $lang['Statistics'],
		'L_TOPLIST' => $lang['Toplist'],
		'L_UPLOAD' => $lang['User_upload'],
		'L_VIEW_ALL' => $lang['Viewall'],
		
		'SEARCH_IMG' => $images['pa_search'],
		'STATS_IMG' => $images['pa_stats'],
		'TOPLIST_IMG' => $images['pa_toplist'],
		'UPLOAD_IMG' => $images['pa_upload'],
		'VIEW_ALL_IMG' => $images['pa_viewall'],

		'U_TOPLIST' => append_sid("dload.php?action=toplist"),
		'U_PASEARCH' => append_sid("dload.php?action=search"),
		'U_UPLOAD' => append_sid("dload.php?action=user_upload"),
		'U_VIEW_ALL' => append_sid("dload.php?action=viewall"),
		'U_PASTATS' => append_sid("dload.php?action=stats"))
	);

}
//===================================================
// page footer for pafiledb 
//===================================================
function pafiledb_page_footer()
{
	global $pafiledb_config, $lang, $pafiledb_template, $board_config, $userdata;
	global $starttime, $pafiledb_sql_time, $pafiledb_sql_report, $pafiledb_num_queries;

	$pafiledb_template->assign_vars(array(
		'JUMPMENU' => jumpmenu('dload.php', 'jump', ''),
		'S_TIMEZONE' => sprintf($lang['All_times'], $lang[number_format($board_config['board_timezone'])]))
	);
	
	$pafiledb_template->display('body');

	if ( PAFILEDB_DEBUG )
	{
		$mtime = explode(' ', microtime());
		$totaltime = $mtime[0] + $mtime[1] - $starttime;

		if ( defined('PAFILEDB_QUERY_DEBUG') )
		{
			if ($pafiledb_sql_time > 0)
			{
				$fp = fopen('pafiledb/explain/e' . $userdata['user_id'] . '.html', 'wt');
				fwrite($fp, $pafiledb_sql_report);
				$str = "<pre><b>pafiledb generated " . $pafiledb_num_queries . " queries,\nspending " . $pafiledb_sql_time . ' doing MySQL queries and ' . ($totaltime - $pafiledb_sql_time) . ' doing PHP things.</b></pre>';
				fwrite($fp, $str);
				fclose($fp);
				@chmod('pafiledb/explain/e' . $userdata['user_id'] . '.html', 0777);
			}
		}

		$debug_output = '<center><font size="-2">pafiledb - [ ';
	
		if ( defined('PAFILEDB_QUERY_DEBUG') )
		{
			$debug_output .= sprintf(' Time : %.3fs | ', $pafiledb_sql_time);
		}
	
		$debug_output .= $pafiledb_num_queries . ' Queries ';

		if ( defined('PAFILEDB_QUERY_DEBUG') )
		{
			$debug_output .= ' | <a href="pafiledb/explain/e' . $userdata['user_id'] . '.html" target="_blank">Explain</a>';		
		}

		$debug_output .= ' ]</font></center>';

		print $debug_output;
	}
}

//=========================================
// This class is used to determin Browser and operating system info of the user
//
//  Copyright (c) 2002 Chip Chapin <cchapin@chipchapin.com>
//                     http://www.chipchapin.com
//  All rights reserved.
//=========================================


class User_info
{
	var $agent = 'unknown';
	var $ver = 0;
	var $majorver = 0;
	var $minorver = 0;
	var $platform = 'unknown';

	function get_agent()
	{
		return $this->agent;
	}
	
	
	function get_version()
	{ 
		return $this->ver;
	}

	function get_platform()
	{
		return $this->platform;
	}
	
	function is_mac()
	{
		return $this->platform == 'Mac';
	}
	
	// function is_windows()   { return $this->platform == 'Win'; }
	function is_win()
	{
		return $this->platform == 'Win';
	}
	
	function is_ie()
	{
		return $this->agent == 'IE';
	}
	
	function is_ie3()
	{
		return $this->is_ie() && $this->majorver < 4;
	}

	function is_ie4()
	{
		return $this->is_ie() && $this->majorver == 4;
	}
	
	function is_ie5up()
	{
		return $this->is_ie() && $this->majorver >= 5;
	}
	
	// function is_netscape()  { return $this->agent == 'MOZILLA'; }
	function is_moz()
	{
		return $this->agent == 'MOZILLA';
	}
	
	// function is_netscape4() { return $this->agent == 'MOZILLA' && $this->majorver <= 4; }
	function is_moz4dn()
	{
		return $this->agent == 'MOZILLA' && $this->majorver <= 4;
	}
	
	function is_moz5()
	{
		return $this->agent == 'MOZILLA' && $this->majorver == 5;
	}
	
	function is_moz5up()
	{
		return $this->agent == 'MOZILLA' && $this->majorver >= 5;
	}

	// function is_winNN()     { return ($this->is_windows() && $this->is_netscape());}
	function is_winNN()
	{
		return ($this->is_win() && $this->is_moz4dn());
	}
	
	function is_macNN()
	{
		return ($this->is_mac() && $this->is_moz4dn());
	}
	

	/* Constructor
	 Determine client browser type, version and platform using
	 heuristic examination of user agent string.
	 @param $user_agent allows override of user agent string for testing.
	*/
	
	function User_info( $user_agent = '' )
	{
		global $_SERVER, $HTTP_USER_AGENT, $HTTP_SERVER_VARS;
		
		if (!empty($_SERVER['HTTP_USER_AGENT'])) 
		{
			$HTTP_USER_AGENT = $_SERVER['HTTP_USER_AGENT'];
		} 
		else if (!empty($HTTP_SERVER_VARS['HTTP_USER_AGENT'])) 
		{
			$HTTP_USER_AGENT = $HTTP_SERVER_VARS['HTTP_USER_AGENT'];
		}
		else if (!isset($HTTP_USER_AGENT))
		{
			$HTTP_USER_AGENT = '';
		}
		
		if (empty($user_agent))
		{
			$user_agent = $HTTP_USER_AGENT;
		}
	
		$user_agent = strtolower($user_agent);

		// Determine browser and version
		// The order in which we test the agents patterns is important
		// Intentionally ignore Konquerer.  It should show up as Mozilla.
		// post-Netscape Mozilla versions using Gecko show up as Mozilla 5.0
	
		if (preg_match( '/(opera |opera\/)([0-9]*).([0-9]{1,2})/', $user_agent, $matches)) ;
		elseif (preg_match( '/(msie )([0-9]*).([0-9]{1,2})/', $user_agent, $matches)) ;
		elseif (preg_match( '/(mozilla\/)([0-9]*).([0-9]{1,2})/', $user_agent, $matches)) ;
		else
		{
			$matches[1] = 'unknown'; 
			$matches[2] = 0; 
			$matches[3] = 0;
		}
		
		$this->majorver = $matches[2];
		$this->minorver = $matches[3];
		$this->ver = $matches[2] . '.' . $matches[3];
	
		switch ($matches[1]) 
		{
			case 'opera/':
			case 'opera ':
				$this->agent = 'OPERA'; 
				break;
	
			case 'msie ':
				$this->agent = 'IE'; 
				break;

			case 'mozilla/':
				$this->agent = 'NETSCAPE'; 
				if($this->majorver >= 5)
				{
					$this->agent = 'MOZILLA';
				}
				break;
			
			case 'unknown':
				$this->agent = 'OTHER';
				break;

			default:
				$this->agent = 'Oops!';
		}

    
		// Determine platform
		// This is very incomplete for platforms other than Win/Mac
	
		if (preg_match( '/(win|mac|linux|unix)/', $user_agent, $matches));
		else $matches[1] = 'unknown';
	
		switch ($matches[1])
		{
			case 'win':
				$this->platform = 'Win';
				break;

			case 'mac':
				$this->platform = 'Mac';
				break;

			case 'linux':
				$this->platform = 'Linux';
				break;

			case 'unix':
				$this->platform = 'Unix';
				break;

			case 'unknown':
				$this->platform = 'Other';
				break;

			default:
				$this->platform = 'Oops!';
		}
	}
	
	function update_downloader_info($file_id)
	{
		global $user_ip, $db, $userdata;
		
		$where_sql = ( $userdata['user_id'] != ANONYMOUS ) ? "user_id = '" . $userdata['user_id'] . "'" : "downloader_ip = '" . $user_ip . "'";
		
		$sql = "SELECT user_id, downloader_ip 
			FROM " . PA_DOWNLOAD_INFO_TABLE . " 
			WHERE $where_sql";
		
		if(!($result = pafiledb_sql_query($sql)))
		{
			message_die(GENERAL_ERROR, 'Couldnt Query User id', '', __LINE__, __FILE__, $sql);
		}
		
		if(!$db->sql_numrows($result))
		{
			$sql = "INSERT INTO " . PA_DOWNLOAD_INFO_TABLE . " (file_id, user_id, downloader_ip, downloader_os, downloader_browser, browser_version) 
						VALUES('" . $file_id . "', '" . $userdata['user_id'] . "', '" . $user_ip . "', '" . $this->platform . "', '" . $this->agent . "', '" . $this->ver . "')";
			if(!(pafiledb_sql_query($sql)))
			{
				message_die(GENERAL_ERROR, 'Couldnt Update Downloader Table Info', '', __LINE__, __FILE__, $sql);
			}
		}

		$db->sql_freeresult($result);
	}
	
	function update_voter_info($file_id, $rating)
	{
		global $user_ip, $db, $userdata, $lang;
		
		$where_sql = ( $userdata['user_id'] != ANONYMOUS ) ? "user_id = '" . $userdata['user_id'] . "'" : "votes_ip = '" . $user_ip . "'";
		
		$sql = "SELECT user_id, votes_ip 
			FROM " . PA_VOTES_TABLE . " 
			WHERE $where_sql
			AND votes_file = '" . $file_id . "'
			LIMIT 1";
		
		if(!($result = pafiledb_sql_query($sql)))
		{
			message_die(GENERAL_ERROR, 'Couldnt Query User id', '', __LINE__, __FILE__, $sql);
		}
		
		if(!$db->sql_numrows($result))
		{
			$sql = "INSERT INTO " . PA_VOTES_TABLE . " (user_id, votes_ip, votes_file, rate_point, voter_os, voter_browser, browser_version) 
						VALUES('" . $userdata['user_id'] . "', '" . $user_ip . "', '" . $file_id . "','" . $rating ."', '" . $this->platform . "', '" . $this->agent . "', '" . $this->ver . "')";
			if(!(pafiledb_sql_query($sql)))
			{
				message_die(GENERAL_ERROR, 'Couldnt Update Votes Table Info', '', __LINE__, __FILE__, $sql);
			}
		}
		else
		{
			message_die(GENERAL_MESSAGE, $lang['Rerror']);
		}
		
		$db->sql_freeresult($result);
	}	
}
?>
