<?php
/*
  paFileDB 3.0
  2001/2002 PHP Arena
  Written by Todd
  todd@phparena.net
  http://www.phparena.net
  Keep all copyright links on the script visible
  Please read the license included with this script for more information.
*/


$cancel = ( isset($HTTP_POST_VARS['cancel']) ) ? TRUE : 0;

$confirm = ( isset($HTTP_POST_VARS['confirm']) ) ? TRUE : 0;


if(!$pafiledb_auth['auth_view_comment'])
{
	$message = sprintf($lang['Sorry_auth_view_comments'], $pafiledb_auth['auth_view_comment_type']);
	message_die(GENERAL_MESSAGE, $message);
}

if ( isset($HTTP_GET_VARS['file_id']) || isset($HTTP_POST_VARS['file_id']) )
{
	$file_id = ( isset($HTTP_GET_VARS['file_id']) ) ? intval($HTTP_GET_VARS['file_id']) : intval($HTTP_POST_VARS['file_id']);
}

if ( isset($HTTP_GET_VARS['cid']) || isset($HTTP_POST_VARS['cid']) )
{
	$cid = ( isset($HTTP_GET_VARS['cid']) ) ? intval($HTTP_GET_VARS['cid']) : intval($HTTP_POST_VARS['cid']);
}

if ( isset($HTTP_GET_VARS['delete']) || isset($HTTP_POST_VARS['delete']) )
{
	$delete = ( isset($HTTP_GET_VARS['delete']) ) ? $HTTP_GET_VARS['delete'] : $HTTP_POST_VARS['delete'];
}

include_once($phpbb_root_path . 'includes/bbcode.'.$phpEx);

//
// Define censored word matches
//

$orig_word = array();

$replacement_word = array();

obtain_word_list($orig_word, $replacement_word);

if ($cancel)
{
	redirect(append_sid("dload.php?action=file&file_id=" . $file_id, true));
}

if ($delete == 'do') 
{
	if( $userdata['user_level'] != ADMIN )
	{
		message_die(GENERAL_MESSAGE, $lang['Not_admin']);
	}
	else
	{

		if ( !$confirm )
		{

			$s_hidden_fields =  '<input type="hidden" name="action" value="file" /><input type="hidden" name="cid" value="' . $cid . '" /><input type="hidden" name="file_id" value="' . $file_id . '" /><input type="hidden" name="delete" value="do" />';

			include($phpbb_root_path . 'includes/page_header.'.$phpEx);

			$pafiledb_template->set_filenames(array(
				'confirm_body' => 'confirm_body.tpl')
			);

			$pafiledb_template->assign_vars(array(
				'MESSAGE_TITLE' => $lang['Information'],
				'MESSAGE_TEXT' =>  $lang['Confirm_delete_pm'],

				'L_YES' => $lang['Yes'],
				'L_NO' => $lang['No'],

				'S_CONFIRM_ACTION' => append_sid("dload.$phpEx"),
				'S_HIDDEN_FIELDS' => $s_hidden_fields)
			);

			$pafiledb_template->pparse('confirm_body');

			include($phpbb_root_path . 'includes/page_tail.'.$phpEx);
		}

		if ( $confirm )
		{ 
			$sql = "DELETE FROM " . PA_COMMENTS_TABLE . " WHERE comments_id = " . $cid;

			if ( !(pafiledb_sql_query($sql)) )
			{
				message_die(GENERAL_ERROR, 'Couldnt delete this comment', '', __LINE__, __FILE__, $sql);
			}

			$pafiledb_template->assign_vars(array(
				"META" => '<meta http-equiv="refresh" content="3;url='  .append_sid("dload.php?action=file&id=" . $file_id) . '">')
			);

			$message = $lang['Comment_deleted'] . "<br /><br />" . sprintf($lang['Click_return'], "<a href=\"" . append_sid("dload.php?action=file&id=" . $id) . "\">", "</a>");

			message_die(GENERAL_MESSAGE, $message);
		}
	}
}

$pafiledb_template->assign_vars(array(
	'L_COMMENTS' => $lang['Comments']) 
);

$sql = "SELECT * 
	FROM " . PA_COMMENTS_TABLE . " 
	WHERE file_id = '" . $file_id . "'";

if ( !($comment = pafiledb_sql_query($sql)) )
{
	message_die(GENERAL_ERROR, 'Couldnt select comments', '', __LINE__, __FILE__, $sql);
}

if (!($comment_number = $db->sql_numrows($comment)))
{
	$pafiledb_template->assign_vars(array(
		'L_NO_COMMENTS' => $lang['No_comments'],

		'NO_COMMENTS' => TRUE) 
	);
}

$sql = "SELECT *
	FROM " . RANKS_TABLE . "
	ORDER BY rank_special, rank_min";
if ( !($result = pafiledb_sql_query($sql)) )
{
	message_die(GENERAL_ERROR, "Could not obtain ranks information.", '', __LINE__, __FILE__, $sql);
}

$ranksrow = array();
while ( $row = $db->sql_fetchrow($result) )
{
	$ranksrow[] = $row;
}
$db->sql_freeresult($result);

while ($r = $db->sql_fetchrow($comment)) 
{
	extract ($r);
      
	$time = create_date($board_config['default_dateformat'], $comments_time, $board_config['board_timezone']);

	if ( !$pafiledb_config['allow_html'] )
	{
		if ( $comments_text != '' && $userdata['user_allowhtml'] )
		{
			$comments_text = comment_suite($comments_text); 

			$comments_text = preg_replace('#(<)([\/]?.*?)(>)#is', "&lt;\\2&gt;", $comments_text);
		}      
	}

	if ( $pafiledb_config['allow_bbcode'] )
	{
		if ( $comments_text != '' && $comment_bbcode_uid != '' )
		{
			$comments_text = comment_suite($comments_text);

			$comments_text = ( $pafiledb_config['allow_bbcode'] ) ? bbencode_second_pass($comments_text, $comment_bbcode_uid) : preg_replace('/\:[0-9a-z\:]+\]/si', ']', $comments_text);
		}    
	}

	$comments_text = comment_suite($comments_text);

	$comments_text = make_clickable($comments_text);

   	if ( count($orig_word) )
	{
		if ( $comments_text != '' )
		{
			$comments_text = preg_replace($orig_word, $replacement_word, $comments_text);
		}
	}

	if ( $pafiledb_config['allow_smilies'] )
	{
		if ( $userdata['user_allowsmile'] && $comments_text != '' )
		{
			$comments_text = smilies_pass($comments_text);
		}
	}

	$comments_poster = get_userdata(intval($poster_id));

	$poster = ( $comments_poster['user_id'] == ANONYMOUS ) ? $lang['Guest'] : $comments_poster['username'];

	$poster_posts = ( $comments_poster['user_id'] != ANONYMOUS ) ? $lang['Posts'] . ': ' . $comments_poster['user_posts'] : '';

	$poster_from = ( $comments_poster['user_from'] && $comments_poster['user_id'] != ANONYMOUS ) ? $lang['Location'] . ': ' . $comments_poster['user_from'] : '';

	$poster_joined = ( $comments_poster['user_id'] != ANONYMOUS ) ? $lang['Joined'] . ': ' . create_date($lang['DATE_FORMAT'], $comments_poster['user_regdate'], $board_config['board_timezone']) : '';

	$poster_avatar = '';
	if ( $comments_poster['user_avatar_type'] && $poster_id != ANONYMOUS && $comments_poster['user_allowavatar'] )
	{
		switch( $comments_poster['user_avatar_type'] )
		{
			case USER_AVATAR_UPLOAD:
				$poster_avatar = ( $board_config['allow_avatar_upload'] ) ? '<img src="' . $board_config['avatar_path'] . '/' . $comments_poster['user_avatar'] . '" alt="" border="0" />' : '';
				break;
			case USER_AVATAR_REMOTE:
				$poster_avatar = ( $board_config['allow_avatar_remote'] ) ? '<img src="' . $comments_poster['user_avatar'] . '" alt="" border="0" />' : '';
				break;
			case USER_AVATAR_GALLERY:
				$poster_avatar = ( $board_config['allow_avatar_local'] ) ? '<img src="' . $board_config['avatar_gallery_path'] . '/' . $comments_poster['user_avatar'] . '" alt="" border="0" />' : '';
				break;
		}
	}
 
	//
	// Generate ranks, set them to empty string initially.
	//
	$poster_rank = '';
	$rank_image = '';
	if ( $comments_poster['user_id'] == ANONYMOUS )
	{
	}
	else if ( $comments_poster['user_rank'] )
	{
		for($j = 0; $j < count($ranksrow); $j++)
		{
			if ( $comments_poster['user_rank'] == $ranksrow[$j]['rank_id'] && $ranksrow[$j]['rank_special'] )
			{
				$poster_rank = $ranksrow[$j]['rank_title'];
				$rank_image = ( $ranksrow[$j]['rank_image'] ) ? '<img src="' . $ranksrow[$j]['rank_image'] . '" alt="' . $poster_rank . '" title="' . $poster_rank . '" border="0" /><br />' : '';
			}
		}
	}
	else
	{
		for($j = 0; $j < count($ranksrow); $j++)
		{
			if ( $comments_poster['user_posts'] >= $ranksrow[$j]['rank_min'] && !$ranksrow[$j]['rank_special'] )
			{
				$poster_rank = $ranksrow[$j]['rank_title'];
				$rank_image = ( $ranksrow[$j]['rank_image'] ) ? '<img src="' . $ranksrow[$j]['rank_image'] . '" alt="' . $poster_rank . '" title="' . $poster_rank . '" border="0" /><br />' : '';
			}
		}
	}

	$comments_text = str_replace("\n", "\n<br />\n", $comments_text);

	$pafiledb_template->assign_block_vars("text", array(
		"POSTER" => $poster,
		"U_COMMENT_DELETE" => ( $pafiledb_auth['auth_delete_comment'] ) ? append_sid("dload.php?action=file&cid=$comments_id&delete=do&id=$file_id") : '',
		'AUTH_COMMENT_DELETE' => ( $pafiledb_auth['auth_delete_comment'] ) ? TRUE : FALSE,
		'POSTER_RANK' => $poster_rank,
		'RANK_IMAGE' => $rank_image,
		'POSTER_JOINED' => $poster_joined,
		'POSTER_POSTS' => $poster_posts,
		'POSTER_FROM' => $poster_from,
		'POSTER_AVATAR' => $poster_avatar,
		"TITLE" => $comments_title,
		"TIME" => $time,
		"TEXT" => $comments_text) 
	);
}

$db->sql_freeresult($comment);

$reply_img = $images['pa_comment_post'];

$pafiledb_template->assign_vars(array(
	'REPLY_IMG' => ( $pafiledb_auth['auth_post_comment'] ) ? $reply_img : '',
	'AUTH_POST' => ( $pafiledb_auth['auth_post_comment'] ) ? TRUE : FALSE,
	'L_COMMENT_DO' => ( $pafiledb_auth['auth_post_comment'] ) ? $lang['Comment_do'] : '',
	'L_COMMENTS' => $lang['Comments'],
	'L_AUTHOR' => $lang['Author'],
	'L_POSTED' => $lang['Posted'],
	'L_COMMENT_SUBJECT' => $lang['Comment_subject'],
	'L_COMMENT_ADD' => $lang['Comment_add'],
	'L_COMMENT_DELETE' => $lang['Comment_delete'],
	'L_COMMENTS_NAME' => $lang['Name'],
	'L_BACK_TO_TOP' => $lang['Back_to_top'],
	'U_COMMENT_DO' => append_sid("dload.php?action=post_comment&file_id=$file_id"),
	'ID' => $file_id)
);

?>
