<?php
/***************************************************************************
 *                                 auth.php
 *                            -------------------                         
 *   begin                : Saturday, Feb 13, 2001 
 *   copyright            : (C) 2001 The phpBB Group        
 *   email                : support@phpbb.com                           
 *                                                          
 *   $Id: auth.php,v 1.37.2.2 2002/12/22 18:46:26 psotfx Exp $                                                           
 *                                                            
 * 
 ***************************************************************************/ 

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 ***************************************************************************/

/*
	$type's accepted (pre-pend with AUTH_):
	VIEW, READ, POST, REPLY, EDIT, DELETE, STICKY, ANNOUNCE, VOTE, POLLCREATE

	Possible options ($type/forum_id combinations):

	* If you include a type and forum_id then a specific lookup will be done and
	the single result returned

	* If you set type to AUTH_ALL and specify a forum_id an array of all auth types
	will be returned

	* If you provide a forum_id a specific lookup on that forum will be done

	* If you set forum_id to PA_AUTH_LIST_ALL and specify a type an array listing the
	results for all forums will be returned

	* If you set forum_id to PA_AUTH_LIST_ALL and type to AUTH_ALL a multidimensional
	array containing the auth permissions for all types and all forums for that
	user is returned

	All results are returned as associative arrays, even when a single auth type is
	specified.

	If available you can send an array (either one or two dimensional) containing the
	forum auth levels, this will prevent the auth function having to do its own
	lookup
*/
function pafiledb_auth($type, $cat_id, $userdata, $c_access = '')
{
	global $db, $lang;

	switch( $type )
	{
		case PA_AUTH_ALL:
			$a_sql = 'a.auth_view, a.auth_read, a.auth_view_file, a.auth_upload, a.auth_download, a.auth_rate, a.auth_email, a.auth_view_comment, a.auth_post_comment, a.auth_edit_comment, a.auth_delete_comment';
			$auth_fields = array('auth_view', 'auth_read', 'auth_view_file', 'auth_upload', 'auth_download', 'auth_rate', 'auth_email', 'auth_view_comment', 'auth_post_comment', 'auth_edit_comment', 'auth_delete_comment');
			break;
		case PA_AUTH_VIEW:
			$a_sql = 'a.auth_view';
			$auth_fields = array('auth_view');
			break;
		case PA_AUTH_READ:
			$a_sql = 'a.auth_read';
			$auth_fields = array('auth_read');
			break;
		case PA_AUTH_VIEW_FILE:
			$a_sql = 'a.auth_view_file';
			$auth_fields = array('auth_view_file');
			break;
		case PA_AUTH_UPLOAD:
			$a_sql = 'a.auth_upload';
			$auth_fields = array('auth_upload');
			break;
		case PA_AUTH_DOWNLOAD:
			$a_sql = 'a.auth_download';
			$auth_fields = array('auth_download');
			break;
		case PA_AUTH_RATE:
			$a_sql = 'a.auth_rate';
			$auth_fields = array('auth_rate');
			break;
		case PA_AUTH_EMAIL:
			$a_sql = 'a.auth_email';
			$auth_fields = array('auth_email');
			break;			
		case PA_AUTH_COMMENT_VIEW:
			$a_sql = 'a.auth_view_comment';
			$auth_fields = array('auth_view_comment');
			break;
		case PA_AUTH_COMMENT_POST:
			$a_sql = 'a.auth_post_comment';
			$auth_fields = array('auth_post_comment');
			break;

		case PA_AUTH_COMMENT_EDIT:
			$a_sql = 'a.auth_edit_comment';
			$auth_fields = array('auth_edit_comment');
			break;
		case PA_AUTH_COMMENT_DELETE:
			$a_sql = 'a.auth_delete_comment';
			$auth_fields = array('auth_delete_comment');
			break;
		default:
			break;
	}

	//
	// If c_access has been passed, or auth is needed to return an array of forums
	// then we need to pull the auth information on the given forum (or all forums)
	//
	if ( empty($c_access) )
	{
		$cat_match_sql = ( $cat_id != PA_AUTH_LIST_ALL ) ? "WHERE a.cat_id = $cat_id" : '';

		$sql = "SELECT a.cat_id, $a_sql
			FROM " . PA_CATEGORY_TABLE . " a
			$cat_match_sql";
		if ( !($result = pafiledb_sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Failed obtaining category access control lists', '', __LINE__, __FILE__, $sql);
		}

		$sql_fetchrow = ( $cat_id != PA_AUTH_LIST_ALL ) ? 'sql_fetchrow' : 'sql_fetchrowset';

		if ( !($c_access = $db->$sql_fetchrow($result)) )
		{
			$db->sql_freeresult($result);
			return array();
		}

		$db->sql_freeresult($result);
	}

	//
	// If the user isn't logged on then all we need do is check if the forum
	// has the type set to ALL, if yes they are good to go, if not then they
	// are denied access
	//
	$u_access = array();
/*	if ( $userdata['session_logged_in'] )
	{
		//$cat_match_sql = ( $cat_id != PA_AUTH_LIST_ALL ) ? "AND a.cat_id = $cat_id" : '';

		$sql = "SELECT a.cat_id, $a_sql, a.auth_mod 
			FROM " . PA_AUTH_ACCESS_TABLE . " a, " . USER_GROUP_TABLE . " ug 
			WHERE ug.user_id = " . $userdata['user_id'] . " 
				AND ug.user_pending = 0 
				AND a.group_id = ug.group_id";
				//$cat_match_sql";
		if ( !($result = pafiledb_sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Failed obtaining category access control lists', '', __LINE__, __FILE__, $sql);
		}

		if ( $row = $db->sql_fetchrow($result) )
		{
			do
			{
				//if ( $cat_id != PA_AUTH_LIST_ALL)
				//{
					$u_access[] = $row;
				//}
				//else
				//{
				//	$u_access[$row['cat_id']][] = $row;
				//}
			}
			while( $row = $db->sql_fetchrow($result) );
		}
	}
*/
	$is_admin = ( $userdata['user_level'] == ADMIN && $userdata['session_logged_in'] ) ? TRUE : 0;

	$auth_user = array();
	for($i = 0; $i < count($auth_fields); $i++)
	{
		$key = $auth_fields[$i];

		//
		// If the user is logged on and the forum type is either ALL or REG then the user has access
		//
		// If the type if ACL, MOD or ADMIN then we need to see if the user has specific permissions
		// to do whatever it is they want to do ... to do this we pull relevant information for the
		// user (and any groups they belong to)
		//
		// Now we compare the users access level against the forums. We assume here that a moderator
		// and admin automatically have access to an ACL forum, similarly we assume admins meet an
		// auth requirement of MOD
		//
		if ( $cat_id != PA_AUTH_LIST_ALL )
		{
			$value = $c_access[$key];

			switch( $value )
			{
				case AUTH_ALL:
					$auth_user[$key] = TRUE;
					$auth_user[$key . '_type'] = $lang['Auth_Anonymous_users'];
					break;

				case AUTH_REG:
					$auth_user[$key] = ( $userdata['session_logged_in'] ) ? TRUE : 0;
					$auth_user[$key . '_type'] = $lang['Auth_Registered_Users'];
					break;

				case AUTH_ACL:
					$auth_user[$key] = ( $userdata['session_logged_in'] ) ? pafiledb_auth_check_user(AUTH_ACL, $key, $u_access, $is_admin) : 0;
					$auth_user[$key . '_type'] = $lang['Auth_Users_granted_access'];
					break;

				case AUTH_MOD:
					$auth_user[$key] = ( $userdata['session_logged_in'] ) ? pafiledb_auth_check_user(AUTH_MOD, 'auth_mod', $u_access, $is_admin) : 0;
					$auth_user[$key . '_type'] = $lang['Auth_Moderators'];
					break;

				case AUTH_ADMIN:
					$auth_user[$key] = $is_admin;
					$auth_user[$key . '_type'] = $lang['Auth_Administrators'];
					break;

				default:
					$auth_user[$key] = 0;
					break;
			}
		}
		else
		{
			for($k = 0; $k < count($c_access); $k++)
			{
				$value = $c_access[$k][$key];
				$c_cat_id = $c_access[$k]['cat_id'];

				switch( $value )
				{
					case AUTH_ALL:
						$auth_user[$c_cat_id][$key] = TRUE;
						$auth_user[$c_cat_id][$key . '_type'] = $lang['Auth_Anonymous_users'];
						break;

					case AUTH_REG:
						$auth_user[$c_cat_id][$key] = ( $userdata['session_logged_in'] ) ? TRUE : 0;
						$auth_user[$c_cat_id][$key . '_type'] = $lang['Auth_Registered_Users'];
						break;

					case AUTH_ACL:
						$auth_user[$c_cat_id][$key] = ( $userdata['session_logged_in'] ) ? pafiledb_auth_check_user(AUTH_ACL, $key, $u_access, $is_admin) : 0;
						$auth_user[$c_cat_id][$key . '_type'] = $lang['Auth_Users_granted_access'];
						break;

					case AUTH_MOD:
						$auth_user[$c_cat_id][$key] = ( $userdata['session_logged_in'] ) ? pafiledb_auth_check_user(AUTH_MOD, 'auth_mod', $u_access, $is_admin) : 0;
						$auth_user[$c_cat_id][$key . '_type'] = $lang['Auth_Moderators'];
						break;

					case AUTH_ADMIN:
						$auth_user[$c_cat_id][$key] = $is_admin;
						$auth_user[$c_cat_id][$key . '_type'] = $lang['Auth_Administrators'];
						break;

					default:
						$auth_user[$c_cat_id][$key] = 0;
						break;
				}
			}
		}
	}

	//
	// Is user a moderator?
	//
//	if ( $cat_id != PA_AUTH_LIST_ALL )
//	{
		$auth_user['auth_mod'] = ( $userdata['session_logged_in'] ) ? pafiledb_auth_check_user(AUTH_MOD, 'auth_mod', $u_access, $is_admin) : 0;
//	}
/*	else
	{
		for($k = 0; $k < count($c_access); $k++)
		{
			$c_cat_id = $c_access[$k]['cat_id'];

			$auth_user[$c_cat_id]['auth_mod'] = ( $userdata['session_logged_in'] ) ? pafiledb_auth_check_user(AUTH_MOD, 'auth_mod', $u_access[$c_cat_id], $is_admin) : 0;
		}
	}*/

	return $auth_user;
}

function pafiledb_auth_check_user($type, $key, $u_access, $is_admin)
{
	$auth_user = 0;

	if ( count($u_access) )
	{
		for($j = 0; $j < count($u_access); $j++)
		{
			$result = 0;
			switch($type)
			{
				case AUTH_ACL:
					$result = $u_access[$j][$key];

				case AUTH_MOD:
					$result = $result || $u_access[$j]['auth_mod'];

				case AUTH_ADMIN:
					$result = $result || $is_admin;
					break;
			}

			$auth_user = $auth_user || $result;
		}
	}
	else
	{
		$auth_user = $is_admin;
	}

	return $auth_user;
}

?>