<?php
/***************************************************************************
 *                               s2s_users.php
 *                            -------------------
 *   begin                : Thursday, Apr 17, 2003
 *   version              : 1.0.0
 *   date                 : 2003/06/08 16:43
 ***************************************************************************/

if ( !defined('IN_PHPBB') || !defined('IN_PRILLIAN') )
{
	die('Hacking attempt');
}

// Session update to delete old sessions
$im_userdata['refresh_rate'] = $board_config['im_refresh_rate'];
im_session_update(true);

$sql = 'SELECT u.username, u.user_id
	FROM ' . USERS_TABLE . ' u, ' . IM_SESSIONS_TABLE . ' s
	WHERE u.user_id = s.session_user_id
		AND u.user_allow_viewonline = 1
	ORDER BY u.username ASC';

if( !($result = $db->sql_query($sql)) )
{
	message_die(GENERAL_ERROR, 'Could not obtain user/online information', '', __LINE__, __FILE__, $sql);
}

$prillian_online = array();
$prev_user_id = 0;

while( $row = $db->sql_fetchrow($result) )
{
	// Skip multiple sessions for one user
	if ( $row['user_id'] != $prev_user_id )
	{
		$prillian_online[] = $row;
		$prev_user_id = $row['user_id'];
	}
}
$db->sql_freeresult($result);


$template->set_filenames(array(
	'body' => 's2s_users_body.tpl')
);

// Send Prillian version number to template
// This will be used in future versions of the basic output of this file changes
$template->assign_vars(array(
	'VERSION' => $board_config['im_version']
));

if ( empty($prillian_online) )
{
	$template->assign_block_vars('switch_user_list', array(
		'ONLINE_USER' => 'None',
		'ONLINE_USERID' => ''
	));
}
else
{
	while (list($key, $value) = each ($prillian_online))
	{
		// We won't show ignored users or ones the person can't contact 

		$template->assign_block_vars('switch_user_list', array(
			'ONLINE_USER' => addslashes($value['username']),
			'ONLINE_USERID' => $value['user_id']
		));
	}
}

$template->pparse('body');
?>