<?php
/***************************************************************************
 *                             functions_im.php
 *                            -------------------
 *   begin                : Tuesday, Nov 19, 2002
 *   version              : 0.6.0
 *   date                 : 2003/06/08 16:39
 ***************************************************************************/

/***************************************************************************
 * This file has been modified by Fully Moddded phpBB
 *
 *   $FMId: 2003/07/23 03:43:12 mj
 *
 ***************************************************************************/

if ( !defined('IN_PHPBB') || !defined('IN_PRILLIAN') )
{
	die('Hacking attempt');
}

define('PRILL_FUN', true);

$phpbb_bid_path = $phpbb_root_path . 'mods/bid/';

if ( !defined('CF_INCLUDED') )
{
	include($phpbb_bid_path . "functions_common.$phpEx");
}

function override_im_settings(&$im_data, $id, $msg)
// Used to set default user IM preferences
{
	global $db, $board_config;

	$im_data = array(
		'user_id' => $id,
		'user_allow_ims' => $board_config['im_allow_ims'],
		'user_allow_shout' => $board_config['im_allow_shout'],
		'user_allow_chat' => $board_config['im_allow_chat'],
		'attach_sig' => 0,
		'refresh_rate' => $board_config['im_refresh_rate'],
		'success_close' => $board_config['im_success_close'],
		'refresh_method' => $board_config['im_refresh_method'],
		'auto_launch' => $board_config['im_auto_launch'],
		'popup_ims' => $board_config['im_popup_ims'],
		'list_ims' => $board_config['im_list_ims'],
		'show_controls' => $board_config['im_show_controls'],
		'list_all_online' => $board_config['im_list_all_online'],
		'win_main_height' => $board_config['im_main_height'],
		'win_main_width' => $board_config['im_main_width'],
		'win_online_height' => $board_config['im_online_height'],
		'win_online_width' => $board_config['im_online_width'],
		'win_read_height' => $board_config['im_read_height'],
		'win_read_width' => $board_config['im_read_width'],
		'win_send_height' => $board_config['im_send_height'],
		'win_send_width' => $board_config['im_send_width'],
		'play_sound' => $board_config['im_allow_sound'],
		'default_sound' => $board_config['im_default_sound'],
		'sound_name' => $board_config['im_sound_name'],
		'themes_id' => $board_config['im_themes_id'],
		's2s_user_list' => $board_config['im_s2s_user_list'],
		'open_pms' => $board_config['im_open_pms'],
		'auto_delete' => $board_config['im_auto_delete']
	);

	$sql = 'SELECT admin_allow_ims, admin_allow_shout, admin_allow_chat, admin_allow_s2s, new_ims, unread_ims, read_ims, total_sent FROM ' . IM_PREFS_TABLE . " WHERE user_id=$id";

	if ( !($result = $db->sql_query($sql)) )
	{
		$msg = 'Could not query IM preferences table for extra info' . $msg;
		message_die(CRITICAL_ERROR, $msg, '', __LINE__, __FILE__, $sql);
	}

	if ( $row = $db->sql_fetchrow($result) )
	{
		$im_data['new_ims'] = $row['new_ims'];
		$im_data['unread_ims'] = $row['unread_ims'];
		$im_data['read_ims'] = $row['read_ims'];
		$im_data['total_sent'] = $row['total_sent'];
		$im_data['admin_allow_ims'] = $row['admin_allow_ims'];
		$im_data['admin_allow_shout'] = $row['admin_allow_shout'];
		$im_data['admin_allow_chat'] = $row['admin_allow_chat'];
		$im_data['admin_allow_s2s'] = $row['admin_allow_s2s'];
	}
}

function init_imprefs($id, $style_setup = false)
// Gets user IM preferences from the database.
{
	global $db, $board_config, $lang, $gen_simple_header, $theme, $template, $images;

	$id = intval($id);
	$im_data = array();

	if( $gen_simple_header )
	{
		$msg = $lang['Close_window_link'];
	}
	else
	{
		$msg = '';
	}

	if( $board_config['im_override_users'] || empty($id) )
	{
		$extra = ( empty($id) || $id == ANONYMOUS ) ?  0: 1;

		// Admin has chosen to override all user settings - let's set defaults
		override_im_settings($im_data, $id, $msg);
	}
	elseif( $id != ANONYMOUS )
	{
		$sql = 'SELECT * FROM ' . IM_PREFS_TABLE . "
				WHERE user_id=$id";

		if ( !($result = $db->sql_query($sql)) )
		{
			// Bad mojo
			$msg = 'Could not query IM preferences table' . $msg;
			message_die(CRITICAL_ERROR, $msg, '', __LINE__, __FILE__, $sql);
		}

		if ( !($im_data = $db->sql_fetchrow($result)) )
		{
			$msg = 'User not found in IM preferences table' . $msg;
			message_die(CRITICAL_ERROR, $msg, '', __LINE__, __FILE__, $sql);
		}
	}

	// Set the style for the IM Client

	if( $style_setup )
	{
		if ( $board_config['im_themes_allow'] )
		{
			if ( $id != ANONYMOUS && $im_data['themes_id'] > 0 )
			{
				if ( $theme = setup_style($im_data['themes_id']) )
				{
					return $im_data;
				}
			}
		}

		$theme = setup_style($board_config['im_themes_id']);
	}

	return $im_data;
}

function auto_close()
// Used for automatically closing a window.
// Page headers & footers are not needed.
{
	global $template, $lang;

	$template->set_filenames(array(
		'autoclose' => 'imclient_autoclose.tpl')
	);

	$template->assign_vars(array(
		'L_NO_AUTOCLOSE' => $lang['No_autoclose'])
	);

	$template->pparse('autoclose');
	exit;
}

function save_a_copy($in_or_out, $to_userdata, $msg_time, $html_on, $bbcode_on, $smilies_on, $attach_sig, $bbcode_uid, $instant_message, $instant_subject, $site_id)
// Saves a copy of an Instant Message in the user's private message Savebox.
{
	global $db, $userdata, $board_config, $user_ip, $lang;

	if( $in_or_out == PRIVMSGS_SAVED_IN_MAIL )
	{
		// It's a received message
		$from_userid = $to_userdata['user_id'];
		$to_userid = $userdata['user_id'];
		$username['type'] = 'privmsgs_from_username';
		$username['name'] = $to_userdata['username'];
	}
	elseif( $in_or_out == PRIVMSGS_SAVED_OUT_MAIL )
	{
		// It's a sent message
		$from_userid = $userdata['user_id'];
		$to_userid = $to_userdata['user_id'];
		$username['type'] = 'privmsgs_to_username';
		$username['name'] = $to_userdata['username'];
	}
	
	//
	// See if user is at their savebox limit
	//
	$sql = 'SELECT COUNT(privmsgs_id) AS savebox_items, MIN(privmsgs_date) AS oldest_post_time 
		FROM ' . PRIVMSGS_TABLE . ' 
		WHERE ( ( privmsgs_to_userid = ' . $userdata['user_id'] . ' 
				AND privmsgs_type = ' . PRIVMSGS_SAVED_IN_MAIL . ' )
			OR ( privmsgs_from_userid = ' . $userdata['user_id'] . ' 
				AND privmsgs_type = ' . PRIVMSGS_SAVED_OUT_MAIL . ') )';
	if ( !($result = $db->sql_query($sql)) )
	{
		$msg = 'Could not obtain sent message info for sender' . $lang['Close_window_link'];
		message_die(GENERAL_ERROR, $msg, '', __LINE__, __FILE__, $sql);
	}

	$sql_priority = ( SQL_LAYER == 'mysql' ) ? 'LOW_PRIORITY' : '';

	if ( $saved_info = $db->sql_fetchrow($result) )
	{
		if ( $saved_info['savebox_items'] >= $board_config['max_savebox_privmsgs'] )
		{
			$sql = 'SELECT privmsgs_id FROM ' . PRIVMSGS_TABLE . ' 
				WHERE ( ( privmsgs_to_userid = ' . $userdata['user_id'] . ' 
							AND privmsgs_type = ' . PRIVMSGS_SAVED_IN_MAIL . ' )
						OR ( privmsgs_from_userid = ' . $userdata['user_id'] . ' 
							AND privmsgs_type = ' . PRIVMSGS_SAVED_OUT_MAIL . ') ) 
					AND privmsgs_date = ' . $saved_info['oldest_post_time'];
			if ( !$result = $db->sql_query($sql) )
			{
				message_die(GENERAL_ERROR, 'Could not find oldest privmsgs (save)', '', __LINE__, __FILE__, $sql);
			}
			$old_privmsgs_id = $db->sql_fetchrow($result);
			$old_privmsgs_id = $old_privmsgs_id['privmsgs_id'];
			
			$sql = "DELETE $sql_priority FROM " . PRIVMSGS_TABLE . " 
				WHERE privmsgs_id = $old_privmsgs_id";
			if ( !$db->sql_query($sql) )
			{
				message_die(GENERAL_ERROR, 'Could not delete oldest privmsgs (save)', '', __LINE__, __FILE__, $sql);
			}

			$sql = "DELETE $sql_priority FROM " . PRIVMSGS_TEXT_TABLE . " 
				WHERE privmsgs_text_id = $old_privmsgs_id";
			if ( !$db->sql_query($sql) )
			{
				message_die(GENERAL_ERROR, 'Could not delete oldest privmsgs text (save)', '', __LINE__, __FILE__, $sql);
			}
		}
	}

	//
	// This makes a copy of the post and stores it as a SAVED message.
	// Perhaps not the most DB friendly way but a lot easier to 
	// manage, besides the admin can set limits on numbers of 
	// storable posts for users. (This part is adapted from
	// saving a copy of a sent message after the message was read)
	//
	if( $site_id )
	{
		$extra_cols = ', ' . $username['type'] . ', site_id';
		$extra_data = ', \'' . str_replace("\'", "''", $username['name']) . '\', ' . $site_id;
	}
	else
	{
		$extra_cols = '';
		$extra_data = '';
	}

	$sql = "INSERT $sql_priority INTO " . PRIVMSGS_TABLE . ' (privmsgs_type, privmsgs_subject, privmsgs_from_userid, privmsgs_to_userid, privmsgs_date, privmsgs_ip, privmsgs_enable_html, privmsgs_enable_bbcode, privmsgs_enable_smilies, privmsgs_attach_sig' . $extra_cols . ")
		VALUES ($in_or_out , '" . str_replace("\'", "''", $instant_subject) . "', $from_userid, $to_userid, $msg_time, '$user_ip', $html_on, $bbcode_on, $smilies_on, $attach_sig" . $extra_data . ')';
	if ( !$db->sql_query($sql) )
	{
		$msg = 'Could not insert message saved info' . $lang['Close_window_link'];
		message_die(GENERAL_ERROR, $msg, '', __LINE__, __FILE__, $sql);
	}

	$privmsg_sent_id = $db->sql_nextid();

	$sql = "INSERT $sql_priority INTO " . PRIVMSGS_TEXT_TABLE . " (privmsgs_text_id, privmsgs_bbcode_uid, privmsgs_text)
		VALUES ($privmsg_sent_id, '" . $bbcode_uid . "', '" . str_replace("\'", "''", $instant_message) . "')";
	if ( !$db->sql_query($sql) )
	{
		$msg = 'Could not insert message saved text' . $lang['Close_window_link'];
		message_die(GENERAL_ERROR, $msg, '', __LINE__, __FILE__, $sql);
	}
}


/**
 * Copied and modified from phpBB 2.0.4's bbcode.php function make_clickable($text)
 * Modifications:
 *	Renamed function to im_make_clickable
 *		Reason: To preserve target="_blank" in links on boards that have been
 *			modified to change links in the board to self-targeting links.
 *			Self-targeting links in very a small window == Bad Thing.
 *
 * phpBB 2.0.4 original comments:
 * Rewritten by Nathan Codding - Feb 6, 2001.
 * - Goes through the given string, and replaces xxxx://yyyy with an HTML <a> tag 
 * 	linking to that URL
 * - Goes through the given string, and replaces www.xxxx.yyyy[zzzz] with an HTML 
 * 	<a> tag linking to http://www.xxxx.yyyy[/zzzz]
 * - Goes through the given string, and replaces xxxx@yyyy with an HTML mailto: tag 
 * 	linking	to that email address
 * - Only matches these 2 patterns either after a space, or at the beginning of a 
 * 	line
 *
 * Notes: the email one might get annoying - it's easy to make it more restrictive, 
 * though.. maybe have it require something like xxxx@yyyy.zzzz or such. We'll see.
 */
function im_make_clickable($text)
{

	// pad it with a space so we can match things at the start of the 1st line.
	$ret = ' ' . $text;

	// matches an "xxxx://yyyy" URL at the start of a line, or after a space.
	// xxxx can only be alpha characters.
	// yyyy is anything up to the first space, newline, comma, double quote or <
	$ret = preg_replace("#([\t\r\n ])([a-z0-9]+?){1}://([\w\-]+\.([\w\-]+\.)*[\w]+(:[0-9]+)?(/[^ \"\n\r\t<]*)?)#i", '\1<a href="\2://\3" target="_blank">\2://\3</a>', $ret);

	// matches a "www|ftp.xxxx.yyyy[/zzzz]" kinda lazy URL thing
	// Must contain at least 2 dots. xxxx contains either alphanum, or "-"
	// zzzz is optional.. will contain everything up to the first space, newline, 
	// comma, double quote or <.
	$ret = preg_replace("#([\t\r\n ])(www|ftp)\.(([\w\-]+\.)*[\w]+(:[0-9]+)?(/[^ \"\n\r\t<]*)?)#i", '\1<a href="http://\2.\3" target="_blank">\2.\3</a>', $ret);

	// matches an email@domain type address at the start of a line, or after a space.
	// Note: Only the followed chars are valid; alphanums, "-", "_" and or ".".
	$ret = preg_replace("#([\n ])([a-z0-9\-_.]+?)@([\w\-]+\.([\w\-\.]+\.)*[\w]+)#i", "\\1<a href=\"mailto:\\2@\\3\">\\2@\\3</a>", $ret);

	// Remove our padding..
	$ret = substr($ret, 1);

	return($ret);
}

function generic_select($value, $name, $lang_list)
// Used to create various drop down lists used in preferences editors.
{
	global $im_userdata, $lang;

	ksort($lang[$lang_list]);

	$select = '<select name="' . $name . '">';
	while( list($key, $val) = each($lang[$lang_list]) )
	{
		$select .= '<option value="' . $key;
		$select .= ( $im_userdata[$name] == $key || $value == $key ) ? '" selected>' : '">' ;
		$select .= "$val</option>\n";
	}
	$select .= '</select>';

	return $select;
}

function im_prepare_vars($array, $use_admin = true)
// Prepares array of user preference variables
{
	global $board_config;

	$final_vars = array();
	$admin_defaults = array(
		'attach_sig' => 0,
		'refresh_rate' => $board_config['im_refresh_rate'],
		'success_close' => $board_config['im_success_close'],
		'refresh_method' => $board_config['im_refresh_method'],
		'auto_launch' => $board_config['im_auto_launch'],
		'popup_ims' => $board_config['im_popup_ims'],
		'list_ims' => $board_config['im_list_ims'],
		'show_controls' => $board_config['im_show_controls'],
		'list_all_online' => $board_config['im_list_all_online'],
		'win_main_height' => $board_config['im_main_height'],
		'win_main_width' => $board_config['im_main_width'],
		'win_online_height' => $board_config['im_online_height'],
		'win_online_width' => $board_config['im_online_width'],
		'win_read_height' => $board_config['im_read_height'],
		'win_read_width' => $board_config['im_read_width'],
		'win_send_height' => $board_config['im_send_height'],
		'win_send_width' => $board_config['im_send_width'],
		'play_sound' => $board_config['im_allow_sound'],
		'default_sound' => $board_config['im_default_sound'],
		'sound_name' => $board_config['im_sound_name'],
		'themes_id' => $board_config['im_themes_id'],
		's2s_user_list' => $board_config['im_s2s_user_list'],
		'open_pms' => $board_config['im_open_pms'],
		'auto_delete' => $board_config['im_auto_delete']
	);

	$var_list = array('attach_sig', 'refresh_rate', 'success_close', 'refresh_method', 'auto_launch', 'popup_ims', 'list_ims', 'show_controls', 'list_all_online', 'win_main_height', 'win_main_width', 'win_online_height', 'win_online_width', 'win_read_height', 'win_read_width', 'win_send_height', 'win_send_width', 'play_sound', 'default_sound', 'sound_name', 'current_sound_name', 'themes_id', 's2s_user_list', 'open_pms', 'auto_delete');

	if( $use_admin )
	{
		$admin_defaults['admin_allow_ims'] = $board_config['im_allow_ims'];
		$admin_defaults['admin_allow_shout'] = $board_config['im_allow_shout'];
		$admin_defaults['admin_allow_chat'] = $board_config['im_allow_chat'];
		$admin_defaults['admin_allow_s2s'] = $board_config['im_allow_s2s'];
		$var_list[] = 'admin_allow_ims';
		$var_list[] = 'admin_allow_shout';
		$var_list[] = 'admin_allow_chat';
		$var_list[] = 'admin_allow_s2s';
	}
	else
	{
		$admin_defaults['user_allow_ims'] = $board_config['im_allow_ims'];
		$admin_defaults['user_allow_shout'] = $board_config['im_allow_shout'];
		$admin_defaults['user_allow_chat'] = $board_config['im_allow_chat'];
		$admin_defaults['user_allow_s2s'] = $board_config['im_allow_s2s'];
		$var_list[] = 'user_allow_ims';
		$var_list[] = 'user_allow_shout';
		$var_list[] = 'user_allow_chat';
		$var_list[] = 'user_allow_s2s';
	}

	reset($var_list);
	while( list($key, $var) = @each($var_list) )
	{
		if ( $var != 'sound_name' && $var != 'current_sound_name' && isset($array[$var]) )
		{
			$final_vars[$var] = intval(preg_replace('/[^\d]/', '', $array[$var]));
		}
		elseif( $var == 'sound_name' || $var == 'current_sound_name' )
		{
			$final_vars[$var] = trim(htmlspecialchars($array[$var]));
		}
		else
		{
			$final_vars[$var] = $admin_defaults[$var];
		}
	}

	return $final_vars;
}

function process_user_online($user, $is_on_im)
// Processes user information for adding to Users Online list in template
{
	global $userdata, $template, $theme, $phpbb_root_path, $phpEx, $im_userdata, $lang, $images, $board_config;

	$style_color = '';
	$user_online_name = '';
	$user_online_link = '';

	if ( $user['user_level'] == ADMIN )
	{
		$user['username'] = '<b>' . $user['username'] . '</b>';
		$style_color = ' style="color:#' . $theme['adminfontcolor'] . '"';
	}
	else if ( $user['user_level'] == LESS_ADMIN )
	{
		$user['username'] = '<b>' . $user['username'] . '</b>';
		$style_color = ' style="color:#' . $theme['supermodfontcolor'] . '"';
	}

	else if ( $user['user_level'] == MOD )
	{
		$user['username'] = '<b>' . $user['username'] . '</b>';
		$style_color = ' style="color:#' . $theme['modfontcolor'] . '"';
	}

	$u_message_user = $phpbb_root_path . "imclient.$phpEx?mode=post&" . POST_USERS_URL . '=' . $user['user_id'];
	$u_pmessage_user = $phpbb_root_path . "privmsg.$phpEx?mode=post&" . POST_USERS_URL . '=' . $user['user_id'];

	if( $user['user_level'] == OFF_SITE )
	{
		$site_img = '<img src="' . $images['prill_offsite'] . '" alt="' . $lang['Online_at'] . $user['site_name'] . '" align="center" />';
		$u_message_user .= '&amp;site_id=' . $user['site_id'];
		$u_pmessage_user = '';
	}
	else
	{
		$site_img = '<img src="' . $images['prill_onsite'] . '" alt="' . $lang['Online_at'] . $board_config['sitename'] . '" align="center" />';
	}

	if ( $user['user_allow_viewonline'] )
	{
		if( $user['user_level'] == OFF_SITE )
		{
			$user_online_link = $user['url'];
		}
		else
		{
			$user_online_link = append_sid($phpbb_root_path . "profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . '=' . $user['user_id']);
		}

		$user_online_name = $user['username'];
	}
	elseif( $userdata['user_level'] == ADMIN )
	{
		$user_online_link = append_sid($phpbb_root_path . "profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . '=' . $user['user_id']);
		$user_online_name = '<strike>' . $user['username'] . '</strike>';
	}

	if( $user_online_name )
	{
		if( $is_on_im )
		{
			$user_online_name = '<em>' . $user_online_name . '</em>';
		}

		$template->assign_block_vars('switch_users_online.switch_user_list', array(
			'ONLINE_USER' => $user_online_name,
			'ONLINE_USER_SITE' => $site_img,
			'ONLINE_USER_STYLE' => $style_color,
			'ONLINE_USER_URL' => $user_online_link,
			'U_MESSAGE_USER' => append_sid($u_message_user),
			'U_PMESSAGE_USER' => append_sid($u_pmessage_user)
		));
	}
}

function im_session_update($delete_only = false, $delete_self = false)
{
	global $db, $im_userdata, $userdata, $board_config;

	if( $userdata['session_logged_in'] && !$delete_only )
	{
		$sql = 'SELECT * FROM ' . IM_SESSIONS_TABLE . '
			WHERE session_user_id = ' . $userdata['user_id'];

		if ( !($result = $db->sql_query($sql)) )
		{
			// Can't query the table? Let's stop now then.
			return;
		}

		if ( !($im_session = $db->sql_fetchrow($result)) )
		{
			// User does not have an open session - make one
			$sql = 'INSERT INTO ' . IM_SESSIONS_TABLE . ' (session_user_id, session_id, session_time)
				VALUES (' . $userdata['user_id'] . ", '" . $userdata['session_id'] . "', " . time() . ')';

			if ( !$db->sql_query($sql) )
			{
				message_die(CRITICAL_ERROR, 'Error creating IM session', '', __LINE__, __FILE__, $sql);
			}
		}
		else
		{
			// User has an open session - update the session time
			$sql = 'UPDATE ' . IM_SESSIONS_TABLE . ' SET 
				session_time = ' . time() . " 
				WHERE session_id = '" . $userdata['session_id'] . "'";

			if ( !$db->sql_query($sql) )
			{
				message_die(CRITICAL_ERROR, 'Error updating IM session', '', __LINE__, __FILE__, $sql);
			}
		}
	}

	// Delete old sessions
	if( $delete_self )
	{
		$added_sql = 'AND session_id = \'' . $userdata['session_id'] . '\'';
	}
	else
	{
		$added_sql = 'AND session_id <> \'' . $userdata['session_id'] . '\'';
	}
	$sess_length = $board_config['im_session_length'];
	$expiry_time = time() - $sess_length;
	$sql = 'DELETE FROM ' . IM_SESSIONS_TABLE . " 
			WHERE session_time < $expiry_time 
				$added_sql";
	if ( !$db->sql_query($sql) )
	{
		message_die(CRITICAL_ERROR, 'Error clearing old IM sessions', '', __LINE__, __FILE__, $sql);
	}
}

function im_session_end()
// Used to end an IM session. Mainly used when logging out.
{
	global $db, $userdata;

	$sql = 'DELETE FROM ' . IM_SESSIONS_TABLE . " 
			WHERE session_user_id = '" . $userdata['session_id'] . "'";
	if ( !$db->sql_query($sql) )
	{
		message_die(CRITICAL_ERROR, 'Error clearing old IM sessions', '', __LINE__, __FILE__, $sql);
	}
}

function print_controls($mode_append = '?mode=main', $oldmode = '')
{
	global $db, $im_userdata, $template, $images, $board_config, $lang, $phpEx, $phpbb_root_path, $mode, $u_login_logout;

	$u_login_logout .= '&in_prill=1';

	$template->assign_vars(array(
		'IMG_MESSAGE' => $images['prill_message'],
		'IMG_REFRESH' => $images['prill_refresh'],
		'IMG_HELP' => $images['prill_help'],
		'IMG_BUDDIES' => $images['prill_buddies'],
		'IMG_HOME' => $images['prill_home'],
		'IMG_CLOSE_WINDOWS' => $images['prill_closewin'],
		'IMG_LOGOUT' => $images['prill_logout'],
		'IMG_MESSAGE_LOG' => $images['prill_log'],

		'L_ALT_REFRESH' => $lang['Alt_New_Messages'],
		'L_ALT_BUDDIES' => $lang['Alt_Buddy_Man'],
		'L_ALT_HOME' => $lang['Alt_Home'],
		'L_ALT_CLOSE_WINDOWS' => $lang['Alt_Close_Windows'],
		'L_ALT_LOGOUT' => $lang['Alt_Logout'],
		'L_ALT_MESSAGE' => $lang['Send_im'],
		'L_ALT_MESSAGE_LOG' => $lang['Alt_Message_Log'],
		'L_ALT_HELP' => $lang['Prillian_Help'],
		'L_CONTROLS' => $lang['Controls'],
		'L_CLOSE_WINDOWS' => $lang['Alt_Close_Windows'],
		'L_LOGOUT' => $lang['Logout'],
		'L_CHECK_IMS' => $lang['Check_IMs'],
		'L_BUDDY_MAN' => $lang['Buddy_Management'],
		'L_PROFILE' => $lang['Profile'],
		'L_SEND_IM' => $lang['Send_im'],
		'L_MESSAGE_LOG' => $lang['Message_Log'],

		'U_HELP' => append_sid($phpbb_root_path . 'faq.' . $phpEx . '?mode=prill'),
		'U_MESSAGE_LOG' => append_sid($phpbb_root_path . "imclient.$phpEx?mode=log"),
		'U_BUDDY_MAN' => append_sid($phpbb_root_path . 'bid.'.$phpEx),
		'U_SEND_IM' => append_sid($phpbb_root_path . "imclient.$phpEx?mode=post"),
		'U_RELOAD' => append_sid($phpbb_root_path . 'imclient.'. $phpEx . $mode_append),
		'U_PROFILE' => append_sid($phpbb_root_path . 'profile.'.$phpEx.'?mode=editprofile'),
		'U_INDEX' => append_sid($phpbb_root_path),
		'U_LOGIN_LOGOUT' => append_sid($u_login_logout),
		'U_PREFS' => append_sid($phpbb_root_path . 'imclient.'.$phpEx.'?mode=editprofile&oldmode=' . $oldmode),

		'SEND_WIDTH' => $im_userdata['win_send_width'],
		'SEND_HEIGHT' => $im_userdata['win_send_height'],
		'PREFS_WIDTH' => $im_userdata['win_online_width'],
		'PREFS_HEIGHT' => $im_userdata['win_online_height'],
	));

	
	if( $im_userdata['show_controls'] == 1 || $im_userdata['show_controls'] == 3 )
	{
		$template->assign_block_vars('switch_controls_images', array());

		if( !$board_config['im_override_users'] )
		{
			$template->assign_block_vars('switch_controls_images.switch_prefs', array(
				'U_PREFS' => append_sid($phpbb_root_path . 'imclient.'.$phpEx.'?mode=editprofile&oldmode=' . $oldmode),
				'IMG_PREFS' => $images['prill_prefs'],
				'L_ALT_PREFS' => $lang['Alt_Prefs']
			));
		}
	}

	if( $im_userdata['show_controls'] == 2 || $im_userdata['show_controls'] == 3 )
	{
		$template->assign_block_vars('switch_controls_text', array());

		if( !$board_config['im_override_users'] )
		{
			$template->assign_block_vars('switch_controls_text.switch_prefs', array(
				'U_PREFS' => append_sid($phpbb_root_path . 'imclient.'.$phpEx.'?mode=editprofile&oldmode=' . $oldmode),
				'L_PREFS' => $lang['Preferences']
			));
		}
	}
}


// Auto launch checks - should only trigger auto launch of Main IM Client
// when the board/user preference is on and the file name is index.$phpEx

function auto_prill_check()
// Checks various factors to see if the auto popup of the IM Client should
// be used. It would be better to accomplish it with JavaScript, but that
// doesn't seem to work even when I copy stuff straight from a tutorial.
// Returns either 1 (trigger the popup) or 0 (don't)
{
	global $db, $HTTP_SERVER_VARS, $board_config, $phpEx, $im_userdata;

	// Does the user have the auto launch feature enabled?
	if( !$im_userdata['auto_launch'] )
	{
		return 0;
	}

	// Auto launch should only be triggered on index.php
	// build a pattern url and check it against PHP_SELF
	$pattern_str = $board_config['script_path'];
	$position = strpos($board_config['script_path'], '/');
	if ( !is_integer($position) && $position != 0 )
	{
	    $pattern_str = '/' . $pattern_str;
	}

	$position = strrpos($board_config['script_path'], '/');
	if ( $position != strlen($board_config['script_path']) - 1 )
	{
	    $pattern_str .= '/';
	}

	$pattern_str = '#' . $pattern_str . 'index\.' . $phpEx . '#';
	$script_name_check = preg_match($pattern_str, $HTTP_SERVER_VARS['PHP_SELF']);

	if( !$script_name_check )
	{
		return 0;
	}

	// Final check - has the popup already been triggered in this IM session?
	$sql = 'SELECT session_popup FROM ' . IM_SESSIONS_TABLE . ' WHERE session_user_id=' . $im_userdata['user_id'];
	if( !$result = $db->sql_query($sql) )
	{
		$message = 'Could not check messenger auto popup status';
		message_die(GENERAL_ERROR, $msg, '', __LINE__, __FILE__, $sql);
	}

	$row = $db->sql_fetchrow($result);
	if( !$row['session_popup'] )
	{
		$sql = 'UPDATE ' . IM_SESSIONS_TABLE . ' SET session_popup=1 WHERE session_user_id=' . $im_userdata['user_id'];
		if( !$result = $db->sql_query($sql) )
		{
			$message = 'Could not add messenger auto popup status';
			message_die(GENERAL_ERROR, $msg, '', __LINE__, __FILE__, $sql);
		}

		return 1;
	}
	else
	{
		return 0;
	}
}

?>