<?php
/***************************************************************************
 *                            functions_bid.php
 *                            -------------------
 *   begin                : Sunday, Dec 01, 2002
 *   version              : 0.5.2
 *   date                 : 2003/06/08 16:46
 ***************************************************************************/

if ( !defined('IN_PHPBB') || !defined('IN_BUDDY') )
{
	die('Hacking attempt');
}

define('BIDF_INCLUDED', true);


// Include common functions only if they have not already been included
if ( !defined('CF_INCLUDED') )
{
	include($phpbb_bid_path . "functions_common.$phpEx");
}

// Here's a little thing for Prillian
// It's used to append a javascript-backed "Close Window"
// link to any error messages in small windows
if( $gen_simple_header )
{
	$append_msg = $lang['Close_window_link'];
}
else
{
	$append_msg = '';
}

function get_all_buddies(&$buddy_list, &$disallow_list, &$ignore_list)
// Gets lists of buddies, ignored users, and users not allowed to contact you
{
	global $db, $lang, $userdata, $append_msg;

	$sql = 'SELECT buddy.buddy_id, buddy.user_ignore, buddy.alert, buddy.alert_status, buddy.disallow, u.username FROM ' . 
		BUDDY_TABLE . ' buddy, ' . USERS_TABLE . ' u
		WHERE buddy.user_id = ' . $userdata['user_id'] . ' 
			AND u.user_id = buddy.buddy_id';

	if ( !($result = $db->sql_query($sql)) )
	{
		$msg = 'Could not query buddy table' . $append_msg;
		message_die(CRITICAL_ERROR, $msg, '', __LINE__, __FILE__, $sql);
	}

	$buddy_list = array();
	$disallow_list = array();
	$ignore_list = array();
	while( $row = $db->sql_fetchrow($result) )
	{
		if( $row['user_ignore'] )
		{
			$ignore_list[] = $row;
		}
		elseif( $row['disallow'] )
		{
			$disallow_list[] = $row;
		}
		else
		{
			$buddy_list[] = $row;
		}
	}
}

function get_single_list($type, $limit = false, $start = '0', $sort_order = 'ASC', $limit_num = 0)
// Gets a single list of buddies, ignores, disallows, buddieds,
// ignoreds, or disalloweds
// Parameters:
// $type - Type of list to fetch: buddy, ignore, disallow, ignored, disallowed,
//				or buddied
// Optional Parameters:
// $limit - Get only a limited number of results? TRUE or FALSE
// $start - Start the result set at this number
// $sort_order - Alphabetical order of result set. ASC or DESC
// $limit_num - The maximum number of results to fetch. If not set or 0, the max
//				is the same as the max number of topics per page in Admin Panel
{
	global $db, $lang, $userdata, $board_config, $append_msg;

	switch($type)
	{
		case 'buddy':
			$sql = 'SELECT buddy.buddy_id, buddy.alert, buddy.alert_status, u.username
					FROM ' . BUDDY_TABLE . ' buddy, ' . USERS_TABLE . ' u
					WHERE buddy.user_id = ' . $userdata['user_id'] . '
						AND buddy.disallow = 0
						AND buddy.user_ignore = 0
						AND buddy.buddy_id = u.user_id';
			break;
		case 'ignore':
			$sql = 'SELECT buddy.buddy_id, u.username FROM ' . 
					BUDDY_TABLE . ' buddy, ' . USERS_TABLE . ' u
					WHERE buddy.user_id = ' . $userdata['user_id'] . '
						AND buddy.user_ignore = 1
						AND buddy.buddy_id = u.user_id';
			break;
		case 'disallow':
			$sql = 'SELECT buddy.buddy_id, u.username  FROM ' . 
					BUDDY_TABLE . ' buddy, ' . USERS_TABLE . ' u
					WHERE buddy.user_id = ' . $userdata['user_id'] . '
						AND buddy.disallow = 1
						AND buddy.buddy_id = u.user_id';
			break;
		case 'buddied':
			$sql = 'SELECT buddy.user_id, buddy.alert, buddy.alert_status, u.username
					FROM ' . BUDDY_TABLE . ' buddy, ' . USERS_TABLE . ' u
					WHERE buddy.buddy_id = ' . $userdata['user_id'] . '
						AND buddy.disallow = 0
						AND buddy.user_ignore = 0
						AND buddy.user_id = u.user_id';
			break;
		case 'ignored':
			$sql = 'SELECT buddy.user_id, u.username FROM ' . 
					BUDDY_TABLE . ' buddy, ' . USERS_TABLE . ' u
					WHERE buddy.buddy_id = ' . $userdata['user_id'] . '
						AND buddy.user_ignore = 1
						AND u.user_id = buddy.user_id';
			break;
		case 'disallowed':
			$sql = 'SELECT buddy.user_id, u.username  FROM ' . 
					BUDDY_TABLE . ' buddy, ' . USERS_TABLE . ' u
					WHERE buddy.buddy_id = ' . $userdata['user_id'] . '
						AND buddy.disallow = 1
						AND u.user_id = buddy.user_id';
			break;
	}
	
	$sql .= ' ORDER BY u.username ' . $sort_order;


	if( $limit )
	{
		$limit_max = ( $limit_num ) ? $limit_num : $board_config['topics_per_page'];
		$sql .= ' LIMIT ';
		$sql .= ( $start ) ? $start . ', ' : '';
		$sql .= $limit_max;
	}
	
	if ( !($result = $db->sql_query($sql)) )
	{
		$msg = 'Could not get ' . $type . ' list' . $append_msg;
		message_die(CRITICAL_ERROR, $msg, '', __LINE__, __FILE__, $sql);
	}

	$list = array();
	while( $row = $db->sql_fetchrow($result) )
	{
		$list[] = $row;
	}

	return $list;
}

function get_single_count($type)
// Gets a count of a list of buddies, ignores, disallows, buddieds,
// ignoreds, or disalloweds
{
	global $db, $lang, $userdata, $board_config, $append_msg;

	switch($type)
	{
		case 'buddy':
			$sql = 'SELECT count(*) AS total
					FROM ' . BUDDY_TABLE . ' buddy, ' . USERS_TABLE . ' u
					WHERE buddy.user_id = ' . $userdata['user_id'] . '
						AND buddy.disallow = 0
						AND buddy.user_ignore = 0
						AND buddy.buddy_id = u.user_id';
			break;
		case 'ignore':
			$sql = 'SELECT count(*) AS total FROM ' . 
					BUDDY_TABLE . ' buddy, ' . USERS_TABLE . ' u
					WHERE buddy.user_id = ' . $userdata['user_id'] . '
						AND buddy.user_ignore = 1
						AND buddy.buddy_id = u.user_id';
			break;
		case 'disallow':
			$sql = 'SELECT count(*) AS total  FROM ' . 
					BUDDY_TABLE . ' buddy, ' . USERS_TABLE . ' u
					WHERE buddy.buddy_id = ' . $userdata['user_id'] . '
						AND buddy.disallow = 1
						AND u.user_id = buddy.buddy_id';
			break;
		case 'buddied':
			$sql = 'SELECT count(*) AS total
					FROM ' . BUDDY_TABLE . ' buddy, ' . USERS_TABLE . ' u
					WHERE buddy.buddy_id = ' . $userdata['user_id'] . '
						AND buddy.disallow = 0
						AND buddy.user_ignore = 0
						AND buddy.user_id = u.user_id';
			break;
		case 'ignored':
			$sql = 'SELECT count(*) AS total FROM ' . 
					BUDDY_TABLE . ' buddy, ' . USERS_TABLE . ' u
					WHERE buddy.buddy_id = ' . $userdata['user_id'] . '
						AND buddy.user_ignore = 1
						AND u.user_id = buddy.user_id';
			break;
		case 'disallowed':
			$sql = 'SELECT count(*) AS total  FROM ' . 
					BUDDY_TABLE . ' buddy, ' . USERS_TABLE . ' u
					WHERE buddy.buddy_id = ' . $userdata['user_id'] . '
						AND buddy.disallow = 1
						AND u.user_id = buddy.user_id';
			break;
	}

	if ( !($result = $db->sql_query($sql)) )
	{
		$msg = 'Could not get count of ' . $type . ' list' . $append_msg;
		message_die(CRITICAL_ERROR, $msg, '', __LINE__, __FILE__, $sql);
	}

	if( $row = $db->sql_fetchrow($result) )
	{
		return $row['total'];
	}
	else
	{
		return false;
	}
}

function alert_check($buddy_list)
// Checks list of online users to see if a buddy has just come online
/* Bug: if checked in a forum, the list of all online users will 
    contain only users in that forum.
    Solution: don't check the alerts in a forum for now. Need to rework 
	an SQL query in page_header.php to get around this
*/
{
	global $lang, $userdata, $append_msg, $online_array;

	$online_list = '';
	$online_names = '';
	$offline_list = '';
	$offline_names = '';

	while( list($key, $val) = each($buddy_list) )
	{
		if( $val['alert'] )
		{
			if( inarray($val['buddy_id'], $online_array) && !$val['alert_status'] )
			{
				// Buddy is online & we haven't alerted user before
				$online_list .= ( ( $online_list == '') ? '' : ',' ) . $val['buddy_id'];
				$online_names .= ( ( $online_names == '') ? '' : ', ' ) . $val['username'];
			}
			elseif( !inarray($val['buddy_id'], $online_array) && $val['alert_status'] )
			{
				// Buddy was online, but now isn't
				$offline_list .= ( ( $offline_list == '') ? '' : ',' ) . $val['buddy_id'];
				$offline_names .= ( ( $offline_names == '') ? '' : ', ' ) . $val['username'];
			}
		}
	}
	if( $online_list != '' || $offline_list != '' )
	{
		// Update alert_status
		alert_update($online_list, $offline_list);
		// Inform user of online/offline users
		do_alert($online_names, $offline_names);
	}
}

function alert_update($online_list, $offline_list)
// Updates alert_status in BID table
{
	global $db, $lang, $userdata, $append_msg;

	if( $online_list != '' )
	{
		$sql = 'UPDATE ' . BUDDY_TABLE . '
				SET alert_status = 1
				WHERE user_id = ' . $userdata['user_id'] . "
				AND buddy_id IN ($online_list)";

		if ( !($result = $db->sql_query($sql)) )
		{
			$msg = 'Could not update online alert status' . $append_msg;
			message_die(CRITICAL_ERROR, $msg, '', __LINE__, __FILE__, $sql);
		}
	}

	if( $offline_list != '' )
	{
		$sql = 'UPDATE ' . BUDDY_TABLE . '
				SET alert_status = 0
				WHERE user_id = ' . $userdata['user_id'] . "
				AND buddy_id IN ($offline_list)";

		if ( !($result = $db->sql_query($sql)) )
		{
			$msg = 'Could not update offline alert status' . $append_msg;
			message_die(CRITICAL_ERROR, $msg, '', __LINE__, __FILE__, $sql);
		}
	}
}

function manage_buddy($type, $buddy_id, $ignore = 0, $alert = 0, $disallow = 0)
// Modifies listings in database
{
	global $db, $lang, $userdata, $append_msg;

	if( is_array($buddy_id) )
	{
		$id_list = '';
		for ($i = 0; $i < sizeof($buddy_id); $i++)
		{
			$id_list .= (( $id_list ) ? ', ' : '') . $buddy_id[$i];
		}
		$list_sql = 'IN ( ' . $id_list . ')';
	}
	else
	{
		$list_sql = '= ' . $buddy_id;
	}

	switch( $type )
	{
		case 'new':
			// New information
			$sql = 'INSERT INTO ' . BUDDY_TABLE . '(user_id, buddy_id, user_ignore, alert, alert_status, disallow)
				VALUES (' . $userdata['user_id'] . ', ' . $buddy_id . ', ' . $ignore . ', ' . $alert . ', 0, ' . $disallow . ')';
	
			if ( !($result = $db->sql_query($sql)) )
			{
				$msg = 'Could not insert data into buddy table' . $append_msg;
				message_die(GENERAL_ERROR, $msg, '', __LINE__, __FILE__, $sql);
			}
			break;
		case 'update':
			// Update contact info
		
			$sql = 'UPDATE ' . BUDDY_TABLE . '
					SET user_ignore = ' . $ignore . ', alert = ' . $alert . ', disallow = ' . $disallow . '
					WHERE user_id = ' . $userdata['user_id'] . '
					AND buddy_id ' . $list_sql;

			if ( !($result = $db->sql_query($sql)) )
			{
				$msg = 'Could not update data in buddy table' . $append_msg;
				message_die(GENERAL_ERROR, $msg, '', __LINE__, __FILE__, $sql);
			}
			break;
		case 'delete':
			// Delete a single contact or list of contacts from the list
			$sql = 'DELETE FROM ' . BUDDY_TABLE . '
				WHERE user_id = ' . $userdata['user_id'] . '
					AND buddy_id ' . $list_sql;
			
			if ( !($result = $db->sql_query($sql)) )
			{
				$msg = 'Could not delete data in buddy table' . $append_msg;
				message_die(GENERAL_ERROR, $msg, '', __LINE__, __FILE__, $sql);
			}
			break;
		case 'deleteall':
			$sql = 'DELETE FROM ' . BUDDY_TABLE . '
				WHERE user_id = ' . $userdata['user_id'];
			
			if ( !($result = $db->sql_query($sql)) )
			{
				$msg = 'Could not delete data in buddy table' . $append_msg;
				message_die(GENERAL_ERROR, $msg, '', __LINE__, __FILE__, $sql);
			}
			break;
	}
}

function change_inform($method, $id_list, $type = '')
// Informs users (via private message) that they have been added/removed from
// another user's BID lists.
{
	global $db, $userdata, $board_config, $lang, $phpbb_root_path, $phpEx, $append_msg, $user_ip;

	$script_name = preg_replace('#^\/?(.*?)\/?$#', '\1', trim($board_config['script_path']));
	$server_name = trim($board_config['server_name']);
	$server_protocol = ( $board_config['cookie_secure'] ) ? 'https://' : 'http://';
	$server_port = ( $board_config['server_port'] <> 80 ) ? ':' . trim($board_config['server_port']) . '/' : '/';

	$base_profile_url = $server_protocol . $server_name . $server_port . $script_name;
	$bidcp_string = $base_profile_url;
	$base_profile_url .= '/profile.' . $phpEx . '?mode=viewprofile&amp;sid=' . $userdata['session_id'] . '&amp;' . POST_USERS_URL . '=';
	$bidcp_string .= '/bid.' . $phpEx . '?mode=show&amp;sid=' . $userdata['session_id'];
	$msg_time = time();

	switch( $type )
	{
		case 'buddy':
			$list_type = $lang['Buddy'];
			break;
		case 'ignore':
			$list_type = $lang['Ignore'];
			break;
		case 'disallow':
			$list_type = $lang['Disallow'];
			break;
		case '':
			$list_type = '';
			break;
	}

	switch( $method )
	{
		case 'update':
			$base_msg = $lang['PM_Alert_Moved'];
			break;
		case 'new':
			$base_msg = $lang['PM_Alert_Added'];
			break;
		case 'delete':
			$base_msg = $lang['PM_Alert_Removed'];
			$list_type = $lang['Buddy'] . '/' . $lang['Ignore'] . '/' . $lang['Disallow'];
			break;
	}

	// Make sure we're dealing with an array of buddy_id's
	if( !is_array($id_list) )
	{
		$temp_array = array();
		$temp_array[] = $id_list;
		$id_list = $temp_array;
	}

	// Send Private Message to every affected user
	// Much of this is lifted straight from 2.0.4's privmsg.php
	for ($i = 0; $i < sizeof($id_list); $i++)
	{
		$to_userdata = array();

		$sql = 'SELECT username, user_notify_pm, user_email, user_lang, user_active
				FROM ' . USERS_TABLE . '
				WHERE user_id = \'' . $id_list[$i] . '\'';

		if ( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Could not get user data for sending system message' . $append_msg, '', __LINE__, __FILE__, $sql);
		}

		$to_userdata = $db->sql_fetchrow($result);
		$to_userdata['user_id'] = $id_list[$i];

		$user_profile_string = $base_profile_url . $userdata['user_id'];
		$username_string = str_replace("\'", "''", $userdata['username']);
		$to_username = str_replace("\'", "''", $to_userdata['username']);

		$sys_message = sprintf($base_msg, $user_profile_string, $username_string, $list_type);

		$sys_message .= ' ' . sprintf($lang['PM_Alert_end'], $bidcp_string);

		$bbcode_uid = make_bbcode_uid();
		$privmsg_message = prepare_message($sys_message, '1', '1', '0', $bbcode_uid);

		//
		// See if recipient is at their inbox limit
		//
		$sql = 'SELECT COUNT(privmsgs_id) AS inbox_items, MIN(privmsgs_date) AS oldest_post_time 
			FROM ' . PRIVMSGS_TABLE . ' 
			WHERE ( privmsgs_type = ' . PRIVMSGS_NEW_MAIL . ' 
					OR privmsgs_type = ' . PRIVMSGS_READ_MAIL . '  
					OR privmsgs_type = ' . PRIVMSGS_UNREAD_MAIL . ' ) 
				AND privmsgs_to_userid = ' . $to_userdata['user_id'];
		if ( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_MESSAGE, $lang['No_such_user'] . $append_msg);
		}

		$sql_priority = ( SQL_LAYER == 'mysql' ) ? 'LOW_PRIORITY' : '';

		if ( $inbox_info = $db->sql_fetchrow($result) )
		{
			if ( $inbox_info['inbox_items'] >= $board_config['max_inbox_privmsgs'] )
			{
				$sql = 'SELECT privmsgs_id FROM ' . PRIVMSGS_TABLE . ' 
					WHERE ( privmsgs_type = ' . PRIVMSGS_NEW_MAIL . ' 
							OR privmsgs_type = ' . PRIVMSGS_READ_MAIL . ' 
							OR privmsgs_type = ' . PRIVMSGS_UNREAD_MAIL . '  ) 
						AND privmsgs_date = ' . $inbox_info['oldest_post_time'] . ' 
						AND privmsgs_to_userid = ' . $to_userdata['user_id'];
				if ( !$result = $db->sql_query($sql) )
				{
					message_die(GENERAL_ERROR, 'Could not find oldest privmsgs (inbox)' . $append_msg, '', __LINE__, __FILE__, $sql);
				}
				$old_privmsgs_id = $db->sql_fetchrow($result);
				$old_privmsgs_id = $old_privmsgs_id['privmsgs_id'];

				$sql = "DELETE $sql_priority FROM " . PRIVMSGS_TABLE . " 
					WHERE privmsgs_id = $old_privmsgs_id";
				if ( !$db->sql_query($sql) )
				{
					message_die(GENERAL_ERROR, 'Could not delete oldest privmsgs (inbox)' . $append_msg, '', __LINE__, __FILE__, $sql);
				}

				$sql = "DELETE $sql_priority FROM " . PRIVMSGS_TEXT_TABLE . " 
					WHERE privmsgs_text_id = $old_privmsgs_id";
				if ( !$db->sql_query($sql) )
				{
					message_die(GENERAL_ERROR, 'Could not delete oldest privmsgs text (inbox)' . $append_msg, '', __LINE__, __FILE__, $sql);
				}
			}
		}

		$sql_info = 'INSERT INTO ' . PRIVMSGS_TABLE . ' (privmsgs_type, privmsgs_subject, privmsgs_from_userid, privmsgs_to_userid, privmsgs_date, privmsgs_ip, privmsgs_enable_html, privmsgs_enable_bbcode, privmsgs_enable_smilies, privmsgs_attach_sig)
			VALUES (' . PRIVMSGS_NEW_MAIL . ", '" . str_replace("\'", "''", $lang['System_title']) . "', " . $userdata['user_id'] . ", " . $to_userdata['user_id'] . ", $msg_time, '$user_ip', 1, 1, 0, 0)";

		if ( !$result = $db->sql_query($sql_info, BEGIN_TRANSACTION) )
		{
			message_die(GENERAL_ERROR, 'Could not insert/update private message sent info.' . $append_msg, "", __LINE__, __FILE__, $sql_info);
		}

		$privmsg_sent_id = $db->sql_nextid();

		$sql = 'INSERT INTO ' . PRIVMSGS_TEXT_TABLE . " (privmsgs_text_id, privmsgs_bbcode_uid, privmsgs_text)
			VALUES ($privmsg_sent_id, '$bbcode_uid ', '" . str_replace("\'", "''", addslashes($privmsg_message)) . "')";

		if ( !$result = $db->sql_query($sql, END_TRANSACTION) )
		{
			message_die(GENERAL_ERROR, 'Could not insert/update private message sent text.' . $append_msg, "", __LINE__, __FILE__, $sql_info);
		}

		//
		// Add to the users new pm counter
		//
		$sql = 'UPDATE ' . USERS_TABLE . '
			SET user_new_privmsg = user_new_privmsg + 1, user_last_privmsg = ' . time() . '  
			WHERE user_id = ' . $to_userdata['user_id']; 
		if ( !$status = $db->sql_query($sql) )
		{
			message_die(GENERAL_ERROR, 'Could not update private message new/read status for user' . $append_msg, '', __LINE__, __FILE__, $sql);
		}

		if ( $to_userdata['user_notify_pm'] && !empty($to_userdata['user_email']) && $to_userdata['user_active'] )
		{
			$email_headers = 'From: ' . $board_config['board_email'] . "\nReturn-Path: " . $board_config['board_email'] . "\n";

			$script_name = ( $script_name != '' ) ? $script_name . '/privmsg.'.$phpEx : 'privmsg.'.$phpEx;
			include($phpbb_root_path . 'includes/emailer.'.$phpEx);
			$emailer = new emailer($board_config['smtp_delivery']);

			$emailer->use_template('privmsg_notify', $to_userdata['user_lang']);
			$emailer->extra_headers($email_headers);
			$emailer->email_address($to_userdata['user_email']);
			$emailer->set_subject($lang['Notification_subject']);
					
			$emailer->assign_vars(array(
				'USERNAME' => $to_username, 
				'SITENAME' => $board_config['sitename'],
				'EMAIL_SIG' => (!empty($board_config['board_email_sig'])) ? str_replace('<br />', "\n", "-- \n" . $board_config['board_email_sig']) : '', 

				'U_INBOX' => $server_protocol . $server_name . $server_port . $script_name . '?folder=inbox')
			);

			$emailer->send();
			$emailer->reset();
		}
	}
}


function do_alert($online_names, $offline_names)
// Informs user that buddies are online/offline
// Uses javascript alert for now - I don't know if there's a good way to pass 
// the lists to a new window
{
	global $template, $lang, $userdata, $append_msg;

	if( $online_names != '' )
	{
		if( strchr($online_names, ',') )
		{
			$online_str = $lang['Buddies_online'] . ': ';
		}
		else
		{
			$online_str = $lang['Buddy_online'] . ': ';
		}
	}
	else
	{
		$online_str = '';
	}

	if( $offline_names != '' )
	{
		if( strchr($offline_names, ',') )
		{
			$offline_str = $lang['Buddies_offline'] . ': ';
		}
		else
		{
			$offline_str = $lang['Buddy_offline'] . ': ';
		}
	}
	else
	{
		$offline_str = '';
	}

	$template->assign_block_vars('buddy_alert',	array(
		'L_BUDDIES_ONLINE' => $online_str,
		'BUDDIES_ONLINE' => $online_names,
		'L_BUDDIES_OFFLINE' => $offline_str,
		'BUDDIES_OFFLINE' => $offline_names
		)
	);
}

function do_bid_confirm($s_hidden_fields, $msg_text)
{
	global $template, $lang, $phpbb_root_path, $phpEx, $db, $gen_simple_header;

	//
	// Output confirmation page
	//

	$template->set_filenames(array(
		'confirm_body' => 'confirm_body.tpl')
	);
	$template->assign_vars(array(
		'MESSAGE_TITLE' => $lang['Buddy_Management'],
		'MESSAGE_TEXT' => $msg_text, 


		'L_YES' => $lang['Yes'],
		'L_NO' => $lang['No'],

		'S_CONFIRM_ACTION' => append_sid($phpbb_root_path . "bid.$phpEx"),
		'S_HIDDEN_FIELDS' => $s_hidden_fields)
	);

	if ( $gen_simple_header )
	{
		$template->assign_vars(array(
			'U_INDEX' => '',
			'L_INDEX' => '')
		);
	}

	$template->pparse('confirm_body');

	include($phpbb_root_path . 'includes/page_tail.'.$phpEx);
}

function process_alert_updates($mark_list, $users_list)
{
	global $db, $lang, $append_msg;

	$list = get_single_list('buddy');

	if ( count($mark_list) && count($users_list) )
	{
		$bad_list = '';
		$on_list = array();
		$off_list = array();

		for ($i = 0; $i < sizeof($mark_list); $i++)
		{
			$this_user_id = intval($mark_list[$i]);
			$check_array = in_m_array($this_user_id, $list, true);
			if( $check_array[0] && !$list[$check_array[1]]['alert'] )
			{
				$on_list[] = $this_user_id;
			}
			else
			{
				if( !$check_array[0] )
				{
					$error = TRUE;
					$bad_list .=  ( ( $bad_list == '' ) ? '' : ', ' ) . '\'' . $this_user_id . '\'';
				}
			}
		}

		for ($i = 0; $i < sizeof($users_list); $i++)
		{
			$this_user_id = intval($users_list[$i]);
			$check_array = in_m_array($this_user_id, $list, true);
			if( !inarray($this_user_id, $mark_list) && $list[$check_array[1]]['alert'] )
			{
				$off_list[] = $this_user_id;
			}
		}

		if( !empty($on_list) )
		{
			manage_buddy('update', $on_list, 0, 1);
		}

		if( !empty($off_list) )
		{
			manage_buddy('update', $off_list);
		}

		if( $error && !empty($bad_list) )
		{
			$bad_names = '';
			$sql = 'SELECT username FROM ' . USERS_TABLE . '
					WHERE user_id IN (' . $bad_list . ')';
			if ( !$result=$db->sql_query($sql) )
			{
				$message = 'Could not get list of usernames for alert update error';
				message_die(GENERAL_ERROR, $message . $append_msg, '', __LINE__, __FILE__, $sql);
			}
			while( $row = $db->sql_fetchrow($result) )
			{
				$bad_names .=  ( ( $bad_names == '' ) ? '' : ', ' ) . $row['username'];
			}

			$message = $lang['Alerts_updated'] . $lang['Alerts_oops'] . $bad_names;
			message_die(GENERAL_MESSAGE, $message . $append_msg);
		}

		$message = $lang['Alerts_updated'];
		message_die(GENERAL_MESSAGE, $message . $append_msg);
	}
	elseif ( count($users_list) )
	{
		// $mark_list is empty, but $users_list is not. This means
		// to remove alert updates for all of the users in $users_list.
		for ($i = 0; $i < sizeof($users_list); $i++)
		{
			$check_array = in_m_array(intval($users_list[$i]), $list, true);
			if( $list[$check_array[1]]['alert'] )
			{
				$off_list[] = $list[$i]['buddy_id'];
			}
		}

		if( !empty($off_list) )
		{
			manage_buddy('update', $off_list);
		}

		$message = $lang['Alerts_updated'];
		message_die(GENERAL_MESSAGE, $message . $append_msg);
	}
	else
	{
		$message = $lang['No_alerts_updated'];
		message_die(GENERAL_MESSAGE, $message . $append_msg);
	}

}

?>