<?php
/***************************************************************************
 *                              memberlist.php
 *                            -------------------
 *   begin                : Friday, May 11, 2001
 *   copyright            : (C) 2001 The phpBB Group
 *   email                : support@phpbb.com
 *
 *   $Id: memberlist.php,v 1.36.2.8 2003/06/09 13:06:19 psotfx Exp $
 *
 ***************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 ***************************************************************************/

/***************************************************************************
 * This file has been modified by Fully Moddded phpBB
 *
 *   $FMId: 2003/07/09 05:23:12 mj
 *
 ***************************************************************************/

define('IN_PHPBB', true);
$phpbb_root_path = './';
include($phpbb_root_path . 'extension.inc');
include($phpbb_root_path . 'common.'.$phpEx);

//
// Start session management
//
$userdata = session_pagestart($user_ip, PAGE_VIEWMEMBERS);
init_userprefs($userdata);
//
// End session management
//

if ( !$userdata['session_logged_in'] ) 
{ 
	redirect("login.".$phpEx."?redirect=memberlist.".$phpEx); 
	exit; 
} 

if(isset($HTTP_POST_VARS['letter']))
{
	$by_letter = ($HTTP_POST_VARS['letter']) ? $HTTP_POST_VARS['letter'] : 'all';
}
else if(isset($HTTP_GET_VARS['letter']))
{
	$by_letter = ($HTTP_GET_VARS['letter']) ? $HTTP_GET_VARS['letter'] : 'all';
}

$start = ( isset($HTTP_GET_VARS['start']) ) ? intval($HTTP_GET_VARS['start']) : 0;

if ( isset($HTTP_GET_VARS['mode']) || isset($HTTP_POST_VARS['mode']) )
{
	$mode = ( isset($HTTP_POST_VARS['mode']) ) ? htmlspecialchars($HTTP_POST_VARS['mode']) : htmlspecialchars($HTTP_GET_VARS['mode']);
}
else
{
	$mode = 'joined';
}

if(isset($HTTP_POST_VARS['order']))
{
	$sort_order = ($HTTP_POST_VARS['order'] == 'ASC') ? 'ASC' : 'DESC';
}
else if(isset($HTTP_GET_VARS['order']))
{
	$sort_order = ($HTTP_GET_VARS['order'] == 'ASC') ? 'ASC' : 'DESC';
}
else
{
	$sort_order = 'ASC';
}

//
// Memberlist sorting
//
$mode_types_text = array($lang['Last_logon'], $lang['Sort_Joined'], $lang['Sort_Username'], $lang['Gender'], $lang['Profile_photo'], $lang['Location'], $lang['Country_Flag'], $lang['Sort_Posts'], $lang['Sort_Email'], $lang['Level'], $lang['RankFAQ_Block_Title'], $lang['Sort_Website'], $lang['Sort_Top_Ten'], $board_config['points_name']);
$mode_types = array('lastlogon', 'joindate', 'username', 'gender', 'photo', 'location', 'flag', 'posts', 'email', 'level', 'rank', 'website', 'topten', 'points');

$select_sort_mode = '<select name="mode">';
for($i = ($userdata['user_level'] == ADMIN ) ? 0:1; $i < count($mode_types_text); $i++)
{
	$selected = ( $mode == $mode_types[$i] ) ? ' selected="selected"' : '';
	$select_sort_mode .= '<option value="' . $mode_types[$i] . '"' . $selected . '>' . $mode_types_text[$i] . '</option>';
}
$select_sort_mode .= '</select>';

$select_sort_order = '<select name="order">';
if($sort_order == 'ASC')
{
	$select_sort_order .= '<option value="ASC" selected="selected">' . $lang['Sort_Ascending'] . '</option><option value="DESC">' . $lang['Sort_Descending'] . '</option>';
}
else
{
	$select_sort_order .= '<option value="ASC">' . $lang['Sort_Ascending'] . '</option><option value="DESC" selected="selected">' . $lang['Sort_Descending'] . '</option>';
}
$select_sort_order .= '</select>';

//
// Generate page
//
$page_title = $lang['Memberlist'];
include($phpbb_root_path . 'includes/page_header.'.$phpEx);

$template->set_filenames(array(
	'body' => 'memberlist_body.tpl')
);
make_jumpbox('viewforum.'.$phpEx);

$template->assign_vars(array(
	'L_SELECT_SORT_METHOD' => $lang['Select_sort_method'],
	'L_EMAIL' => $lang['Email'],
	'L_WEBSITE' => $lang['Website'],
	'L_LEVEL' => $lang['Level'],
	'L_FROM' => $lang['Location'],
	'L_ORDER' => $lang['Order'],
	'L_SORT' => $lang['Sort'],
	'L_SUBMIT' => $lang['Sort'],
	'L_AIM' => $lang['AIM'],
	'L_YIM' => $lang['YIM'],
	'L_MSNM' => $lang['MSNM'],
	'L_ICQ' => $lang['ICQ'], 
	'L_JOINED' => $lang['Joined'], 
	'L_POSTS' => $lang['Posts'], 
	'L_PM' => $lang['PM'], 
	'L_LOGON' => $lang['Last_logon'], 
	'L_POINTS' => $board_config['points_name'],
	'L_USER_RANK' => $lang['RankFAQ_Block_Title'], 
	'L_POST_TIME' => $lang['Last_Post'] . ' ' . $lang['Time'], 

	'S_MODE_SELECT' => $select_sort_mode,
	'S_ORDER_SELECT' => $select_sort_order,
	'S_MODE_ACTION' => append_sid("memberlist.$phpEx"))
);

switch( $mode )
{
	case 'joined':
		$order_by = "user_regdate $sort_order LIMIT $start, " . $board_config['topics_per_page'];
		break;
	case 'lastlogon': 
	      $order_by = ($userdata['user_level'] == ADMIN ) ? "user_lastlogon $sort_order LIMIT $start, " . $board_config['topics_per_page'] : "username $sort_order LIMIT $start, " . $board_config['topics_per_page']; 
	      break; 
	case 'username':
		$order_by = "username $sort_order LIMIT $start, " . $board_config['topics_per_page'];
		break;
	case 'gender':
		$order_by = "user_gender $sort_order LIMIT $start, " . $board_config['topics_per_page'];
		break;
	case 'photo':
		$order_by = "user_photo $sort_order LIMIT $start, " . $board_config['topics_per_page'];
		break;
	case 'location':
		$order_by = "user_from $sort_order LIMIT $start, " . $board_config['topics_per_page'];
		break;
	case 'flag':
		$order_by = "user_from_flag $sort_order LIMIT $start, " . $board_config['topics_per_page'];
		break;
	case 'posts':
		$order_by = "user_posts $sort_order LIMIT $start, " . $board_config['topics_per_page'];
		break;
	case 'email':
		$order_by = "user_email $sort_order LIMIT $start, " . $board_config['topics_per_page'];
		break;
	case 'level':
		$order_by = "user_level $sort_order LIMIT $start, " . $board_config['topics_per_page'];
		break;
	case 'rank':
		$order_by = "user_rank $sort_order LIMIT $start, " . $board_config['topics_per_page'];
		break;
	case 'website':
		$order_by = "user_website $sort_order LIMIT $start, " . $board_config['topics_per_page'];
		break;
	case 'topten':
		$order_by = "user_posts $sort_order LIMIT 10";
		break;
	case 'points':
		$order_by = "user_points $sort_order LIMIT $start," . $board_config['topics_per_page'];
		break;
	default:
		$order_by = "user_regdate $sort_order LIMIT $start, " . $board_config['topics_per_page'];
		break;
}

//
// Set per-letter selection
//
$others_sql = '';
$select_letter = '';
for ($i = 97; $i <= 122; $i++)
{
	$others_sql .= " AND username NOT LIKE '" . chr($i) . "%' ";
	$select_letter .= ( $by_letter == chr($i) ) ? chr($i) : '<a href="' . append_sid("memberlist.$phpEx?letter=" . chr($i) . "&amp;mode=$mode&amp;order=$sort_order&amp;start=$start") . '">' . chr($i) . '</a>&nbsp;';
}
$select_letter .= ( $by_letter == 'others' ) ? $lang['Others'] : '<a href="' . append_sid("memberlist.$phpEx?letter=others&amp;mode=$mode&amp;order=$sort_order&amp;start=$start") . '">' . $lang['Others'] . '</a>&nbsp;';
$select_letter .= ( $by_letter == 'all' ) ? $lang['All'] : '<a href="' . append_sid("memberlist.$phpEx?letter=all&amp;mode=$mode&amp;order=$sort_order&amp;start=$start") . '">' . $lang['All'] . '</a>';

$template->assign_vars(array(
	'L_SORT_PER_LETTER' => $lang['Sort_per_letter'],
	'S_LETTER_SELECT' => $select_letter,
	'S_LETTER_HIDDEN' => '<input type="hidden" name="letter" value="' . $by_letter . '">')
);

if($by_letter == 'all')
{
	$letter_sql = "";
}
else if($by_letter == 'others')
{
	$letter_sql = $others_sql;
}
else
{
	$letter_sql = " AND username LIKE '$by_letter%' ";
}

$sql = "SELECT * 
   FROM " . RANKS_TABLE . " 
   ORDER BY rank_special, rank_min"; 
if ( !($result = $db->sql_query($sql)) ) 
{ 
   message_die(GENERAL_ERROR, "Could not obtain ranks information.", '', __LINE__, __FILE__, $sql); 
} 
$ranksrow = array(); 
while ( $row = $db->sql_fetchrow($result) ) 
{ 
   $ranksrow[] = $row; 
} 
$db->sql_freeresult($result); 

$sql = "SELECT *
	FROM " . USERS_TABLE . "
	WHERE user_id <> " . ANONYMOUS . "$letter_sql
      AND user_active = 1	
	ORDER BY $order_by";
if( !($result = $db->sql_query($sql)) )
{
	message_die(GENERAL_ERROR, 'Could not query users', '', __LINE__, __FILE__, $sql);
}

if ( $row = $db->sql_fetchrow($result) )
{
	$i = 0;
	do
	{
		$username = $row['username'];
		$photo = ( $row['user_photo'] ) ? '<a href="profile.php?mode=viewprofile&amp;u='.$row['user_id'].'#photo"><img src="'.$images['icon_mini_photo'].'" width="16" height="12" border="0" alt="'.$lang['Profile_photo'].'"></a>' : '';
		$user_id = $row['user_id'];

		$from = ( !empty($row['user_from']) ) ? $row['user_from'] : '&nbsp;';
		$flag = ( !empty($row['user_from_flag']) ) ? "&nbsp;<img src=\"images/flags/" . $row['user_from_flag'] . "\" alt=\"".$lang['Country_Flag'].": " . $row['user_from_flag'] . "\">" : '';
		$joined = create_date($lang['DATE_FORMAT'], $row['user_regdate'], $board_config['board_timezone']);
		$posts = ( $row['user_posts'] ) ? $row['user_posts'] : 0;
	      $user_rank = ''; 
	      $rank_image = ''; 
	      if ( $row['user_rank'] ) 
	      { 
	         for($j = 0; $j < count($ranksrow); $j++) 
	         { 
	            if ( $row['user_rank'] == $ranksrow[$j]['rank_id'] && $ranksrow[$j]['rank_special'] ) 
	            { 
	               $user_rank = $ranksrow[$j]['rank_title']; 
	               $rank_image = ( $ranksrow[$j]['rank_image'] ) ? '<img src="templates/' . $template_name . '/ranks/' . $images['rank'] . $ranksrow[$j]['rank_image'] . '" alt="' . $poster_rank . '" title="' . $poster_rank . '" border="0" /><br />' : ''; 
	            } 
	         } 
	      } 
	      else 
	      { 
	         for($j = 0; $j < count($ranksrow); $j++) 
	         { 
	            if ( $row['user_posts'] >= $ranksrow[$j]['rank_min'] && !$ranksrow[$j]['rank_special'] ) 
	            { 
	               $user_rank = $ranksrow[$j]['rank_title']; 
	               $rank_image = ( $ranksrow[$j]['rank_image'] ) ? '<img src="templates/' . $template_name . '/ranks/' . $images['rank'] . $ranksrow[$j]['rank_image'] . '" alt="' . $poster_rank . '" title="' . $poster_rank . '" border="0" /><br />' : ''; 
	            } 
	         } 
	      } 

		$gender_image = ''; 

		if( $row['user_level'] == 1)
		{
			$level = "<font color=#" . $theme['adminfontcolor'] . "><b>" . $lang['Admin'] . "</b>";
			$username = "<font color=#" . $theme['adminfontcolor'] . "><b>" . $row['username'] . "</b>";
			$from = ( !empty($row['user_from']) ) ? "<font color=#" . $theme['adminfontcolor'] . "><b>" . $row['user_from'] . "</b>" : '&nbsp;';
			$joined = "<font color=#" . $theme['adminfontcolor'] . "><b>" . create_date($lang['DATE_FORMAT'], $row['user_regdate'], $board_config['board_timezone']) . "</b>";
			$posts = ( $row['user_posts'] ) ? "<font color=#" . $theme['adminfontcolor'] . "><b>" . $row['user_posts'] : 0 . "</b>";
			$user_points = "<font color=#" . $theme['adminfontcolor'] . "><b>" . $row['user_points'] . "</b>";
		}
		elseif( $row['user_level'] == 2)
		{
			$level = "<font color=#" . $theme['supermodfontcolor'] . "><b>" . $lang['Super_Mod'] . "</b>";
			$username = "<font color=#" . $theme['supermodfontcolor'] . "><b>" . $row['username'] . "</b>";
			$from = ( !empty($row['user_from']) ) ? "<font color=#" . $theme['supermodfontcolor'] . "><b>" . $row['user_from'] . "</b>" : '&nbsp;';
			$joined = "<font color=#" . $theme['supermodfontcolor'] . "><b>" . create_date($lang['DATE_FORMAT'], $row['user_regdate'], $board_config['board_timezone']) . "</b>";
			$posts = ( $row['user_posts'] ) ? "<font color=#" . $theme['supermodfontcolor'] . "><b>" . $row['user_posts'] : 0 . "</b>";
			$user_points = "<font color=#" . $theme['supermodfontcolor'] . "><b>" . $row['user_points'] . "</b>";
		}
		elseif( $row['user_level'] == 3)
		{
			$level = "<font color=#" . $theme['modfontcolor'] . "><b>" . $lang['Mod'] . "</b>";
			$username = "<font color=#" . $theme['modfontcolor'] . "><b>" . $row['username'] . "</b>";
			$from = ( !empty($row['user_from']) ) ? "<font color=#" . $theme['modfontcolor'] . "><b>" . $row['user_from'] . "</b>" : '&nbsp;';
			$joined = "<font color=#" . $theme['modfontcolor'] . "><b>" . create_date($lang['DATE_FORMAT'], $row['user_regdate'], $board_config['board_timezone']) . "</b>";
			$posts = ( $row['user_posts'] ) ? "<font color=#" . $theme['modfontcolor'] . "><b>" . $row['user_posts'] : 0 . "</b>";
			$user_points = "<font color=#" . $theme['modfontcolor'] . "><b>" . $row['user_points'] . "</b>";
		}
		elseif( $row['user_level'] == 0)
		{
			$level = $lang['User'];
			$username = $row['username'];
			$from = ( !empty($row['user_from']) ) ? $row['user_from'] : '&nbsp;';
			$joined = create_date($lang['DATE_FORMAT'], $row['user_regdate'], $board_config['board_timezone']);
			$posts = ( $row['user_posts'] ) ? $row['user_posts'] : 0;
			$user_points = $row['user_points'];
		}

		$poster_avatar = '';
		if ( $row['user_avatar_type'] && $user_id != ANONYMOUS && $row['user_allowavatar'] )
		{
			switch( $row['user_avatar_type'] )
			{
				case USER_AVATAR_UPLOAD:
					$poster_avatar = ( $board_config['allow_avatar_upload'] ) ? '<img src="' . $board_config['avatar_path'] . '/' . $row['user_avatar'] . '" alt="" border="0" />' : '';
					break;
				case USER_AVATAR_REMOTE:
					$poster_avatar = ( $board_config['allow_avatar_remote'] ) ? '<img src="' . $row['user_avatar'] . '" alt="" border="0" />' : '';
					break;
				case USER_AVATAR_GALLERY:
					$poster_avatar = ( $board_config['allow_avatar_local'] ) ? '<img src="' . $board_config['avatar_gallery_path'] . '/' . $row['user_avatar'] . '" alt="" border="0" />' : '';
					break;
			}
		}

		if ( !empty($row['user_viewemail']) || $userdata['user_level'] == ADMIN )
		{
			$email_uri = ( $board_config['board_email_form'] ) ? append_sid("profile.$phpEx?mode=email&amp;" . POST_USERS_URL .'=' . $user_id) : 'mailto:' . $row['user_email'];

			$email_img = '<a href="' . $email_uri . '"><img src="' . $images['icon_email'] . '" alt="' . $lang['Send_email'] . '" title="' . $lang['Send_email'] . '" border="0" /></a>';
			$email = '<a href="' . $email_uri . '">' . $lang['Send_email'] . '</a>';
		}
		else
		{
			$email_img = '&nbsp;';
			$email = '&nbsp;';
		}

		$temp_url = append_sid("profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . "=$user_id");
		$profile_img = '<a href="' . $temp_url . '"><img src="' . $images['icon_profile'] . '" alt="' . $lang['Read_profile'] . '" title="' . $lang['Read_profile'] . '" border="0" /></a>';
		$profile = '<a href="' . $temp_url . '">' . $lang['Read_profile'] . '</a>';

		$temp_url = append_sid("privmsg.$phpEx?mode=post&amp;" . POST_USERS_URL . "=$user_id");
		$pm_img = '<a href="' . $temp_url . '"><img src="' . $images['icon_pm'] . '" alt="' . $lang['Send_private_message'] . '" title="' . $lang['Send_private_message'] . '" border="0" /></a>';
		$pm = '<a href="' . $temp_url . '">' . $lang['Send_private_message'] . '</a>';

		$www_img = ( $row['user_website'] ) ? '<a href="' . $row['user_website'] . '" target="_userwww"><img src="' . $images['icon_www'] . '" alt="' . $lang['Visit_website'] . '" title="' . $lang['Visit_website'] . '" border="0" /></a>' : '';
		$www = ( $row['user_website'] ) ? '<a href="' . $row['user_website'] . '" target="_userwww">' . $lang['Visit_website'] . '</a>' : '';

		if ( !empty($row['user_gender'])) 
		         { 
		            switch ($row['user_gender']) 
		            { 
		               case 1 : $gender_image = "<img src=\"" . $images['icon_minigender_male'] . "\" alt=\"".$lang['Gender'].": ".$lang['Male']."\" title=\"".$lang['Gender'].": ".$lang['Male']. "\" border=\"0\" />"; break; 
		               case 2 : $gender_image = "<img src=\"" . $images['icon_minigender_female'] . "\" alt=\"".$lang['Gender'].": ".$lang['Female']. "\" title=\"".$lang['Gender'].": ".$lang['Female']. "\" border=\"0\" />"; break; 
		               default : $gender_image=""; 
		            } 
		         } 

		$temp_url = append_sid("search.$phpEx?search_author=" . urlencode($username) . "&amp;showresults=posts");
		$search_img = '<a href="' . $temp_url . '"><img src="' . $images['icon_search'] . '" alt="' . $lang['Search_user_posts'] . '" title="' . $lang['Search_user_posts'] . '" border="0" /></a>';
		$search = '<a href="' . $temp_url . '">' . $lang['Search_user_posts'] . '</a>';

		$view_online_img = (($row['user_session_time'] >= ( time() - 300 )) && ($row['user_allow_viewonline'])) ? '<img src="' . $images['Online'] . '" alt="' . $lang['Online'] . '" title="' . $lang['Online'] . '" border="0" />' : '<img src="' . $images['Offline'] . '" alt="' . $lang['Offline'] . '" title="' . $lang['Offline'] . '" border="0" />'; 

		$row_color = ( !($i % 2) ) ? $theme['td_color1'] : $theme['td_color2'];
		$row_class = ( !($i % 2) ) ? $theme['td_class1'] : $theme['td_class2'];

		$post_time_sql = "SELECT post_time
			FROM " . POSTS_TABLE . "
			WHERE poster_id = " . $user_id . "
			ORDER BY post_time DESC
			LIMIT 1";

		if ( !($post_time_result = $db->sql_query($post_time_sql)) )
		{
			message_die(GENERAL_ERROR, 'Error getting user last post time information', '', __LINE__, __FILE__, $post_time_sql);
		}

		$post_time_row = $db->sql_fetchrow($post_time_result);
		$last_post_time = ( isset($post_time_row['post_time']) ) ? create_date($board_config['default_dateformat'], $post_time_row['post_time'], $board_config['board_timezone']) : $lang['Never_last_logon'];

		$template->assign_block_vars('memberrow', array(
			'ROW_NUMBER' => $i + ( $HTTP_GET_VARS['start'] + 1 ),
			'ROW_COLOR' => '#' . $row_color,
			'ROW_CLASS' => $row_class,
			'USERNAME' => $username,
			'FROM' => $from,
			'FLAG' => $flag,
			'JOINED' => $joined,
			'POSTS' => $posts,
			'PHOTO' => $photo, 
			'AVATAR_IMG' => $poster_avatar,
			'PROFILE_IMG' => $profile_img, 
			'PROFILE' => $profile, 
			'SEARCH_IMG' => $search_img,
			'SEARCH' => $search,
			'PM_IMG' => (($userdata['user_level']==ADMIN)?'<a href="' . append_sid("delete_users.$phpEx?mode=user_id&amp;del_user=$user_id") . '"><img src="' . $images['icon_delpost'] . '" alt="' . $lang['Delete'] . ' '.$username.'" title="' . $lang['Delete'] . ' '.$username.'" border="0" align="baseline" /></a> ':'').$pm_img,
			'PM' => $pm,
			'EMAIL_IMG' => $email_img,
			'EMAIL' => $email,
			'WWW_IMG' => $www_img,
			'WWW' => $www,
			'ICQ_STATUS_IMG' => $icq_status_img,
			'ICQ_IMG' => $icq_img, 
			'ICQ' => $icq, 
			'AIM_IMG' => $aim_img,
			'AIM' => $aim,
			'MSN_IMG' => $msn_img,
			'MSN' => $msn,
			'YIM_IMG' => $yim_img,
			'YIM' => $yim,
			'LEVEL' => $level,
			'LAST_LOGON' => ($userdata['user_level'] == ADMIN || (!$board_config['hidde_last_logon'] && $row['user_allow_viewonline'])) ? (($row['user_lastlogon'])? create_date($board_config['default_dateformat'], $row['user_lastlogon'], $board_config['board_timezone']):$lang['Never_last_logon']):$lang['Hidde_last_logon'],
			'POSTER_GENDER' => $gender_image, 	
			'POINTS' => $user_points,
			'USER_RANK' => $user_rank, 
			'USER_RANK_IMG' => $rank_image, 
			'VIEW_ONLINE' => $view_online_img, 
			'LAST_POST_TIME' => $last_post_time,

			'U_VIEWPROFILE' => append_sid("profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . "=$user_id"))
		);

		$i++;
	}
	while ( $row = $db->sql_fetchrow($result) );
}

if ( $mode != 'topten' || $board_config['topics_per_page'] < 10 )
{
	$sql = "SELECT count(*) AS total
		FROM " . USERS_TABLE . "
            WHERE user_id <> " . ANONYMOUS . "$letter_sql" . " 
		AND user_active = 1";

	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Error getting total users', '', __LINE__, __FILE__, $sql);
	}

	if ( $total = $db->sql_fetchrow($result) )
	{
		$total_members = $total['total'];

		$pagination = generate_pagination("memberlist.$phpEx?mode=$mode&amp;order=$sort_order&amp;letter=$by_letter", $total_members, $board_config['topics_per_page'], $start). '&nbsp;';
	}
}
else
{
	$pagination = '&nbsp;';
	$total_members = 10;
}

$template->assign_vars(array(
	'PAGINATION' => $pagination,
	'PAGE_NUMBER' => sprintf($lang['Page_of'], ( floor( $start / $board_config['topics_per_page'] ) + 1 ), ceil( $total_members / $board_config['topics_per_page'] )), 

	'L_GOTO_PAGE' => $lang['Goto_page'])
);

$template->pparse('body');

include($phpbb_root_path . 'includes/page_tail.'.$phpEx);

?>
