<?php
/***************************************************************************
 *                              links.php
 *                            -------------------
 *   begin                : May 11, 2002
 *   copyright            : (C) R. U. Serious
 *   email                : r.u.serious@handykoelsch.de
 *
 ***************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 ***************************************************************************/

define('IN_PHPBB', true);
$phpbb_root_path = './';
include($phpbb_root_path . 'extension.inc');
include($phpbb_root_path . 'common.'.$phpEx);
include($phpbb_root_path . 'includes/bbcode.'.$phpEx);
include($phpbb_root_path . 'includes/functions_post.'.$phpEx);

// Change this to zero (0) if you do not want anonymous to add links
// Links added by anonymous always go under lost links first.
$allow_anonymus_to_addlink = 0;
// Change this to the id of the category that should be shown as default
// If it does not exist you will get an errormessage
$default_cat=1;
//allow BBCode in the URL Description field
//When switching off, already entered BBcoded decriptions will still
// be parsed. If you want to turn off BBCode for ALL posts
// try this sql-query: UPDATE 'links_url' SET enable_bbcode=0
$bbcode_on = 1;

//
// Start session management
//
$userdata = session_pagestart($user_ip, PAGE_LINKS);
init_userprefs($userdata);
//
// End session management
//

// Start initial var setup
//
define('LINKS_CAT', $table_prefix.'links_cat');
define('LINKS_URL', $table_prefix.'links_url');
define('LINKS_URLINCAT', $table_prefix.'links_urlincat');

$error = FALSE;
$current_time = time();
$show_cat_exists=0;
$pers_cat_exists=0;
$bbcode_uid = '';
$url_row=NULL;
$url_rows=NULL;
$cat_rows=NULL;
$urlincat_rows=NULL;
$cat_urls=NULL;
$INcat_rows=NULL;
$lurl_rows=NULL;

if ( isset($HTTP_GET_VARS['c'])) 
{	
	$show_cat = str_replace("\'", "''",htmlspecialchars(trim($HTTP_GET_VARS['c'])));
}
else 
{	
	$show_cat = $default_cat;
}
If ((isset($HTTP_GET_VARS['mode']))||(isset($HTTP_POST_VARS['mode']))) 
{
	$mode= (isset($HTTP_POST_VARS['mode'])) ? str_replace("\'", "''",htmlspecialchars(trim($HTTP_POST_VARS['mode']))) : str_replace("\'", "''",htmlspecialchars(trim($HTTP_GET_VARS['mode'])));
}

If ((isset($HTTP_GET_VARS['id']))||(isset($HTTP_POST_VARS['id'])))
{
 	if ($id!='new')
 		$id = (isset($HTTP_POST_VARS['id'])) ? intval($HTTP_POST_VARS['id']) : intval($HTTP_GET_VARS['id']);
}

$submit = (isset($HTTP_POST_VARS['post'])) ? true : false;
$delete = (isset($HTTP_POST_VARS['delete'])) ? true : false;
//
// End initial var setup
//

switch( $mode )
{
  case 'show': //*********** Show the Link that has been clicked
    if ($id != '') 
	{	// Get the url of the accessed link
		$sql = "SELECT id, url, clickcounter, lastclickid, lastclicktime 
				FROM ".LINKS_URL."
				WHERE id = ". $id;
		if( !($result = $db->sql_query($sql)) )
		{ 
			message_die(GENERAL_ERROR, 'Could not query url list', '', __LINE__, __FILE__, $sql); 
		}
		while (($url_row[] = $db->sql_fetchrow($result)));
        if (!strlen($url_row[0]["url"])) 
		{ 
			message_die(GENERAL_ERROR, 'There is no such link', '', __LINE__, __FILE__, $sql); 
		}
        if (substr($url_row[0]["url"],0,7)!="http://")
        { 
        	$url_row[0]["url"] = "http://".$url_row[0]["url"];
        }
		$header_location = ( @preg_match('/Microsoft|WebSTAR|Xitami/', getenv('SERVER_SOFTWARE')) ) ? 'Refresh: 0; URL=' : 'Location: ';
		header($header_location . $url_row[0]['url']);	// Redirect to site
		// Prevent Spamming of click counter: Different User_id or waiting (Floodtime) 
		If (($current_time > ($url_row[0]["lastclicktime"] + ($board_config['flood_interval']))) || ($userdata['user_id'] != $url_row[0]['lastclickid']))
		{
			$url_row[0]['clickcounter']++; // Increase ClickCounter
			$sql = "UPDATE ".LINKS_URL." SET clickcounter=". $url_row[0]['clickcounter'] .", lastclickid='". $userdata['user_id']."', lastclicktime='$current_time' 
					WHERE id = ". $id;
			if( !($result = $db->sql_query($sql)) )
			{ 
				message_die(GENERAL_ERROR, 'Cannot update counter', '', __LINE__, __FILE__, $sql); 
			}
		}
		exit;
	} 
	else
	{	
		message_die(GENERAL_ERROR, 'url not specified', '', __LINE__, __FILE__, $sql);
	};

  case 'favlink': //*****************  Add a link to the users favorites
	// Read all categories
	If ($id!='')
	{
		if( !$userdata['session_logged_in'] ) 
	    { 
			$header_location = ( @preg_match('/Microsoft|WebSTAR|Xitami/', getenv('SERVER_SOFTWARE')) ) ? 'Refresh: 0; URL=' : 'Location: ';
	       	header($header_location . append_sid("login.$phpEx?redirect=$PHP_SELF&mode=favlink&id=". $id, true));
	       	exit; 
	    } 
		$sql = "SELECT u.id, u.name, u.owner 
				FROM ".LINKS_URL." as u 
				WHERE u.id='$id' ORDER BY u.id";
		if( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Could not query url list', '', __LINE__, __FILE__, $sql);
		}
		while (($url_rows[] = $db->sql_fetchrow($result)));
		if ($url_rows[0]['id']=='') // The url does not exist
		{
			message_die(GENERAL_ERROR, 'URL does not exist', '', __LINE__, __FILE__, $sql);
			$header_location = ( @preg_match('/Microsoft|WebSTAR|Xitami/', getenv('SERVER_SOFTWARE')) ) ? 'Refresh: 0; URL=' : 'Location: ';
			header($header_location . append_sid($phpbb_root_path."links.$phpEx"), true);
			exit;
		}

		$sql = "SELECT id, owner 
				FROM ".LINKS_CAT." 
				WHERE owner='". $userdata['user_id']."'";
		if( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Could not query url list', '', __LINE__, __FILE__, $sql);
		}
		while (($cat_rows[] = $db->sql_fetchrow($result)));
		If ($cat_rows[0]['id']=='') 
		{
			// Make a personal category, because the user hasn't one yet
			$catname ="'". $userdata['username']."s ". $lang['Favorites']."'";
			$sql = "INSERT INTO ".LINKS_CAT." SET name=". $catname. ", hidden=1, owner=". $userdata['user_id'];
			if( !($result = $db->sql_query($sql)) )
			{
				message_die(GENERAL_ERROR, 'Could not create Personal Bookmarks Category', '', __LINE__, __FILE__, $sql);
			}
			$cat_rows[0]['id'] = $db->sql_nextid();
		} 

		$sql = "SELECT url_id, cat_id  
				FROM ".LINKS_URLINCAT." 
				WHERE url_id=$id AND cat_id=". $cat_rows[0]['id'];
		if( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Could not query url list', '', __LINE__, __FILE__, $sql);
		}
		while (($urlincat_rows[] = $db->sql_fetchrow($result)));
		If ($urlincat_rows[0]['id']=='') 
		{	//Check if the url is already in the users favorites, if not=> add it
			$sql = " INSERT INTO ".LINKS_URLINCAT." SET url_id=$id,cat_id=". $cat_rows[0]['id'];
			if( !($result = $db->sql_query($sql)) )
			{
				message_die(GENERAL_ERROR, 'Could not add url to your favorites', '', __LINE__, __FILE__, $sql);
			}
		}
	}
	// Update successful, now redirect to link-index
	$header_location = ( @preg_match('/Microsoft|WebSTAR|Xitami/', getenv('SERVER_SOFTWARE')) ) ? 'Refresh: 0; URL=' : 'Location: ';
	header($header_location . append_sid($phpbb_root_path."links.$phpEx"), true);
	exit;


  case 'editcat';
	// Only allow admins to edit categories or users their own favorites
	if ($id!='new')
	{
		$sql = "SELECT id, name, hidden, owner 
				FROM ".LINKS_CAT." 
				WHERE id =". $id ." ORDER BY id";
		if( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Could not query category list', '', __LINE__, __FILE__, $sql);
		}
		while (($cat_rows[] = $db->sql_fetchrow($result)));
	}
	
	if ((!$userdata['session_logged_in']) || (($userdata['user_level']!=ADMIN)&&($userdata['user_id']!=$cat_rows[0]['owner']))) 
    { 
		$header_location = ( @preg_match('/Microsoft|WebSTAR|Xitami/', getenv('SERVER_SOFTWARE')) ) ? 'Refresh: 0; URL=' : 'Location: ';
        header($header_location . append_sid("links.$phpEx", true));
       	exit; 
    } 


	// When hitting return in the form, submit is not set as it should be (clicking submit works)
	if ((isset($HTTP_POST_VARS['cat_name']))&&(!$delete)) $submit=1;

	if  (($submit)&&(isset($HTTP_POST_VARS['cat_name']))&&(isset($HTTP_GET_VARS['id'])))
	{
		$cat_name=str_replace("\'", "''",htmlspecialchars(trim($HTTP_POST_VARS['cat_name'])));
		if ($id=='new')
		{
			// Inset the category with the specified name
			$sql = "INSERT INTO ".LINKS_CAT." SET name='$cat_name', hidden=0, owner=0";
			if( !($result = $db->sql_query($sql)) )
			{
				message_die(GENERAL_ERROR, 'Could not query category list', '', __LINE__, __FILE__, $sql);
			}
			$id = $db->sql_nextid();
		}
		else
		{
			// First update the name of the category 
			// If its the owner also update the hidden status
			(($userdata['user_id']==$cat_rows[0]['owner'])
			 &&($HTTP_POST_VARS['option_hidden']=='on')) ? $hide=", hidden=1" : $hide=", hidden=0";

			$sql = "UPDATE ".LINKS_CAT." SET name='$cat_name' $hide 
					WHERE id='$id'";
			if( !($result = $db->sql_query($sql)) )
			{
				message_die(GENERAL_ERROR, 'Could not query category list', '', __LINE__, __FILE__, $sql);
			}

			// Read all urls that belong to the cat
			$sql = "SELECT id, url_id, pos 
					FROM ".LINKS_URLINCAT." 
					WHERE cat_id=$id";
			if( !($result = $db->sql_query($sql)) )
			{
				message_die(GENERAL_ERROR, 'Could not query cat-urls list', '', __LINE__, __FILE__, $sql);
			}
			while (($url_rows[] = $db->sql_fetchrow($result)));
			$total_urls = count($url_rows)-1;

			// Look if one of the urls was unchecked (if it was=> remove it)
			$test='';
			for($i = 0; $i < $total_urls; $i++) 
			{ 	// Loop through the urls
				if (!isset($HTTP_POST_VARS['option_'. $url_rows[$i]['url_id']])) 
				{
					// It was unchecked, so remove the link from the category
					$sql = "DELETE 
							FROM ".LINKS_URLINCAT." 
							WHERE id=". $url_rows[$i]['id'];
					$result = $db->sql_query($sql);
				}
				else
				{
					$pos_entered = intval($HTTP_POST_VARS['pos_'. $url_rows[$i]['url_id']]);
					if ($pos_entered!=$url_rows[$i]['pos'])
					{
						$sql = "UPDATE ".LINKS_URLINCAT." SET pos='$pos_entered' 
								WHERE id=". $url_rows[$i]['id'];
						$result = $db->sql_query($sql);
					}
				}
			}
		}
		// Update successful, now redirect to link-index
		$header_location = ( @preg_match('/Microsoft|WebSTAR|Xitami/', getenv('SERVER_SOFTWARE')) ) ? 'Refresh: 0; URL=' : 'Location: ';
		header($header_location . append_sid($phpbb_root_path."links.$phpEx?c=$id", true), true);
		exit;
	}
  	// A category was selected for deletion
	if  (($delete)&&(isset($HTTP_GET_VARS['id'])))
	{
		$sql = "DELETE 
				FROM ".LINKS_URLINCAT." 
				WHERE cat_id=$id";
		if( !($result = $db->sql_query($sql)) )
		{ 
			message_die(GENERAL_ERROR, 'Deletion ERROR', '', __LINE__, __FILE__, $sql); 
		}	
		$sql = "DELETE 
				FROM ".LINKS_CAT." 
				WHERE id=$id";
		if( !($result = $db->sql_query($sql)) )
		{ 
			message_die(GENERAL_ERROR, 'Deletion ERROR', '', __LINE__, __FILE__, $sql); 
		}	
		$header_location = ( @preg_match('/Microsoft|WebSTAR|Xitami/', getenv('SERVER_SOFTWARE')) ) ? 'Refresh: 0; URL=' : 'Location: ';
		header($header_location . append_sid($phpbb_root_path."links.$phpEx"), true);
		exit;
	}


	//***************  Build the page for adding/editing categories
	$box_header =$lang['add_cat'];
	$page_title = $lang['add_cat'];
	include($phpbb_root_path . 'includes/page_header.'.$phpEx);
	$template->set_filenames(array(
		'body' => 'link_editcat.tpl')
	);

	make_jumpbox('viewforum.'.$phpEx, $forum_id); 

	$delete_button = '';

	if (($id!= '')&&($id!='new'))
	{
		//See if the selected category exists
		$sql = "SELECT id, name, hidden, owner 
				FROM ".LINKS_CAT." 
				WHERE id =". $id ." ORDER BY id";
		if( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Could not query category list', '', __LINE__, __FILE__, $sql);
		}
		while (($cat_rows[] = $db->sql_fetchrow($result)));
	}

	if ((!$cat_rows[0]['id'])||($id == '')) $id='new';

    if ($id!='new') // When editing an existing category, fetch data
    {	
		$box_header =$lang['edit_cat'].": ". $cat_rows[0]['name'];

		// For private categories allow the user to set whether it should be hidden
		if(($userdata['user_id'] == $cat_rows[0]['owner'])&&($cat_rows[0]['owner']!=0))
		{
			if ($cat_rows[0]['hidden']==1) $hidden='checked="checked"'; else $hidden='';
			$template->assign_block_vars("switch_catowner", array(
				'L_HIDDEN' => $lang['hide_cat'],
				'HIDDEN_CHECK' => $hidden,
				)
			);
		}

		// Read all urls that belong to the cat
		$sql = "SELECT u.id, u.url, u.name, u.description, uc.url_id, uc.cat_id, uc.pos
				FROM ".LINKS_URL." as u, ".LINKS_URLINCAT." as uc 
				WHERE u.id = uc.url_id AND uc.cat_id=". $cat_rows[0]['id'] ."
				ORDER BY uc.pos, u.name";
		if( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Could not query url list', '', __LINE__, __FILE__, $sql);
		}
		while (($url_rows[] = $db->sql_fetchrow($result)));
		$total_urls = count($url_rows)-1;
		$delete_button = '&nbsp;<input type="submit" accesskey="d" name="delete" class="mainoption" value="'. $lang['del_cat'] .'" />';
    } 

	for($i = 0; $i < $total_urls; $i++) { // loop through the urls
		$template->assign_block_vars('linkrow', array(
			'URL_ID' => $url_rows[$i]['id'],
			'URL_NAME' => $url_rows[$i]['name'],
			'L_POS' => $lang['pos'],
			'URL_POS' => $url_rows[$i]['pos'],
			)
		);			
	}
    
	$hidden_form_fields='';
//	$hidden_form_fields = '<input type="hidden" name="id" value="' . $id . '" />';
	
	$template->assign_vars(array(
		'L_HEADER' => $box_header,
		'L_URL' => $lang['url_c'],
		'L_CAT' => $lang['cat'],
		'L_SUBMIT' => $lang['Submit'],
		'L_EMPTY_MESSAGE' => $lang['Empty_message'],
	
		'S_POST_ACTION' => append_sid($phpbb_root_path."links.$phpEx?mode=editcat&id=". $id),
		'S_DELETE_ACTION' => $delete_button,
		'S_HIDDEN_FORM_FIELDS' => $hidden_form_fields,

		'CAT_NAME' => $cat_rows[0]['name'],
		)
	);
	$template->pparse('body');
	include($phpbb_root_path . 'includes/page_tail.'.$phpEx);
    exit;
  	

  case 'editlink': //*****************  Add a link to the db or edit a link from the db
	// Only allow admins and owners to edit a link
	if ($id!='new')
	{
		$sql = "SELECT id, name, owner 
				FROM ".LINKS_URL." 
				WHERE id =". $id ." ORDER BY id";
		if( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Could not query category list', '', __LINE__, __FILE__, $sql);
		}
		while (($cat_urls[] = $db->sql_fetchrow($result)));
		if ((!$userdata['session_logged_in'])||(($userdata['user_level']!=ADMIN)&&($userdata['user_id']!=$cat_urls[0]['owner']))) 
	    { 
			$header_location = ( @preg_match('/Microsoft|WebSTAR|Xitami/', getenv('SERVER_SOFTWARE')) ) ? 'Refresh: 0; URL=' : 'Location: ';
	       	header($header_location . append_sid("links.$phpEx", true));
	       	exit; 
	    } 
	} 
	else
	{
		if ((!$userdata['session_logged_in'])&&(!$allow_anonymus_to_addlink)) 
	    { 
			$header_location = ( @preg_match('/Microsoft|WebSTAR|Xitami/', getenv('SERVER_SOFTWARE')) ) ? 'Refresh: 0; URL=' : 'Location: ';
	        	header($header_location . append_sid("links.$phpEx", true));
	       	exit; 
	    } 
	}
	
  	// A new or edited link was submitted
	if  (($submit)&&(isset($HTTP_POST_VARS['site_url']))&&(isset($HTTP_POST_VARS['site_url_desc']))&&(isset($HTTP_GET_VARS['id'])))
	{
		$site_url=str_replace("\'", "''",htmlspecialchars(trim($HTTP_POST_VARS['site_url'])));
		If (isset($HTTP_POST_VARS['site_url_name'])) 
		{
			$site_name = str_replace("\'", "''",htmlspecialchars(trim($HTTP_POST_VARS['site_url_name']))); 
			if ($site_name=='') $site_name = $site_url;
		} 
		else 
		{
			$site_name = $site_url;
		}
		//$site_desc = str_replace("\'", "''",htmlspecialchars(trim(stripslashes($HTTP_POST_VARS['site_url_desc']))));
		$site_desc = trim($HTTP_POST_VARS['site_url_desc']);
		// BBCode-Support
		// Original is prepare_message($signature, $allowhtml, $allowbbcode, $allowsmilies, $signature_bbcode_uid);
		$bbcode_uid = ( $bbcode_on ) ? make_bbcode_uid() : '';
		$site_desc = prepare_message($site_desc, 0, $bbcode_on, 1, $bbcode_uid);
		If ($id=='new')
		{
			$current_time = time();
			$owner = ($userdata['session_logged_in']) ? $userdata['user_id'] : '0';
			$sql = "INSERT INTO ".LINKS_URL." SET url = '$site_url', name='$site_name', description='$site_desc', owner='". $owner ."', added='$current_time', bbcode_uid='$bbcode_uid', enable_bbcode='$bbcode_on'";
		}
		else
		{	
			$sql = "UPDATE ".LINKS_URL." SET url='$site_url', name='$site_name', description='$site_desc', bbcode_uid='$bbcode_uid' ";
			if ($bbcode_on) { $sql .=", enable_bbcode='$bbcode_on' "; };
			$sql .= "WHERE id=". $id;
		}
		if( !($result = $db->sql_query($sql)) )
		{ 
			message_die(GENERAL_ERROR, 'ERROR updating links table'. $sql, '', __LINE__, __FILE__, $sql); 
		}

		If ($id=='new')		//If new url was inserted this is the key of our new url
		{	
			$id = $db->sql_nextid();
		}

		// If a user is submitting a link to his personal bookmarks for the first time
		// we have to make him his own category
		If ((isset($HTTP_POST_VARS['option_new']))&&($HTTP_POST_VARS['option_new']='on'))
		{
			$catname ="'". $userdata['username']."s ". $lang['Favorites']."'";
			$sql = "INSERT INTO ".LINKS_CAT." SET name=". $catname. ", hidden=1, owner=". $userdata['user_id'];
			if( !($result = $db->sql_query($sql)) )
			{
				message_die(GENERAL_ERROR, 'Could not create Personal Bookmarks Category', '', __LINE__, __FILE__, $sql);
			}
			$pers_cat = $db->sql_nextid();
			$HTTP_POST_VARS['option_'. $pers_cat]=$HTTP_POST_VARS['option_new'];
		} 
			
		// Now after inserting the link, we have to update/insert the connection to the cat(s)
		// Read all categories 
		$sql = "SELECT id, name 
				FROM ".LINKS_CAT." ORDER BY id";
		if( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Could not query url list', '', __LINE__, __FILE__, $sql);
		}
		while (($cat_rows[] = $db->sql_fetchrow($result)));
		$total_cats = count($cat_rows)-1;

		// Read the active categories to know what connection url->cat were already set yxc
		// OLD: $sql = "SELECT cat_id FROM ".LINKS_URLINCAT." WHERE url_id='$id' ORDER BY cat_id ASC";
		// NEW: 
		$sql = "SELECT uc.cat_id 
				FROM ".LINKS_CAT." as c, ".LINKS_URLINCAT." as uc 
				WHERE uc.url_id='$id' AND c.id=uc.cat_id AND (owner='0' OR owner='". $userdata['user_id'] ."') ORDER BY uc.cat_id ASC";
		if( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Could not query which url in which cat', '', __LINE__, __FILE__, $sql);
		}
		while (($INcat_rows[] = $db->sql_fetchrow($result)));
		$total_INcats = count($INcat_rows)-1;

		for($i = 0; $i < $total_cats; $i++) 
		{ 	//all cats 
			$sql= '';$INcat=0;
			for($j = 0; $j < $total_INcats; $j++) 
			{ 	//check if url in this cat
				if ($cat_rows[$i]['id'] == $INcat_rows[$j]['cat_id']) $INcat=1;
			}
			If (($INcat)&&(!isset($HTTP_POST_VARS['option_'. $cat_rows[$i]['id']]))) 
			{
				$sql = "DELETE 
						FROM ".LINKS_URLINCAT." 
						WHERE url_id=$id AND cat_id=". $cat_rows[$i]['id']." ";
			}
			else 
			{	
				If (!($INcat)&&(isset($HTTP_POST_VARS['option_'. $cat_rows[$i]['id']]))) 
				{
					$sql = " INSERT INTO ".LINKS_URLINCAT." 
							 SET url_id=$id,cat_id=". $cat_rows[$i]['id']." ";
				}
			}
			If ($sql != '') if( !($result = $db->sql_query($sql)) )
			{ 
				message_die(GENERAL_ERROR, 'ERROR updating urlincat table'. $sql, '', __LINE__, __FILE__, $sql); 
			}

		}

		// Update successful, now redirect to link-index
		$header_location = ( @preg_match('/Microsoft|WebSTAR|Xitami/', getenv('SERVER_SOFTWARE')) ) ? 'Refresh: 0; URL=' : 'Location: ';
		header($header_location . append_sid($phpbb_root_path."links.$phpEx"), true);
		exit;

	}

  	// A link was selected for deletion
	if  (($delete)&&(isset($HTTP_GET_VARS['id'])))
	{
		$sql = "DELETE 
				FROM ".LINKS_URLINCAT." 
				WHERE url_id=$id";
		if( !($result = $db->sql_query($sql)) )
		{ 
			message_die(GENERAL_ERROR, 'Deletion ERROR', '', __LINE__, __FILE__, $sql); 
		}	
		$sql = "DELETE 
				FROM ".LINKS_URL." 
				WHERE id=$id";
		if( !($result = $db->sql_query($sql)) )
		{ 
			message_die(GENERAL_ERROR, 'Deletion ERROR', '', __LINE__, __FILE__, $sql); 
		}	
		$header_location = ( @preg_match('/Microsoft|WebSTAR|Xitami/', getenv('SERVER_SOFTWARE')) ) ? 'Refresh: 0; URL=' : 'Location: ';
		header($header_location . append_sid($phpbb_root_path."links.$phpEx"), true);
		exit;
	}
	//***************  Build the page for adding/editing url
	$box_header =$lang['add_url'];
	$page_title = $lang['add_url'];
	include($phpbb_root_path . 'includes/page_header.'.$phpEx);
	$template->set_filenames(array(
		'body' => 'link_editurl.tpl')
	);

	make_jumpbox('viewforum.'.$phpEx, $forum_id); 

	$delete_button = '';

	// Read all categories to be able to select which cat the url goes into
	$sql = "SELECT id, name, owner 
			FROM ".LINKS_CAT." 
			ORDER BY owner, id";
	if( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Could not query cat list', '', __LINE__, __FILE__, $sql);
	}
	while (($cat_rows[] = $db->sql_fetchrow($result)));
	$total_cats = count($cat_rows)-1;
	
	if ($id == '') $id='new';
    if ($id!='new') // When editing an existing link, fetch data
    {	
		$box_header =$lang['edit_url'];
		$sql = "SELECT u.id, u.url, u.name, u.description, u.bbcode_uid, u.enable_bbcode 
				FROM ".LINKS_URL." as u 
				WHERE u.id = ". $id;
		if( !($result = $db->sql_query($sql)) )
		{ 
			message_die(GENERAL_ERROR, 'Could not query url list', '', __LINE__, __FILE__, $sql); 
		}
		while (($url_row[] = $db->sql_fetchrow($result)));
        if (!strlen($url_row[0]["id"])) 
		{ 
			message_die(GENERAL_ERROR, $url_row[0]["id"] . 'There is no such link', '', __LINE__, __FILE__, $sql); 
		}
		
		// Read the active categories to make the appropiate checkboxes
		$sql = "SELECT uc.cat_id 
				FROM ".LINKS_CAT." as c, ".LINKS_URLINCAT." as uc 
				WHERE uc.url_id='$id' AND c.id=uc.cat_id AND (owner='0' OR owner='". $userdata['user_id'] ."') ORDER BY uc.cat_id ASC";
		if( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'Could not query which url in which cat', '', __LINE__, __FILE__, $sql);
		}
		while (($INcat_rows[] = $db->sql_fetchrow($result)));
		$total_INcats = count($INcat_rows)-1;
		$delete_button = '&nbsp;<input type="submit" accesskey="d" name="delete" class="mainoption" value="'. $lang['del_url'] .'" />';
    } 
	if ($userdata['session_logged_in'])
	{
		for($i = 0; $i < $total_cats; $i++) { // loop through cats 
			if (($cat_rows[$i]['owner']==$userdata['user_id'])||($cat_rows[$i]['owner']==0))
			{
				$INcat = '';
				for($j = 0; $j < $total_INcats; $j++) 
				{ 	//check if url in this cat
					if ($cat_rows[$i]['id'] == $INcat_rows[$j]['cat_id']) $INcat='checked="checked"';
				}
				//if user has a pers_cat and adds a link check his pers_cat per default
				if (($cat_rows[$i]['owner'] == $userdata['user_id'])&& ($id=='new'))
				{	
					$INcat='checked="checked"';
					$pers_cat_exists=1;
				}
				$template->assign_block_vars('catrow', array(
					'CAT_CHECK' => $INcat,
					'CAT_ID' => $cat_rows[$i]['id'],
					'CAT_NAME' => $cat_rows[$i]['name'],
					)
				);			
			}
		}
		// If new url then check if personal cat exists, 
		// else show a dummy one and always make the checkbox for that dummy personal category!
		if (($id=='new')&&(!$pers_cat_exists))
		{
			$template->assign_block_vars('catrow', array(
				'CAT_CHECK' => 'checked="checked"',
				'CAT_ID' => 'new',
				'CAT_NAME' => $userdata['username']."s ". $lang['Favorites'],
				)
			);			
		}
		$template->assign_vars(array(
			'L_CAT' => $lang['cat_c'] ,
			)
		);

	}
	    
	$hidden_form_fields='';
//	$hidden_form_fields = '<input type="hidden" name="id" value="' . $id . '" />';
	// BBCode-Support
	$site_desc = $url_row[0]["description"];
	$bbcode_uid = $url_row[0]["bbcode_uid"];
	$site_desc = preg_replace("/\:(([a-z0-9]:)?)$bbcode_uid/si", '', $site_desc);
	$template->assign_vars(array(
		'L_HEADER' => $box_header,
		'L_URL' => $lang['url'],
		'L_URL_NAME' => $lang['url_name'],
		'L_URL_DESC' => $lang['url_desc'],
		'L_SUBMIT' => $lang['Submit'],
		'L_EMPTY_MESSAGE' => $lang['Empty_message'],

		'S_POST_ACTION' => append_sid($phpbb_root_path."links.$phpEx?mode=editlink&id=". $id),
		'S_DELETE_ACTION' => $delete_button,

		'S_HIDDEN_FORM_FIELDS' => $hidden_form_fields,

		'SITE_URL' => $url_row[0]["url"],
		'SITE_URL_NAME' => $url_row[0]["name"],
		'SITE_URL_DESC' => $site_desc,
		)
	);
	$template->pparse('body');
	include($phpbb_root_path . 'includes/page_tail.'.$phpEx);
    exit;

  default:     //************************** Show the requested (/default) Category
	$page_title = $lang['Links'];
	include($phpbb_root_path . 'includes/page_header.'.$phpEx);
	$template->set_filenames(array(
		'body' => 'link_body.tpl')
	);

	make_jumpbox('viewforum.'.$phpEx, $forum_id); 

	if( $userdata['user_level'] == ADMIN )
	{
		$template->assign_block_vars("switch_user_admin", array(
			'ADD_CAT_URL' => append_sid("links.php?mode=editcat&id=new"),
			)
		);
	}
	else
	{
		// Only Admins get to see 'lost links'
		if ($show_cat=='lost') $show_cat=$default_cat;
	}
	
	if (($userdata['session_logged_in'])||($allow_anonymus_to_addlink==1))
	{
		$template->assign_block_vars("switch_user_loggedin", array(
			'ADD_LINK_URL' => append_sid("links.php?mode=editlink&id=new"),	
			)
		);
	}
	$template->assign_vars(array(
		'NEW_URL_IMG' => $images['links_newurl'],
		'NEW_CAT_IMG' => $images['links_newcat'],
		'L_ADD_CAT' => $lang['add_cat'],
		'L_ADD_URL' => $lang['add_url'], 		
		)
	);

	// Read all public categories and the users own category
	$sql = "SELECT id, name, owner, hidden 
			FROM ".LINKS_CAT." 
			ORDER BY owner, id";
	if( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Could not query url list', '', __LINE__, __FILE__, $sql);
	}
	while (($cat_rows[] = $db->sql_fetchrow($result)));
	$total_cats = count($cat_rows)-1;

	// Read all urls 
	//$sql = "SELECT u.id, u.url, u.name, u.description, u.added, u.owner, u.clickcounter, u.bbcode_uid, uc.url_id, uc.cat_id, uc.pos
	$sql = "SELECT u.*, uc.url_id, uc.cat_id, uc.pos
			FROM ".LINKS_URL." as u, ".LINKS_URLINCAT." as uc 
			WHERE u.id = uc.url_id 
			ORDER BY uc.pos, u.name";
	if( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, 'Could not query url list', '', __LINE__, __FILE__, $sql);
	}
	while (($url_rows[] = $db->sql_fetchrow($result)));
	$total_urls = count($url_rows)-1;

	// Tag the ones that are already in the users personal bookmarks, so that 
	// we can have an "add to my bookmarks" link if he doesn't have it
	for($i = 0; $i < $total_cats; $i++) 
	{ 	//Loop through cats
		$current_cat = $cat_rows[$i]['id'];
		if ($current_cat==$show_cat) $show_cat_exists=1;
		// If a hidden cat is selected, only show default cat
		if (($current_cat==$show_cat)&&($cat_rows[$i]['hidden']==1)&&($cat_rows[$i]['owner']!=$userdata['user_id']))
		{
			$show_cat=$default_cat;
			$error = TRUE;
			$error_msg = $lang['Sorry_auth'];
		}
		if ($cat_rows[$i]['owner']==$userdata['user_id']) 
		{
			for($j = 0; $j < $total_urls; $j++) 
			{ 	//tag the links that are in the viewers personal Cat
		        if ($url_rows[$j]['cat_id'] == $current_cat) 
		        {
					for($k = 0; $k < $total_urls; $k++)
					{
						if ($url_rows[$k]['id']==$url_rows[$j]['id']) 
							$url_rows[$k]['in_pers_cat']=1;
					}
				}
			}
		}
	}
	
	if ((!$show_cat_exists)&&($show_cat!='all')&&($show_cat!='lost'))
	{
		$show_cat=$default_cat;
		$error = TRUE;
		$error_msg = $lang['Sorry_auth'];
	}
	

	// Build Navigation
	for($i = 0; $i < $total_cats; $i++) { //printout cats
		if (!(($cat_rows[$i]['owner']!=0)&&($cat_rows[$i]['owner']!=$userdata['user_id'])))
		{
			if ($show_cat == $cat_rows[$i]['id']) 
			{	
				$nav_button = '<b> '. $cat_rows[$i]['name'].' </b>';
			}
			else 
			{	
				$nav_button = $cat_rows[$i]['name'];
			}
			$template->assign_block_vars('navbar', array(
				'CAT_URL' => append_sid("links.$phpEx?c=". $cat_rows[$i]['id']),
				'CAT_NAME' => $nav_button,
				)
			);
		}
	}
	// Show the navbutton for "ALL CATEGORIES"
	if ($show_cat == 'all') 
	{
		$lang['show_all']='<b> '. $lang['show_all'] .' </b>';
	}
	$template->assign_block_vars('navbar', array(
		'CAT_URL' => append_sid("links.$phpEx?c=all"),
		'CAT_NAME' => $lang['show_all'],
		)
	);			
	// Show the navbutton for "LOST LINKS"
	if ($show_cat == 'lost') 
	{
		$lang['lost_links']='<b> '. $lang['lost_links'] .' </b>';
	}
	if ($userdata['user_level'] == ADMIN )
	{
		$template->assign_block_vars('navbar', array(
			'CAT_URL' => append_sid("links.$phpEx?c=lost"),
			'CAT_NAME' => $lang['lost_links'],
			)
		);			
	}
	// Build the index
	for($i = 0; $i < $total_cats; $i++) 
	{ 	// Printout cats
		$current_cat = $cat_rows[$i]['id'];
		if (($current_cat == $show_cat) || ( ($show_cat=='all') && (($cat_rows[$i]['owner']=='0') || ($cat_rows[$i]['owner']==$userdata['user_id']))))
		//y
		{
			$editlink='';
			if (($userdata['user_id'] == $cat_rows[$i]['owner']) || ( $userdata['user_level'] == ADMIN ))
			{ 
				$editlink= '&nbsp;<a href="'. append_sid("links.$phpEx?mode=editcat&id=". $current_cat) .'" class="forumdetails" style="color:#FFFFFF">('.$lang['edit_cat'].')</a>'; 
			}
			$template->assign_block_vars('catrow', array(
				'CAT_NAME' => $cat_rows[$i]['name'] . $editlink,
				)
			);
			$row=0;
			for($j = 0; $j < $total_urls; $j++) 
			{ 	//printout urls 
		        $url_id = $j;
		        if ($url_rows[$url_id]['cat_id'] == $current_cat) 
		        {
		        	$row++;
			        if (substr($url_rows[$url_id]["url"],0,7)!="http://") 
			        {
			            $url_rows[$url_id]["url"] = "http://".$url_rows[$url_id]["url"];
			        }
					$editlink='';
					if (($userdata['user_id'] == $url_rows[$url_id]['owner']) || ( $userdata['user_level'] == ADMIN ))
					{ 
						$editlink .= '<a href="'. append_sid("links.$phpEx?mode=editlink&id=". $url_rows[$url_id]['id']) .'" class="gensmall">('.$lang['edit_url'].')</a>';
					}
					$statistics = '['. $url_rows[$url_id]['clickcounter'] .' clicks]';
					if (!$url_rows[$url_id]['in_pers_cat'])
					{
						$statistics .= ' :: [<a href="'. append_sid("links.$phpEx?mode=favlink&id=". $url_rows[$url_id]['id']) .'" class="gensmall" title="'.$lang['add_link_fav'].'">'.$lang['add_link_fav'].'</a>]';
					}
					// BBCode-Support
					$site_desc = $url_rows[$url_id]['description'];
					$site_desc = str_replace("\n", "\n<br />\n", $site_desc);
					$bbcode_uid = $url_rows[$url_id]['bbcode_uid'];
					$use_bbcode = (($bbcode_on) ||($url_rows[$url_id]['enable_bbcode'])) ? true : false;
					$site_desc = ( $use_bbcode ) ? bbencode_second_pass($site_desc, $bbcode_uid) : preg_replace('/\:[0-9a-z\:]+\]/si', ']', $site_desc);
					//$site_desc = str_replace("\n", "\n<br />\n", $site_desc);
					$template->assign_block_vars('catrow.linkrow',	array(
						'EDIT_LINK' => $editlink,
		                		'LINK_CLASS' => ($row % 2) ? 'row3' : 'row1',
						'LINK_ID' => $url_rows[$url_id]['id'],
						'LINK_URL' => "links.$phpEx?mode=show&id=". $url_rows[$url_id]['id'],
						'LINK_NAME' => stripslashes($url_rows[$url_id]['name']),
						'LINK_DESC' => smilies_pass($site_desc),
						'LINK_STAT'	=> $statistics,
						)
					);
				}
			} // Printout urls 
		}// Showcat
	}// Printout cats
	// When selected Lost Links show those that have no cat
	if ($show_cat=='lost') 
	{
		$template->assign_block_vars('catrow', array(
			'CAT_NAME' => $lang['lost_links'],
			)
		);

		// Read all urls 
		//$sql = "SELECT u.id, u.url, u.name, u.description, u.added, u.owner, u.clickcounter
		$sql = "SELECT u.*
				FROM ".LINKS_URL." as u 
				LEFT JOIN ".LINKS_URLINCAT." as uc ON u.id=uc.url_id 
				WHERE uc.url_id IS NULL";
		if( !($result = $db->sql_query($sql)) )
		{
			message_die(GENERAL_ERROR, 'E: '. $sql, '', __LINE__, __FILE__, $sql);
		}
		while (($lurl_rows[] = $db->sql_fetchrow($result)));
		$total_lost_urls = count($lurl_rows)-1;

		$row=0;
		for($j = 0; $j < $total_lost_urls; $j++) 
		{ 	//printout urls 
        	$row++;
	        $url_id = $j;
	        if (substr($lurl_rows[$url_id]["url"],0,7)!="http://") 
	        {
	            $lurl_rows[$url_id]["url"] = "http://".$lurl_rows[$url_id]["url"];
	        }
			$editlink='';
			if ( $userdata['user_level'] == ADMIN )
			{ 
				$editlink .= '<a href="' . append_sid("links.$phpEx?mode=editlink&id=". $lurl_rows[$url_id]['id']) . '"><small>('.$lang['edit_url'].')<small></a>';
			}
			$statistics = '['. $lurl_rows[$url_id]['clickcounter'] .' clicks]';
			// BBCode-Support
			$site_desc = $lurl_rows[$url_id]['description'];
			$site_desc = str_replace("\n", "\n<br />\n", $site_desc);
			$bbcode_uid = $lurl_rows[$url_id]['bbcode_uid'];
			$use_bbcode = (($bbcode_on) ||($lurl_rows[$url_id]["enable_bbcode"])) ? true : false;
			$site_desc = ( $use_bbcode ) ? bbencode_second_pass($site_desc, $bbcode_uid) : preg_replace('/\:[0-9a-z\:]+\]/si', ']', $site_desc);
			$template->assign_block_vars('catrow.linkrow',	array(
				'EDIT_LINK' => $editlink,
	                  'LINK_CLASS' => ($row % 2) ? 'row3' : 'row1',
				'LINK_ID' => $lurl_rows[$url_id]['id'],
				'LINK_URL' => "links.$phpEx?mode=show&id=". $lurl_rows[$url_id]['id'],
				'LINK_NAME' => stripslashes($lurl_rows[$url_id]['name']),
				'LINK_DESC' => $site_desc,
				'LINK_STAT'	=> $statistics,
				)
			);
		} // Printout urls 
	}
	if ( $error )
	{
		$template->set_filenames(array(
			'reg_header' => 'error_body.tpl')
		);
		$template->assign_vars(array(
			'ERROR_MESSAGE' => $error_msg)
		);
		$template->assign_var_from_handle('ERROR_BOX', 'reg_header');
	}
	$template->pparse('body');
	include($phpbb_root_path . 'includes/page_tail.'.$phpEx);
}
?>