<?php
/***************************************************************************
 *                            link.php
 *                            -------------------
 *  MOD add-on page. Contains GPL code copyright of phpBB group.
 *  Author: OOHOO < webdev@phpbb-tw.net >
 *  Author: Stefan2k1 and ddonker from www.portedmods.com
 *  Demo: http://phpbb-tw.net/
 *  Version: 1.0.X - 2002/03/22 - for phpBB RC serial, and was named Related_Links_MOD
 *  Version: 1.1.0 - 2002/04/25 - Re-packed for phpBB 2.0.0, and renamed to Links_MOD
 *  Version: 1.2.0 - 2003/06/15 - Enhanced and Re-packed for phpBB 2.0.4
 ***************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 ***************************************************************************/ 

/***************************************************************************
 * This file has been modified by Fully Moddded phpBB
 *
 *   $FMId: 2003/06/29 14:56:45 krystal
 *
 ***************************************************************************/

define('IN_PHPBB', true);

$phpbb_root_path = "./"; 
include($phpbb_root_path . 'extension.inc');
include($phpbb_root_path . "common.$phpEx");
$language = $board_config['default_lang'];

if( !file_exists($phpbb_root_path . 'language/lang_' . $language . '/lang_main_link.'.$phpEx) )
{
	$language = 'english';
}

include($phpbb_root_path . 'language/lang_' . $language . '/lang_main_link.' . $phpEx);

// Start session management
$userdata = session_pagestart($user_ip, PAGE_LINKS);
init_userprefs($userdata);

//
// Count and forwrad
//
if($HTTP_GET_VARS['action'] == "go" && $HTTP_GET_VARS['link_id'])
{
	$link_id = $HTTP_GET_VARS['link_id'];
	// Secure check
	if(is_numeric($link_id))
	{
		$sql = "SELECT link_id, link_url, last_user_ip
			FROM " . LINKS_TABLE . "
			WHERE link_id = '$link_id'
			AND link_active = 1";

		if($result = $db->sql_query($sql))
		{
			$row = $db->sql_fetchrow($result);
			if($link_url = $row['link_url'])
			{
				if($user_ip != $row['last_user_ip'])
				{
					// Update
					$sql = "UPDATE " . LINKS_TABLE . "
						SET link_hits = link_hits + 1, last_user_ip = '$user_ip'
						WHERE link_id = '$link_id'";
					$result = $db->sql_query($sql);
				}

				// Forward to website
				header("Location: $link_url");
				exit;
			}
		}
	}
}

// Output the basic page
$page_title = $lang['Site_links'];
include('includes/page_header.'.$phpEx);

$template->set_filenames(array(
	'body' => "links_body.tpl"
));

$start = ( isset($HTTP_GET_VARS['start']) ) ? $HTTP_GET_VARS['start'] : 0;
//
// Get Link Config
//
$sql = "SELECT *
		FROM ". LINK_CONFIG_TABLE;
if(!$result = $db->sql_query($sql))
{
	message_die(GENERAL_ERROR, "Could not query Link config information", "", __LINE__, __FILE__, $sql);
}
while( $row = $db->sql_fetchrow($result) )
{
	$link_config_name = $row['config_name'];
	$link_config_value = $row['config_value'];
	$link_config[$link_config_name] = $link_config_value;
	$linkspp=$link_config['linkspp'];
}

$template->assign_vars(array(
	'L_SITE_LINKS' => $lang['Site_links'],
	'L_LINK_US' => $lang['Link_us'] . $board_config['sitename'],
	'L_LINK_US_EXPLAIN' => sprintf($lang['Link_us_explain'], $board_config['sitename']),
	'L_LINK_REGISTER' => $lang['Link_register'],
	'L_LINK_REGISTER_RULE' => $lang['Link_register_rule'],
	'L_LINK_TITLE' => $lang['Link_title'],
	'L_LINK_DESC' => $lang['Link_desc'],
	'L_LINK_URL' => $lang['Link_url'],
	'L_LINK_LOGO_SRC' => $lang['Link_logo_src'],
	'L_LINK_JOINED' => $lang['Joined'],
	'L_LINK_CATEGORY' => $lang['Link_category'],
	'L_LINK_HITS' => $lang['link_hits'],
	'L_PLEASE_ENTER_YOUR' => $lang['Please_enter_your'],
	'L_SUBMIT' => $lang['Submit'],
	'U_SITE_LINKS' => append_sid("link.$phpEx"),
	'U_SITE_LOGO' => $link_config['site_logo'],
	'LINK_US_SYNTAX' => str_replace(" ", "&nbsp;", sprintf(htmlentities($lang['Link_us_syntax'], ENT_QUOTES), $link_config['site_url'], $link_config['site_logo'], $link_config['width'],$link_config['height'], $board_config['sitename']))
));

//
// Grab link categories
//
$sql = "SELECT cat_id, cat_title FROM " . LINK_CATEGORIES_TABLE . " ORDER BY cat_order";

if(!$result = $db->sql_query($sql))
{
	message_die(GENERAL_ERROR, 'Could not query link categories list', '', __LINE__, __FILE__, $sql);
}

while($row = $db->sql_fetchrow($result))
{
	$link_categories[$row['cat_id']] = $row['cat_title'];
}


//
// Grab links
//
$sql = "SELECT * FROM " . LINKS_TABLE . "
	WHERE link_active = 1
	ORDER BY link_hits DESC, link_id DESC
	LIMIT $start, $linkspp";

if(!$result = $db->sql_query($sql))
{
	message_die(GENERAL_ERROR, 'Could not query links list', '', __LINE__, __FILE__, $sql);
}

if ( $row = $db->sql_fetchrow($result) )
{
	do
	{
		$template->assign_block_vars("linkrow", array(
			'LINK_URL' => append_sid("link.$phpEx?action=go&link_id=" . $row['link_id']),
			'LINK_TITLE' => $row['link_title'],
			'LINK_DESC' => $row['link_desc'],
			'LINK_LOGO_SRC' => $row['link_logo_src'],
			'LINK_CATEGORY' => $link_categories[$row['link_category']],
			'LINK_JOINED' => create_date($lang['DATE_FORMAT'], $row['link_joined'], $board_config['board_timezone']),
			'LINK_HITS' => $row['link_hits']


		));
	}
	while ( $row = $db->sql_fetchrow($result) );
}

//
// Pagination
//
$sql = "SELECT count(*) AS total
	FROM " . LINKS_TABLE . "
	WHERE link_active = 1";

if ( !($result = $db->sql_query($sql)) )
{
	message_die(GENERAL_ERROR, 'Could not query links number', '', __LINE__, __FILE__, $sql);
}

if ( $row = $db->sql_fetchrow($result) )
{
	$total_links = $row['total'];
	$pagination = generate_pagination("link.$phpEx?", $total_links, $linkspp, $start). '&nbsp;';
}
else
{
	$pagination = '&nbsp;';
	$total_links = 10;
}

//
// Link categories dropdown list
//
foreach($link_categories as $cat_id => $cat_title)
{
	$link_cat_option .= "<option value=\"$cat_id\">$cat_title</option>";
}

$template->assign_vars(array(
	'PAGINATION' => $pagination,
	'PAGE_NUMBER' => sprintf($lang['Page_of'], ( floor( $start / $linkspp ) + 1 ), ceil( $total_links / $linkspp )),
	'L_GOTO_PAGE' => $lang['Goto_page'],

	'LINK_CAT_OPTION' => $link_cat_option
));

$template->pparse("body");

include('includes/page_tail.'.$phpEx);

?>