<?php
/***************************************************************************
 *                                 kb.php
 *                            -------------------
 *   begin                : Sunday, Mar 31, 2003
 *   copyright            : (C) 2001 The phpBB Group
 *   email                : support@phpbb.com
 *
 *   $Id: kb.php,v 1.0.0 2003/03/31 00:06:33 psotfx Exp $
 *
 *
 ***************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 ***************************************************************************/

define('IN_PHPBB', true);
$phpbb_root_path = './';
include($phpbb_root_path . 'extension.inc');
include($phpbb_root_path . 'common.'.$phpEx);
include($phpbb_root_path . 'includes/bbcode.'.$phpEx);
include($phpbb_root_path . 'includes/functions_post.'.$phpEx);

//
// Start session management
//
$userdata = session_pagestart($user_ip, PAGE_KB);
init_userprefs($userdata);
//
// End session management
//


//options
if ( !$board_config['allow_html'] )
{
   $html_on = 0;
}
else
{
 	$html_on = ( $submit || $refresh ) ? ( ( !empty($HTTP_POST_VARS['disable_html']) ) ? 0 : TRUE ) : ( ( $userdata['user_id'] == ANONYMOUS ) ? $board_config['allow_html'] : $userdata['user_allowhtml'] );
}
if ( !$board_config['allow_bbcode'] )
{
   $bbcode_on = 0;
}
else
{
 	$bbcode_on = ( $submit || $refresh ) ? ( ( !empty($HTTP_POST_VARS['disable_bbcode']) ) ? 0 : TRUE ) : ( ( $userdata['user_id'] == ANONYMOUS ) ? $board_config['allow_bbcode'] : $userdata['user_allowbbcode'] );
}
if ( !$board_config['allow_smilies'] )
{
   $smilies_on = 0;
}
else
{
 	$smilies_on = ( $submit || $refresh ) ? ( ( !empty($HTTP_POST_VARS['disable_smilies']) ) ? 0 : TRUE ) : ( ( $userdata['user_id'] == ANONYMOUS ) ? $board_config['allow_smilies'] : $userdata['user_allowsmile'] );
}

if ( isset($HTTP_POST_VARS['mode']) || isset($HTTP_GET_VARS['mode']) )
{
	$mode = ( isset($HTTP_POST_VARS['mode']) ) ? $HTTP_POST_VARS['mode'] : $HTTP_GET_VARS['mode'];
}
else
{
	if ( $article )
	{
		$mode = 'article';
	}
	else if ( $cat )
	{
		$mode = 'cat';
	}
	else if ( $add )
	{
		$mode = 'add';
	}
	else if ( $search )
	{
		$mode = 'search';
	}
	else if ( $edit )
	{
		$mode = 'edit';
	}
	else
	{
		$mode = '';
	}
}

$is_admin = ( $userdata['user_level'] == ADMIN && $userdata['session_logged_in'] ) ? TRUE : 0;

switch( $mode )
{
	case 'article':

	$article_id = $HTTP_GET_VARS['k'];
	
	$sql = "SELECT *
		FROM " . KB_ARTICLES_TABLE . "
		WHERE article_id = $article_id";
	if ( !($result = $db->sql_query($sql)) )
	{
		message_die(GENERAL_ERROR, "Could not obtain article data", '', __LINE__, __FILE__, $sql);
	}

	if ( $row = $db->sql_fetchrow($result) )
	{
	
	   $article_title = $row['article_title'];
	   $article_category_id = $row['article_category_id'];
	
	   $sql = "SELECT *  
       		FROM " . KB_CATEGORIES_TABLE . " 
      		WHERE category_id = $article_category_id";
	
	   if ( !($result2 = $db->sql_query($sql)) )
	   {
		  message_die(GENERAL_ERROR, "Could not obtain category data", '', __LINE__, __FILE__, $sql);
	   }

	   if ( $category = $db->sql_fetchrow($result2) )
	   {
	
		  $article_category_name = $category['category_name'];
	   }
	
	   $temp_url = append_sid($phpbb_root_path . "kb.$phpEx?mode=cat&amp;cat=$article_category_id");
	   $category = '<a href="' . $temp_url . '" class="gen">' . $article_category_name . '</a>';
	
	   $article_date = $row['article_date'];
	
	   // author information
	   $author_id = $row['article_author_id'];
	
	   $sql = "SELECT *  
       		FROM " . USERS_TABLE . " 
      		WHERE user_id = $author_id";
	 
	   if ( !($result3 = $db->sql_query($sql)) )
	   {
		  message_die(GENERAL_ERROR, "Could not obtain user data", '', __LINE__, __FILE__, $sql);
	   }

	   if ( $author = $db->sql_fetchrow($result3) )
	   {	
		  $author_name = $author['username'];
	   }
	
	   $temp_url = append_sid($phpbb_root_path . "profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . "=$author_id");
	   $author = '<a href="' . $temp_url . '" class="gen">' . $author_name . '</a>';
	
	   $article = $row['article_body'];
	   $description = $row['article_description'];
	   $date = $row['article_date'];
	   
	   $type_id = $row['article_type'];
	   
	   $sql = "SELECT *  
       		FROM " . KB_TYPES_TABLE . " 
      		WHERE id = $type_id";
	
	   if ( !($result3 = $db->sql_query($sql)) )
	   {
		  message_die(GENERAL_ERROR, "Could not obtain category data", '', __LINE__, __FILE__, $sql);
	   }

	   if ( $types = $db->sql_fetchrow($result3) )
	   {
	
		  $type = $types['type'];
	   }
	   
	   $keywords = $row['article_keywords'];
	}
	//
	// Parse message and/or sig for BBCode if reqd
	//
	$bbcode_uid = $row['bbcode_uid'];
	
	$article = stripslashes(prepare_message($article, $html_on, $bbcode_on, $smilies_on, $bbcode_uid));
	
	if ( $board_config['allow_bbcode'] )
	{
		if ( $bbcode_uid != '' )
		{
			$article = ( $board_config['allow_bbcode'] ) ? bbencode_second_pass($article, $bbcode_uid) : preg_replace('/\:[0-9a-z\:]+\]/si', ']', $article);
		}
	}

	$article = make_clickable($article);

	//
	// Parse smilies
	//
	if ( $board_config['allow_smilies'] )
	{
		$article = smilies_pass($article);		
	}

	//
	// Highlight active words (primarily for search)
	//
	if ($highlight_match)
				{
		// This was shamelessly 'borrowed' from volker at multiartstudio dot de
		// via php.net's annotated manual
		$message = str_replace('\"', '"', substr(preg_replace('#(\>(((?>([^><]+|(?R)))*)\<))#se', "preg_replace('#\b(" . $highlight_match . ")\b#i', '<span style=\"color:#" . $theme['fontcolor3'] . "\"><b>\\\\1</b></span>', '\\0')", '>' . $article . '<'), 1, -1));
	}

	//
	// Replace naughty words
	//
	if ( count($orig_word) )
	{
		$article_title = preg_replace($orig_word, $replacement_word, $article_title);

		$article = str_replace('\"', '"', substr(preg_replace('#(\>(((?>([^><]+|(?R)))*)\<))#se', "preg_replace(\$orig_word, \$replacement_word, '\\0')", '>' . $article . '<'), 1, -1));
	}

	//
	// Replace newlines (we use this rather than nl2br because
	// till recently it wasn't XHTML compliant)
	//

	$article = str_replace("\n", "\n<br />\n", $article);
	
	//edit links
	if ( ( $userdata['user_id'] == $author_id && $kb_config['allow_edit'] ) || ( $is_admin ) )
	{
		$temp_url = append_sid("kb.$phpEx?mode=edit&amp;k=" . $article_id);
		$edit_img = '<a href="' . $temp_url . '"><img src="' . $images['icon_edit'] . '" alt="' . $lang['Edit_delete_post'] . '" title="' . $lang['Edit_delete_post'] . '" border="0" /></a>';
		$edit = '<a href="' . $temp_url . '">' . $lang['Edit_delete_post'] . '</a>';
	}
	else
	{
		$edit_img = '';
		$edit = '';
	}
	
	//
	//Build page
	//
	
	$page_title = $article_title;
	include($phpbb_root_path . 'includes/page_header.'.$phpEx);
	
	make_jumpbox('kb.'.$phpEx);
	
	//load header
	include ($phpbb_root_path ."includes/kb_header.".$phpEx);
	
 	$template->set_filenames(array(
		'body' => 'kb_article_body.tpl')
	);
	
	$template->assign_vars(array(
		'L_ARTICLE_DESCRIPTION' => $lang['Article_description'],
		'L_ARTICLE_DATE' => $lang['Date'],
		'L_ARTICLE_TYPE' => $lang['Article_type'],
		'L_ARTICLE_KEYWORDS' => $lang['Article_keywords'],
		'L_ARTICLE_CATEGORY' => $lang['Category'],
		'L_ARTICLE_AUTHOR' => $lang['Author'])
	);
	
	$template->assign_vars(array(
		'ARTICLE_TITLE' => $article_title,
		'ARTICLE_AUTHOR' => $author,
		'ARTICLE_CATEGORY' => $category,
		'ARTICLE_TEXT' => $article,
		'ARTICLE_DESCRIPTION' => $description,
		'ARTICLE_DATE' => $date,
		'ARTICLE_TYPE' => $type,
		'ARTICLE_KEYWORDS' => $keywords,
		'EDIT_IMG' => $edit_img,
		'EDIT' => $edit)
	);

	break;

	case 'cat':
	
	$category_id = $HTTP_GET_VARS['cat'];
	
	$sql = "SELECT *  
       		FROM " . KB_CATEGORIES_TABLE . " 
      		WHERE category_id = $category_id";
	
	if ( !($cat_result = $db->sql_query($sql)) )
	{
	   message_die(GENERAL_ERROR, "Could not obtain category information", '', __LINE__, __FILE__, $sql);
	}

	if ( $category = $db->sql_fetchrow($cat_result) )
	{	
		$category_name = $category['category_name'];
		$category_details = $category['category_details'];
		$number_articles = $category['number_articles'];
	}
	
	$page_title = $category_name;
	include($phpbb_root_path . 'includes/page_header.'.$phpEx);
	
	make_jumpbox('kb.'.$phpEx, $category_id);
	
	//load header
	include ($phpbb_root_path ."includes/kb_header.".$phpEx);
	
	$template->set_filenames(array(
		'body' => 'kb_cat_body.tpl')
	);

	$template->assign_vars(array(
		'L_CATEGORY_NAME' => $category_name,
		'L_CATEGORY_DETAILS' => $category_details,
		'L_ARTICLE' => $lang['Article'],
		'L_ARTICLE_TYPE' => $lang['Article_type'],
		'L_ARTICLE_CATEGORY' => $lang['Category'],
		'L_ARTICLE_DATE' => $lang['Date'],
		'L_ARTICLE_AUTHOR' => $lang['Author'])
	);
	
	$sql = "SELECT *  
       		FROM " . KB_ARTICLES_TABLE . " 
      		WHERE article_category_id = $category_id AND approved = 1 
			ORDER BY article_title ASC";
	
	if ( !($article_result = $db->sql_query($sql)) )
	{
	   message_die(GENERAL_ERROR, "Could not obtain article data", '', __LINE__, __FILE__, $sql);
	}

	while($article = $db->sql_fetchrow($article_result))
	{	
		$article_description = $article['article_description'];
		
		$type_id = $article['article_type'];	   
	    $sql = "SELECT *  
       		FROM " . KB_TYPES_TABLE . " 
      		WHERE id = $type_id";
	
	    if ( !($result3 = $db->sql_query($sql)) )
	    {
		   message_die(GENERAL_ERROR, "Could not obtain category data", '', __LINE__, __FILE__, $sql);
	    }

	    if ( $types = $db->sql_fetchrow($result3) )
	    {	
		  $article_type = $types['type'];
	    }
		
		$article_date = $article['article_date'];
		
	   // author information
	   $author_id = $article['article_author_id'];
	
	   $sql = "SELECT *  
       		FROM " . USERS_TABLE . " 
      		WHERE user_id = $author_id";
	 
	   if ( !($result3 = $db->sql_query($sql)) )
	   {
		  message_die(GENERAL_ERROR, "Could not obtain author data", '', __LINE__, __FILE__, $sql);
	   }

	   if ( $author = $db->sql_fetchrow($result3) )
	   {	
		  $author_name = $author['username'];
	   }
	
	   $temp_url = append_sid($phpbb_root_path . "profile.$phpEx?mode=viewprofile&amp;" . POST_USERS_URL . "=$author_id");
	   $author = '<a href="' . $temp_url . '" class="gen">' . $author_name . '</a>';
		
		$article_id = $article['article_id'];
		
		$article_title = $article['article_title'];
		$temp_url = append_sid($phpbb_root_path . "kb.$phpEx?mode=article&amp;k=$article_id");
	   	$article = '<a href="' . $temp_url . '" class="gen">' . $article_title . '</a>';

		$template->assign_block_vars('articlerow', array(
			'ARTICLE' => $article,
			'ARTICLE_DESCRIPTION' => $article_description,
			'ARTICLE_TYPE' => $article_type,
			'ARTICLE_DATE' => $article_date,
			'ARTICLE_AUTHOR' => $author)
		);
	}
	break;
	
	case 'add':
	
	//show article form
	if ( !$HTTP_POST_VARS['article_submit'] )
	{
	   $page_title = $lang['Add_article'];
	   include($phpbb_root_path . 'includes/page_header.'.$phpEx);
	
	   make_jumpbox('kb.'.$phpEx,'');

	   //
	   // HTML toggle selection
	   //
	   if ( $board_config['allow_html'] )
	   {
	   	  $html_status = $lang['HTML_is_ON'];
	   }
	   else
	   {
	   	  $html_status = $lang['HTML_is_OFF'];
	   }

	   //
	   // BBCode toggle selection
	   //
	   if ( $board_config['allow_bbcode'] )
	   {
	      $bbcode_status = $lang['BBCode_is_ON'];
	   }
	   else
	   {
	   	  $bbcode_status = $lang['BBCode_is_OFF'];
       }

	   //
	   // Smilies toggle selection
	   //
	   if ( $board_config['allow_smilies'] )
	   {
	   	  $smilies_status = $lang['Smilies_are_ON'];
	   }
	   else
	   {
	   	   $smilies_status = $lang['Smilies_are_OFF'];
	   }
	   
	   // Generate smilies listing for page output
	   generate_smilies('inline', PAGE_POSTING);
	   
	   //load header
	   include ($phpbb_root_path ."includes/kb_header.".$phpEx);
	
	   //set up page
	   $template->set_filenames(array(
		  'body' => 'kb_add_body.tpl')
	   );
	
	   $template->assign_vars(array(
		  'L_ADD_ARTICLE' => $lang['Add_article'],
		  'L_ARTICLE_TITLE' => $lang['Article_title'],
		  'L_ARTICLE_DESCRIPTION' => $lang['Article_description'],
		  'L_ARTICLE_TEXT' => $lang['Article_text'],
		  'L_ARTICLE_KEYWORDS' => $lang['Article_keywords'],
		  'L_ARTICLE_TYPE' => $lang['Article_type'],
		  'L_ARTICLE_CATEGORY' => $lang['Category'],
		  'L_SUBMIT' => $lang['Submit'],
		  'L_PREVIEW' => $lang['Preview'],
		  'L_SELECT' => $lang['Select'],
		  
		  'S_ACTION' => 'kb.php?mode=add',
		  'HTML_STATUS' => $html_status,
		  'BBCODE_STATUS' => sprintf($bbcode_status, '<a href="' . append_sid("faq.$phpEx?mode=bbcode") . '" target="_phpbbcode">', '</a>'), 
		  'SMILIES_STATUS' => $smilies_status,
		
		'L_BBCODE_B_HELP' => $lang['bbcode_b_help'], 
		'L_BBCODE_I_HELP' => $lang['bbcode_i_help'], 
		'L_BBCODE_U_HELP' => $lang['bbcode_u_help'], 
		'L_BBCODE_Q_HELP' => $lang['bbcode_q_help'], 
		'L_BBCODE_C_HELP' => $lang['bbcode_c_help'], 
		'L_BBCODE_L_HELP' => $lang['bbcode_l_help'], 
		'L_BBCODE_O_HELP' => $lang['bbcode_o_help'], 
		'L_BBCODE_P_HELP' => $lang['bbcode_p_help'], 
		'L_BBCODE_W_HELP' => $lang['bbcode_w_help'], 
		'L_BBCODE_A_HELP' => $lang['bbcode_a_help'], 
		'L_BBCODE_S_HELP' => $lang['bbcode_s_help'], 
		'L_BBCODE_F_HELP' => $lang['bbcode_f_help'], 
		'L_EMPTY_MESSAGE' => $lang['Empty_message'],
		'L_EMPTY_CAT' => $lang['Empty_category'],
		'L_EMPTY_TYPE' => $lang['Empty_type'],

		'L_FONT_COLOR' => $lang['Font_color'], 
		'L_COLOR_DEFAULT' => $lang['color_default'], 
		'L_COLOR_DARK_RED' => $lang['color_dark_red'], 
		'L_COLOR_RED' => $lang['color_red'], 
		'L_COLOR_ORANGE' => $lang['color_orange'], 
		'L_COLOR_BROWN' => $lang['color_brown'], 
		'L_COLOR_YELLOW' => $lang['color_yellow'], 
		'L_COLOR_GREEN' => $lang['color_green'], 
		'L_COLOR_OLIVE' => $lang['color_olive'], 
		'L_COLOR_CYAN' => $lang['color_cyan'], 
		'L_COLOR_BLUE' => $lang['color_blue'], 
		'L_COLOR_DARK_BLUE' => $lang['color_dark_blue'], 
		'L_COLOR_INDIGO' => $lang['color_indigo'], 
		'L_COLOR_VIOLET' => $lang['color_violet'], 
		'L_COLOR_WHITE' => $lang['color_white'], 
		'L_COLOR_BLACK' => $lang['color_black'], 

		'L_FONT_SIZE' => $lang['Font_size'], 
		'L_FONT_TINY' => $lang['font_tiny'], 
		'L_FONT_SMALL' => $lang['font_small'], 
		'L_FONT_NORMAL' => $lang['font_normal'], 
		'L_FONT_LARGE' => $lang['font_large'], 
		'L_FONT_HUGE' => $lang['font_huge'], 

		'L_BBCODE_CLOSE_TAGS' => $lang['Close_Tags'], 
		'L_STYLES_TIP' => $lang['Styles_tip'])
	   );
	   
	   //category info
	   $sql = "SELECT *  
       		FROM " . KB_CATEGORIES_TABLE;
	
	   if ( !($cat_result = $db->sql_query($sql)) )
	   {
	       message_die(GENERAL_ERROR, "Could not obtain category information", '', __LINE__, __FILE__, $sql);
	   }

	   while ( $category = $db->sql_fetchrow($cat_result) )
	   {	
		   $category_name = $category['category_name'];
		   $category_id = $category['category_id'];
		   
		   if ( $category_id == $HTTP_POST_VARS['category_id'] )
		   {
		   	   $status = 'selected';
		   }
		   else
		   {
		   	   $status = '';
		   }
		   
		   $category = '<option value="' . $category_id . '" ' . $status . '>' . $category_name . '</option>';
		   
		   $template->assign_block_vars('categories', array(
		       'CATEGORY' => $category)
		   );
	   }
	   
	   //type info
	   $sql = "SELECT *  
       		FROM " . KB_TYPES_TABLE;
	
	   if ( !($type_result = $db->sql_query($sql)) )
	   {
	       message_die(GENERAL_ERROR, "Could not obtain category information", '', __LINE__, __FILE__, $sql);
	}
	
	   while ( $type = $db->sql_fetchrow($type_result) )
	   {	
		   $type_name = $type['type'];
		   $type_id = $type['id'];
		   
		   if ( $type_id == $HTTP_POST_VARS['type_id'] )
		   {
		   	   $status = 'selected';
		   }
		   else
		   {
		   	   $status = '';
		   }
		   
		   $type = '<option value="' . $type_id . '" ' . $status . '>' . $type_name . '</option>';
		   
		   $template->assign_block_vars('types', array(
		       'TYPE' => $type)
		   );
	   }
	}
	
	//BEGIN - PreText HIDE/SHOW
	if ( $kb_config['show_pretext'] ) {
		// Pull Header/Body info.
		
       	        $pt_header = $kb_config['pt_header'];		
		$pt_body = $kb_config['pt_body'];		
		$template->set_filenames(array('pretext' => 'kb_add_pretext.tpl'));
		$template->assign_vars(array(
			'PRETEXT_HEADER' => $pt_header,
			'PRETEXT_BODY' => $pt_body ));
		$template->assign_var_from_handle('KB_PRETEXT_BOX', 'pretext');
	}
	//END - PreText HIDE/SHOW
	
	if( $HTTP_POST_VARS['preview'] )
	{
		$orig_word = array();
		$replacement_word = array();
		obtain_word_list($orig_word, $replacement_word);

		$message = $HTTP_POST_VARS['message'];
		
		$bbcode_uid = make_bbcode_uid();

		$preview_message = stripslashes(prepare_message($message, $html_on, $bbcode_on, $smilies_on, $bbcode_uid)); 

		$message = stripslashes($message);

		if ( $row['bbcode_uid'] != '' )
		{
			$message = preg_replace('/\:(([a-z0-9]:)?)' . $row['bbcode_uid'] . '/s', '', $message);
		}

		$preview_message = bbencode_first_pass($preview_message, $bbcode_uid);
		
		$preview_message = bbencode_second_pass($preview_message, $bbcode_uid);

		$preview_message = make_clickable($preview_message);

		if( $smilies_on )
		{
			$preview_message = smilies_pass($preview_message);
		}

		$preview_message = str_replace("\n", '<br />', $preview_message);

		$template->set_filenames(array(
			'preview' => 'kb_add_preview.tpl')
		);

		$template->assign_vars(array(
			'ARTICLE_TITLE' => $HTTP_POST_VARS['article_name'],
			'ARTICLE_DESC' => $HTTP_POST_VARS['article_desc'],
			'ARTICLE_BODY' => $message,
			'ARTICLE_KEYWORDS' => $HTTP_POST_VARS['article_keywords'],
			
			'PREVIEW_MESSAGE' => $preview_message)
		);
		$template->assign_var_from_handle('KB_PREVIEW_BOX', 'preview');
	}
	
	
	//post article
	if ( $HTTP_POST_VARS['article_submit'] )
	{
	
	   $page_title = $lang['Add_article'];
	   include($phpbb_root_path . 'includes/page_header.'.$phpEx);
	
	   make_jumpbox('kb.'.$phpEx,'');
	   
	   //load header
	   include ($phpbb_root_path ."includes/kb_header.".$phpEx);
	   
	   if ( !$HTTP_POST_VARS['article_name'] || !$HTTP_POST_VARS['article_desc'] || !$HTTP_POST_VARS['message'] )
	   {
	   	  echo "<br /><br /><center>Please fill out all parts of the form.  <a href='kb.php?mode=add'>Click Here</a> to go back to the form.</center>";
		  exit;
	   }
	   $article_text = $HTTP_POST_VARS['message'];
	   
	   $bbcode_uid = make_bbcode_uid();
	   $error_msg = '';	      
	   $article_text = bbencode_first_pass($article_text, $bbcode_uid);
	   $category = $HTTP_POST_VARS['category_id'];
	   $title = $HTTP_POST_VARS['article_name'];
	   $description = $HTTP_POST_VARS['article_desc'];
	   $date = date("D M d, Y g:i a");
	   $author_id = $userdata['user_id'];	   
	   $type = $HTTP_POST_VARS['type_id'];
	   $keywords = $HTTP_POST_VARS['article_keywords'];
	   
	   if ( ( !$kb_config['approve_edit'] ) || ( $is_admin ) || ( $userdata['user_level'] == MOD ) )
	   {
	   	  $approve = 1;
		  
		  //update number of articles in category if article has been approve
	   	  $sql = "SELECT * FROM " . KB_CATEGORIES_TABLE . " WHERE category_id = '" . $category . "'";
		  if ( !($results = $db->sql_query($sql)) )
	   	  {
   	  	  	 message_die(GENERAL_ERROR, "Could not obtain article data", '', __LINE__, __FILE__, $sql);
	   	  }
	   	  if ( $cat = $db->sql_fetchrow($results) )
	   	  { 
	  	   	$new_number = $cat['number_articles'] + 1;
	 	  }
	
	  	  $sql = "UPDATE " . KB_CATEGORIES_TABLE .
		   	   " SET number_articles = " . $new_number .
		   	   " WHERE category_id = '" . $category . "'";
		 
	 	   if ( !($result = $db->sql_query($sql)) )
	 	   {
   	  	  	 message_die(GENERAL_ERROR, "Could not update category data", '', __LINE__, __FILE__, $sql);
	 	   }	  
	   }
	   else
	   {
	   $approve = 0;	   
	   }	   

	   $sql = "INSERT INTO " . KB_ARTICLES_TABLE . " ( `article_category_id` , `article_title` , `article_description` , `article_date` , `article_author_id` , `bbcode_uid` , `article_body` , `article_type` , `article_keywords` , `approved` ) 
	   VALUES ( '$category', '$title', '$description', '$date', '$author_id', '$bbcode_uid', '$article_text', '$type', '$keywords', '$approve')";   

	   if ( !($results = $db->sql_query($sql)) )
	   {
	       message_die(GENERAL_ERROR, "Could not submit aritcle", '', __LINE__, __FILE__, $sql);
	   }

	   if ( $kb_config['notify'] == 2 && $approve == 0 )
	   {	   
	   		   $email_body = $lang['Email_body'];
	   
	   		   include($phpbb_root_path . 'includes/emailer.'.$phpEx); 
	   		   $emailer = new emailer($board_config['smtp_delivery']); 

	  		   $email_headers = 'From: ' . $board_config['board_email'] . "\nReturn-Path: " . $board_config['board_email'] . "\n"; 

	   		   $emailer->email_address($board_config['board_email']); 
	   		   $emailer->set_subject($lang['New_article']); 
	   		   $emailer->extra_headers($email_headers); 
	   		   $emailer->msg = $email_body; 

	   		   $emailer->send(); 
	   		   $emailer->reset();
		}
		
		if ( $kb_config['notify'] == 1 && $approve == 0 )
		{
		   $sql = "UPDATE " . USERS_TABLE . " 
		   		SET user_new_privmsg = '1', user_last_privmsg = '9999999999'
				WHERE user_id = " . $kb_config['admin_id'];
				
		   if ( !($result = $db->sql_query($sql)) )
           {
		      message_die(GENERAL_ERROR, 'Could not update users table', '', __LINE__, __FILE__, $sql);
           }

		   $user_id = $kb_config['admin_id'];
		   
           $new_article_subject = $lang['New_article'];
           $new_article = $lang['Email_body'];
           $privmsgs_date = date("U");
           $sql = "INSERT INTO " . PRIVMSGS_TABLE . " (privmsgs_type, privmsgs_subject, privmsgs_from_userid, privmsgs_to_userid, privmsgs_date, privmsgs_enable_html, privmsgs_enable_bbcode, privmsgs_enable_smilies, privmsgs_attach_sig) VALUES ('0', '" . $new_article_subject . "', '" . $user_id . "', '" . $user_id . "', '" . $privmsgs_date . "', '0', '1', '1', '0')";
           
		   if ( !$db->sql_query($sql) )
		   {
			  message_die(GENERAL_ERROR, 'Could not insert private message sent info', '', __LINE__, __FILE__, $sql);
		   }

		   $privmsg_sent_id = $db->sql_nextid();
		   $privmsgs_text = $lang['register_pm_subject'];
           //
           $sql = "INSERT INTO " . PRIVMSGS_TEXT_TABLE . " (privmsgs_text_id, privmsgs_text) VALUES ($privmsg_sent_id, '" . $new_article . "')";
           if ( !$db->sql_query($sql) )
		   {
			  message_die(GENERAL_ERROR, 'Could not insert private message sent text', '', __LINE__, __FILE__, $sql);
		   }
	   }	  
	   $message = $lang['Article_submitted'] . '<br /><br />' . sprintf($lang['Click_return_kb'], '<a href="' . append_sid("kb.$phpEx") . '">', '</a>') . '<br /><br />' . sprintf($lang['Click_return_index'], '<a href="' . append_sid("index.$phpEx") . '">', '</a>');

	   message_die(GENERAL_MESSAGE, $message);	   
	}	
	break;

	case 'edit':
	
	//show article form
	if ( !$HTTP_POST_VARS['article_submit'] )
	{
	   $article_id = $HTTP_GET_VARS['k'];
	   
	   if ( !$article_id )
	   {
	       $article_id = $HTTP_POST_VARS['article_id'];
	   }
	
	   $sql = "SELECT *
		  FROM " . KB_ARTICLES_TABLE . "
		  WHERE article_id = $article_id";
	   if ( !($result = $db->sql_query($sql)) )
	   {
		  message_die(GENERAL_ERROR, "Could not obtain article data", '', __LINE__, __FILE__, $sql);
	   }

	   if ( $row = $db->sql_fetchrow($result) )
	   {
		  $article_name = $row['article_title'];
		  $article_category = $row['article_category_id'];
		  $article_desc = $row['article_description'];
		  $article_body = $row['article_body'];
		  $article_type = $row['article_type'];
		  $article_keywords = $row['article_keywords'];
		  $bbcode_uid = $row['bbcode_uid'];
		  
		  if ( $row['bbcode_uid'] != '' )
		  {
			  $article_body = preg_replace('/\:(([a-z0-9]:)?)' . $row['bbcode_uid'] . '/s', '', $article_body);
		  }
	   }
	
	   $page_title = $lang['Edit_article'];
	   include($phpbb_root_path . 'includes/page_header.'.$phpEx);
	
	   make_jumpbox('kb.'.$phpEx,'');

	   //
	   // HTML toggle selection
	   //
	   if ( $board_config['allow_html'] )
	   {
	   	  $html_status = $lang['HTML_is_ON'];
	   }
	   else
	   {
	   	  $html_status = $lang['HTML_is_OFF'];
	   }

	   //
	   // BBCode toggle selection
	   //
	   if ( $board_config['allow_bbcode'] )
	   {
	      $bbcode_status = $lang['BBCode_is_ON'];
	   }
	   else
	   {
	   	  $bbcode_status = $lang['BBCode_is_OFF'];
       }

	   //
	   // Smilies toggle selection
	   //
	   if ( $board_config['allow_smilies'] )
	   {
	   	  $smilies_status = $lang['Smilies_are_ON'];
	   }
	   else
	   {
	   	   $smilies_status = $lang['Smilies_are_OFF'];
	   }
	   
	   // Generate smilies listing for page output
	   generate_smilies('inline', PAGE_POSTING);
	   
	   //load header
	   include ($phpbb_root_path ."includes/kb_header.".$phpEx);
	
	   //set up page
	   $template->set_filenames(array(
		  'body' => 'kb_add_body.tpl')
	   );
	
	   $template->assign_vars(array(
		  'L_ADD_ARTICLE' => $lang['Edit_article'],
		  'L_ARTICLE_TITLE' => $lang['Article_title'],
		  'L_ARTICLE_DESCRIPTION' => $lang['Article_description'],
		  'L_ARTICLE_TEXT' => $lang['Article_text'],
		  'L_ARTICLE_KEYWORDS' => $lang['Article_keywords'],
		  'L_ARTICLE_TYPE' => $lang['Article_type'],
		  'L_ARTICLE_CATEGORY' => $lang['Category'],
		  'L_SUBMIT' => $lang['Edit'],
		  'L_PREVIEW' => $lang['Preview'],
		  
		  'L_FAQ' => $lang['FAQ'],
		  'L_HOWTO' => $lang['HowTo'],
		  'L_INFO' => $lang['Info'],
		  'L_TUTORIAL' => $lang['Tutorial'],
		  
		  'S_ACTION' => 'kb.php?mode=edit',
		  'HTML_STATUS' => $html_status,
		  'BBCODE_STATUS' => sprintf($bbcode_status, '<a href="' . append_sid("faq.$phpEx?mode=bbcode") . '" target="_phpbbcode">', '</a>'), 
		  'SMILIES_STATUS' => $smilies_status,
		  
		  'ARTICLE_TITLE' => $article_name,
		  'ARTICLE_DESC' => $article_desc,
		  'ARTICLE_BODY' => $article_body,
		  'ARTICLE_KEYWORDS' => $article_keywords,
		  'S_HIDDEN' => '<input type="hidden" name="article_id" value="' . $article_id . '">',
		
		'L_BBCODE_B_HELP' => $lang['bbcode_b_help'], 
		'L_BBCODE_I_HELP' => $lang['bbcode_i_help'], 
		'L_BBCODE_U_HELP' => $lang['bbcode_u_help'], 
		'L_BBCODE_Q_HELP' => $lang['bbcode_q_help'], 
		'L_BBCODE_C_HELP' => $lang['bbcode_c_help'], 
		'L_BBCODE_L_HELP' => $lang['bbcode_l_help'], 
		'L_BBCODE_O_HELP' => $lang['bbcode_o_help'], 
		'L_BBCODE_P_HELP' => $lang['bbcode_p_help'], 
		'L_BBCODE_W_HELP' => $lang['bbcode_w_help'], 
		'L_BBCODE_A_HELP' => $lang['bbcode_a_help'], 
		'L_BBCODE_S_HELP' => $lang['bbcode_s_help'], 
		'L_BBCODE_F_HELP' => $lang['bbcode_f_help'], 
		'L_EMPTY_MESSAGE' => $lang['Empty_message'],

		'L_FONT_COLOR' => $lang['Font_color'], 
		'L_COLOR_DEFAULT' => $lang['color_default'], 
		'L_COLOR_DARK_RED' => $lang['color_dark_red'], 
		'L_COLOR_RED' => $lang['color_red'], 
		'L_COLOR_ORANGE' => $lang['color_orange'], 
		'L_COLOR_BROWN' => $lang['color_brown'], 
		'L_COLOR_YELLOW' => $lang['color_yellow'], 
		'L_COLOR_GREEN' => $lang['color_green'], 
		'L_COLOR_OLIVE' => $lang['color_olive'], 
		'L_COLOR_CYAN' => $lang['color_cyan'], 
		'L_COLOR_BLUE' => $lang['color_blue'], 
		'L_COLOR_DARK_BLUE' => $lang['color_dark_blue'], 
		'L_COLOR_INDIGO' => $lang['color_indigo'], 
		'L_COLOR_VIOLET' => $lang['color_violet'], 
		'L_COLOR_WHITE' => $lang['color_white'], 
		'L_COLOR_BLACK' => $lang['color_black'], 

		'L_FONT_SIZE' => $lang['Font_size'], 
		'L_FONT_TINY' => $lang['font_tiny'], 
		'L_FONT_SMALL' => $lang['font_small'], 
		'L_FONT_NORMAL' => $lang['font_normal'], 
		'L_FONT_LARGE' => $lang['font_large'], 
		'L_FONT_HUGE' => $lang['font_huge'], 

		'L_BBCODE_CLOSE_TAGS' => $lang['Close_Tags'], 
		'L_STYLES_TIP' => $lang['Styles_tip'])
	   );
	   
	   //category info
	   $sql = "SELECT *  
       		FROM " . KB_CATEGORIES_TABLE;
	
	   if ( !($cat_result = $db->sql_query($sql)) )
	   {
	       message_die(GENERAL_ERROR, "Could not obtain category information", '', __LINE__, __FILE__, $sql);
	   }

	   while ( $category = $db->sql_fetchrow($cat_result) )
	   {	
		   $category_name = $category['category_name'];
		   $category_id = $category['category_id'];
		   
		   if ( $article_category == $category_id )
		   {
		   	   $status = 'selected';
		   }
		   else
		   {
		   	   $status = '';
		   }
		   
		   $category = '<option value="' . $category_id . '" ' . $status . '>' . $category_name . '</option>';
		   
		   $template->assign_block_vars('categories', array(
		       'CATEGORY' => $category)
		   );
	   }
	   
	   //type info
	   $sql = "SELECT *  
       		FROM " . KB_TYPES_TABLE;
	
	   if ( !($type_result = $db->sql_query($sql)) )
	   {
	       message_die(GENERAL_ERROR, "Could not obtain category information", '', __LINE__, __FILE__, $sql);
	   }

	   while ( $type = $db->sql_fetchrow($type_result) )
	   {	
		   $type_name = $type['type'];
		   $type_id = $type['id'];
		   
		   if ( $article_type == $type_id )
		   {
		   	   $status = 'selected';
		   }
		   else
		   {
		   	   $status = '';
		   }
		   
		   $type = '<option value="' . $type_id . '" ' . $status . '>' . $type_name . '</option>';
		   
		   $template->assign_block_vars('types', array(
		       'TYPE' => $type)
		   );
	   }
	}
	
	if( $HTTP_POST_VARS['preview'] )
	{
		$orig_word = array();
		$replacement_word = array();
		obtain_word_list($orig_word, $replacement_word);

		$message = $HTTP_POST_VARS['message'];

		$preview_message = stripslashes(prepare_message($message, $html_on, $bbcode_on, $smilies_on, $bbcode_uid));
		
		$message = stripslashes($message);

		if ( $row['bbcode_uid'] != '' )
		{
			$message = preg_replace('/\:(([a-z0-9]:)?)' . $row['bbcode_uid'] . '/s', '', $message);
		}

		$preview_message = bbencode_first_pass($preview_message, $bbcode_uid);
		
		$preview_message = bbencode_second_pass($preview_message, $bbcode_uid);

		$preview_message = make_clickable($preview_message);

		if( $smilies_on )
		{
			$preview_message = smilies_pass($preview_message);
		}

		$preview_message = str_replace("\n", '<br />', $preview_message);

		$template->set_filenames(array(
			'preview' => 'kb_add_preview.tpl')
		);

		$template->assign_vars(array(
			'ARTICLE_TITLE' => $HTTP_POST_VARS['article_name'],
			'ARTICLE_DESC' => $HTTP_POST_VARS['article_desc'],
			'ARTICLE_BODY' => $message,
			'ARTICLE_KEYWORDS' => $HTTP_POST_VARS['article_keywords'],
			
			'PREVIEW_MESSAGE' => $preview_message)
		);
		$template->assign_var_from_handle('KB_PREVIEW_BOX', 'preview');
	}
	
	//update article
	if ( $HTTP_POST_VARS['article_submit'] )
	{
	
	   $page_title = $lang['Edit_article'];
	   include($phpbb_root_path . 'includes/page_header.'.$phpEx);
	
	   make_jumpbox('kb.'.$phpEx,'');
	   
	   //load header
	   include ($phpbb_root_path ."includes/kb_header.".$phpEx);
	   
	   if ( !$HTTP_POST_VARS['article_name'] || !$HTTP_POST_VARS['article_desc'] || !$HTTP_POST_VARS['message'] )
	   {
	   	  echo "<br /><br /><center>Please fill out all parts of the form.<br /><br />Click <a href='kb.php?mode=add'>Here</a> to return to the form</center>";
		  exit;
	   }
	   $article_text = $HTTP_POST_VARS['message'];
	   
	   $article_id = $HTTP_POST_VARS['article_id'];
	
	   $sql = "SELECT *
		  FROM " . KB_ARTICLES_TABLE . "
		  WHERE article_id = '$article_id'";
	   if ( !($result = $db->sql_query($sql)) )
	   {
		  message_die(GENERAL_ERROR, "Could not obtain article data", '', __LINE__, __FILE__, $sql);
	   }

	   if ( $row = $db->sql_fetchrow($result) )
	   {	   
	   	   $bbcode_uid = $row['bbcode_uid'];
		   $old_approve = $row['approved'];
	   }
	   $error_msg = '';	      
	   $article_text = bbencode_first_pass($article_text, $bbcode_uid);
	   $category = $HTTP_POST_VARS['category_id'];
	   $title = $HTTP_POST_VARS['article_name'];
	   $description = $HTTP_POST_VARS['article_desc'];
	   $date = date("D M d, Y g:i a");
	   $author_id = $row['article_author_id'];	   
	   $type = $HTTP_POST_VARS['type_id'];
	   $keywords = $HTTP_POST_VARS['article_keywords'];
	   
	   if ( ( !$kb_config['approve_edit'] ) || ( $is_admin ) || ( $userdata['user_level'] == MOD ) )
	   {
	   	  $approve = 1;
		  
		  if ( $old_approve != 1 )
		  {
		  //update number of articles in category if article has been approve
	   	  $sql = "SELECT * FROM " . KB_CATEGORIES_TABLE . " WHERE category_id = '" . $category . "'";
		  if ( !($results = $db->sql_query($sql)) )
	   	  {
   	  	  	 message_die(GENERAL_ERROR, "Could not obtain article data", '', __LINE__, __FILE__, $sql);
	   	  }
	   	  if ( $cat = $db->sql_fetchrow($results) )
	   	  { 
	  	   	$new_number = $cat['number_articles'] + 1;
	 	  }
	
	  	  $sql = "UPDATE " . KB_CATEGORIES_TABLE .
		   	   " SET number_articles = " . $new_number .
		   	   " WHERE category_id = '" . $category . "'";
		 
	 	   if ( !($result = $db->sql_query($sql)) )
	 	   {
   	  	  	 message_die(GENERAL_ERROR, "Could not update category data", '', __LINE__, __FILE__, $sql);
		   }
		  }
	   }
	   else
	   {
	   	   $approve = 0;
		   
		   if ( $old_approve == 1 )
		   {		   
		   $sql = "SELECT * FROM " . KB_CATEGORIES_TABLE . " WHERE category_id = '" . $category . "'";
		 
	   	   if ( !($results = $db->sql_query($sql)) )
	   	   {
   	  	  	  message_die(GENERAL_ERROR, "Could not obtain article data", '', __LINE__, __FILE__, $sql);
	   	   }
	   	   if ( $cat = $db->sql_fetchrow($results) )
	   	   { 
	  	   	  $new_number = $cat['number_articles'] - 1;
	 	   }
	
	  	   $sql = "UPDATE " . KB_CATEGORIES_TABLE .
		   	   " SET number_articles = " . $new_number .
		   	   " WHERE category_id = '" . $category . "'";
		 
	 	    if ( !($result = $db->sql_query($sql)) )
	 	  	{
   	  	  	   message_die(GENERAL_ERROR, "Could not update category data", '', __LINE__, __FILE__, $sql);
	 	    }
			}
	   }

	   $sql = "UPDATE " . KB_ARTICLES_TABLE . "
	   		SET article_category_id = '$category', 
			article_title = '$title', 
			article_description = '$description', 
			article_date = '$date', 
			article_author_id = '$author_id', 
			article_body = '$article_text', 
			article_type = '$type', 
			article_keywords = '$keywords', 
			approved = '$approve' 
			WHERE article_id = '$article_id'";
			  
	   if ( !($edit_article = $db->sql_query($sql)) )
	   {
	   	  message_die(GENERAL_ERROR, "Could not edit aritcle", '', __LINE__, __FILE__, $sql);
	   }

	  if ( $kb_config['notify'] == 2 && $approve == 0 )
	  {	   
	   		$email_body = $lang['Email_body'];
	   
	   		include($phpbb_root_path . 'includes/emailer.'.$phpEx); 
	   		$emailer = new emailer($board_config['smtp_delivery']); 

	  		$email_headers = 'From: ' . $board_config['board_email'] . "\nReturn-Path: " . $board_config['board_email'] . "\n"; 

	   		$emailer->email_address($board_config['board_email']); 
	   		$emailer->set_subject($lang['New_article']); 
	   		$emailer->extra_headers($email_headers); 
	   		$emailer->msg = $email_body; 

	   		$emailer->send(); 
	   		$emailer->reset();
		}
		
		if ( $kb_config['notify'] == 1 && $approve == 0 )
		{
		  $sql = "UPDATE " . USERS_TABLE . " 
		   		SET user_new_privmsg = '1', user_last_privmsg = '9999999999'
				WHERE user_id = " . $kb_config['admin_id'];
				
		   if ( !($result = $db->sql_query($sql)) )
           {
		      message_die(GENERAL_ERROR, 'Could not update users table', '', __LINE__, __FILE__, $sql);
           }

		   $user_id = $kb_config['admin_id'];
		   
           $new_article_subject = $lang['New_article'];
           $new_article = $lang['Email_body'];
           $privmsgs_date = date("U");
           $sql = "INSERT INTO " . PRIVMSGS_TABLE . " (privmsgs_type, privmsgs_subject, privmsgs_from_userid, privmsgs_to_userid, privmsgs_date, privmsgs_enable_html, privmsgs_enable_bbcode, privmsgs_enable_smilies, privmsgs_attach_sig) VALUES ('0', '" . $new_article_subject . "', '" . $user_id . "', '" . $user_id . "', '" . $privmsgs_date . "', '0', '1', '1', '0')";
           
		   if ( !$db->sql_query($sql) )
		   {
			  message_die(GENERAL_ERROR, 'Could not insert private message sent info', '', __LINE__, __FILE__, $sql);
		   }

		   $privmsg_sent_id = $db->sql_nextid();
		   $privmsgs_text = $lang['register_pm_subject'];
           $sql = "INSERT INTO " . PRIVMSGS_TEXT_TABLE . " (privmsgs_text_id, privmsgs_text) VALUES ($privmsg_sent_id, '" . $new_article . "')";
           if ( !$db->sql_query($sql) )
		   {
			 message_die(GENERAL_ERROR, 'Could not insert private message sent text', '', __LINE__, __FILE__, $sql);
		   }
	   }
	   
	   $message = $lang['Article_Edited'] . '<br /><br />' . sprintf($lang['Click_return_kb'], '<a href="' . append_sid("kb.$phpEx") . '">', '</a>') . '<br /><br />' . sprintf($lang['Click_return_forum_index'], '<a href="' . append_sid("index.$phpEx") . '">', '</a>');

	   message_die(GENERAL_MESSAGE, $message);	   
	}	
	break;

	default:
	
	$page_title = $lang['KB_title'];
	include($phpbb_root_path . 'includes/page_header.'.$phpEx);
	
	make_jumpbox('kb.'.$phpEx,'');

	//load header
	include ($phpbb_root_path ."includes/kb_header.".$phpEx);
	
	$template->set_filenames(array(
		'body' => 'kb_index_body.tpl')
	);
	
	$template->assign_vars(array(
		'L_CATEGORY' => $lang['Category'],
		'L_ARTICLES' => $lang['Articles'])
	);
	
	$sql = "SELECT *  
       		FROM " . KB_CATEGORIES_TABLE . " 
			ORDER BY category_name ASC";
	
	if ( !($cat_result = $db->sql_query($sql)) )
	{
	   message_die(GENERAL_ERROR, "Could not obtain category information", '', __LINE__, __FILE__, $sql);
	}

	while ( $category = $db->sql_fetchrow($cat_result) )
	{	
		
		$category_details = $category['category_details'];
		$category_articles = $category['number_articles'];
		
		$category_id = $category['category_id'];
		$category_name = $category['category_name'];
		$temp_url = append_sid($phpbb_root_path . "kb.$phpEx?mode=cat&amp;cat=$category_id");
	   	$category = '<a href="' . $temp_url . '" class="forumlink">' . $category_name . '</a>';
		
		$template->assign_block_vars('catrow', array(
			'CATEGORY' => $category,
			'CAT_DESCRIPTION' => $category_details,
			'CAT_ARTICLES' => $category_articles)
		);
	}
	break;
}

$template->pparse('body');

include($phpbb_root_path . 'includes/page_tail.'.$phpEx);

?>
