<?php
/***************************************************************************
 *                              page_tail.php
 *                            -------------------
 *   begin                : Saturday, Feb 13, 2001
 *   copyright            : (C) 2001 The phpBB Group
 *   email                : support@phpbb.com
 *
 *   $Id: page_tail.php,v 1.27.2.2 2002/11/26 11:42:12 psotfx Exp $
 *
 ***************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 ***************************************************************************/

/***************************************************************************
 * This file has been modified by Fully Moddded phpBB
 *
 *   $FMId: 2003/08/11 07:22:12 mj
 *
 ***************************************************************************/

if ( !defined('IN_PHPBB') )
{
	die('Hacking attempt');
}

//
// Show the overall footer.
//

// Serverload
$server_load = serverload();
$out_server = $lang['Server_load'];
$out_server .= $server_load;
$out_server .= $lang['Pages_served'];

// Unique hits
$unique_hits = '' . uniquehits() . ' ' . $lang['Unique_hits'] . '';

if ( $userdata['user_level'] == ADMIN ) 
{ 
	$admin_link = '[ <a href="admin/index.' . $phpEx . '?sid=' . $userdata['session_id'] . '" target="_blank" class="copyright">' . $lang['Admin_panel'] . '</a> | <a href="super_mod/index.' . $phpEx . '?sid=' . $userdata['session_id'] . '" target="_blank" class="copyright">' . $lang['Super_Mod_panel'] . '</a> | <a href="modcp/index.' . $phpEx . '?sid=' . $userdata['session_id'] . '" target="_blank" class="copyright">' . $lang['Mod_CP'] . '</a> |';
	$stats_link = '<a href="statistics.' . $phpEx . '?sid=' . $userdata['session_id'] . '" class="copyright">' . $lang['Stats_panel'] . '</a> ]<br /><br />'; 
} 
else if ( $userdata['user_level'] == LESS_ADMIN ) 
{ 
	$admin_link = '[ <a href="super_mod/index.' . $phpEx . '?sid=' . $userdata['session_id'] . '" target="_blank" class="copyright">' . $lang['Super_Mod_panel'] . '</a> | <a href="modcp/index.' . $phpEx . '?sid=' . $userdata['session_id'] . '" target="_blank" class="copyright">' . $lang['Mod_CP'] . '</a> |';
	$stats_link = '<a href="statistics.' . $phpEx . '?sid=' . $userdata['session_id'] . '" class="copyright">' . $lang['Stats_panel'] . '</a> ]<br /><br />'; 
}
else if ( $userdata['user_level'] == MOD ) 
{ 
	$admin_link = '[ <a href="modcp/index.' . $phpEx . '?sid=' . $userdata['session_id'] . '" target="_blank" class="copyright">' . $lang['Mod_CP'] . '</a> |';
	$stats_link = '<a href="statistics.' . $phpEx . '?sid=' . $userdata['session_id'] . '" class="copyright">' . $lang['Stats_panel'] . '</a> ]<br /><br />'; 
}


$template->set_filenames(array(
	'overall_footer' => ( empty($gen_simple_header) ) ? 'overall_footer.tpl' : 'simple_footer.tpl')
);

$template->assign_vars(array(
	'L_ALL_CONTENT' => $lang['All_content'],
	'L_ORIG_AUTHOR' => $lang['Original_author'],
	'PHPBB_VERSION' => '2' . $board_config['version'],
	'FM_VERSION' => $board_config['fm_version'],
	'BOARD_SIG' => $board_config['board_sig'],
	'TRANSLATION_INFO' => ( isset($lang['TRANSLATION_INFO']) ) ? $lang['TRANSLATION_INFO'] : '', 
	'SYNDICATE_INFO' => $lang['SYNDICATE_INFO'] . ' <a href="' . $lang['BACKEND'] . '.' . $phpEx . '">' . $lang['BACKEND'] . '.' . $phpEx . '</a>',
	'ADMIN_LINK' => $admin_link, 
	'STATS_LINK' => $stats_link,
	'UNIQUE_HITS' => $unique_hits,
	'SERVER_LOAD' => $out_server)
);

$template->pparse('overall_footer');

//
// Generation Creation
//
$mtime = microtime(); 
$mtime = explode(" ",$mtime); 
$mtime = $mtime[1] + $mtime[0]; 
$endtime = $mtime; 
$totaltime = ($endtime - $starttime); 

$gzip_text = ($board_config['gzip_compress']) ? "GZIP : On " : "GZIP : Off "; 
$debug_mode = ($board_config['debug_value']) ? " | Debug : On" : ""; 

//
// Close our DB connection.
//
$db->sql_close();

//
// Compress buffered output if required and send to browser
//
if ( $do_gzip_compress )
{
	//
	// Borrowed from php.net!
	//
	$gzip_contents = ob_get_contents();
	ob_end_clean();

	$gzip_size = strlen($gzip_contents);
	$gzip_crc = crc32($gzip_contents);

	$gzip_contents = gzcompress($gzip_contents, 9);
	$gzip_contents = substr($gzip_contents, 0, strlen($gzip_contents) - 4);

	echo "\x1f\x8b\x08\x00\x00\x00\x00\x00";
	echo $gzip_contents;
	echo pack('V', $gzip_crc);
	echo pack('V', $gzip_size);
}

$generation_time =  printf("<div align=\"center\"><span class=\"copyright\">[ Time : %fs | " . $db->num_queries . " Queries | " . $attach_num_queries . " Attachment Queries | $gzip_text".$debug_mode." ]</span><br />&nbsp;</div></body></html>", $totaltime); 

exit;

?>