<?php
/***************************************************************************
 *
 *                                 quiz.php         
 *                            ------------------
 *   begin                : Thursday, November 1, 2002
 *   copyright            : (c) 2002 Giga Knight
 *   email                : community@gigaknight.com
 *
 *   $Id                  : quiz.php v0.0.1
 *
 ***************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 ***************************************************************************/

if (!defined('IN_PHPBB'))
{
  die('Hacking attempt');
  exit;
}

// Start session management
$userdata = session_pagestart($user_ip, PAGE_ACTIVITY);
init_userprefs($userdata);
// End session management

// include language file
$language = $board_config['default_lang'];

if( !file_exists($phpbb_root_path . 'language/lang_' . $language . '/lang_games.'.$phpEx) )
{
	$language = 'english';
}

include($phpbb_root_path . 'language/lang_' . $language . '/lang_games.' . $phpEx);

// Make sure the player is registered
$username = $userdata['user_id'];

if ( !$userdata['session_logged_in'] && $user_id == ANONYMOUS) 
{ 
	redirect("login.".$phpEx."?redirect=activity.".$phpEx); 
	exit; 
} 

include($phpbb_root_path . 'includes/page_header.'.$phpEx);

// Grab some Gk Game Data ===================================================

$sql = "SELECT * FROM " . GK_TABLE . "";
if ( !($result = $db->sql_query($sql)) )
{
	message_die(GENERAL_ERROR, 'Could not obtaining quiz information', '', __LINE__, __FILE__, $sql);
}
if ( $row = $db->sql_fetchrow($result) )
{
	// Grab the Hiscores data
	$quiz_hs = $row['quiz_best_score'];
	$quiz_bp = $row['quiz_best_player'];
}

$sql = "SELECT * FROM " . GK_QUIZ_TABLE . "
        ORDER BY quiz_topic_id";
if( !$result = $db->sql_query($sql) )
{
	message_die(GENERAL_ERROR, "Could not obtain quiz information", "", __LINE__, __FILE__, $sql);
}
$quiz_count = $db->sql_numrows($result);
$quiz_rows = $db->sql_fetchrowset($result);

if( $board_config['use_allowance_system'] )
{
	$reward_system = $board_config['money_name'];
}
else if ( $board_config['use_point_system'] )
{
	$reward_system = $board_config['points_name'];
}

// Generate page
$template->set_filenames(array(
	'body' => 'quiz_list_body.tpl')
);
make_jumpbox('viewforum.'.$phpEx, $forum_id); 

$template->assign_vars(array(
	'L_QUIZ' => $lang['Quiz_menu'],
	'L_SCORE' => $lang['Highscore'],
	'L_MONEY' => $reward_system)
);

for($i = 0; $i < $quiz_count; $i++)
{
	$quiz_id = $quiz_rows[$i]['quiz_topic_id'];

	$quiz = $quiz_rows[$i]['quiz_topic_name'];
	$quiz_co = $quiz_rows[$i]['quiz_topic_cost'];
	$quiz_img = $quiz_rows[$i]['quiz_topic_img'];
	$quiz_desc = $quiz_rows[$i]['quiz_topic_desc']; 
    
	$row_color = ( !($i % 2) ) ? $theme['td_color1'] : $theme['td_color2'];
	$row_class = ( !($i % 2) ) ? $theme['td_class1'] : $theme['td_class2'];

	$template->assign_block_vars("quiz", array(
		"ROW_COLOR" => "#" . $row_color,
		"ROW_CLASS" => $row_class,
	
		"QUIZ" => $quiz,
		"QUIZ_CO" => $quiz_co,
		"QUIZ_DESC" => $quiz_desc,
		"QUIZ_DISPLAY_IMG" => ( $quiz_img != "" ) ? '<img align="middle" src="./games/quiz/images/' . $quiz_img . '">' : "",
		"S_QUIZ_ACTION" => append_sid("activity.$phpEx?mode=play_quiz&amp;quiz_id=$quiz_id"))
	);
}

$template->pparse('body');

include($phpbb_root_path . 'includes/page_tail.'.$phpEx);

?>