<?php
/***************************************************************************
 *                                  charts.php
 *                            -------------------
 *   copyright            : (C) 2003 dzidzius
 *   email                : dzidzius@forumbest.now.pl <http://www.forumbest.now.pl>
 *
 *   $FMId: 2003/04/29 19:07:45 mj 
 *
 ***************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 ***************************************************************************/

define('IN_PHPBB', true);
$phpbb_root_path = './';
include($phpbb_root_path . 'extension.inc');
include($phpbb_root_path . 'common.'.$phpEx);

//
// Start session management
//
$userdata = session_pagestart($user_ip, PAGE_CHARTS);
init_userprefs($userdata);
//
// End session management
//

include($phpbb_root_path.'language/lang_' . $board_config['default_lang'] . '/lang_charts.'.$phpEx);

if( isset($HTTP_GET_VARS['action']) || isset($HTTP_POST_VARS['action']) )
{
	$mode = ($HTTP_GET_VARS['action']) ? $HTTP_GET_VARS['action'] : $HTTP_POST_VARS['action'];
}
else
{
	//
	// These could be entered via a form button
	//
	if( isset($HTTP_POST_VARS['save']) )
	{
		$mode = "save";
	}
	else
	{
		$mode = "";
	}
}

if( $mode != "" )
{
        if( $mode == "list" || $mode == "all_list" )
        {
                $page_title = $lang['Charts'];
                include($phpbb_root_path . 'includes/page_header.'.$phpEx);
                $list_type = ($mode=="list")?"all_list":"list";

		$template->set_filenames(array(
			"body" => "charts_list_body.tpl")
		);
            make_jumpbox('viewforum.'.$phpEx, $forum_id); 
        	$v_num = ($mode == "list")?10:30;

                $template->assign_vars(array(
                        "V_WEEK_NUM" => $board_config['charts_week_num'],
                        "U_SHOW_LIST" => append_sid("charts.$phpEx?action=".$list_type),
                        "L_SHOW_LIST" => ($mode == "list")?$lang['All_Charts']:$lang['Top_Ten'],
                        "U_ADD_CHART" => append_sid("charts.$phpEx?action=new"),
                        "L_WEEK" => $lang['Chart_Week'],
                        "L_CHART_NAME" => $lang['Charts'],
                        "L_THIS_WEEK" => $lang['Chart_Curr_Pos'],
                        "L_LAST_WEEK" => $lang['Chart_Last_Pos'],
                        "L_BEST_POS" => $lang['Chart_Best_Pos'],
                        "L_TITLE" => $lang['Chart_Title'],
                        "L_ARTIST" => $lang['Chart_Artist'],
                        "L_ALBUM" => $lang['Chart_Album'],
                        "L_LABEL" => $lang['Chart_Label'],
                        "L_CAT_NO" => $lang['Chart_Cat_No'],
                        "L_WEBSITE" => $lang['Website'],
                        "L_ADDED" => $lang['Chart_Added_By'],
                        "L_RATE" => $lang['Chart_Rate'],
			      "ADD_IMG" => '<img src="' . $images['icon_add_song'] . '" border="0" alt="' . $lang['New_Song'] . '">')
                );
                $db->sql_freeresult($result);

               	$sql = 'SELECT chart_id, chart_hot, chart_not, chart_song_name, chart_artist, chart_album, chart_label, chart_catno, chart_website, chart_last_pos, chart_best_pos, username FROM '.CHARTS_TABLE.', '.USERS_TABLE.' WHERE chart_poster_id=user_id ORDER BY (chart_hot-chart_not) DESC, chart_artist LIMIT 0,'.$v_num;
                if( !$result = $db->sql_query($sql) )
                   	message_die(GENERAL_ERROR, $lang['Chart_Sql_Error'], $lang['Error'], __LINE__, __FILE__, $sql);
                while($row = $db->sql_fetchrow($result))
                {
                	$chart_counter++;
	                $template->assign_block_vars('chart_block', array(
  	                        "CHART_SONG" => $row['chart_song_name'],
		                  "CHART_ARTIST" => $row['chart_artist'],
  		                  "CHART_ALBUM" => ($row['chart_album']=="NULL")?"":$row['chart_album'],
  		                  "CHART_LABEL" => ($row['chart_label']=="NULL")?"":$row['chart_label'],
  		                  "CHART_CAT_NO" => ($row['chart_catno']=="NULL")?"":$row['chart_catno'],
  		                  "CHART_WEBSITE" => ($row['chart_website']=="NULL")?"":$row['chart_website'],
		                  "CHART_POSTER" => $row['username'],
                              "CHART_LAST" => ($row['chart_last_pos']==0)?($lang['Chart_New_Song']): "".$row['chart_last_pos']."",
                              "CHART_BEST" => $row['chart_best_pos'],
                              "CHART_HOT_NOT" => "(".$lang['Chart_Hot'].": ".$row['chart_hot']." - ".$lang['Chart_Not'].": ".$row['chart_not'].")",
                              "HOT_IMG" => '<img src="' . $images['icon_hot'] . '" border="0" alt="' . $lang['Chart_Hot'] . '">',
                              "NOT_IMG" => '<img src="' . $images['icon_not'] . '" border="0" alt="' . $lang['Chart_Not'] . '">',
                              "U_CHART_HOT" => append_sid("charts.$phpEx?action=vote&amp;rate=1&amp;id=".$row['chart_id']),
                              "U_CHART_NOT" => append_sid("charts.$phpEx?action=vote&amp;rate=2&amp;id=".$row['chart_id']),
		                  "CHART_POS" => $chart_counter)
                        );
                }
                $db->sql_freeresult($result);
                $template->pparse('body');
                include($phpbb_root_path . 'includes/page_tail.'.$phpEx);

        }
        else if( $mode == "vote" )
        {
                $page_title = $lang['Charts'];
                include($phpbb_root_path . 'includes/page_header.'.$phpEx);

        	if( isset($HTTP_POST_VARS['id']) ||  isset($HTTP_GET_VARS['id']) )
        	{
        		$chart_id = ( isset($HTTP_POST_VARS['id']) ) ? $HTTP_POST_VARS['id'] : $HTTP_GET_VARS['id'];
        	}
		else
		{
			$chart_id = 0;
		}
		if($chart_id)
		{
                        if( isset($HTTP_POST_VARS['rate']) ||  isset($HTTP_GET_VARS['rate']) )
                        {
                        	$rate = ( isset($HTTP_POST_VARS['rate']) ) ? $HTTP_POST_VARS['rate'] : $HTTP_GET_VARS['rate'];
                        }
                        else
                        {
                        	$rate = 0;
                        }
                        if($rate==1||$rate==2)
                        {
                                if($userdata['session_logged_in'])
                                {
                                        $sql = 'SELECT count(*) as counter FROM '.CHARTS_VOTERS_TABLE.' WHERE vote_chart_id = '.$chart_id.' AND vote_user_id = '.$userdata['user_id'];
                                        if( !$result = $db->sql_query($sql) )
                   	                    message_die(GENERAL_ERROR, $lang['Chart_Sql_Error'], $lang['Error'], __LINE__, __FILE__, $sql);
                                        $row = $db->sql_fetchrow($result);
                                        $db->sql_freeresult($result);
                                        if(!$row['counter'])
                                        {
                                        	$sql = 'INSERT INTO '.CHARTS_VOTERS_TABLE.'(vote_user_id, vote_chart_id, vote_rate)
                                        	        VALUES('.$userdata['user_id'].','.$chart_id.','.$rate.')';
                                  		if(!$result = $db->sql_query($sql))
                                    		{
                                      			message_die(GENERAL_ERROR, $lang['Chart_Sql_Base_Error'], $lang['Error'], __LINE__, __FILE__, $sql);
                                        	}
                                        	if($rate==1)
                                        	        $sql = 'UPDATE '.CHARTS_TABLE.'
                                        	                SET chart_hot=chart_hot+1
                                                                WHERE chart_id = '.$chart_id;
                                        	else
                                        	        $sql = 'UPDATE '.CHARTS_TABLE.'
                                        	                SET chart_not=chart_not+1
                                                                WHERE chart_id = '.$chart_id;
                                  		if(!$result = $db->sql_query($sql))
                                    		{
                                      			message_die(GENERAL_ERROR, $lang['Chart_Sql_Error'], $lang['Error'], __LINE__, __FILE__, $sql);
                                        	}

                                                $message = $lang['Vote_cast'];
                                                $message .= "<br /><br />" . sprintf($lang['Chart_click_link'], "<a href=\"" . append_sid("charts.$phpEx?action=all_list") . "\">", "</a>") . "<br /><br />" . sprintf($lang['Click_return_index'], "<a href=\"" . append_sid("index.$phpEx") . "\">", "</a>");
                                                message_die(GENERAL_MESSAGE, $message);
                                        }
                                        else
                                        {
                                        	$message = $lang['Chart_Rate_Err'];
                                                $message .= "<br /><br />" . sprintf($lang['Chart_click_link'], "<a href=\"" . append_sid("charts.$phpEx?action=all_list") . "\">", "</a>") . "<br /><br />" . sprintf($lang['Click_return_index'], "<a href=\"" . append_sid("index.$phpEx") . "\">", "</a>");
                                                message_die(GENERAL_MESSAGE, $message);
                                        }
                                }
                                else
                                {
                                	$message = $lang['Chart_Login_Err'];
                                	$message .= "<br /><br />" . sprintf($lang['Chart_click_link'], "<a href=\"" . append_sid("charts.$phpEx?action=all_list") . "\">", "</a>") . "<br /><br />" . sprintf($lang['Click_return_index'], "<a href=\"" . append_sid("index.$phpEx") . "\">", "</a>");
                                	message_die(GENERAL_MESSAGE, $message);
                                }
                        }
                        else
                        {
                        	$message = $lang['Chart_Vote_Err'];
                        	$message .= "<br /><br />" . sprintf($lang['Chart_click_link'], "<a href=\"" . append_sid("charts.$phpEx?action=all_list") . "\">", "</a>") . "<br /><br />" . sprintf($lang['Click_return_index'], "<a href=\"" . append_sid("index.$phpEx") . "\">", "</a>");
                        	message_die(GENERAL_MESSAGE, $message);
                        }
		}
                else
                {
                	$message = $lang['Chart_Choose_Err'];
                	$message .= "<br /><br />" . sprintf($lang['Chart_click_link'], "<a href=\"" . append_sid("charts.$phpEx?action=all_list") . "\">", "</a>") . "<br /><br />" . sprintf($lang['Click_return_index'], "<a href=\"" . append_sid("index.$phpEx") . "\">", "</a>");
                        message_die(GENERAL_MESSAGE, $message);
                }
        }
        else if( $mode == "new" )
        {
        	if($userdata['session_logged_in'])
        	{
                        $page_title = $lang['Charts']." :: ". $lang['New_Song'];
                        include($phpbb_root_path . 'includes/page_header.'.$phpEx);
                        $s_hidden_fields = '';
		        $template->set_filenames(array(
			        "body" => "charts_new_body.tpl")
		        );
			  make_jumpbox('viewforum.'.$phpEx, $forum_id); 

                        $template->assign_vars(array(
                                "L_ADDING_TITLE" => $lang['New_Song'],
                                "L_TITLE" => $lang['Charts'],
					  "L_ITEMS_REQUIRED" => $lang['Items_required'],
					  "L_SONG" => $lang['Chart_Title'],
                                "L_ARTIST" => $lang['Chart_Artist'],
                                "L_ALBUM" => $lang['Chart_Album'],
                                "L_LABEL" => $lang['Chart_Label'],
                                "L_CAT_NO" => $lang['Chart_Cat_No'],
                                "L_WEBSITE" => $lang['Website'],
                                "L_SUBMIT" => $lang['Submit'],
                                "L_RESET" => $lang['Reset'],
                                "S_HIDDEN_FIELDS" => $s_hidden_fields,
                                "S_CHART_ACTION" => append_sid("charts.$phpEx"),
                                "U_SHOW_LIST" => append_sid("charts.$phpEx?action=list"))
                        );
                        $template->pparse('body');
                        include($phpbb_root_path . 'includes/page_tail.'.$phpEx);
        	}
                else
                {
                        $message = $lang['Chart_SLog_Err'];
                        $message .= "<br /><br />" . sprintf($lang['Chart_click_link'], "<a href=\"" . append_sid("charts.$phpEx?action=list") . "\">", "</a>") . "<br /><br />" . sprintf($lang['Click_return_index'], "<a href=\"" . append_sid("index.$phpEx") . "\">", "</a>");
                        message_die(GENERAL_MESSAGE, $message);
                }
        }
        else if( $mode == "save" )
        {
        	if($userdata['session_logged_in'])
        	{
        		$song_name = ( isset($HTTP_POST_VARS['song_name']) ) ? trim($HTTP_POST_VARS['song_name']) : "";
        		$artist_name = ( isset($HTTP_POST_VARS['artist_name']) ) ? trim($HTTP_POST_VARS['artist_name']) : "";
        		$album_name = ( isset($HTTP_POST_VARS['album_name']) ) ? trim($HTTP_POST_VARS['album_name']) : "";

                        if( $artist_name == "" || $song_name == "")
                        {
                                $message = $lang['Chart_Fields_Err'];
                                $message .= "<br /><br />" . sprintf($lang['Chart_click_link'], "<a href=\"" . append_sid("charts.$phpEx?action=list") . "\">", "</a>") . "<br /><br />" . sprintf($lang['Click_return_index'], "<a href=\"" . append_sid("index.$phpEx") . "\">", "</a>");
                                message_die(GENERAL_MESSAGE, $message);
                        }

                        $sql = "INSERT INTO ".CHARTS_TABLE."(chart_song_name, chart_artist, chart_album, chart_label, chart_catno, chart_website, chart_poster_id)
                                VALUES('".$song_name."','".$artist_name."','".$album_name."','".$label_name."','".$catno_name."','".$website_name."',".$userdata['user_id'].")";
                        if(!$result = $db->sql_query($sql))
                        {
                                $message = $lang['Chart_Song_Err'];
                                $message .= "<br /><br />" . sprintf($lang['Chart_click_link'], "<a href=\"" . append_sid("charts.$phpEx?action=new") . "\">", "</a>") . "<br /><br />" . sprintf($lang['Click_return_index'], "<a href=\"" . append_sid("index.$phpEx") . "\">", "</a>");
                                message_die(GENERAL_ERROR, $message);
                        }
                        $message = $lang['Chart_Song_Add'];
                        $message .= "<br /><br />" . sprintf($lang['Chart_click_link'], "<a href=\"" . append_sid("charts.$phpEx?action=list") . "\">", "</a>") . "<br /><br />" . sprintf($lang['Click_return_index'], "<a href=\"" . append_sid("index.$phpEx") . "\">", "</a>");
                        message_die(GENERAL_MESSAGE, $message);
        	}
                else
                {
                        $message = $lang['Chart_SLog_Err'];
                        $message .= "<br /><br />" . sprintf($lang['Chart_click_link'], "<a href=\"" . append_sid("charts.$phpEx?action=list") . "\">", "</a>") . "<br /><br />" . sprintf($lang['Click_return_index'], "<a href=\"" . append_sid("index.$phpEx") . "\">", "</a>");
                        message_die(GENERAL_MESSAGE, $message);
                }
        }
}
else
{
$page_title = $lang['Title'];
include($phpbb_root_path . 'includes/page_header.'.$phpEx);
message_die(GENERAL_MESSAGE, $lang['Chart_No_Arguments']);
}

?>