<?php
/***************************************************************************
                        admin_user_active.php
                        -------------------
   begin                : Sat May 18 2002
   copyright            : (C) 2002 John B. Abela
   email                : abela@phpbb.com
		
***************************************************************************/

/***************************************************************************
*                                         		                               
*   This program is free software; you can redistribute it and/or modify  	
*   it under the terms of the GNU General Public License as published by  
*   the Free Software Foundation; either version 2 of the License, or	    	
*   (at your option) any later version.
*
***************************************************************************/

define('IN_PHPBB', 1);

if( !empty($setmodules) )
{
	$filename = basename(__FILE__);
	$module['Users']['Inactive_users'] = append_sid($filename);
	return;
}

//
// Load default header
//
$phpbb_root_path = "../";
require($phpbb_root_path . 'extension.inc');
require('pagestart.' . $phpEx);
include($phpbb_root_path.'language/lang_' . $board_config['default_lang'] . '/lang_inactive_users.'.$phpEx);

//
// Page Specific Functions
//
function id_to_name($user_id) {
	global $db;

	$sql = "SELECT username
	FROM " . USERS_TABLE . "
	WHERE user_id = $user_id";

	if(!$result = $db->sql_query($sql))
	{
		message_die(GENERAL_ERROR, "Couldn't query users table to obtain users name.", "", __LINE__, __FILE__, $sql);
	}
	$row = $db->sql_fetchrow($result);
	return $row['username'];
}
//
//End Page Specific Functions
//

//
// Generate page
//
	$sql = "SELECT user_id, user_email, user_regdate  
		FROM " . USERS_TABLE . "
	WHERE user_active = 0
	AND user_id != -1";
	$result = $db->sql_query($sql);
	if( !$result )
	{
		message_die(GENERAL_ERROR, "Couldn't obtain inactive users from database", "", __LINE__, __FILE__, $sql);
	}

      $result_count = $db->sql_numrows($result);
	$result_rows = $db->sql_fetchrowset($result);

	$template->set_filenames(array(
		"body" => "admin/admin_user_active_body.tpl")
	);

	$template->assign_vars(array(
		"L_PAGE_TITLE" => $lang['Page_title'],
		"L_PAGE_DESCRIPTION" => $lang['Page_description'],
		"L_INACTIVE_USERS" => $lang['Inactive_users'],
		"L_USER_ID" => $lang['Users_id'],
		"L_USER_NAME" => $lang['Users_name'],
		"L_USER_EMAIL" => $lang['Users_email'],
		"L_USER_REG_DATE" => $lang['Users_regdate'])
	);

//
// Loop through the rows of inactive users setting block vars for the template.
//
	for($i = 0; $i < $result_count; $i++)
	{
		$row_color = ( !($i % 2) ) ? $theme['td_color1'] : $theme['td_color2'];
		$row_class = ( !($i % 2) ) ? $theme['td_class1'] : $theme['td_class2'];

		$template->assign_block_vars("users", array(
			"ROW_COLOR" => "#" . $row_color,
			"ROW_CLASS" => $row_class,
			
			"USER_NAME" => id_to_name($result_rows[$i]['user_id']),
			"USER_EMAIL" => $result_rows[$i]['user_email'], 
			"USER_REGDATE" => create_date($board_config['default_dateformat'], $result_rows[$i]['user_regdate'], $board_config['board_timezone']), 
			"USER_ID" => $result_rows[$i]['user_id'])
		);
	}

$template->pparse("body");

include('page_footer_admin.'.$phpEx);

?>