<?php
/***************************************************************************
 *                                admin_referers.php
 *                            -------------------
 *   begin                : Friday, February 28, 2003
 *   copyright            : (C) 2002 NKieTo
 *   email                : nkieto@yahoo.es
 *
 *   $Id: admin_referers.php,v 0.2.0 11/03/2003, 22:04:58 NKieTo Exp $
 *
 ***************************************************************************/

/***************************************************************************
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 ***************************************************************************/

/***************************************************************************
 *
 *   Some code in this file I borrowed from Admin Users List Mod by
 *   Smartor (http://smartor.is-root.com)
 *
 ***************************************************************************/

/***************************************************************************
 * This file has been modified by Fully Moddded phpBB
 *
 *   $FMId: 2003/06/20 05:41:12 mj 
 *
 ***************************************************************************/

define('IN_PHPBB', 1);

if( !empty($setmodules) )
{
	$file = basename(__FILE__);
	$module['Referrals']['HTTP_Referers_Title'] = $file;
	return;
}

//
// Load default header
//
$phpbb_root_path = "./../";
require($phpbb_root_path . 'extension.inc');
require('./pagestart.' . $phpEx);


//
// Set variables
//
$referers_per_page = 25;

//
// Check to see what mode we should operate in.
//
if( isset($HTTP_POST_VARS['mode']) || isset($HTTP_GET_VARS['mode']) )
{
	$mode = ( isset($HTTP_POST_VARS['mode']) ) ? $HTTP_POST_VARS['mode'] : $HTTP_GET_VARS['mode'];
}
else
{
	$mode = "";
}

//
// Select main mode
//
if( isset($HTTP_POST_VARS['delete']) || isset($HTTP_GET_VARS['delete']) )
{
	//
	// Delete all referers data 
	//
	$sql = "DELETE FROM " . REFERERS_TABLE;
	if (!$query = $db->sql_query($sql))
	{
		message_die(GENERAL_ERROR, 'Imposible borrar', '', __LINE__, __FILE__, $sql);
	}
	$message = $lang['referer_del_success'] . "<br /><br />" . sprintf($lang['Click_return_referersadmin'], "<a href=\"" . append_sid("admin_referers.$phpEx") . "\">", "</a>") . "<br /><br />" . sprintf($lang['Click_return_admin_index'], "<a href=\"" . append_sid("index.$phpEx?pane=right") . "\">", "</a>");

	message_die(GENERAL_MESSAGE, $message);		
}

else if ( $mode != "" )
{
	switch( $mode )
	{
		case 'delete':
			//
			// Delete a individual referer
			//		
		$referer_id = ( !empty($HTTP_POST_VARS['id']) ) ? $HTTP_POST_VARS['id'] : $HTTP_GET_VARS['id'];		

		$sql = "DELETE FROM " . REFERERS_TABLE . "
				WHERE referer_id = " . $referer_id;
		$result = $db->sql_query($sql);
		if( !$result )
		{
			message_die(GENERAL_ERROR, "Couldn't delete referer", "", __LINE__, __FILE__, $sql);
		}

		$message = $lang['referer_del_success'] . "<br /><br />" . sprintf($lang['Click_return_referersadmin'], "<a href=\"" . append_sid("admin_referers.$phpEx") . "\">", "</a>") . "<br /><br />" . sprintf($lang['Click_return_admin_index'], "<a href=\"" . append_sid("index.$phpEx?pane=right") . "\">", "</a>");

		message_die(GENERAL_MESSAGE, $message);
		break;
	}		
}		
else
{
	//
	// This is the main display of the page before the admin has selected
	// any options.
	//
	$start = (isset($HTTP_GET_VARS['start'])) ? intval($HTTP_GET_VARS['start']) : 0;

	if( isset($HTTP_POST_VARS['sort']) )
	{
		$sort_method = $HTTP_POST_VARS['sort'];
	}
	else if( isset($HTTP_GET_VARS['sort']) )
	{
		$sort_method = $HTTP_GET_VARS['sort'];
	}
	else
	{
		$sort_method = 'referer_http';
	}

	if( isset($HTTP_POST_VARS['order']) )
	{
		$sort_order = $HTTP_POST_VARS['order'];
	}
	else if( isset($HTTP_GET_VARS['order']) )
	{
		$sort_order = $HTTP_GET_VARS['order'];
	}
	else
	{
		$sort_order = '';
	}

	$template->set_filenames(array(
		"body" => "admin/admin_referers.tpl")
	);

	$template->assign_vars(array(
		'L_HTTP_REFERERS_TITLE' => $lang['HTTP_Referers_Title'],
		'L_HTTP_REFERERS_EXPLAIN' => $lang['HTTP_Referers_Explain'],
		'L_SELECT_SORT_METHOD' => $lang['Select_sort_method'],
		'U_LIST_ACTION' => append_sid("admin_referers.$phpEx"),
		'L_SORT' => $lang['Sort'],
		'L_ORDER' => $lang['Order'],
		'L_DELETE' => $lang['Delete'],
		'L_SORT_DESCENDING' => $lang['Sort_Descending'],
		'L_SORT_ASCENDING' => $lang['Sort_Ascending'],
		'L_REFERER' => $lang['Referer_http'],
		'L_HITS' => $lang['Referer_hits'],
		'L_FIRSTVISIT' => $lang['Referer_firstvisit'],
		'L_LASTVISIT' => $lang['Referer_lastvisit'],
		'L_ACTION' => $lang['Action'],	
		'REFERER_SELECTED' => ($sort_method == 'referer_http') ? 'selected="selected"' : '',
		'HITS_SELECTED' => ($sort_method == 'referer_hits') ? 'selected="selected"' : '',
		'FIRSTVISIT_SELECTED' => ($sort_method == 'referer_firstvisit') ? 'selected="selected"' : '',
		'LASTVISIT_SELECTED' => ($sort_method == 'referer_lastvisit') ? 'selected="selected"' : '',
		'ASC_SELECTED' => ($sort_order != 'DESC') ? 'selected="selected"' : '',
		'DESC_SELECTED' => ($sort_order == 'DESC') ? 'selected="selected"' : ''
		)	
	);

	// Count referers
	$sql = "SELECT * FROM " . REFERERS_TABLE;
	if(!$result = $db->sql_query($sql))
	{
		message_die(GENERAL_ERROR, "Could not query referers table", "Error", __LINE__, __FILE__, $sql);
	}
	$total_referers = $db->sql_numrows($result);

	// Query referer info...
	$sql = "SELECT referer_id, referer_http, referer_hits, referer_firstvisit, referer_lastvisit FROM " . REFERERS_TABLE . " ORDER BY " . $sort_method . " " . $sort_order . " LIMIT ".$start.",".$referers_per_page;
	if(!$result = $db->sql_query($sql))
	{
		message_die(GENERAL_ERROR, "Ostias", "", __LINE__, __FILE__, $sql);
	}

	while( $row = $db->sql_fetchrow($result) )
	{
		$refererrow[] = $row;
	}

	for ($i = 0; $i < $referers_per_page; $i++)
	{
		if (empty($refererrow[$i]))
		{
			break;
		}

		$row_color = (($i % 2) == 0) ? "row1" : "row2";

		$firstvisit = create_date($board_config['default_dateformat'], $refererrow[$i]['referer_firstvisit'], $board_config['board_timezone']);
		if ($refererrow[$i]['referer_lastvisit'] != 0) {
			$lastvisit = create_date($board_config['default_dateformat'], $refererrow[$i]['referer_lastvisit'], $board_config['board_timezone']);
		}
		else {
			$lastvisit = '';
		}
		$template->assign_block_vars('refererrow', array(
			'COLOR' => $row_color,
			'REFERER' => $refererrow[$i]['referer_http'],
			'FIRSTVISIT' => $firstvisit,
			'LASTVISIT' => $lastvisit,
			'HITS' => $refererrow[$i]['referer_hits'],
			'U_DELETE' => append_sid("admin_referers.$phpEx?mode=delete&amp;id=" . $refererrow[$i]['referer_id'])
			) //end array
		);
	} // end for

	$template->assign_vars(array(
		'PAGINATION' => generate_pagination(append_sid("admin_referers.$phpEx?sort=$sort_method&amp;order=$sort_order"), $total_referers, $referers_per_page, $start),
		'PAGE_NUMBER' => sprintf($lang['Page_of'], ( floor( $start / $referers_per_page ) + 1 ), ceil( $total_referers / $referers_per_page ))
		) // end array
	);

	$template->pparse('body');

}

include('./page_footer_admin.'.$phpEx);


?>