<?php
/***************************************************************************
 *                              admin_phpbbmyadmin.php
 *                            -------------------
 *   copyright            : (C) 2003 Armin Altorffer
 *   email                : aaltorffer@hotmail.com
 *
 ***************************************************************************/

/***************************************************************************
*
*   Copyright:      phpBBMyAdmin v0.0.7  2003 by Armin Altorffer
*   Support:         http://www.phpbbhacks.com/forums
*   This hack is released under the GPL License.
*   This hack can be freely used, but not distributed, without permission.
*   Intellectual Property is retained by the hack author(s) listed above.
*
***************************************************************************/

/***************************************************************************
*
*   This product is in no way affiliated with phpMyAdmin (www.phpmyadmin.net)
*   Nor does the author of this product offer support for phpMyAdmin.
*   For support on phpMyAdmin or for phpMyAdmin itself, visit www.phpmyadmin.net
*
***************************************************************************/
define('IN_PHPBB', 1);

if ( !empty($setmodules) )
{
	$file = basename(__FILE__);
	$module['Database']['phpBBMyAdmin'] = "$file";
	return;
}

// Going to powerful way here, using $file in links and not a literal text:
$file = basename(__FILE__);

//
// Let's set the root dir for phpBB
//
$phpbb_root_path = "./../";
require($phpbb_root_path . 'extension.inc');
require('./pagestart.' . $phpEx);
include($phpbb_root_path . 'includes/functions_selects.'.$phpEx);
include($phpbb_root_path . 'language/lang_' . $board_config['default_lang'] . '/lang_phpbbmyadmin.' . $phpEx);

//
// Start session management
//
$userdata = session_pagestart($user_ip, PAGE_INDEX);
init_userprefs($userdata);
//
// End session management
//

// Main Admin or not?
if ($userdata['user_id'] != 2)
{
	message_die(GENERAL_MESSAGE, $lang['SQL_Admin_No_Access']);
}

$template->set_filenames(array(
	"body" => "admin/phpbbmyadmin.tpl")
);

// Buttons pressed?
// Submit or $mode=submit:
if( isset($HTTP_POST_VARS['submit']) || ($mode == 'submit'))
{
	if (empty($this_query))
	{
		message_die(GENERAL_MESSAGE, sprintf($lang['SQL_Admin_No_Query'], '<a href="' . $file . '" style="text-decoration:none">', '</a>' , '<a href="index.php?pane=right&' . $userdata['session_id'] . '" style="text-decoration:none">', '</a>'));
	}
	// Add a semi-colon to the end if there isn't one:
	if (!strrpos($this_query, ";"))
	{
		$this_query .= ";";
	}
	$this_query = stripslashes ($this_query);
	// Cut into multiple queries:
	$currentpos = 0;
	$counter = 0;
	while (($nextpos = strpos($this_query, ";", $currentpos)) != false)
	{
		$counter++;
		$query[$counter] = substr ($this_query, $currentpos, ($nextpos - $currentpos));
		$query[$counter] .= ';';
		$currentpos = $nextpos + 1;
	}
	// That takes care of the multiple query support... now, let's do them queries!
	$output = '<br>';			// For the final message_die...
	for ($i = 1; $i <= $counter; $i++)
	{
		// Confirmation message required?
		if ($confirm == 'yes')
		{
			$message = $query[$i];
			$message .= '<br>' . $lang['SQL_Admin_Confirm'];
			$message .= '<br><a href="' . $file . '?mode=submit&this_query=' . $this_query . '" style="text-decoration:none">' . $lang['SQL_Admin_Yes_Word'] . '</a> / ';
			$message .= '<a href="' . $file . '" style="text-decoration:none">' . $lang['SQL_Admin_No_Word'] . '</a>';
			message_die (GENERAL_MESSAGE, $message);
		}
		$result = $db->sql_query($query[$i]);
		if (!$result)
		{
			message_die(GENERAL_ERROR, sprintf($lang['SQL_Admin_Error_In_Query'], $query[$i], '<a href="' . $file . '" style="text-decoration:none">', '</a>' , '<a href="index.php?pane=right&' . $userdata['session_id'] . '" style="text-decoration:none">', '</a>'));
		}
		$output .= $query[$i];
		$output .= '<br>';
	}
	// done with this query:
	$db->sql_freeresult($result);
	message_die(GENERAL_MESSAGE, sprintf($lang['SQL_Admin_Success_Query'], $output, '<a href="' . $file . '" style="text-decoration:none">', '</a>' , '<a href="index.php?pane=right&' . $userdata['session_id'] . '" style="text-decoration:none">', '</a>'));
}

// Repair All:
if( isset($HTTP_POST_VARS['repairall']) )
{
	// Retrieving the currently existing tables:
	$sql = "SHOW TABLES";
	$result = $db->sql_query($sql);
	if (!$result)
	{
		// This makes no sense, the board would be dead... :P
		message_die(GENERAL_ERROR, $lang['SQL_Admin_Tables_Error']);
	}
	// Start going through the tables, repairing them as we find them...
	$fooh = 'Tables_in_';
	$fooh .= $dbname;
	$tablecount = 0;
	while ($row = $db->sql_fetchrow($result))
	{
		$tablecount++;
		$repair = "REPAIR TABLE " . $row[$fooh];
		$repairresult = $db->sql_query($repair);
		if (!$repairresult)
		{
			// Error repairing table?
			message_die(GENERAL_ERROR, sprintf($lang['SQL_Admin_Repair_Error'], $row[$fooh]));
		}
	}
	$db->sql_freeresult($repairresult);
	$db->sql_freeresult($result);
	// Successfully repaired all.
	message_die(GENERAL_MESSAGE, sprintf($lang['SQL_Admin_Repair_Done'], $tablecount, '<a href="' . $file . '" style="text-decoration:none">', '</a>' , '<a href="index.php?pane=right&' . $userdata['session_id'] . '" style="text-decoration:none">', '</a>'));
}

// Optimize All:
if( isset($HTTP_POST_VARS['optimizeall']) )
{
	// Retrieving the currently existing tables:
	$sql = "SHOW TABLES";
	$result = $db->sql_query($sql);
	if (!$result)
	{
		// This makes no sense, the board would be dead... :P
		message_die(GENERAL_ERROR, $lang['SQL_Admin_Tables_Error']);
	}
	// Start going through the tables, optimizing them as we find them...
	$fooh = 'Tables_in_';
	$fooh .= $dbname;
	$tablecount = 0;
	while ($row = $db->sql_fetchrow($result))
	{
		$tablecount++;
		$optimize = "OPTIMIZE TABLE " . $row[$fooh];
		$optimizeresult = $db->sql_query($optimize);
		if (!$optimizeresult)
		{
			// Error optimizing table?
			message_die(GENERAL_ERROR, sprintf($lang['SQL_Admin_Optimize_Error'], $row[$fooh]));
		}
	}
	$db->sql_freeresult($optimizeresult);
	$db->sql_freeresult($result);
	// Successfully optimized all.
	message_die(GENERAL_MESSAGE, sprintf($lang['SQL_Admin_Optimize_Done'], $tablecount, '<a href="' . $file . '" style="text-decoration:none">', '</a>' , '<a href="index.php?pane=right&' . $userdata['session_id'] . '" style="text-decoration:none">', '</a>'));
}

// Done with buttons...

// Any options given?

if ($mode == 'browse')
// Browse a table...
{
	if ( empty ($tablename))
	// No table?
	{
		message_die(GENERAL_ERROR, $lang['SQL_Admin_No_Table']);
	}
	// Retrieve columns for this table:
	$sql = "SHOW COLUMNS FROM " . $tablename;
	$result = $db->sql_query($sql);
	if (!$result)
	{
		// Right... no columns?!?
		message_die(GENERAL_ERROR, $lang['SQL_Admin_Columns_Error']);
	}
	// Go through columns list, saving each Field.
	// Also save a SELECT argument.
	$fieldcount = 0;
	$fieldselect = '';			// SELECT $fieldselect FROM
	$columnsbrowse = '<td></td>';		// These are the available columns for this table...
	while ($row = $db->sql_fetchrow($result))
	{
		$fieldcount++;
		if ($fieldcount > 1)
		{
			$fieldselect .= ', ';
		}
		$field[$fieldcount] = $row['Field'];
		$fieldselect .= $row['Field'];
		$columnsbrowse .= '<td class="gensmall" style="text-decoration: none" align="center"><a href="' . $file . '?mode=browse&tablename=' . $tablename . '&order=' . $fieldcount . '&sort=ASC" class="gensmall">' . $row['Field'] . '</a></td>';
	}
	// Found ourselves all the columns/fields... let's retrieve the information and build an output.
	// First, let us quickly fetch the total number of entries in this table:
	$sql = "SELECT " . $fieldselect . " FROM " . $tablename;
	$result = $db->sql_query($sql);
	$totalentries = $db->sql_numrows($result);
	// OK, now that that is out of the way, let us continue:
	// order by?
	if (empty($order))
	{
		$order = 1;
	}
	$sql = "SELECT " . $fieldselect . " FROM " . $tablename . " ORDER BY " . $field[$order] . " ";
	// check for additional options
	if (empty($sort) || ($sort == 'ASC'))
	{
		$sort = "ASC";
		$sql .= "ASC";
	}
	else
	{
		$sort = "DESC";
		$sql .= "DESC";
	}
	$sql .= " ";
	if (empty($first))
	{
		$first = 0;
	}
	$sql .= "LIMIT " . $first . ", 30";

	$result = $db->sql_query($sql);
	if (!$result)
	{
		// No results?
		message_die(GENERAL_ERROR, sprintf($lang['SQL_Admin_Browse_Error'], $tablename));
	}
	// OK, we have the data... let's put it out to a thingy!
	while ($row = $db->sql_fetchrow($result))
	{
	$tabledata .= '<tr><td class="copyright"><a href="' . $file . '?mode=submit&this_query=DELETE FROM ' . $tablename . ' WHERE ' . $field[1] . '=\'' . $row[$field[1]] . '\'" class="copyright">' . $lang['SQL_Admin_Delete_Word'] . '</a></td>';
		for ($i = 1; $i <= $fieldcount; $i++)
		{
			$tabledata .= '<td class="copyright" align="center">' . $row[$field[$i]] . '</td>';
		}
	$tabledata .= '</tr>';
	}
	
	// Assign some stuff to the template:
	$jumpprev = $first - 30;
	$jumpnext = $first + 30;
	if ($jumpprev < 0)
	{
		$jumpprev = 0;
	}
	if ($jumpnext > ($totalentries - 30))
	{
		$jumpnext = ($totalentries - 30);
	}
	$columnbrowsetitle = sprintf ($lang['SQL_Admin_Browse_Title'], $tablename);
	$columnbrowsetitle .= '<span class="thHead"> :: <a href="' . $file . '?mode=browse&tablename=' . $tablename . '&first=0&sort=' . $sort . '&order=' . $order .'" style="text-decoration:none">' . $lang['SQL_Admin_First_Page'] . '</a>';
	$columnbrowsetitle .= ' :: <a href="' . $file . '?mode=browse&tablename=' . $tablename . '&first=' . $jumpprev . '&sort=' . $sort . '&order=' . $order .'" style="text-decoration:none">' . $lang['SQL_Admin_Prev_Page'] . '</a>';
	$columnbrowsetitle .= ' :: <a href="' . $file . '?mode=browse&tablename=' . $tablename . '&first=' . $jumpnext . '&sort=' . $sort . '&order=' . $order .'" style="text-decoration:none">' . $lang['SQL_Admin_Next_Page'] . '</a>';
	$columnbrowsetitle .= ' :: <a href="' . $file . '?mode=browse&tablename=' . $tablename . '&first=' . $first . '&sort=ASC&order=' . $order .'" style="text-decoration:none">' . $lang['SQL_Admin_ASC_Word'] . '</a>';
	$columnbrowsetitle .= ' :: <a href="' . $file . '?mode=browse&tablename=' . $tablename . '&first=' . $first . '&sort=DESC&order=' . $order .'" style="text-decoration:none">' . $lang['SQL_Admin_DESC_Word'] . '</a></span>';
	$template->assign_vars(array(
		"COLUMNS_BROWSE" => $columnsbrowse,
		"COLUMNS_BROWSE_TITLE" =>  $columnbrowsetitle,
		"NUMBER_COLUMNS" => ($fieldcount + 1),
		"TABLE_DATA" => $tabledata)
	);

	// Free result...
	$db->sql_freeresult($result);
}

if ($mode == 'showtable')
// Show a specific table:
{
	if ( empty ($tablename))
	// No table specified...
	{
		message_die(GENERAL_ERROR, $lang['SQL_Admin_No_Table']);
	}

	$sql = "SHOW COLUMNS FROM " . $tablename;

	$result = $db->sql_query($sql);
	if (!$result)
	{
		// Eeeeeh... no columns perhaps?
		message_die(GENERAL_ERROR, $lang['SQL_Admin_Columns_Error']);
	}
	// Found data (obviously), let's build an output...
	$columns = '';
	while ($row = $db->sql_fetchrow($result))
	{
		$columns .= '<tr>';
		$columns .= '<td><a href="' . $file . '?mode=submit&this_query=ALTER TABLE ' . $tablename . ' DROP ' . $row['Field'] . '&confirm=yes" class="copyright"><span class="copyright"> ' . $lang['SQL_Admin_Drop_Word'] . ' </span></a>';
		$columns .= '</td><td class="gensmall"><span class="copyright"> ' . $lang['SQL_Admin_Field_Word'] . ': </span>';
		$columns .= $row['Field'];
		$columns .= '</td><td class="gensmall"><span class="copyright"> ' . $lang['SQL_Admin_Type_Word'] . ': </span>';
		$columns .= $row['Type'];
		$columns .= '</td><td class="gensmall"><span class="copyright"> ' . $lang['SQL_Admin_Null_Word'] . ': </span>';
		$columns .= $row['Null'];
		$columns .= '</td><td class="gensmall"><span class="copyright"> ' . $lang['SQL_Admin_Key_Word'] . ': </span>';
		$columns .= $row['Key'];
		$columns .= '</td><td class="gensmall"><span class="copyright"> ' . $lang['SQL_Admin_Default_Word'] . ': </span>';
		$columns .= $row['Default'];
		$columns .= '</td><td class="gensmall"><span class="copyright"> ' . $lang['SQL_Admin_Extra_Word'] . ': </span>';
		$columns .= $row['Extra'];
		$columns .= '</tr>';
	}
	$template->assign_vars(array(
		"COLUMNS_TITLE" => sprintf($lang['SQL_Admin_Columns_Title'], $tablename),
		"COLUMNS" => $columns)
	);

	$db->sql_freeresult($result);
}

// Retrieving the currently existing tables:
$sql = "SHOW TABLES";
$result = $db->sql_query($sql);
if (!$result)
{
	// This makes no sense, the board would be dead... :P
	message_die(GENERAL_ERROR, $lang['SQL_Admin_Tables_Error']);
}
// Make it into a semi-nice looking little list:
$fooh = 'Tables_in_';
$fooh .= $dbname;
$tablecount = 0;
$tables = '';
while ($row = $db->sql_fetchrow($result))
{
	$tablecount++;
	$tables .= '<tr>';
	$tables .= '<td width="1" class="gensmall">' . $row[$fooh] . '</td>';
	$tables .= '<td width="1"><a href="' . $file . '?mode=showtable&tablename=' . $row[$fooh] . '" class="copyright">';
	$tables .= $lang['SQL_Admin_Structure_Word'];
	$tables .= '</a></td>';
	$tables .= '<td width="1"><a href="' . $file . '?mode=browse&tablename=' . $row[$fooh] . '" class="copyright">';
	$tables .= $lang['SQL_Admin_Browse_Word'];
	$tables .= '</a></td>';
	$tables .= '<td width="1"><a href="' . $file . '?mode=submit&this_query=OPTIMIZE TABLE ' . $row[$fooh] . '" class="copyright">';
	$tables .= $lang['SQL_Admin_Optimize_Word'];
	$tables .= '</a></td>';
	$tables .= '<td width="1"><a href="' . $file . '?mode=submit&this_query=REPAIR TABLE ' . $row[$fooh] . '" class="copyright">';
	$tables .= $lang['SQL_Admin_Repair_Word'];
	$tables .= '</a></td>';
	$tables .= '<td width="1"><a href="' . $file . '?mode=submit&this_query=DELETE FROM ' . $row[$fooh] . '&confirm=yes" class="copyright">';
	$tables .= $lang['SQL_Admin_Empty_Word'];
	$tables .= '</a></td>';
	$tables .= '<td><a href="' . $file . '?mode=submit&this_query=DROP TABLE ' . $row[$fooh] . '&confirm=yes" class="copyright">';
	$tables .= $lang['SQL_Admin_Drop_Word'];
	$tables .= '</a></td>';
	$tables .= '</tr>';
}
$db->sql_freeresult($result);

// assign some general stuff:
$template->assign_vars(array(
	"CURRENT_TIME" => sprintf($lang['SQL_Admin_Current_Time'], time (), create_date($board_config['default_dateformat'], time (), $board_config['board_timezone'])),
	"SQL_ACTION" => append_sid("$file"),
	"HEADER" => $lang['SQL_Admin_Title'],
	"QUERY_TITLE" => $lang['SQL_Admin_Query_Title'],
	"COPYRIGHT" => $lang['SQL_Admin_Copyright'],
	"THIS_QUERY" => $new['this_query'],
	"TABLES" => $tables,
	"TABLES_TITLE" => sprintf($lang['SQL_Admin_Tables_Title'], $tablecount),
	"OPTIMIZE_ALL_BUTTON" => $lang['SQL_Admin_Optimize_All_Button'],
	"REPAIR_ALL_BUTTON" => $lang['SQL_Admin_Repair_All_Button'],
	"SUBMIT_BUTTON" => $lang['SQL_Admin_Submit_Button'])
);

// parse body
$template->pparse("body");

// required stuff:
include('./page_footer_admin.'.$phpEx);

?>