<?php                  
/*
  paFileDB 3.0
  2001/2002 PHP Arena
  Written by Todd
  todd@phparena.net
  http://www.phparena.net
  Keep all copyright links on the script visible
  Please read the license included with this script for more information.
*/

define('IN_PHPBB', 1);

if( !empty($setmodules) )
{
	$file = basename(__FILE__);
	$module['Download'][$lang['Afile']] = "$file?file=add";
	$module['Download'][$lang['Efile']] = "$file?file=edit";
	$module['Download'][$lang['Dfile']] = "$file?file=delete";
	return;
}

$phpbb_root_path = "./../";

require($phpbb_root_path . 'extension.inc');

require('./pagestart.' . $phpEx);

include($phpbb_root_path . 'pafiledb/pafiledb_common.'.$phpEx);
 
include($phpbb_root_path . 'pafiledb/includes/functions_field.'.$phpEx);

$custom_field = new custom_field();
$custom_field->init();

if( isset($HTTP_GET_VARS['file']) || isset($HTTP_POST_VARS['file']) )
{
	$file = (isset($HTTP_POST_VARS['file'])) ? $HTTP_POST_VARS['file'] : $HTTP_GET_VARS['file'];

	switch($file)
	{
		case 'add':
		{
			$pafiledb_template->set_filenames(array(
				'admin' => 'admin/pa_admin_file_add.tpl')
			);

			// =======================================================
			// Get Vars
			// =======================================================
		
			$user_screen_shot = ( !empty($_POST['screen_shot_url']) ) ? htmlentities(trim(preg_replace('#\s{2,}#s', ' ', strtr((string) $_POST['screen_shot_url'], array_flip(get_html_translation_table(HTML_ENTITIES)))))) : ( ( !empty($_FILES['screen_shot']['tmp_name']) ) ? $_FILES['screen_shot']['tmp_name'] : '' );
			$ss_upload = ( empty($_POST['screen_shot_url']) ) ? TRUE : FALSE;

			$screen_shot_name = ( !empty($_FILES['screen_shot']['name']) ) ? $_FILES['screen_shot']['name'] : '';

			$screen_shot_size = ( !empty($_FILES['screen_shot']['size']) ) ? $_FILES['screen_shot']['size'] : '';

			$userfile = ( !empty($_POST['download_url']) ) ? htmlentities(trim(preg_replace('#\s{2,}#s', ' ', strtr((string) $_POST['download_url'], array_flip(get_html_translation_table(HTML_ENTITIES)))))) : ( ( !empty($_FILES['userfile']['tmp_name'])) ? $_FILES['userfile']['tmp_name'] : '' );
			$file_upload = ( empty($_POST['download_url']) ) ? TRUE : FALSE;

			$MAX_FILE_SIZE = ( isset($_POST['MAX_FILE_SIZE']) ) ? $_POST['MAX_FILE_SIZE'] : '';

			$userfile_name = ( !empty($_FILES['userfile']['name']) ) ? $_FILES['userfile']['name'] : '';

			$userfile_size = ( !empty($_FILES['userfile']['size']) ) ? $_FILES['userfile']['size'] : '';		

			$cat_id = ( isset($_REQUEST['cat_id']) ) ? intval($_REQUEST['cat_id']) : 0;

			$file_name = ( isset($_POST['name']) ) ? htmlentities(trim(preg_replace('#\s{2,}#s', ' ', strtr((string) $_POST['name'], array_flip(get_html_translation_table(HTML_ENTITIES)))))) : '';

			$file_long_desc = ( isset($_POST['long_desc']) ) ? $_POST['long_desc'] : '';

			$file_short_desc = ( isset($_POST['short_desc']) ) ? htmlentities(trim(preg_replace('#\s{2,}#s', ' ', strtr((string) $_POST['short_desc'], array_flip(get_html_translation_table(HTML_ENTITIES)))))) : ((!empty($file_long_desc)) ? substr($file_long_desc, 0, 50) . '...' : '');
		
			$file_author = ( isset($_POST['author']) ) ? htmlentities(trim(preg_replace('#\s{2,}#s', ' ', strtr((string) $_POST['author'], array_flip(get_html_translation_table(HTML_ENTITIES)))))) : ( ($userdata['user_id'] != ANONYMOUS) ? $userdata['username'] : '' );

			$file_version = ( isset($_POST['version']) ) ? htmlentities(trim(preg_replace('#\s{2,}#s', ' ', strtr((string) $_POST['version'], array_flip(get_html_translation_table(HTML_ENTITIES)))))) : '';

			$file_website = ( isset($_POST['website']) ) ? $_POST['website'] : '';
			if(!empty($file_website))
			{
				$file_website = (!preg_match('#^http[s]?:\/\/#i', $file_website)) ? 'http://' . $file_website : $file_website;
				$file_website = (preg_match('#^http[s]?\\:\\/\\/[a-z0-9\-]+\.([a-z0-9\-]+\.)?[a-z]+#i', $file_website)) ? $file_website : '';			
			}

			$file_posticon = ( isset($_POST['posticon']) ) ? $_POST['posticon'] : '';

			$file_license = ( isset($_POST['license']) ) ? intval($_POST['license']) : 0;

			$file_pin = ( isset($_POST['pin']) ) ? intval($_POST['pin']) : 0;

			$file_ss_link = ( isset($_POST['sshot_link']) ) ? intval($_POST['sshot_link']) : 0;

			// =======================================================
			// IF submit then upload the file and update the sql for it
			// =======================================================
		
			if ( isset($_POST['submit']) )
			{
				if($cat_id == -1)
				{
					message_die(GENERAL_ERROR, $lang['Missing_field']);
				}
			
				if(empty($file_name))
				{
					message_die(GENERAL_ERROR, $lang['Missing_field']);
				}
			
				if(empty($file_long_desc))
				{
					message_die(GENERAL_ERROR, $lang['Missing_field']);
				}
			
				if(empty($userfile))
				{
					message_die(GENERAL_ERROR, $lang['Missing_field']);
				}
				// =======================================================
				// if the file already exit then give the user a nice error message 
				// =======================================================
			
				if($file_upload)
				{
					$file_info = upload_file($userfile, $userfile_name, $userfile_size, $MAX_FILE_SIZE);
				
					if($file_info['error'])
					{
						message_die(GENERAL_ERROR, $file_info['message']);
					}
					$file_url = $file_info['url'];
				}
				else
				{
					$file_url = $userfile;
				}
			
				if(!empty($user_screen_shot))
				{
					if($ss_upload)
					{
						$screen_shot_info = upload_file($user_screen_shot, $screen_shot_name, $screen_shot_size, $MAX_FILE_SIZE);
	
						if($screen_shot_info['error'])
						{
							message_die(GENERAL_ERROR, $screen_shot_info['message']);
						}
						$screen_shot_url = $screen_shot_info['url'];
					}
					else
					{
						$screen_shot_url = $user_screen_shot;
					}
				}

				$time = time();

				$sql = "INSERT INTO " . PA_FILES_TABLE . " (user_id, poster_ip, file_name, file_desc, file_creator, file_version, file_longdesc, file_ssurl, file_sshot_link, file_dlurl, file_time, file_update_time, file_catid, file_posticon, file_license, file_dls, file_last, file_pin, file_docsurl, file_approved)
						VALUES('" . $userdata['user_id'] . "', '" . $user_ip . "', '" . str_replace("\'", "''", $file_name) . "', '" . str_replace("\'", "''", $file_short_desc) . "', '" . str_replace("\'", "''", $file_author) . "', '" . str_replace("\'", "''", $file_version) . "', '" . str_replace("\'", "''", $file_long_desc) . "', '" . $screen_shot_url . "', '" . $file_ss_link . "', '" . $file_url . "', '" . $time . "', '" . $time . "', '" . $cat_id . "', '" . $file_posticon . "', '" . $file_license . "', '0', '0', '" . $file_pin . "', '" . $file_website . "', '1')";

				if ( !(pafiledb_sql_query($sql)) )
				{
					message_die(GENERAL_ERROR, 'Couldnt Add the file information to the database', '', __LINE__, __FILE__, $sql);
				}

				$file_id = $db->sql_nextid();

				$custom_field->file_update_data($file_id);

				$message = $lang['Fileadded'] . '<br /><br />' . sprintf($lang['Click_return'], '<a href="' . append_sid("admin_pa_file.php?file=add") . '">', '</a>');

				message_die(GENERAL_MESSAGE, $message);
			}

			if ( !isset($HTTP_POST_VARS['submit']) )
			{
				$curicons = 1;

				$posticons .= '<input type="radio" name="form[posticon]" value="none" checked><a class="gensmall">' . $lang['None'] . '</a>&nbsp;';

				$handle = @opendir($phpbb_root_path . ICONS_DIR);
          
				while ($icon = @readdir($handle)) 
				{
					if ($icon !== "." && $icon !== ".." && $icon !== "index.htm") 
					{
						$posticons .= '<input type="radio" name="form[posticon]" value="' . $icon . '"><img src="' . $phpbb_root_path . ICONS_DIR . $icon . '">&nbsp;';

						$curicons++;

						if ($curicons == 8)
						{
							$posticons .= '<br />';

							$curicons = 0;
						}
					}
				}

				$dropmenu = jumpmenu('', 'admin', '');
                
				$sql = "SELECT license_id, license_name
					FROM " . PA_LICENSE_TABLE . " 
					ORDER BY license_id";

				if ( !($result = pafiledb_sql_query($sql)) )
				{
					message_die(GENERAL_ERROR, 'Couldnt Query info', '', __LINE__, __FILE__, $sql);
				}

				while ($license = $db->sql_fetchrow($result)) 
				{
					$ldropmenu .= '<option value="' . $license['license_id'] . '">' . $license['license_name'] . '</option>';
				}

				$custom_exist = $custom_field->display_edit();

				$pafiledb_template->assign_vars(array(
					'S_ADD_FILE_ACTION' => append_sid("admin_pa_file.$phpEx"),

					'L_AFILETITLE' => $lang['Afiletitle'],                    
					'L_FILEEXPLAIN' => $lang['Fileexplain'],                    
					'L_FILENAME' => $lang['Filename'],
					'L_FILENAMEINFO' => $lang['Filenameinfo'],
					'L_FILESD' => $lang['Filesd'],
					'L_FILESDINFO' => $lang['Filesdinfo'],
					'L_FILELD' => $lang['Fileld'],
					'L_FILELDINFO' => $lang['Fileldinfo'],
					'L_FILECREATOR' => $lang['Filecreator'],
					'L_FILECREATORINFO' => $lang['Filecreatorinfo'],
					'L_FILEVERSION' => $lang['Fileversion'],
					'L_FILEVERSIONINFO' => $lang['Fileversioninfo'],
					'L_SCREENSHOT' => $lang['Scrsht'],
					'L_FILESS' => $lang['Filess'],
					'L_FILESSINFO' => $lang['Filessinfo'],
					'L_FILESS_UPLOAD' => $lang['Filess_upload'],
					'L_FILESSINFO_UPLOAD' => $lang['Filessinfo_upload'],
					'L_FILE_SSLINK' => $lang['Filess_link'],
					'L_FILE_SSLINK_INFO' => $lang['Filess_link_info'],					
					'L_FILEDOCS' => $lang['Filedocs'],
					'L_FILEDOCSINFO' => $lang['Filedocsinfo'],
					'L_FILES' => $lang['Files'],
					'L_FILE_UPLOAD' => $lang['File_upload'],
					'L_FILEINFO_UPLOAD' => $lang['Fileinfo_upload'],
					'L_FILEURL' => $lang['Fileurl'],
					'L_FILEURLINFO' => $lang['Fileurlinfo'],
					'L_FILEPI' => $lang['Filepi'],
					'L_FILEPIINFO' => $lang['Filepiinfo'],
					'L_FILECAT' => $lang['Filecat'],
					'L_FILECATINFO' => $lang['Filecatinfo'],
					'L_FILELICENSE' => $lang['Filelicense'],
					'L_NONE' => $lang['None'],
					'L_FILELICENSEINFO' => $lang['Filelicenseinfo'],
					'L_FILEPIN' => $lang['Filepin'],
					'L_FILEPININFO' => $lang['Filepininfo'],
					'L_ADDTIONAL_FIELD' => $lang['Addtional_field'],
					'L_NO' => $lang['No'],
					'L_YES' => $lang['Yes'],

					'CUSTOM_EXIST' => $custom_exist,
					'POSTICONS' => $posticons,
					'LDROPMENU' => $ldropmenu,                                                                    
					'DROPMENU' => $dropmenu)
				);
			}

			$pafiledb_template->display('admin');

			break;            
		}

		case 'edit':
		{
			$pafiledb_template->set_filenames(array(
				'admin' => 'admin/pa_admin_file_edit.tpl')
			);

			// =======================================================
			// Get Vars
			// =======================================================
			
			if ( isset($HTTP_GET_VARS['file_id']) || isset($HTTP_POST_VARS['file_id']) )
			{
				$file_id = ( isset($HTTP_GET_VARS['file_id']) ) ? intval($HTTP_GET_VARS['file_id']) : intval($HTTP_POST_VARS['file_id']);
			}
		
			$user_screen_shot = ( !empty($_POST['screen_shot_url']) ) ? htmlentities(trim(preg_replace('#\s{2,}#s', ' ', strtr((string) $_POST['screen_shot_url'], array_flip(get_html_translation_table(HTML_ENTITIES)))))) : ( ( !empty($_FILES['screen_shot']['tmp_name']) ) ? $_FILES['screen_shot']['tmp_name'] : '' );
			$ss_upload = ( empty($_POST['screen_shot_url']) ) ? TRUE : FALSE;

			$screen_shot_name = ( !empty($_FILES['screen_shot']['name']) ) ? $_FILES['screen_shot']['name'] : '';

			$screen_shot_size = ( !empty($_FILES['screen_shot']['size']) ) ? $_FILES['screen_shot']['size'] : '';
		
			$userfile = ( !empty($_POST['download_url']) ) ? htmlentities(trim(preg_replace('#\s{2,}#s', ' ', strtr((string) $_POST['download_url'], array_flip(get_html_translation_table(HTML_ENTITIES)))))) : ( ( !empty($_FILES['userfile']['tmp_name'])) ? $_FILES['userfile']['tmp_name'] : '' );
			$file_upload = ( empty($_POST['download_url']) ) ? TRUE : FALSE;
		
			$MAX_FILE_SIZE = ( isset($_POST['MAX_FILE_SIZE']) ) ? $_POST['MAX_FILE_SIZE'] : '';

			$userfile_name = ( !empty($_FILES['userfile']['name']) ) ? $_FILES['userfile']['name'] : '';

			$userfile_size = ( !empty($_FILES['userfile']['size']) ) ? $_FILES['userfile']['size'] : '';		

			$cat_id = ( isset($_REQUEST['cat_id']) ) ? intval($_REQUEST['cat_id']) : 0;

			$file_name = ( isset($_POST['name']) ) ? htmlentities(trim(preg_replace('#\s{2,}#s', ' ', strtr((string) $_POST['name'], array_flip(get_html_translation_table(HTML_ENTITIES)))))) : '';
		
			$file_long_desc = ( isset($_POST['long_desc']) ) ? $_POST['long_desc'] : '';
		
			$file_short_desc = ( isset($_POST['short_desc']) ) ? htmlentities(trim(preg_replace('#\s{2,}#s', ' ', strtr((string) $_POST['short_desc'], array_flip(get_html_translation_table(HTML_ENTITIES)))))) : ((!empty($file_long_desc)) ? substr($file_long_desc, 0, 50) . '...' : '');
		
			$file_author = ( isset($_POST['author']) ) ? htmlentities(trim(preg_replace('#\s{2,}#s', ' ', strtr((string) $_POST['author'], array_flip(get_html_translation_table(HTML_ENTITIES)))))) : ( ($userdata['user_id'] != ANONYMOUS) ? $userdata['username'] : '' );
		
			$file_version = ( isset($_POST['version']) ) ? htmlentities(trim(preg_replace('#\s{2,}#s', ' ', strtr((string) $_POST['version'], array_flip(get_html_translation_table(HTML_ENTITIES)))))) : '';
		
			$file_website = ( isset($_POST['website']) ) ? $_POST['website'] : '';
			if(!empty($file_website))
			{
				$file_website = (!preg_match('#^http[s]?:\/\/#i', $file_website)) ? 'http://' . $file_website : $file_website;
				$file_website = (preg_match('#^http[s]?\\:\\/\\/[a-z0-9\-]+\.([a-z0-9\-]+\.)?[a-z]+#i', $file_website)) ? $file_website : '';			
			}
		
			$file_posticon = ( isset($_POST['posticon']) ) ? $_POST['posticon'] : '';
		
			$file_license = ( isset($_POST['license']) ) ? intval($_POST['license']) : 0;
		
			$file_pin = ( isset($_POST['pin']) ) ? intval($_POST['pin']) : 0;
		
			$file_ss_link = ( isset($_POST['sshot_link']) ) ? intval($_POST['sshot_link']) : 0;
			
			$file_dls = ( isset($_POST['dls']) ) ? intval($_POST['dls']) : 0;
			
			$file_approved = ( isset($_POST['approved']) ) ? intval($_POST['approved']) : 0;

			if ( isset($HTTP_GET_VARS['edit']) || isset($HTTP_POST_VARS['edit']) )
			{
				$edit = ( isset($HTTP_GET_VARS['edit']) ) ? $HTTP_GET_VARS['edit'] : $HTTP_POST_VARS['edit'];
			}

			if ($edit == 'do' &&  isset($HTTP_POST_VARS['submit']) )
			{
				// =======================================================
				// if the file already exit then give the user a nice error message 
				// =======================================================
				
				$sql = "SELECT file_dlurl, file_ssurl 
					FROM " . PA_FILES_TABLE . " 
					WHERE file_id = '" . $file_id . "'";

				if ( !($result = $db->sql_query($sql)) )
				{
					message_die(GENERAL_ERROR, 'Couldnt Query info', '', __LINE__, __FILE__, $sql);
				}

				$file_row = $db->sql_fetchrow($result);

				$uploaded_file = ($file_upload) ? get_formated_url() . '/' . UPLOAD_DIR . $userfile_name : $userfile;
				$file_check = FALSE;

				if($uploaded_file != $file_row['file_dlurl'])
				{
					$file_check = TRUE;
					if($file_upload)
					{
						$file_info = upload_file($userfile, $userfile_name, $userfile_size, $MAX_FILE_SIZE);
				
						if($file_info['error'])
						{
							message_die(GENERAL_ERROR, $file_info['message']);
						}
						$file_url = $file_info['url'];
					}
					else
					{
						$file_url = $userfile;
					}
				}
				
				$uploaded_ss_file = ($ss_upload) ? get_formated_url() . '/' . UPLOAD_DIR . $screen_shot_name : $user_screen_shot;
				$ss_check = FALSE;
				
				if($uploaded_ss_file != $file_row['file_ssurl'])
				{
					$ss_check = TRUE;
					if(!empty($user_screen_shot))
					if($ss_upload)
					{
						$screen_shot_info = upload_file($user_screen_shot, $screen_shot_name, $screen_shot_size, $MAX_FILE_SIZE);
				
						if($screen_shot_info['error'])
						{
							message_die(GENERAL_ERROR, $screen_shot_info['message']);
						}
						$screen_shot_url = $screen_shot_info['url'];
					}
					else
					{
						$screen_shot_url = $user_screen_shot;
					}
				}
				
				if(!$ss_check)
				{
					$screen_shot_url = $file_row['file_ssurl'];
				}
				
				if(!$file_check)
				{
					$file_url = $file_row['file_dlurl'];
				}

				$time = time();
				
				$sql = "UPDATE " . PA_FILES_TABLE . " 
					SET file_name = '" . str_replace("\'", "''", $file_name) . "', 
					file_desc = '" . str_replace("\'", "''", $file_short_desc) . "', 
					file_longdesc = '" . str_replace("\'", "''", $file_long_desc) . "', 
					file_creator = '" . str_replace("\'", "''", $file_author) . "', 
					file_version = '" . str_replace("\'", "''", $file_version) . "', 
					file_ssurl = '" . $screen_shot_url . "', 
					file_sshot_link = '" . $file_ss_link . "',  
					file_dlurl = '" . $file_url . "', 
					file_update_time = '" . $time . "', 
					file_catid = '" . $cat_id . "', 
					file_posticon = '" . $file_posticon . "', 
					file_license = '" . $file_license . "', 
					file_pin = '" .$file_pin . "', 
					file_docsurl = '" . $file_website . "', 
					file_dls = '" . $file_dls . "', 
					file_approved = '" . $file_approved . "' 
					WHERE file_id = '" . $file_id . "'";

				if ( !($result = $db->sql_query($sql)) )
				{
					message_die(GENERAL_ERROR, 'Couldnt Query Info', '', __LINE__, __FILE__, $sql);
				}

				$custom_field->file_update_data($file_id);

				$message = $lang['Fileedited'] . '<br /><br />' . sprintf($lang['Click_return'], '<a href="' . append_sid("admin_pa_file.$phpEx?file=edit") . '">', '</a>') . '<br /><br />' . sprintf($lang['Click_return_admin_index'], '<a href="' . append_sid("index.$phpEx?pane=right") . '">', '</a>');

				message_die(GENERAL_MESSAGE, $message);
			}

			if ( isset($HTTP_POST_VARS['do_edit']) && ! isset($HTTP_POST_VARS['submit']) && !isset($HTTP_POST_VARS['select_cat']))
			{
				$pafiledb_template->assign_block_vars('file_form', array());

				$sql = "SELECT * 
					FROM " . PA_FILES_TABLE . " 
					WHERE file_id = '" . $file_id . "'";

				if ( !($result = $db->sql_query($sql)) )
				{
					message_die(GENERAL_ERROR, 'Couldnt Query info', '', __LINE__, __FILE__, $sql);
				}

				$file_info = $db->sql_fetchrow($result);

				$curicons = 1;

				if ($file_info['file_posticon'] =='none' or $file_info['file_posticon'] == 'none.gif' or empty($file_info['file_posticon']))
				{
					$posticons .= '<input type="radio" name="posticon" value="none" checked><a class="small">' . $lang['None'] . '</a>&nbsp;';
				}
				else 
				{
					$posticons .= '<input type="radio" name="posticon" value="none"><a class="small">' . $lang['None'] . '</a>&nbsp;';
				}

				$handle = @opendir($phpbb_root_path . ICONS_DIR);
          
				while ($icon = @readdir($handle))
				{
					if ($icon !== "." && $icon !== ".." && $icon !== "index.htm") 
					{
						if ($file_info['file_posticon'] == $icon) 
						{
							$posticons .= '<input type="radio" name="posticon" value="' . $icon . '" checked><img src="' . $phpbb_root_path . ICONS_DIR . $icon . '">&nbsp;';
						} 
						else 
						{
							$posticons .= '<input type="radio" name="posticon" value="' . $icon . '"><img src="' . $phpbb_root_path . ICONS_DIR . $icon . '">&nbsp;';
						}

						$curicons++;

						if ($curicons == 8) 
						{
							$posticons .= '<br>';

							$curicons = 0;
						}
					}
				}

				$dropmenu = jumpmenu('', 'admin', array($file_info['file_catid']=>1));

				if ($file_info['file_license'] == 0) 
				{
					$ldropmenu .= '<option calue="0" selected>' . $lang['None'] . '</option>';
				}
				else
				{
					$ldropmenu .= '<option calue="0">' . $lang['None'] . '</option>';
				}

				$sql = "SELECT * 
					FROM " . PA_LICENSE_TABLE . " 
					ORDER BY license_id";

				if ( !($result = $db->sql_query($sql)) )
				{
					message_die(GENERAL_ERROR, 'Couldnt Query info', '', __LINE__, __FILE__, $sql);
				}

				while ($license = $db->sql_fetchrow($result)) 
				{
					if ($file_info['file_license'] == $license['license_id']) 
					{
						$ldropmenu .= '<option value="' . $license['license_id'] . '" selected>' . $license['license_name'] . '</option>';
					}
					else 
					{
						$ldropmenu .= '<option value="' . $license['license_id'] . '">' . $license['license_name'] . '</option>';
					}
				}

				if ($file_info['file_pin'] == 0) 
				{
					$pdropmenu .= '<option value="0" selected>' . $lang['No'] . '</option>';

					$pdropmenu .= '<option value="1">' . $lang['Yes'] . '</option>';
				}
				else
				{
					$pdropmenu .= '<option value="0">' . $lang['No'] . '</option>';

					$pdropmenu .= '<option value="1" selected>' . $lang['Yes'] . '</option>';
				}

				if ($file_info['file_sshot_link'] == 0) 
				{
					$ss_checked_no = 'checked';
					$ss_checked_yes = '';
				}
				else
				{
					$ss_checked_no = '';
					$ss_checked_yes = 'checked';
				}
				
				if($file_info['file_approved'] == 0)
				{
					$checked_no = 'checked';
					$checked_yes = '';
				}
				else
				{
					$checked_no = '';
					$checked_yes = 'checked';
				}
				
				$custom_exist = $custom_field->display_edit($file_id);

				$pafiledb_template->assign_vars(array(
					'S_EDIT_FILE_ACTION' => append_sid("admin_pa_file.$phpEx"),
					'SELECT' => $file_id,                
					'L_EFILETITLE' => $lang['Efiletitle'],                    
					'L_FILEEXPLAIN' => $lang['Fileexplain'],
					'L_SCREENSHOT' => $lang['Scrsht'],
					'L_FILES' => $lang['Files'],
					'FFILE_NAME' => $file_info['file_name'],
					'FFILE_DESC' => $file_info['file_desc'],
					'FFILE_LONGDESC' => $file_info['file_longdesc'],
					'FFILE_CREATOR' => $file_info['file_creator'],
					'FFILE_VERSION' => $file_info['file_version'],
					'FFILE_SSURL' => $file_info['file_ssurl'],
					'FFILE_DOCSURL' => $file_info['file_docsurl'],
					'FFILE_DLURL' => $file_info['file_dlurl'],
					
					'L_FILENAME' => $lang['Filename'],
					'L_FILENAMEINFO' => $lang['Filenameinfo'],
					'L_FILESD' => $lang['Filesd'],
					'L_FILESDINFO' => $lang['Filesdinfo'],
					'L_FILELD' => $lang['Fileld'],
					'L_FILELDINFO' => $lang['Fileldinfo'],
					'L_FILECREATOR' => $lang['Filecreator'],
					'L_FILECREATORINFO' => $lang['Filecreatorinfo'],
					'L_FILEVERSION' => $lang['Fileversion'],
					'L_FILEVERSIONINFO' => $lang['Fileversioninfo'],
					'L_FILESS' => $lang['Filess'],
					'L_FILESSINFO' => $lang['Filessinfo'],
					'L_FILESS_UPLOAD' => $lang['Filess_upload'],
					'L_FILESSINFO_UPLOAD' => $lang['Filessinfo_upload'],
					'L_FILE_SSLINK' => $lang['Filess_link'],
					'L_FILE_SSLINK_INFO' => $lang['Filess_link_info'],
					'L_FILESSUPLOAD' => $lang['Filessupload'],
					'L_FILEDOCS' => $lang['Filedocs'],
					'L_FILEDOCSINFO' => $lang['Filedocsinfo'],
					'L_FILEURL' => $lang['Fileurl'],
					'L_FILE_UPLOAD' => $lang['File_upload'],
					'L_FILEINFO_UPLOAD' => $lang['Fileinfo_upload'],
					'DBURL' => $dburl,
					'L_FILEURLINFO' => $lang['Fileurlinfo'],
					'L_FILEURLUPLOAD' => $lang['Fileurlupload'],
					'L_FILEPI' => $lang['Filepi'],
					'POSTICONS' => $posticons,
					'L_FILEPIINFO' => $lang['Filepiinfo'],
					'L_FILECAT' => $lang['Filecat'],
					'L_FILECATINFO' => $lang['Filecatinfo'],
					'L_FILELICENSE' => $lang['Filelicense'],
					'L_NONE' => $lang['None'],
					'LDROPMENU' => $ldropmenu,
					'DROPMENU' => $dropmenu,
					'L_FILELICENSEINFO' => $lang['Filelicenseinfo'],
					'L_FILEPIN' => $lang['Filepin'],
					'L_FILEPININFO' => $lang['Filepininfo'],
					'L_FILEDLS' => $lang['Filedls'],
					'FFILE_DLS' => $file_info['file_dls'],
					'L_NO' => $lang['No'],
					'L_YES' => $lang['Yes'],
					'PDROPMENU' => $pdropmenu,
					'SDROPMENU' => $sdropmenu,
					'L_FILE_APPROVED' => $lang['Approved'],
					'L_FILE_APPROVED_INFO' => $lang['Approved_info'],
					'L_ADDTIONAL_FIELD' => $lang['Addtional_field'],
					'CUSTOM_EXIST' => $custom_exist,
					'CHECKED_YES' => $checked_yes,
					'CHECKED_NO' => $checked_no,
					'SS_CHECKED_YES' => $ss_checked_yes,
					'SS_CHECKED_NO' => $ss_checked_no,
					'U_UPLOAD_SS' => "javascript:NewWindow('" . append_sid("admin_pa_file.php?file=upload&field=ssurl") . "','fileupload','600','450','custom','front');",
					'U_UPLOAD_FILE' => "javascript:NewWindow('" . append_sid("admin_pa_file.php?file=upload&field=dlurl") . "','fileupload','600','450','custom','front');")
				);
			}

			if (isset($HTTP_POST_VARS['select_cat']) || empty($edit)) 
			{
				if ( isset($HTTP_GET_VARS['cat_id']) || isset($HTTP_POST_VARS['cat_id']) )
				{
					$cat_id = ( isset($HTTP_GET_VARS['cat_id']) ) ? intval($HTTP_GET_VARS['cat_id']) : intval($HTTP_POST_VARS['cat_id']);
				}

				$cat_list = jumpmenu('', 'admin', array($cat_id => 1));

				$pafiledb_template->assign_block_vars("file_edit", array());
				
				$sql = "SELECT * 
					FROM " . PA_FILES_TABLE . "
					WHERE file_catid = '" . $cat_id . "'";
					
				if ( !($result = $db->sql_query($sql)) )
				{
					message_die(GENERAL_ERROR, 'Couldnt Query info', '', __LINE__, __FILE__, $sql);
				}
					
				while ($file_info = $db->sql_fetchrow($result)) 
				{
					$approved = (!$file_info['file_approved']) ? $lang['Not_approved'] : '';
						
					$pafiledb_template->assign_block_vars('file_edit.file_list', array(
						'FILE_ID' => $file_info['file_id'],
						'FILE_NAME' => $file_info['file_name'],
						'FILE_APPROVED' => $approved,
						'FILE_DESC' => $file_info['file_desc'])
					);
				}

				$pafiledb_template->assign_vars(array(
					'S_EDIT_FILE_ACTION' => append_sid("admin_pa_file.$phpEx"),
					'L_EFILETITLE' => $lang['Efiletitle'],                    
					'L_FILEEXPLAIN' => $lang['Fileexplain'],
					'L_GO' => $lang['Go'],
					'S_CAT_SELECT' => $cat_list)
				);
			}

			$pafiledb_template->display('admin');

			break;                    
		}

		case 'delete':
		{
			$pafiledb_template->set_filenames(array(
				'admin' => 'admin/pa_admin_file_delete.tpl')
			);

			if ( isset($HTTP_GET_VARS['delete']) || isset($HTTP_POST_VARS['delete']) )
			{
				$delete = ( isset($HTTP_GET_VARS['delete']) ) ? $HTTP_GET_VARS['delete'] : $HTTP_POST_VARS['delete'];
			}

			if ( isset($HTTP_POST_VARS['submit']) ) 
			{
				if ( isset($HTTP_GET_VARS['select']) || isset($HTTP_POST_VARS['select']) )
				{
					$select = ( isset($HTTP_GET_VARS['select']) ) ? $HTTP_GET_VARS['select'] : $HTTP_POST_VARS['select'];
				}

				if (empty($select)) 
				{
					message_die(GENERAL_MESSAGE, $lang['Fderror']);
				} 
				else 
				{
					foreach ($select as $key => $value) 
					{
						$sql = "DELETE FROM " . PA_FILES_TABLE . " 
							WHERE file_id = '" . $key . "'";

						if ( !($db->sql_query($sql)) )
						{
							message_die(GENERAL_ERROR, 'Couldnt Query info', '', __LINE__, __FILE__, $sql);
						}

						$sql = "DELETE FROM " . PA_VOTES_TABLE . " 
							WHERE votes_file = '" . $key . "'";

						if ( !($db->sql_query($sql)) )
						{
							message_die(GENERAL_ERROR, 'Couldnt Query info', '', __LINE__, __FILE__, $sql);
						}

						$sql = "DELETE FROM " . PA_CUSTOM_DATA_TABLE . " 
							WHERE customdata_file = '" . $key . "'";

						if ( !($db->sql_query($sql)) )
						{
							message_die(GENERAL_ERROR, 'Couldnt Query info', '', __LINE__, __FILE__, $sql);
						}
					}

					$message = $lang['Filesdeleted'] . '<br /><br />' . sprintf($lang['Click_return'], '<a href="' . append_sid("admin_pa_file.$phpEx?file=delete") . '">', '</a>') . '<br /><br />' . sprintf($lang['Click_return_admin_index'], '<a href="' . append_sid("index.$phpEx?pane=right") . '">', '</a>');

					message_die(GENERAL_MESSAGE, $message);                      
				}
			}

			if (isset($HTTP_POST_VARS['select_cat']) || $file == 'delete') 
			{
				if ( isset($HTTP_GET_VARS['cat_id']) || isset($HTTP_POST_VARS['cat_id']) )
				{
					$cat_id = ( isset($HTTP_GET_VARS['cat_id']) ) ? intval($HTTP_GET_VARS['cat_id']) : intval($HTTP_POST_VARS['cat_id']);
				}
				else
				{
					$cat_id = 0;
				}

				$cat_list = jumpmenu('', 'admin', array($cat_id => 1));

				$sql = "SELECT * 
					FROM " . PA_FILES_TABLE . " 
					WHERE file_catid = '" . $cat_id . "'";
					
				if ( !($result = $db->sql_query($sql)) )
				{
					message_die(GENERAL_ERROR, 'Couldnt Query info', '', __LINE__, __FILE__, $sql);
				}
					
				while ($file_info = $db->sql_fetchrow($result)) 
				{
					if ($check == $file_info['file_id'])
					{
						$checkbox = " checked";
					} 
					else 
					{
						$checkbox = "";
					}
					$approved = (!$file_info['file_approved']) ? $lang['Not_approved'] : '';
						
					$pafiledb_template->assign_block_vars('file_list', array(
						'FILE_ID' => $file_info['file_id'],
						'FILE_NAME' => $file_info['file_name'],
						'FILE_APPROVED' => $approved,
						'CHECKBOX' => $checkbox,
						'FILE_DESC' => $file_info['file_desc'])
					);
				}

				$pafiledb_template->assign_vars(array(
					'S_DELETE_FILE_ACTION' => append_sid("admin_pa_file.$phpEx"),
					'L_DFILETITLE' => $lang['Dfiletitle'],                    
					'L_FILEEXPLAIN' => $lang['Fileexplain'],
					'L_GO' => $lang['Go'],
					'S_CAT_SELECT' => $cat_list)
				);
			}

			$pafiledb_template->display('admin');

			break;                               
		}
	}    
}

include('./page_footer_admin.'.$phpEx);

?>
